/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.plaf;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.impl.ToolstripTabContentPanel;
import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.toolstrip.plaf.ToolstripTabLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.PanelUI;

public class ToolstripTabContentUI
extends PanelUI {
    private final ToolstripTabContentPanel fContent;

    public ToolstripTabContentUI(ToolstripTabContentPanel toolstripTabContentPanel) {
        this.fContent = toolstripTabContentPanel;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        ToolstripTabContentUI.fillContentBackground(this.getTab(), jComponent, (Graphics2D)graphics);
    }

    public static void fillContentBackground(ToolstripTab toolstripTab, JComponent jComponent, Graphics2D graphics2D) {
        Color[] colorArray = LAFUtil.getTabContentBackgroundColors(toolstripTab);
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, colorArray[0], 0.0f, jComponent.getHeight(), colorArray[1]));
        graphics2D.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
    }

    private ToolstripTab getTab() {
        return this.fContent.getTab();
    }

    public static ToolstripTabContentUI createUI(JComponent jComponent) {
        return new ToolstripTabContentUI((ToolstripTabContentPanel)jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        jComponent.setLayout(new ToolstripTabLayout((ToolstripTabContentPanel)jComponent));
        jComponent.setBorder(new MyBorder());
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        jComponent.setLayout(null);
        jComponent.setBorder(null);
    }

    private class MyBorder
    implements Border {
        private MyBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(ColorUtils.darker((Color)LAFUtil.getTabColor(ToolstripTabContentUI.this.getTab()), (double)0.6));
            int n5 = n2 + n4 - 1;
            int n6 = n + n3 - 1;
            graphics.drawLine(n, n5, n6, n5);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 1, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

