/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdFunctionMaster;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.UniqueTag;

public abstract class IdScriptable
extends ScriptableObject
implements IdFunctionMaster {
    private int maxId;
    private Object[] idMapData;
    private byte[] attributesArray;
    private int lastIdCache;
    private byte setupFlags;
    private byte extraIdAttributes;

    public boolean has(String string, Scriptable scriptable) {
        int n;
        if (this.maxId != 0 && (n = this.NOT_FOUND(string)) != 0) {
            return this.NaNobj(n);
        }
        return super.has(string, scriptable);
    }

    public Object get(String string, Scriptable scriptable) {
        int n;
        if (this.maxId != 0 && (n = this.NOT_FOUND(string)) != 0) {
            Object[] objectArray = this.idMapData;
            if (objectArray == null) {
                return this.getIdValue(n);
            }
            Object object = objectArray[n - 1];
            if (object == null) {
                object = this.getIdValue(n);
            } else if (object == UniqueTag.NULL_VALUE) {
                object = null;
            }
            return object;
        }
        return super.get(string, scriptable);
    }

    public void put(String string, Scriptable scriptable, Object object) {
        int n;
        if (this.maxId != 0 && (n = this.FALSE(string)) != 0) {
            int n2 = this.TRUE(n);
            if ((n2 & 1) == 0) {
                if (scriptable == this) {
                    this.setIdValue(n, object);
                } else {
                    scriptable.put(string, scriptable, object);
                }
            }
            return;
        }
        super.put(string, scriptable, object);
    }

    public void delete(String string) {
        int n;
        if (this.maxId != 0 && (n = this.mapNameToId(string)) != 0 && !this.isSealed()) {
            int n2 = this.TRUE(n);
            if ((n2 & 4) == 0) {
                this.deleteIdValue(n);
            }
            return;
        }
        super.delete(string);
    }

    public int getAttributes(String string, Scriptable scriptable) throws PropertyException {
        int n;
        if (this.maxId != 0 && (n = this.mapNameToId(string)) != 0 && this.NaNobj(n)) {
            return this.TRUE(n);
        }
        return super.getAttributes(string, scriptable);
    }

    public void setAttributes(String string, Scriptable scriptable, int n) throws PropertyException {
        int n2;
        if (this.maxId != 0 && (n2 = this.mapNameToId(string)) != 0 && this.NaNobj(n2)) {
            IdScriptable idScriptable = this;
            synchronized (idScriptable) {
                this.addPropertyAttribute(n2, n);
            }
            return;
        }
        super.setAttributes(string, scriptable, n);
    }

    synchronized void addPropertyAttribute(int n) {
        this.extraIdAttributes = (byte)(this.extraIdAttributes | (byte)n);
        super.addPropertyAttribute(n);
    }

    public void defineProperty(String string, Object object, int n) {
        int n2;
        if (this.maxId != 0 && (n2 = this.mapNameToId(string)) != 0) {
            int n3 = this.getIdDefaultAttributes(n2);
            if ((n3 & 1) != 0) {
                throw new RuntimeException("Attempt to redefine read-only id " + string);
            }
            this.addPropertyAttribute(n2, n);
            this.setIdValue(n2, object);
            return;
        }
        super.defineProperty(string, object, n);
    }

    Object[] getIds(boolean bl) {
        Object[] objectArray = super.getIds(bl);
        if (this.maxId != 0) {
            Object[] objectArray2 = null;
            int n = 0;
            int n2 = this.maxId;
            while (n2 != 0) {
                if (this.NaNobj(n2) && (bl || (this.TRUE(n2) & 2) == 0)) {
                    if (n == 0) {
                        objectArray2 = new Object[n2];
                    }
                    objectArray2[n++] = this.getIdName(n2);
                }
                --n2;
            }
            if (n != 0) {
                if (objectArray.length == 0 && objectArray2.length == n) {
                    objectArray = objectArray2;
                } else {
                    Object[] objectArray3 = new Object[objectArray.length + n];
                    System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
                    System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, n);
                    objectArray = objectArray3;
                }
            }
        }
        return objectArray;
    }

    private int FALSE(String string) {
        int n;
        Object[] objectArray = this.idMapData;
        if (objectArray != null && objectArray[(n = this.lastIdCache) - 1 + this.maxId] == string) {
            return n;
        }
        return this.mapNameToId(string);
    }

    private int NOT_FOUND(String string) {
        Object[] objectArray = this.idMapData;
        if (objectArray != null) {
            int n = this.lastIdCache;
            if (objectArray[n - 1 + this.maxId] == string) {
                return n;
            }
            n = this.mapNameToId(string);
            if (n != 0) {
                objectArray[n - 1 + this.maxId] = string;
                this.lastIdCache = n;
            }
            return n;
        }
        return this.mapNameToId(string);
    }

    protected abstract int mapNameToId(String var1);

    protected abstract String getIdName(int var1);

    protected int getIdDefaultAttributes(int n) {
        return 2;
    }

    protected boolean hasIdValue(int n) {
        return true;
    }

    protected Object getIdValue(int n) {
        IdFunction idFunction = this.newIdFunction(n);
        idFunction.setParentScope(this.getParentScope());
        return this.cacheIdValue(n, idFunction);
    }

    protected void setIdValue(int n, Object object) {
        IdScriptable idScriptable = this;
        synchronized (idScriptable) {
            Object[] objectArray = this.OEAB();
            objectArray[n - 1] = object != null ? object : UniqueTag.NULL_VALUE;
        }
    }

    protected Object cacheIdValue(int n, Object object) {
        IdScriptable idScriptable = this;
        synchronized (idScriptable) {
            Object[] objectArray = this.OEAB();
            Object object2 = objectArray[n - 1];
            if (object2 == null) {
                objectArray[n - 1] = object != null ? object : UniqueTag.NULL_VALUE;
            } else {
                object = object2;
            }
        }
        return object;
    }

    protected void deleteIdValue(int n) {
        IdScriptable idScriptable = this;
        synchronized (idScriptable) {
            this.OEAB()[n - 1] = Scriptable.NOT_FOUND;
        }
    }

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        throw IdFunction.onBadMethodId(this, n);
    }

    public int methodArity(int n) {
        return -1;
    }

    protected final int getMaxId() {
        return this.maxId;
    }

    protected void setMaxId(int n) {
        if (n < this.maxId) {
            Context.codeBug();
        }
        this.maxId = n;
    }

    protected void setSealFunctionsFlag(boolean bl) {
        this.NULL_VALUE(2, bl);
    }

    protected void setFunctionParametrs(Context context) {
        this.NULL_VALUE(1, context.hasCompileFunctionsWithDynamicScope());
    }

    private void NULL_VALUE(int n, boolean bl) {
        this.setupFlags = bl ? (byte)(this.setupFlags | n) : (byte)(this.setupFlags & ~n);
    }

    public void addAsPrototype(int n, Context context, Scriptable scriptable, boolean bl) {
        this.setMaxId(n);
        this.setSealFunctionsFlag(bl);
        this.setFunctionParametrs(context);
        int n2 = this.mapNameToId("constructor");
        if (n2 == 0) {
            throw new RuntimeException("No id for constructor property");
        }
        IdFunction idFunction = this.newIdFunction(this.getClassName(), n2);
        idFunction.initAsConstructor(scriptable, this);
        this.fillConstructorProperties(context, idFunction, bl);
        if (bl) {
            idFunction.sealObject();
            idFunction.addPropertyAttribute(1);
        }
        this.setParentScope(idFunction);
        this.setPrototype(ScriptableObject.getObjectPrototype(scriptable));
        this.cacheIdValue(n2, idFunction);
        if (bl) {
            this.sealObject();
        }
        ScriptableObject.defineProperty(scriptable, this.getClassName(), idFunction, 2);
    }

    protected void fillConstructorProperties(Context context, IdFunction idFunction, boolean bl) {
    }

    protected void addIdFunctionProperty(Scriptable scriptable, int n, boolean bl) {
        IdFunction idFunction = this.newIdFunction(n);
        if (bl) {
            idFunction.sealObject();
        }
        ScriptableObject.defineProperty(scriptable, this.getIdName(n), idFunction, 2);
    }

    protected Scriptable nextInstanceCheck(Scriptable scriptable, IdFunction idFunction, boolean bl) {
        if (bl && 0 != (this.setupFlags & 1) && (scriptable = scriptable.getPrototype()) != null) {
            return scriptable;
        }
        throw NativeGlobal.typeError1("msg.incompat.call", idFunction.getFunctionName(), idFunction);
    }

    protected IdFunction newIdFunction(int n) {
        return this.newIdFunction(this.getIdName(n), n);
    }

    protected IdFunction newIdFunction(String string, int n) {
        IdFunction idFunction = new IdFunction(this, string, n);
        if (0 != (this.setupFlags & 2)) {
            idFunction.sealObject();
        }
        return idFunction;
    }

    protected final Object wrap_double(double d) {
        return d == d ? new Double(d) : ScriptRuntime.NaNobj;
    }

    protected final Object wrap_int(int n) {
        byte by = (byte)n;
        if (by == n) {
            return new Byte(by);
        }
        return new Integer(n);
    }

    protected final Object wrap_long(long l) {
        int n = (int)l;
        if ((long)n == l) {
            return this.wrap_int(n);
        }
        return new Long(l);
    }

    protected final Object wrap_boolean(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    private boolean NaNobj(int n) {
        Object object;
        Object[] objectArray = this.idMapData;
        if (objectArray == null || (object = objectArray[n - 1]) == null) {
            return this.hasIdValue(n);
        }
        return object != Scriptable.NOT_FOUND;
    }

    private Object[] OEAB() {
        Object[] objectArray = this.idMapData;
        if (objectArray == null) {
            objectArray = new Object[this.maxId * 2];
            this.idMapData = objectArray;
        }
        return objectArray;
    }

    private int TRUE(int n) {
        int n2 = this.getIdDefaultAttributes(n) | this.extraIdAttributes;
        byte[] byArray = this.attributesArray;
        if (byArray != null) {
            n2 |= 0xFF & byArray[n - 1];
        }
        return n2;
    }

    private void addPropertyAttribute(int n, int n2) {
        int n3 = this.getIdDefaultAttributes(n);
        if ((n2 & n3) != n3) {
            throw new RuntimeException("Attempt to unset default attributes");
        }
        byte[] byArray = this.attributesArray;
        if (byArray == null && (n2 &= ~n3) != 0) {
            IdScriptable idScriptable = this;
            synchronized (idScriptable) {
                byArray = this.attributesArray;
                if (byArray == null) {
                    this.attributesArray = byArray = new byte[this.maxId];
                }
            }
        }
        if (byArray != null) {
            byArray[n - 1] = (byte)n2;
        }
    }
}

