/*
 * Decompiled with CFR 0.152.
 */
package ice.ssl;

import ice.cert.CertificateException;
import ice.cert.X509Certificate;
import ice.debug.Debug;
import ice.ssl.ClientHandshake;
import ice.ssl.ConnectionState;
import ice.ssl.HandshakeState;
import ice.ssl.SessionState;
import ice.ssl.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

final class ClientCertificate
extends ClientHandshake {
    HandshakeState handState;

    ClientCertificate(SessionState sessionState, ConnectionState connectionState, HandshakeState handshakeState) {
        super(11, sessionState, connectionState);
        this.length = 0;
        this.handState = handshakeState;
    }

    byte[] toByteArray() throws IOException {
        byte[] byArray = new byte[]{};
        int n = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        if (this.handState.clientCertificate != null) {
            try {
                X509Certificate[] x509CertificateArray = this.handState.clientCertificateChain;
                int n2 = 0;
                while (n2 < x509CertificateArray.length) {
                    byteArrayOutputStream.write(x509CertificateArray[n2].getEncoded());
                    n += x509CertificateArray[n2].getEncoded().length;
                    ++n2;
                }
            }
            catch (CertificateException certificateException) {
                throw new IOException(certificateException.getMessage());
            }
        } else {
            Debug.trace((String)"Client certificate is null");
        }
        this.length = n + 6;
        byteArrayOutputStream2.write(super.toByteArray());
        byteArrayOutputStream2.write(Util.toByteArray(n + 3, 3));
        byteArrayOutputStream2.write(Util.toByteArray(n, 3));
        byteArrayOutputStream2.write(byteArrayOutputStream.toByteArray());
        byArray = byteArrayOutputStream2.toByteArray();
        byteArrayOutputStream2.close();
        return byArray;
    }
}

