/*
 * Decompiled with CFR 0.152.
 */
package ice.ssl;

import ice.ssl.ConnectionState;
import ice.ssl.SessionState;
import ice.ssl.Util;
import java.io.IOException;

abstract class ClientHandshake {
    protected int length;
    protected int messageType;
    protected SessionState sesState;
    protected ConnectionState conState;
    static final int CLIENT_HELLO = 1;
    static final int CERTIFICATE = 11;
    static final int CERTIFICATE_VERIFY = 15;
    static final int CLIENT_KEY_EXCHANGE = 16;
    static final int CLIENT_FINISHED = 20;
    static final int V2_CLIENT_HELLO = 1;
    static final int V2_CERTIFICATE = 8;
    static final int V2_CLIENT_MASTER_KEY = 2;
    static final int V2_CLIENT_FINISHED = 3;

    ClientHandshake(int n, SessionState sessionState, ConnectionState connectionState) {
        this.messageType = n;
        this.sesState = sessionState;
        this.conState = connectionState;
    }

    byte[] toByteArray() throws IOException {
        byte[] byArray;
        if (this.sesState.nowProto == 1) {
            byArray = new byte[]{(byte)this.messageType};
        } else {
            byArray = new byte[4];
            byArray[0] = (byte)this.messageType;
            Util.toByteArray(this.getLength(), byArray, 1, 3);
        }
        return byArray;
    }

    protected int getLength() {
        return this.length;
    }
}

