/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.dastudio.truthtable;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.toolbox.dastudio.truthtable.ActionTableEditor;
import com.mathworks.toolbox.dastudio.truthtable.PredicateTableEditor;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class TruthTableEditor
extends MJFrame
implements ActionListener {
    private int _sfObjectId;
    private PredicateTableEditor predTblEditor;
    private ActionTableEditor actTblEditor;
    private MJButton btnOk;
    private MJButton btnApply;
    private MJButton btnCancel;
    private MJButton btnCompile;
    private static Matlab fMatlab = new Matlab();
    private static String matlabRoot = fMatlab.matlabRoot();

    static String getMatlabRoot() {
        return matlabRoot;
    }

    public TruthTableEditor(int n, String[][] stringArray, String[][] stringArray2) {
        super("Truth Table Editor");
        this._sfObjectId = n;
        this.predTblEditor = stringArray == null ? new PredicateTableEditor() : new PredicateTableEditor(stringArray);
        this.actTblEditor = stringArray2 == null ? new ActionTableEditor() : new ActionTableEditor(stringArray2);
        this.initializeTTEditor();
    }

    private void initializeTTEditor() {
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setTopComponent(this.predTblEditor.getEditorPanel());
        jSplitPane.setBottomComponent(this.actTblEditor.getEditorPanel());
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerSize(8);
        this.getContentPane().add((Component)jSplitPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.btnOk = new MJButton("Ok");
        this.btnOk.addActionListener((ActionListener)this);
        this.btnApply = new MJButton("Apply");
        this.btnApply.addActionListener((ActionListener)this);
        this.btnCancel = new MJButton("Cancel");
        this.btnCancel.addActionListener((ActionListener)this);
        this.btnCompile = new MJButton("Compile");
        this.btnCompile.addActionListener((ActionListener)this);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add((Component)this.btnOk);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add((Component)this.btnApply);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add((Component)this.btnCancel);
        jPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        jPanel.add((Component)this.btnCompile);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.getContentPane().add((Component)jPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                TruthTableEditor.this.closeEditor();
            }
        });
        this.setLocation(200, 200);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.predTblEditor.stopEditing();
        this.actTblEditor.stopEditing();
        if (actionEvent.getSource() == this.btnOk) {
            this.updateSfData();
            this.closeEditor();
        }
        if (actionEvent.getSource() == this.btnApply) {
            this.updateSfData();
        }
        if (actionEvent.getSource() == this.btnCancel) {
            this.closeEditor();
        }
        if (actionEvent.getSource() == this.btnCompile) {
            this.updateSfData();
            this.compileTruthTable();
        }
    }

    public String[][] getPredicateTableStringArray() {
        return this.predTblEditor.getStringArray();
    }

    public String getPredicateTableCellValue(int n, int n2) {
        return this.predTblEditor.getCellValue(n, n2);
    }

    public String[][] getActionTableStringArray() {
        return this.actTblEditor.getStringArray();
    }

    public String getActionTableCellValue(int n, int n2) {
        return this.actTblEditor.getCellValue(n, n2);
    }

    public void closeEditor() {
        Object[] objectArray = new Object[]{"Private", "truth_table_man", "ui_destroyed", new Integer(this._sfObjectId)};
        fMatlab.feval("sf", objectArray, (CompletionObserver)null);
        this.dispose();
    }

    public void updateEditor(String[][] stringArray, String[][] stringArray2) {
    }

    public void setBusyCursor(boolean bl) {
        if (bl) {
            this.setCursor(new Cursor(3));
        } else {
            this.setCursor(new Cursor(0));
        }
    }

    private void updateSfData() {
        Object[] objectArray = new Object[]{"Private", "truth_table_man", "update_data", new Integer(this._sfObjectId)};
        fMatlab.feval("sf", objectArray, (CompletionObserver)null);
    }

    private void compileTruthTable() {
        Object[] objectArray = new Object[]{"Private", "truth_table_man", "compile", new Integer(this._sfObjectId)};
        fMatlab.feval("sf", objectArray, (CompletionObserver)null);
    }

    static {
        matlabRoot = matlabRoot.replace('\\', '/') + "/";
    }
}

