/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.http;

import com.sun.jini.jeri.internal.http.HttpParseException;
import com.sun.jini.jeri.internal.runtime.BASE64Encoder;
import com.sun.jini.jeri.internal.runtime.CharacterEncoder;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ServerInfo
implements Cloneable {
    static final long NO_TIMESTAMP = -1L;
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    final String host;
    final int port;
    int major = 1;
    int minor = 0;
    String authScheme;
    String authRealm;
    String authAlgorithm;
    String authOpaque;
    String authNonce;
    String authUser;
    String authPassword;
    long timestamp = -1L;

    ServerInfo(String string, int n) {
        this.host = string;
        this.port = n;
    }

    void setAuthInfo(String string) throws HttpParseException {
        String string2;
        if (string == null || string.length() == 0) {
            this.authScheme = null;
            this.authRealm = null;
            this.authAlgorithm = null;
            this.authOpaque = null;
            this.authNonce = null;
            this.authUser = null;
            this.authPassword = null;
            return;
        }
        LineParser lineParser = new LineParser(string);
        Map map = lineParser.getEntries("Digest");
        if (map != null) {
            string2 = (String)map.get("realm");
            String string3 = (String)map.get("nonce");
            if (string2 != null && string3 != null) {
                this.authScheme = "Digest";
                this.authRealm = string2;
                this.authNonce = string3;
                this.authAlgorithm = (String)map.get("algorithm");
                this.authOpaque = (String)map.get("opaque");
                if (!"true".equalsIgnoreCase((String)map.get("stale"))) {
                    this.authUser = null;
                    this.authPassword = null;
                }
                return;
            }
        }
        if ((map = lineParser.getEntries("Basic")) != null && (string2 = (String)map.get("realm")) != null) {
            this.authScheme = "Basic";
            this.authRealm = string2;
            this.authAlgorithm = null;
            this.authOpaque = null;
            this.authNonce = null;
            this.authUser = null;
            this.authPassword = null;
            return;
        }
    }

    void updateAuthInfo(String string) throws HttpParseException {
        LineParser lineParser;
        Map map;
        String string2;
        if (string == null || string.length() == 0) {
            return;
        }
        if ("Digest".equals(this.authScheme) && (string2 = (String)(map = (lineParser = new LineParser(string)).getAllEntries()).get("nextnonce")) != null) {
            this.authNonce = string2;
        }
    }

    String getAuthString(String string, String string2, String string3) {
        String string4;
        Object object;
        if (this.authScheme == null) {
            return null;
        }
        if (this.authUser == null) {
            object = this.getPassword(string);
            if (object == null) {
                return null;
            }
            string4 = ((PasswordAuthentication)object).getUserName();
            char[] cArray = ((PasswordAuthentication)object).getPassword();
            if (string4 == null || cArray == null) {
                return null;
            }
            this.authUser = string4;
            this.authPassword = new String(cArray);
        }
        if (this.authScheme.equals("Basic")) {
            object = new BASE64Encoder();
            return "Basic " + ((CharacterEncoder)object).encode((this.authUser + ":" + this.authPassword).getBytes());
        }
        if (this.authScheme.equals("Digest")) {
            try {
                object = this.computeDigest(string2, string3);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return null;
            }
            string4 = "Digest username=\"" + this.authUser + "\", " + "realm=\"" + this.authRealm + "\", " + "nonce=\"" + this.authNonce + "\", " + "uri=\"" + string3 + "\", " + "response=\"" + (String)object + "\"";
            if (this.authOpaque != null) {
                string4 = string4 + ", opaque=\"" + this.authOpaque + "\"";
            }
            if (this.authAlgorithm != null) {
                string4 = string4 + ", algorithm=" + this.authAlgorithm;
            }
            return string4;
        }
        throw new InternalError();
    }

    private String computeDigest(String string, String string2) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(this.authAlgorithm != null ? this.authAlgorithm : "MD5");
        String string3 = this.encode(messageDigest, this.authUser + ":" + this.authRealm + ":" + this.authPassword);
        String string4 = this.encode(messageDigest, string + ":" + string2);
        return this.encode(messageDigest, string3 + ":" + this.authNonce + ":" + string4);
    }

    private String encode(MessageDigest messageDigest, String string) {
        messageDigest.reset();
        byte[] byArray = messageDigest.digest(string.getBytes());
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(hexChars[byArray[i] >>> 4 & 0xF]);
            stringBuffer.append(hexChars[byArray[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private PasswordAuthentication getPassword(final String string) {
        return (PasswordAuthentication)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                InetAddress inetAddress = null;
                try {
                    inetAddress = InetAddress.getByName(ServerInfo.this.host);
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                return Authenticator.requestPasswordAuthentication(inetAddress, ServerInfo.this.port, string, ServerInfo.this.authRealm, ServerInfo.this.authScheme);
            }
        });
    }

    private static class LineParser {
        private static final int EOL = -1;
        private static final int WORD = 0;
        private static final int QUOTE = 1;
        private static final int COMMA = 2;
        private static final int EQUALS = 3;
        private final List entries = new ArrayList();
        private final char[] ca;
        private int pos = 0;
        private String tokenString = null;

        LineParser(String string) throws HttpParseException {
            this.ca = string.toCharArray();
            int n = this.nextToken();
            while (n != -1) {
                if (n == 2) {
                    n = this.nextToken();
                    continue;
                }
                if (n != 0) {
                    throw new HttpParseException("illegal key");
                }
                String string2 = this.tokenString;
                n = this.nextToken();
                if (n == 2) {
                    this.entries.add(new String[]{string2, null});
                    n = this.nextToken();
                    continue;
                }
                if (n != 3) {
                    this.entries.add(new String[]{string2, null});
                    continue;
                }
                n = this.nextToken();
                if (n != 0 && n != 1) {
                    throw new HttpParseException("illegal value");
                }
                this.entries.add(new String[]{string2, this.tokenString});
                n = this.nextToken();
                if (n == 2) {
                    n = this.nextToken();
                    continue;
                }
                if (n == -1) continue;
                throw new HttpParseException("illegal separator");
            }
        }

        private int nextToken() throws HttpParseException {
            char c;
            while (this.pos < this.ca.length && Character.isWhitespace(this.ca[this.pos])) {
                ++this.pos;
            }
            if (this.pos >= this.ca.length) {
                return -1;
            }
            switch (this.ca[this.pos]) {
                case ',': {
                    ++this.pos;
                    return 2;
                }
                case '=': {
                    ++this.pos;
                    return 3;
                }
                case '\"': {
                    int n = ++this.pos;
                    while (this.pos < this.ca.length && this.ca[this.pos] != '\"') {
                        ++this.pos;
                    }
                    if (this.pos >= this.ca.length) {
                        throw new HttpParseException("unterminated quote string");
                    }
                    this.tokenString = new String(this.ca, n, this.pos++ - n);
                    return 1;
                }
            }
            int n = this.pos;
            while (this.pos < this.ca.length && (c = this.ca[this.pos]) != ',' && c != '=' && c != '\"' && !Character.isWhitespace(c)) {
                ++this.pos;
            }
            this.tokenString = new String(this.ca, n, this.pos - n);
            return 0;
        }

        Map getEntries(String string) {
            int n;
            HashMap<String, String> hashMap = null;
            String[][] stringArray = (String[][])this.entries.toArray((T[])new String[this.entries.size()][]);
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n][1] != null || !string.equalsIgnoreCase(stringArray[n][0])) continue;
                hashMap = new HashMap<String, String>();
                break;
            }
            if (hashMap != null) {
                ++n;
                while (n < stringArray.length && stringArray[n][1] != null) {
                    hashMap.put(stringArray[n][0].toLowerCase(), stringArray[n][1]);
                    ++n;
                }
            }
            return hashMap;
        }

        Map getAllEntries() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String[][] stringArray = (String[][])this.entries.toArray((T[])new String[this.entries.size()][]);
            for (int i = 0; i < stringArray.length; ++i) {
                hashMap.put(stringArray[i][0].toLowerCase(), stringArray[i][1]);
            }
            return hashMap;
        }
    }
}

