/*
 * Decompiled with CFR 0.152.
 */
package net.jini.core.constraint;

import [Lnet.jini.core.constraint.InvocationConstraint;;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import net.jini.core.constraint.ArraySet;
import net.jini.core.constraint.Constraint;
import net.jini.core.constraint.ConstraintAlternatives;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.RelativeTimeConstraint;

public final class InvocationConstraints
implements Serializable {
    private static final long serialVersionUID = -3363161199079334224L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("reqs", InvocationConstraint;.class, true), new ObjectStreamField("prefs", InvocationConstraint;.class, true)};
    private static final InvocationConstraint[] empty = new InvocationConstraint[0];
    private static final int REL_REQS = 1;
    private static final int REL_PREFS = 2;
    public static final InvocationConstraints EMPTY = new InvocationConstraints((InvocationConstraint)null, null);
    private InvocationConstraint[] reqs;
    private InvocationConstraint[] prefs;
    private transient int rel = 0;

    public InvocationConstraints(InvocationConstraint invocationConstraint, InvocationConstraint invocationConstraint2) {
        if (invocationConstraint != null) {
            this.reqs = new InvocationConstraint[]{invocationConstraint};
        }
        if (invocationConstraint2 != null) {
            this.prefs = new InvocationConstraint[]{invocationConstraint2};
        }
        this.reduce();
    }

    public InvocationConstraints(InvocationConstraint[] invocationConstraintArray, InvocationConstraint[] invocationConstraintArray2) {
        if (invocationConstraintArray != null) {
            this.reqs = (InvocationConstraint[])invocationConstraintArray.clone();
        }
        if (invocationConstraintArray2 != null) {
            this.prefs = (InvocationConstraint[])invocationConstraintArray2.clone();
        }
        this.reduce();
    }

    public InvocationConstraints(Collection collection, Collection collection2) {
        try {
            if (collection != null) {
                this.reqs = collection.toArray(new InvocationConstraint[collection.size()]);
            }
            if (collection2 != null) {
                this.prefs = collection2.toArray(new InvocationConstraint[collection2.size()]);
            }
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new IllegalArgumentException("element of collection is not an InvocationConstraint");
        }
        this.reduce();
    }

    private InvocationConstraints(InvocationConstraint[] invocationConstraintArray, int n, InvocationConstraint[] invocationConstraintArray2, int n2, int n3) {
        this.reqs = invocationConstraintArray;
        this.prefs = invocationConstraintArray2;
        this.reduce(n, n2);
        this.rel = n3;
    }

    private void reduce() {
        if (this.reqs == null) {
            this.reqs = empty;
        }
        if (this.prefs == null) {
            this.prefs = empty;
        }
        this.reduce(0, 0);
        this.setRelative(this.reqs, 1);
        this.setRelative(this.prefs, 2);
    }

    private void reduce(int n, int n2) {
        InvocationConstraint invocationConstraint;
        int n3;
        for (n3 = n; n3 < this.reqs.length; ++n3) {
            invocationConstraint = this.reqs[n3];
            if (invocationConstraint == null) {
                throw new NullPointerException("elements cannot be null");
            }
            if (Constraint.contains(this.reqs, n, invocationConstraint)) continue;
            this.reqs[n++] = invocationConstraint;
        }
        this.reqs = (InvocationConstraint[])Constraint.trim(this.reqs, n);
        for (n3 = n2; n3 < this.prefs.length; ++n3) {
            invocationConstraint = this.prefs[n3];
            if (invocationConstraint == null) {
                throw new NullPointerException("elements cannot be null");
            }
            if (Constraint.contains(this.prefs, n2, invocationConstraint) || Constraint.contains(this.reqs, this.reqs.length, invocationConstraint)) continue;
            this.prefs[n2++] = invocationConstraint;
        }
        this.prefs = (InvocationConstraint[])Constraint.trim(this.prefs, n2);
    }

    private static boolean relative(InvocationConstraint invocationConstraint) {
        return invocationConstraint instanceof RelativeTimeConstraint && (!(invocationConstraint instanceof ConstraintAlternatives) || ((ConstraintAlternatives)invocationConstraint).relative());
    }

    private void setRelative(InvocationConstraint[] invocationConstraintArray, int n) {
        int n2 = invocationConstraintArray.length;
        while (--n2 >= 0) {
            if (!InvocationConstraints.relative(invocationConstraintArray[n2])) continue;
            this.rel |= n;
            return;
        }
    }

    public static InvocationConstraints combine(InvocationConstraints invocationConstraints, InvocationConstraints invocationConstraints2) {
        int n;
        InvocationConstraint[] invocationConstraintArray;
        if (invocationConstraints == null || invocationConstraints.isEmpty()) {
            return invocationConstraints2 == null ? EMPTY : invocationConstraints2;
        }
        if (invocationConstraints2 == null || invocationConstraints2.isEmpty()) {
            return invocationConstraints;
        }
        if (invocationConstraints2.reqs.length > invocationConstraints.reqs.length) {
            InvocationConstraints invocationConstraints3 = invocationConstraints;
            invocationConstraints = invocationConstraints2;
            invocationConstraints2 = invocationConstraints3;
        }
        if (invocationConstraints2.reqs.length > 0) {
            invocationConstraintArray = InvocationConstraints.concat(invocationConstraints.reqs, invocationConstraints2.reqs);
            n = 0;
        } else {
            invocationConstraintArray = invocationConstraints.reqs;
            n = invocationConstraints.prefs.length;
        }
        InvocationConstraint[] invocationConstraintArray2 = invocationConstraints.prefs.length > 0 || invocationConstraints2.prefs.length > 0 ? InvocationConstraints.concat(invocationConstraints.prefs, invocationConstraints2.prefs) : empty;
        return new InvocationConstraints(invocationConstraintArray, invocationConstraints.reqs.length, invocationConstraintArray2, n, invocationConstraints.rel | invocationConstraints2.rel);
    }

    private static InvocationConstraint[] concat(InvocationConstraint[] invocationConstraintArray, InvocationConstraint[] invocationConstraintArray2) {
        InvocationConstraint[] invocationConstraintArray3 = new InvocationConstraint[invocationConstraintArray.length + invocationConstraintArray2.length];
        System.arraycopy(invocationConstraintArray, 0, invocationConstraintArray3, 0, invocationConstraintArray.length);
        System.arraycopy(invocationConstraintArray2, 0, invocationConstraintArray3, invocationConstraintArray.length, invocationConstraintArray2.length);
        return invocationConstraintArray3;
    }

    private static InvocationConstraint[] makeAbsolute(InvocationConstraint[] invocationConstraintArray, long l) {
        InvocationConstraint[] invocationConstraintArray2 = new InvocationConstraint[invocationConstraintArray.length];
        int n = invocationConstraintArray.length;
        while (--n >= 0) {
            InvocationConstraint invocationConstraint = invocationConstraintArray[n];
            if (invocationConstraint instanceof RelativeTimeConstraint) {
                invocationConstraint = ((RelativeTimeConstraint)invocationConstraint).makeAbsolute(l);
            }
            invocationConstraintArray2[n] = invocationConstraint;
        }
        return invocationConstraintArray2;
    }

    public InvocationConstraints makeAbsolute(long l) {
        int n;
        InvocationConstraint[] invocationConstraintArray;
        if (this.rel == 0) {
            return this;
        }
        if ((this.rel & 1) != 0) {
            invocationConstraintArray = InvocationConstraints.makeAbsolute(this.reqs, l);
            n = 0;
        } else {
            invocationConstraintArray = this.reqs;
            n = this.reqs.length;
        }
        InvocationConstraint[] invocationConstraintArray2 = (this.rel & 2) != 0 ? InvocationConstraints.makeAbsolute(this.prefs, l) : (InvocationConstraint[])this.prefs.clone();
        return new InvocationConstraints(invocationConstraintArray, n, invocationConstraintArray2, 0, 0);
    }

    public InvocationConstraints makeAbsolute() {
        if (this.rel == 0) {
            return this;
        }
        return this.makeAbsolute(System.currentTimeMillis());
    }

    public Set requirements() {
        return new ArraySet(this.reqs);
    }

    public Set preferences() {
        return new ArraySet(this.prefs);
    }

    public boolean isEmpty() {
        return this.reqs.length == 0 && this.prefs.length == 0;
    }

    public int hashCode() {
        return Constraint.hash(this.reqs) + Constraint.hash(this.prefs);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof InvocationConstraints)) {
            return false;
        }
        InvocationConstraints invocationConstraints = (InvocationConstraints)object;
        return Constraint.equal(this.reqs, invocationConstraints.reqs) && Constraint.equal(this.prefs, invocationConstraints.prefs);
    }

    public String toString() {
        return "InvocationConstraints[reqs: " + Constraint.toString(this.reqs) + ", prefs: " + Constraint.toString(this.prefs) + "]";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        InvocationConstraints.verify(this.reqs);
        InvocationConstraints.verify(this.prefs);
        int n = this.prefs.length;
        while (--n >= 0) {
            if (!Constraint.contains(this.reqs, this.reqs.length, this.prefs[n])) continue;
            throw new InvalidObjectException("cannot create constraint with redundant elements");
        }
        this.setRelative(this.reqs, 1);
        this.setRelative(this.prefs, 1);
    }

    private static void verify(InvocationConstraint[] invocationConstraintArray) throws InvalidObjectException {
        if (invocationConstraintArray == null) {
            throw new InvalidObjectException("array cannot be null");
        }
        int n = invocationConstraintArray.length;
        while (--n >= 0) {
            InvocationConstraint invocationConstraint = invocationConstraintArray[n];
            if (invocationConstraint == null) {
                throw new InvalidObjectException("elements cannot be null");
            }
            if (!Constraint.contains(invocationConstraintArray, n, invocationConstraint)) continue;
            throw new InvalidObjectException("cannot create constraint with redundant elements");
        }
    }
}

