/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import java.math.BigInteger;
import java.security.Key;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;
import net.jini.jeri.ssl.Utilities;
import net.jini.security.Security;

class SubjectCredentials
extends Utilities {
    private SubjectCredentials() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CertPath getCertificateChain(Subject subject, String string) {
        if (subject == null) {
            return null;
        }
        CertificateMatcher certificateMatcher = CertificateMatcher.create(string);
        if (certificateMatcher != null) {
            Set<Object> set;
            Set<Object> set2 = set = subject.getPublicCredentials();
            synchronized (set2) {
                Iterator<Object> iterator = set.iterator();
                while (iterator.hasNext()) {
                    CertPath certPath;
                    Object object = iterator.next();
                    if (!SubjectCredentials.isX509CertificateChain(object) || !certificateMatcher.matches(SubjectCredentials.firstX509Cert(certPath = (CertPath)object))) continue;
                    return certPath;
                }
            }
        }
        return null;
    }

    static String getCertificateName(X509Certificate x509Certificate) {
        return CertificateMatcher.getName(x509Certificate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List getCertificateChains(Subject subject) {
        ArrayList<Object> arrayList = null;
        if (subject != null) {
            Set<Object> set;
            Set<Object> set2 = set = subject.getPublicCredentials();
            synchronized (set2) {
                Iterator<Object> iterator = set.iterator();
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    if (!SubjectCredentials.isX509CertificateChain(object)) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList<Object>(set.size());
                    }
                    arrayList.add(object);
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CertPath getCertificateChain(Subject subject, X509Certificate x509Certificate) {
        if (subject != null) {
            Set<Object> set;
            Principal principal = null;
            PublicKey publicKey = null;
            Set<Object> set2 = set = subject.getPublicCredentials();
            synchronized (set2) {
                Iterator<Object> iterator = set.iterator();
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    if (!SubjectCredentials.isX509CertificateChain(object)) continue;
                    CertPath certPath = (CertPath)object;
                    X509Certificate x509Certificate2 = SubjectCredentials.firstX509Cert(certPath);
                    if (x509Certificate.equals(x509Certificate2)) {
                        return certPath;
                    }
                    if (principal == null) {
                        principal = x509Certificate.getSubjectDN();
                        publicKey = x509Certificate.getPublicKey();
                    }
                    if (!((Object)principal).equals(x509Certificate2.getSubjectDN()) || !publicKey.equals(x509Certificate2.getPublicKey())) continue;
                    return certPath;
                }
            }
        }
        return null;
    }

    static Set getPrincipals(Subject subject, int n, X500PrivateCredential[] x500PrivateCredentialArray) {
        HashSet<X500Principal> hashSet = new HashSet<X500Principal>(subject.getPrincipals().size());
        List list = SubjectCredentials.getCertificateChains(subject);
        if (list != null) {
            int n2 = list.size();
            while (--n2 >= 0) {
                boolean bl;
                X500Principal x500Principal;
                CertPath certPath = (CertPath)list.get(n2);
                X509Certificate x509Certificate = SubjectCredentials.firstX509Cert(certPath);
                String string = x509Certificate.getPublicKey().getAlgorithm();
                if (!SubjectCredentials.permittedKeyAlgorithm(string, n) || (x500Principal = SubjectCredentials.getPrincipal(subject, x509Certificate)) == null) continue;
                boolean bl2 = bl = x500PrivateCredentialArray == null;
                if (!bl) {
                    int n3 = x500PrivateCredentialArray.length;
                    while (--n3 >= 0) {
                        X500PrivateCredential x500PrivateCredential = x500PrivateCredentialArray[n3];
                        if (!x509Certificate.equals(x500PrivateCredential.getCertificate())) continue;
                        bl = true;
                        break;
                    }
                }
                if (!bl) continue;
                hashSet.add(x500Principal);
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static X500PrivateCredential getPrivateCredential(Subject subject, X509Certificate x509Certificate) {
        Set<Object> set;
        X500PrivateCredential x500PrivateCredential = null;
        Set<Object> set2 = set = subject.getPrivateCredentials();
        synchronized (set2) {
            Iterator<Object> iterator = set.iterator();
            while (iterator.hasNext()) {
                X500PrivateCredential x500PrivateCredential2;
                Object object = iterator.next();
                if (!(object instanceof X500PrivateCredential) || !x509Certificate.equals((x500PrivateCredential2 = (X500PrivateCredential)object).getCertificate())) continue;
                x500PrivateCredential = x500PrivateCredential2;
                break;
            }
        }
        return x500PrivateCredential;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static X500Principal getPrincipal(Subject subject, X509Certificate x509Certificate) {
        Set<Principal> set;
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        String string = x500Principal.getName("CANONICAL");
        Set<Principal> set2 = set = subject.getPrincipals();
        synchronized (set2) {
            Iterator<Principal> iterator = set.iterator();
            while (iterator.hasNext()) {
                X500Principal x500Principal2;
                Principal principal = iterator.next();
                if (!(principal instanceof X500Principal) || !(x500Principal2 = (X500Principal)principal).getName("CANONICAL").equals(string)) continue;
                return x500Principal2;
            }
        }
        return null;
    }

    static String credentialsString(Subject subject) {
        List list = SubjectCredentials.getCertificateChains(subject);
        if (list == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = list.size();
        while (--n >= 0) {
            CertPath certPath = (CertPath)list.get(n);
            X509Certificate x509Certificate = SubjectCredentials.firstX509Cert(certPath);
            X500Principal x500Principal = SubjectCredentials.getPrincipal(subject, x509Certificate);
            if (x500Principal == null) continue;
            stringBuffer.append("  Principal: ").append(x500Principal).append('\n');
            stringBuffer.append("    Public key: ");
            SubjectCredentials.appendKeyString(x509Certificate.getPublicKey(), stringBuffer);
            stringBuffer.append('\n');
            stringBuffer.append("    Private key: ");
            try {
                PrivateKey privateKey;
                X500PrivateCredential x500PrivateCredential = (X500PrivateCredential)Security.doPrivileged(new GetPrivateCredentialAction(subject, x509Certificate));
                PrivateKey privateKey2 = privateKey = x500PrivateCredential != null ? x500PrivateCredential.getPrivateKey() : null;
                if (privateKey == null) {
                    stringBuffer.append("Not found");
                    continue;
                }
                SubjectCredentials.appendKeyString(privateKey, stringBuffer);
            }
            catch (SecurityException securityException) {
                stringBuffer.append("No permission");
            }
        }
        return stringBuffer.toString();
    }

    private static void appendKeyString(Key key, StringBuffer stringBuffer) {
        String string = key.getClass().getName();
        stringBuffer.append(string.substring(string.lastIndexOf(46) + 1));
        stringBuffer.append('@');
        stringBuffer.append(Integer.toHexString(System.identityHashCode(key)));
    }

    private static boolean isX509CertificateChain(Object object) {
        if (!(object instanceof CertPath)) {
            return false;
        }
        CertPath certPath = (CertPath)object;
        if (certPath.getCertificates().isEmpty()) {
            return false;
        }
        return certPath.getType().equals("X.509");
    }

    static class GetAllPrivateCredentialsAction
    implements PrivilegedAction {
        private final Subject subject;

        GetAllPrivateCredentialsAction(Subject subject) {
            this.subject = subject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run() {
            Set<Object> set = this.subject.getPrivateCredentials();
            ArrayList<Object> arrayList = new ArrayList<Object>(set.size());
            Set<Object> set2 = set;
            synchronized (set2) {
                Iterator<Object> iterator = set.iterator();
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    if (!(object instanceof X500PrivateCredential)) continue;
                    arrayList.add(object);
                }
            }
            return arrayList.toArray(new X500PrivateCredential[arrayList.size()]);
        }
    }

    static class GetPrivateCredentialAction
    implements PrivilegedAction {
        private final Subject subject;
        private final X509Certificate cert;

        GetPrivateCredentialAction(Subject subject, X509Certificate x509Certificate) {
            this.subject = subject;
            this.cert = x509Certificate;
        }

        public Object run() {
            return SubjectCredentials.getPrivateCredential(this.subject, this.cert);
        }
    }

    private static class CertificateMatcher {
        private final BigInteger serialNumber;
        private final String issuerName;

        static CertificateMatcher create(String string) {
            BigInteger bigInteger;
            if (string == null) {
                return null;
            }
            int n = string.indexOf(64);
            if (n < 0) {
                return null;
            }
            try {
                bigInteger = new BigInteger(string.substring(0, n), 16);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            String string2 = string.substring(n + 1);
            return new CertificateMatcher(bigInteger, string2);
        }

        private CertificateMatcher(BigInteger bigInteger, String string) {
            this.serialNumber = bigInteger;
            this.issuerName = string;
        }

        static String getName(X509Certificate x509Certificate) {
            return x509Certificate.getSerialNumber().toString(16) + "@" + CertificateMatcher.getIssuerName(x509Certificate);
        }

        boolean matches(X509Certificate x509Certificate) {
            return x509Certificate.getSerialNumber().equals(this.serialNumber) && CertificateMatcher.getIssuerName(x509Certificate).equals(this.issuerName);
        }

        private static String getIssuerName(X509Certificate x509Certificate) {
            return x509Certificate.getIssuerX500Principal().getName("CANONICAL");
        }
    }
}

