/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui;

import com.mathworks.help.helpui.HelpBrowserSearchConfig;
import com.mathworks.help.helpui.HelpBrowserUtils;
import com.mathworks.help.helpui.LocalDocSetParser;
import com.mathworks.help.helpui.LocaleHelper;
import com.mathworks.help.helpui.SearchHelper;
import com.mathworks.helpsearch.DocLanguage;
import com.mathworks.helpsearch.SearchConfig;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.product.ProductBaseCodeMap;
import com.mathworks.helpsearch.product.ProductFilter;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class HelpBrowserSearchHelper
implements SearchHelper {
    private final SearchConfig fSearchConfig;
    private final DocumentationSet fDocumentationSet;
    private final ProductFilter fProductFilter;

    public HelpBrowserSearchHelper(File file, LocaleHelper localeHelper) {
        this(file, localeHelper, null);
    }

    public HelpBrowserSearchHelper(String string, LocaleHelper localeHelper, Collection<String> collection) {
        this(new File(string), localeHelper, collection);
    }

    public HelpBrowserSearchHelper(File file, LocaleHelper localeHelper, Collection<String> collection) {
        DocLanguage docLanguage = HelpBrowserUtils.getDocLanguageForLocale(localeHelper.getHelpLocale());
        this.fSearchConfig = new HelpBrowserSearchConfig(file, docLanguage);
        this.fDocumentationSet = LocalDocSetParser.parseDocumentationSet(file, docLanguage);
        this.fProductFilter = HelpBrowserSearchHelper.buildProductFilter(this.fDocumentationSet, collection);
    }

    private static ProductFilter buildProductFilter(DocumentationSet documentationSet, Collection<String> collection) {
        if (documentationSet == null || collection == null) {
            return null;
        }
        ProductBaseCodeMap productBaseCodeMap = documentationSet.getBaseCodeMap();
        if (productBaseCodeMap != null) {
            Set set = productBaseCodeMap.getDocProductsForBaseCodes(new HashSet<String>(collection));
            return set.isEmpty() ? null : ProductFilter.includeProducts((Collection)set);
        }
        return null;
    }

    @Override
    public SearchConfig getSearchConfig() {
        return this.fSearchConfig;
    }

    @Override
    public DocumentationSet getDocumentationSet() {
        return this.fDocumentationSet;
    }

    @Override
    public ProductFilter getProductFilter() {
        return this.fProductFilter;
    }
}

