/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui.buildtools;

import com.mathworks.help.helpui.LocalDocSetParser;
import com.mathworks.help.helpui.buildtools.DocSetBuildToolUtils;
import com.mathworks.helpsearch.DocLanguage;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.product.JavaScriptBaseCodeMap;
import java.io.File;
import java.io.IOException;

public class BaseCodeJavaScriptBuilder {
    private final File fDocSetDir;

    public BaseCodeJavaScriptBuilder(File file) {
        this.fDocSetDir = file;
    }

    public void buildJavaScriptFile() throws IOException {
        DocumentationSet documentationSet = this.getDocumentationSet();
        JavaScriptBaseCodeMap javaScriptBaseCodeMap = new JavaScriptBaseCodeMap(documentationSet.getBaseCodeMap());
        javaScriptBaseCodeMap.writeJsFile(this.fDocSetDir);
    }

    private DocumentationSet getDocumentationSet() {
        LocalDocSetParser localDocSetParser = new LocalDocSetParser(this.fDocSetDir, DocLanguage.ENGLISH);
        return localDocSetParser.getDocSet();
    }

    public static void main(String[] stringArray) {
        File file = DocSetBuildToolUtils.getDocSetDirectoryFromInputArgs(stringArray, 0);
        try {
            new BaseCodeJavaScriptBuilder(file).buildJavaScriptFile();
        }
        catch (IOException iOException) {
            System.out.println("Failed to build JavaScript file.");
            iOException.printStackTrace();
            System.exit(1);
        }
    }
}

