/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery.internal;

import com.sun.jini.discovery.UnicastDiscoveryClient;
import com.sun.jini.discovery.UnicastResponse;
import com.sun.jini.discovery.internal.EndpointBasedProvider;
import com.sun.jini.discovery.internal.EndpointInternals;
import com.sun.jini.discovery.internal.Plaintext;
import com.sun.jini.jeri.internal.connection.ConnManager;
import com.sun.jini.jeri.internal.connection.ConnManagerFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.NoSuchElementException;
import javax.net.SocketFactory;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.Endpoint;
import net.jini.jeri.OutboundRequest;
import net.jini.jeri.OutboundRequestIterator;
import net.jini.jeri.connection.Connection;
import net.jini.jeri.connection.ConnectionEndpoint;
import net.jini.jeri.connection.OutboundRequestHandle;

public abstract class EndpointBasedClient
extends EndpointBasedProvider
implements UnicastDiscoveryClient {
    protected EndpointBasedClient(String string, EndpointInternals endpointInternals) {
        super(string, endpointInternals);
    }

    public void checkUnicastDiscoveryConstraints(InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
        if (invocationConstraints == null) {
            invocationConstraints = InvocationConstraints.EMPTY;
        }
        ConnectionInfo connectionInfo = this.getConnectionInfo(null, invocationConstraints);
        EndpointBasedClient.checkIntegrity(this.endpointInternals.getUnfulfilledConstraints(connectionInfo.handle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnicastResponse doUnicastDiscovery(Socket socket, InvocationConstraints invocationConstraints, ClassLoader classLoader, ClassLoader classLoader2, Collection collection, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException, ClassNotFoundException {
        UnicastResponse unicastResponse;
        if (socket == null || byteBuffer == null || byteBuffer2 == null) {
            throw new NullPointerException();
        }
        if (invocationConstraints == null) {
            invocationConstraints = InvocationConstraints.EMPTY;
        }
        ConnectionInfo connectionInfo = this.getConnectionInfo(socket, invocationConstraints);
        Connection connection = connectionInfo.endpoint.connect(connectionInfo.handle);
        try {
            boolean bl = EndpointBasedClient.checkIntegrity(connection.getUnfulfilledConstraints(connectionInfo.handle));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(connection.getOutputStream());
            connection.writeRequestData(connectionInfo.handle, bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).write(EndpointBasedClient.calcHandshakeHash(byteBuffer, byteBuffer2));
            ((OutputStream)bufferedOutputStream).flush();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(connection.getInputStream());
            IOException iOException = connection.readResponseData(connectionInfo.handle, bufferedInputStream);
            if (iOException != null) {
                throw iOException;
            }
            unicastResponse = Plaintext.readUnicastResponse(bufferedInputStream, classLoader, bl, classLoader2, collection);
            Object var16_15 = null;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            connection.close();
            throw throwable;
        }
        connection.close();
        return unicastResponse;
    }

    protected abstract Endpoint getEndpoint(SocketFactory var1, InvocationConstraints var2) throws UnsupportedConstraintException;

    private ConnectionInfo getConnectionInfo(Socket socket, InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
        Endpoint endpoint = this.getEndpoint(new PrearrangedSocketFactory(socket), invocationConstraints);
        ConnManagerFactoryImpl connManagerFactoryImpl = new ConnManagerFactoryImpl();
        this.endpointInternals.setConnManagerFactory(endpoint, connManagerFactoryImpl);
        this.endpointInternals.disableSocketConnect(endpoint);
        OutboundRequestIterator outboundRequestIterator = endpoint.newRequest(invocationConstraints);
        ConnectionInfo connectionInfo = connManagerFactoryImpl.getConnectionInfo();
        if (connectionInfo != null) {
            return connectionInfo;
        }
        if (outboundRequestIterator.hasNext()) {
            try {
                outboundRequestIterator.next();
            }
            catch (UnsupportedConstraintException unsupportedConstraintException) {
                throw unsupportedConstraintException;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new AssertionError((Object)"expected UnsupportedConstraintException");
    }

    private static class PrearrangedSocketFactory
    extends SocketFactory {
        private final Socket socket;

        PrearrangedSocketFactory(Socket socket) {
            this.socket = socket;
        }

        public Socket createSocket() throws IOException {
            return this.socket;
        }

        public Socket createSocket(String string, int n) throws IOException {
            return this.socket;
        }

        public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
            return this.socket;
        }

        public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
            return this.socket;
        }

        public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
            return this.socket;
        }

        public String toString() {
            return "PrearrangedSocketFactory[" + this.socket + "]";
        }
    }

    private static class ConnManagerFactoryImpl
    implements ConnManagerFactory {
        private ConnectionInfo connInfo = null;

        ConnManagerFactoryImpl() {
        }

        public ConnManager create(final ConnectionEndpoint connectionEndpoint) {
            if (connectionEndpoint == null) {
                throw new NullPointerException();
            }
            return new ConnManager(){

                public OutboundRequestIterator newRequest(OutboundRequestHandle outboundRequestHandle) {
                    if (outboundRequestHandle == null) {
                        throw new NullPointerException();
                    }
                    ConnManagerFactoryImpl.this.connInfo = new ConnectionInfo(connectionEndpoint, outboundRequestHandle);
                    return new OutboundRequestIterator(){

                        public boolean hasNext() {
                            return false;
                        }

                        public OutboundRequest next() throws IOException {
                            throw new NoSuchElementException();
                        }
                    };
                }
            };
        }

        ConnectionInfo getConnectionInfo() {
            return this.connInfo;
        }
    }

    private static class ConnectionInfo {
        final ConnectionEndpoint endpoint;
        final OutboundRequestHandle handle;

        ConnectionInfo(ConnectionEndpoint connectionEndpoint, OutboundRequestHandle outboundRequestHandle) {
            this.endpoint = connectionEndpoint;
            this.handle = outboundRequestHandle;
        }
    }
}

