/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.mux;

import com.sun.jini.jeri.internal.mux.ConnectionIO;
import com.sun.jini.jeri.internal.mux.IOFuture;
import com.sun.jini.jeri.internal.mux.Mux;
import com.sun.jini.jeri.internal.mux.ProtocolException;
import com.sun.jini.logging.Levels;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.AccessController;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

final class StreamConnectionIO
extends ConnectionIO {
    private static final int RECEIVE_BUFFER_SIZE = 2048;
    private static final Executor systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(false));
    private static final Logger logger = Logger.getLogger("net.jini.jeri.connection.mux");
    private final OutputStream out;
    private final InputStream in;
    private final WritableByteChannel outChannel;
    private final ReadableByteChannel inChannel;
    private LinkedList sendQueue = new LinkedList();
    private final ByteBuffer inputBuffer = ByteBuffer.allocate(2048);
    static /* synthetic */ Class class$com$sun$jini$jeri$internal$mux$StreamConnectionIO;

    StreamConnectionIO(Mux mux, OutputStream outputStream, InputStream inputStream) {
        super(mux);
        this.out = outputStream;
        this.in = inputStream;
        this.outChannel = StreamConnectionIO.newChannel(outputStream);
        this.inChannel = StreamConnectionIO.newChannel(inputStream);
    }

    void start() throws IOException {
        systemThreadPool.execute(new Writer(), "mux writer");
        systemThreadPool.execute(new Reader(), "mux reader");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncSend(ByteBuffer byteBuffer) {
        Object object = this.mux.muxLock;
        synchronized (object) {
            if (this.mux.muxDown) {
                return;
            }
            this.sendQueue.addLast(byteBuffer);
            this.mux.muxLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncSend(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        Object object = this.mux.muxLock;
        synchronized (object) {
            if (this.mux.muxDown) {
                return;
            }
            this.sendQueue.addLast(byteBuffer);
            this.sendQueue.addLast(byteBuffer2);
            this.mux.muxLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IOFuture futureSend(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        Object object = this.mux.muxLock;
        synchronized (object) {
            IOFuture iOFuture = new IOFuture();
            if (this.mux.muxDown) {
                IOException iOException = new IOException(this.mux.muxDownMessage);
                iOException.initCause(this.mux.muxDownCause);
                iOFuture.done(iOException);
                return iOFuture;
            }
            this.sendQueue.addLast(byteBuffer);
            this.sendQueue.addLast(byteBuffer2);
            this.sendQueue.addLast(iOFuture);
            this.mux.muxLock.notifyAll();
            return iOFuture;
        }
    }

    private void drainQueue(LinkedList linkedList) {
        while (!linkedList.isEmpty()) {
            Object e = linkedList.removeFirst();
            if (!(e instanceof IOFuture)) continue;
            IOException iOException = new IOException(this.mux.muxDownMessage);
            iOException.initCause(this.mux.muxDownCause);
            ((IOFuture)e).done(iOException);
        }
    }

    public static ReadableByteChannel newChannel(final InputStream inputStream) {
        return new ReadableByteChannel(){
            private static final int TRANSFER_SIZE = 8192;
            private byte[] buf = new byte[0];
            private boolean open = true;

            public int read(ByteBuffer byteBuffer) throws IOException {
                int n;
                int n2 = byteBuffer.remaining();
                int n3 = 0;
                for (n = 0; n < n2; n += n3) {
                    int n4 = Math.min(n2 - n, 8192);
                    if (this.buf.length < n4) {
                        this.buf = new byte[n4];
                    }
                    if (n > 0 && inputStream.available() <= 0 || (n3 = inputStream.read(this.buf, 0, n4)) < 0) break;
                    byteBuffer.put(this.buf, 0, n3);
                }
                if (n3 < 0 && n == 0) {
                    return -1;
                }
                return n;
            }

            public boolean isOpen() {
                return this.open;
            }

            public void close() throws IOException {
                inputStream.close();
                this.open = false;
            }
        };
    }

    public static WritableByteChannel newChannel(final OutputStream outputStream) {
        return new WritableByteChannel(){
            private static final int TRANSFER_SIZE = 8192;
            private byte[] buf = new byte[0];
            private boolean open = true;

            public int write(ByteBuffer byteBuffer) throws IOException {
                int n;
                int n2;
                int n3 = byteBuffer.remaining();
                for (n = 0; n < n3; n += n2) {
                    n2 = Math.min(n3 - n, 8192);
                    if (this.buf.length < n2) {
                        this.buf = new byte[n2];
                    }
                    byteBuffer.get(this.buf, 0, n2);
                    outputStream.write(this.buf, 0, n2);
                }
                return n;
            }

            public boolean isOpen() {
                return this.open;
            }

            public void close() throws IOException {
                outputStream.close();
                this.open = false;
            }
        };
    }

    private class Reader
    implements Runnable {
        static final /* synthetic */ boolean $assertionsDisabled;

        Reader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    do {
                        int n;
                        if ((n = StreamConnectionIO.this.inChannel.read(StreamConnectionIO.this.inputBuffer)) == -1) {
                            throw new EOFException();
                        }
                        if (!$assertionsDisabled && n <= 0) {
                            throw new AssertionError();
                        }
                        StreamConnectionIO.this.mux.processIncomingData(StreamConnectionIO.this.inputBuffer);
                    } while ($assertionsDisabled || StreamConnectionIO.this.inputBuffer.hasRemaining());
                    throw new AssertionError();
                }
                catch (ProtocolException protocolException) {
                    IOFuture iOFuture = null;
                    Object object = StreamConnectionIO.this.mux.muxLock;
                    synchronized (object) {
                        if (!StreamConnectionIO.this.mux.muxDown) {
                            logger.log(Levels.HANDLED, "mux reader thread dying, protocol error", protocolException);
                            iOFuture = StreamConnectionIO.this.mux.futureSendError(protocolException.getMessage());
                            StreamConnectionIO.this.mux.setDown("protocol violation detected: " + protocolException.getMessage(), null);
                        } else {
                            logger.log(Level.FINEST, "mux reader thread dying: " + protocolException.getMessage());
                        }
                    }
                    if (iOFuture != null) {
                        try {
                            iOFuture.waitUntilDone();
                        }
                        catch (IOException iOException) {
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    Object var6_10 = null;
                    try {
                        StreamConnectionIO.this.inChannel.close();
                    }
                    catch (IOException iOException) {}
                }
                catch (IOException iOException) {
                    logger.log(Levels.HANDLED, "mux reader thread dying, I/O error", iOException);
                    StreamConnectionIO.this.mux.setDown("I/O error reading from mux connection: " + iOException.toString(), iOException);
                    Object var6_11 = null;
                    try {
                        StreamConnectionIO.this.inChannel.close();
                    }
                    catch (IOException iOException2) {}
                }
                catch (Throwable throwable) {
                    logger.log(Level.INFO, "mux reader thread dying, unexpected exception", throwable);
                    StreamConnectionIO.this.mux.setDown("unexpected exception in mux reader thread: " + throwable.toString(), throwable);
                    Object var6_12 = null;
                    try {
                        StreamConnectionIO.this.inChannel.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_13 = null;
                try {
                    StreamConnectionIO.this.inChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }

        static {
            $assertionsDisabled = !(class$com$sun$jini$jeri$internal$mux$StreamConnectionIO == null ? (class$com$sun$jini$jeri$internal$mux$StreamConnectionIO = StreamConnectionIO.class$("com.sun.jini.jeri.internal.mux.StreamConnectionIO")) : class$com$sun$jini$jeri$internal$mux$StreamConnectionIO).desiredAssertionStatus();
        }
    }

    private class Writer
    implements Runnable {
        static final /* synthetic */ boolean $assertionsDisabled;

        Writer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block46: {
                LinkedList linkedList = null;
                while (true) {
                    Object object = StreamConnectionIO.this.mux.muxLock;
                    synchronized (object) {
                        while (!StreamConnectionIO.this.mux.muxDown && StreamConnectionIO.this.sendQueue.size() == 0) {
                            StreamConnectionIO.this.mux.muxLock.wait();
                        }
                        if (StreamConnectionIO.this.mux.muxDown && StreamConnectionIO.this.sendQueue.size() == 0) {
                            logger.log(Level.FINEST, "mux writer thread dying, connection down and nothing more to send");
                            break;
                        }
                        linkedList = StreamConnectionIO.this.sendQueue;
                        StreamConnectionIO.this.sendQueue = new LinkedList();
                    }
                    boolean bl = false;
                    while (!linkedList.isEmpty()) {
                        Object e = linkedList.getFirst();
                        if (e instanceof ByteBuffer) {
                            StreamConnectionIO.this.outChannel.write((ByteBuffer)e);
                            bl = true;
                        } else {
                            if (!$assertionsDisabled && !(e instanceof IOFuture)) {
                                throw new AssertionError();
                            }
                            if (bl) {
                                StreamConnectionIO.this.out.flush();
                                bl = false;
                            }
                            ((IOFuture)e).done();
                        }
                        linkedList.removeFirst();
                    }
                    if (!bl) continue;
                    StreamConnectionIO.this.out.flush();
                }
                Object var5_9 = null;
                Object object2222 = StreamConnectionIO.this.mux.muxLock;
                synchronized (object2222) {
                    if (!$assertionsDisabled && !StreamConnectionIO.this.mux.muxDown) {
                        throw new AssertionError();
                    }
                    if (linkedList != null) {
                        StreamConnectionIO.this.drainQueue(linkedList);
                    }
                    StreamConnectionIO.this.drainQueue(StreamConnectionIO.this.sendQueue);
                }
                try {
                    StreamConnectionIO.this.outChannel.close();
                }
                catch (IOException object2222) {}
                break block46;
                {
                    catch (InterruptedException interruptedException) {
                        logger.log(Level.INFO, "mux writer thread dying, interrupted", interruptedException);
                        StreamConnectionIO.this.mux.setDown("mux writer thread interrupted", interruptedException);
                        Object var5_10 = null;
                        Object object32222 = StreamConnectionIO.this.mux.muxLock;
                        synchronized (object32222) {
                            if (!$assertionsDisabled && !StreamConnectionIO.this.mux.muxDown) {
                                throw new AssertionError();
                            }
                            if (linkedList != null) {
                                StreamConnectionIO.this.drainQueue(linkedList);
                            }
                            StreamConnectionIO.this.drainQueue(StreamConnectionIO.this.sendQueue);
                        }
                        try {
                            StreamConnectionIO.this.outChannel.close();
                        }
                        catch (IOException object32222) {}
                        break block46;
                    }
                    catch (IOException iOException) {
                        logger.log(Levels.HANDLED, "mux writer thread dying, I/O error", iOException);
                        StreamConnectionIO.this.mux.setDown("I/O error writing to mux connection: " + iOException.toString(), iOException);
                        Object var5_11 = null;
                        Object object42222 = StreamConnectionIO.this.mux.muxLock;
                        synchronized (object42222) {
                            if (!$assertionsDisabled && !StreamConnectionIO.this.mux.muxDown) {
                                throw new AssertionError();
                            }
                            if (linkedList != null) {
                                StreamConnectionIO.this.drainQueue(linkedList);
                            }
                            StreamConnectionIO.this.drainQueue(StreamConnectionIO.this.sendQueue);
                        }
                        try {
                            StreamConnectionIO.this.outChannel.close();
                        }
                        catch (IOException object42222) {}
                        break block46;
                    }
                    catch (Throwable throwable) {
                        logger.log(Level.INFO, "mux writer thread dying, unexpected exception", throwable);
                        StreamConnectionIO.this.mux.setDown("unexpected exception in mux writer thread: " + throwable.toString(), throwable);
                        Object var5_12 = null;
                        Object object52222 = StreamConnectionIO.this.mux.muxLock;
                        synchronized (object52222) {
                            if (!$assertionsDisabled && !StreamConnectionIO.this.mux.muxDown) {
                                throw new AssertionError();
                            }
                            if (linkedList != null) {
                                StreamConnectionIO.this.drainQueue(linkedList);
                            }
                            StreamConnectionIO.this.drainQueue(StreamConnectionIO.this.sendQueue);
                        }
                        try {
                            StreamConnectionIO.this.outChannel.close();
                        }
                        catch (IOException object52222) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var5_13 = null;
                    Object object62222 = StreamConnectionIO.this.mux.muxLock;
                    synchronized (object62222) {
                        if (!$assertionsDisabled && !StreamConnectionIO.this.mux.muxDown) {
                            throw new AssertionError();
                        }
                        if (linkedList != null) {
                            StreamConnectionIO.this.drainQueue(linkedList);
                        }
                        StreamConnectionIO.this.drainQueue(StreamConnectionIO.this.sendQueue);
                    }
                    try {
                        StreamConnectionIO.this.outChannel.close();
                    }
                    catch (IOException object62222) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }

        static {
            $assertionsDisabled = !(class$com$sun$jini$jeri$internal$mux$StreamConnectionIO == null ? (class$com$sun$jini$jeri$internal$mux$StreamConnectionIO = StreamConnectionIO.class$("com.sun.jini.jeri.internal.mux.StreamConnectionIO")) : class$com$sun$jini$jeri$internal$mux$StreamConnectionIO).desiredAssertionStatus();
        }
    }
}

