/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceID;

public class IncomingMulticastAnnouncement {
    protected ServiceID serviceID;
    protected LookupLocator locator;
    protected String[] groups;
    protected final int protoVersion = 1;

    public IncomingMulticastAnnouncement(DatagramPacket datagramPacket) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(datagramPacket.getData());
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        int n = dataInputStream.readInt();
        if (n != 1) {
            throw new IOException("unsupported protocol version: " + n);
        }
        String string = dataInputStream.readUTF();
        int n2 = dataInputStream.readInt();
        if (n2 <= 0 || n2 >= 65536) {
            throw new IOException("port number out of range: " + n2);
        }
        this.locator = new LookupLocator(string, n2);
        this.serviceID = new ServiceID(dataInputStream);
        int n3 = dataInputStream.readInt();
        if (n3 < 0 || n3 > byteArrayInputStream.available() / 2) {
            throw new IOException("group count invalid: " + n3);
        }
        this.groups = new String[n3];
        for (int i = 0; i < this.groups.length; ++i) {
            this.groups[i] = dataInputStream.readUTF();
        }
    }

    public ServiceID getServiceID() {
        return this.serviceID;
    }

    public LookupLocator getLocator() {
        return this.locator;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public int hashCode() {
        return this.serviceID.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof IncomingMulticastAnnouncement && ((IncomingMulticastAnnouncement)object).serviceID.equals(this.serviceID);
    }
}

