/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri;

import com.sun.jini.jeri.internal.runtime.BasicExportTable;
import java.lang.ref.WeakReference;
import java.rmi.Remote;
import java.rmi.server.ExportException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.export.Exporter;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.jeri.BasicObjectEndpoint;
import net.jini.jeri.InvocationLayerFactory;
import net.jini.jeri.ServerEndpoint;

public final class BasicJeriExporter
implements Exporter {
    private static final Logger logger;
    private final ServerEndpoint se;
    private final InvocationLayerFactory ilf;
    private final boolean enableDGC;
    private final boolean keepAlive;
    private final Uuid id;
    private boolean used = false;
    private BasicExportTable.Entry entry;
    private WeakReference weakImplContainer = null;
    private static final BasicExportTable table;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BasicJeriExporter(ServerEndpoint serverEndpoint, InvocationLayerFactory invocationLayerFactory) {
        this(serverEndpoint, invocationLayerFactory, false, true);
    }

    public BasicJeriExporter(ServerEndpoint serverEndpoint, InvocationLayerFactory invocationLayerFactory, boolean bl, boolean bl2) {
        this(serverEndpoint, invocationLayerFactory, bl, bl2, null);
    }

    public BasicJeriExporter(ServerEndpoint serverEndpoint, InvocationLayerFactory invocationLayerFactory, boolean bl, boolean bl2, Uuid uuid) {
        if (serverEndpoint == null || invocationLayerFactory == null) {
            throw new NullPointerException();
        }
        this.se = serverEndpoint;
        this.ilf = invocationLayerFactory;
        this.id = uuid == null ? UuidFactory.generate() : uuid;
        this.enableDGC = bl;
        this.keepAlive = bl2;
    }

    public ServerEndpoint getServerEndpoint() {
        return this.se;
    }

    public InvocationLayerFactory getInvocationLayerFactory() {
        return this.ilf;
    }

    public boolean getEnableDGC() {
        return this.enableDGC;
    }

    public boolean getKeepAlive() {
        return this.keepAlive;
    }

    public Uuid getObjectIdentifier() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Remote export(Remote remote) throws ExportException {
        Remote remote2;
        block6: {
            if (this.used) {
                throw new IllegalStateException("object already exported via this exporter");
            }
            if (!$assertionsDisabled && this.entry != null) {
                throw new AssertionError();
            }
            this.entry = table.export(remote, this.se, this.enableDGC, this.keepAlive, this.id);
            this.used = true;
            InvocationLayerFactory.Instances instances = null;
            try {
                ImplContainer implContainer = new ImplContainer(remote);
                this.weakImplContainer = new WeakReference<ImplContainer>(implContainer);
                BasicObjectEndpoint basicObjectEndpoint = new BasicObjectEndpoint(this.entry.getEndpoint(), this.id, this.enableDGC, implContainer);
                instances = this.ilf.createInstances(remote, basicObjectEndpoint, this.se);
                this.entry.setInvocationDispatcher(instances.getInvocationDispatcher());
                remote2 = instances.getProxy();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "export of {0} via {1} returns proxy {2}", new Object[]{remote, this, remote2});
                }
                Object var7_6 = null;
                if (instances != null) break block6;
                this.unexport(true);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (instances == null) {
                    this.unexport(true);
                }
                throw throwable;
            }
            {
            }
        }
        return remote2;
    }

    public synchronized boolean unexport(boolean bl) {
        boolean bl2;
        if (!this.used) {
            throw new IllegalStateException("no object exported via this exporter");
        }
        if (this.entry != null && this.entry.unexport(bl)) {
            this.entry = null;
            ImplContainer implContainer = (ImplContainer)this.weakImplContainer.get();
            if (implContainer != null) {
                implContainer.clearImpl();
            }
        }
        boolean bl3 = bl2 = this.entry == null;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "unexport on {0} returns {1}", new Object[]{this, bl2});
        }
        return bl2;
    }

    public String toString() {
        return "BasicJeriExporter[" + this.se + "," + this.id + "]";
    }

    static {
        $assertionsDisabled = !BasicJeriExporter.class.desiredAssertionStatus();
        logger = Logger.getLogger("net.jini.jeri.BasicJeriExporter");
        table = new BasicExportTable();
    }

    private static class ImplContainer {
        private Object impl;

        ImplContainer(Object object) {
            this.impl = object;
        }

        void clearImpl() {
            this.impl = null;
        }
    }
}

