/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.appmanagement;

import com.mathworks.appmanagement.AppGalleryPathConfiguration;
import com.mathworks.appmanagement.AppMetadata;
import com.mathworks.appmanagement.Fader;
import com.mathworks.appmanagement.UserAppToolSetFactory;
import com.mathworks.appmanagement.resources.AppManagementComponentName;
import com.mathworks.appmanagement.resources.ResourceKey;
import com.mathworks.toolstrip.Toolstrip;
import com.mathworks.toolstrip.accessories.TSRobot;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.tooltip.BalloonToolTip;
import com.sun.awt.AWTUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

final class ShowNotificationRunnable
implements Runnable {
    private final DTFrame parent;
    private final AppMetadata appMetadata;
    private final ResourceKey labelResource;

    ShowNotificationRunnable(DTFrame dTFrame, AppMetadata appMetadata, ResourceKey resourceKey) {
        this.parent = dTFrame;
        this.appMetadata = appMetadata;
        this.labelResource = resourceKey;
    }

    @Override
    public void run() {
        final Toolstrip toolstrip = this.parent.getToolstrip();
        NotificationType notificationType = this.getNotificationType(toolstrip);
        if (notificationType.shouldShowNotification()) {
            JComponent jComponent = notificationType.getComponent();
            Point point = jComponent.getLocationOnScreen();
            Dimension dimension = jComponent.getSize();
            Rectangle rectangle = new Rectangle(point, dimension);
            Component component = this.createNotificationContent(this.appMetadata);
            ArrayList<BalloonToolTip.ArrowDirection> arrayList = new ArrayList<BalloonToolTip.ArrowDirection>();
            arrayList.add(BalloonToolTip.ArrowDirection.SOUTH);
            Dimension dimension2 = component.getPreferredSize();
            final BalloonToolTip balloonToolTip = new BalloonToolTip((Frame)this.parent, component, arrayList, dimension2, rectangle, null, AWTUtilities.isTranslucencySupported((AWTUtilities.Translucency)AWTUtilities.Translucency.TRANSLUCENT));
            JDialog jDialog = balloonToolTip.getDialog();
            jDialog.setName(AppManagementComponentName.NOTIFICATION.toString());
            final Fader fader = new Fader(jDialog);
            component.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    mouseEvent.consume();
                    balloonToolTip.hide();
                    ShowNotificationRunnable.this.showAppsTabComponent(toolstrip);
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    fader.reset();
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    fader.fade();
                }
            });
            balloonToolTip.show();
            fader.fade();
        }
    }

    private NotificationType getNotificationType(Toolstrip toolstrip) {
        NotificationType[] notificationTypeArray = new NotificationType[]{new NoNotificationType(), new NotifyMoreButtonType(toolstrip), new NotifyAppsTabType(toolstrip)};
        boolean bl = this.isAppGalleryShowing(toolstrip);
        boolean bl2 = this.isMoreButtonComponentShowing(toolstrip);
        boolean bl3 = this.isAppTabComponentShowing(toolstrip);
        boolean bl4 = this.appsTabCurrentlySelected(toolstrip);
        for (NotificationType notificationType : notificationTypeArray) {
            if (!notificationType.isType(bl, bl2, bl3, bl4)) continue;
            return notificationType;
        }
        return null;
    }

    private void showAppsTabComponent(Toolstrip toolstrip) {
        TSRobot tSRobot = new TSRobot(toolstrip);
        String[] stringArray = this.getPathToOpenedGallery();
        tSRobot.ensureVisible(stringArray);
    }

    private boolean isAppGalleryShowing(Toolstrip toolstrip) {
        TSRobot tSRobot = new TSRobot(toolstrip);
        String[] stringArray = this.getPathToOpenedGallery();
        return tSRobot.isVisible(stringArray);
    }

    private boolean isMoreButtonComponentShowing(Toolstrip toolstrip) {
        TSRobot tSRobot = new TSRobot(toolstrip);
        String[] stringArray = this.getPathToOpenedGallery();
        return this.appsTabCurrentlySelected(toolstrip) && this.isRobotTargetShowing(tSRobot, stringArray);
    }

    private boolean isAppTabComponentShowing(Toolstrip toolstrip) {
        TSRobot tSRobot = new TSRobot(toolstrip);
        AppGalleryPathConfiguration appGalleryPathConfiguration = UserAppToolSetFactory.getAppGalleryPathConfiguration();
        String[] stringArray = appGalleryPathConfiguration.getPathToAppsTab();
        return this.isRobotTargetShowing(tSRobot, stringArray);
    }

    private boolean isRobotTargetShowing(TSRobot tSRobot, String[] stringArray) {
        Point point;
        TSRobot.Target target = tSRobot.getPreceedingTrigger(stringArray);
        try {
            point = target.getComponent().getLocationOnScreen();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            return false;
        }
        return !(point.getX() < 0.0) && !(point.getY() < 0.0);
    }

    private String[] getPathToOpenedGallery() {
        AppGalleryPathConfiguration appGalleryPathConfiguration = UserAppToolSetFactory.getAppGalleryPathConfiguration();
        return appGalleryPathConfiguration.getPathToOpenedGallery();
    }

    private boolean appsTabCurrentlySelected(Toolstrip toolstrip) {
        return UserAppToolSetFactory.getAppGalleryPathConfiguration().getAppsTab().equalsIgnoreCase(toolstrip.getCurrentTab());
    }

    private Component createNotificationContent(AppMetadata appMetadata) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel(this.labelResource.getString(new Object[0]));
        Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        jPanel2.add(jLabel);
        jPanel2.setBorder(border);
        jPanel.add((Component)jPanel2, "North");
        JLabel jLabel2 = new JLabel(appMetadata.getIcon());
        jLabel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        jPanel.add((Component)jLabel2, "Center");
        JLabel jLabel3 = new JLabel(appMetadata.getName());
        jLabel3.setFont(jLabel3.getFont().deriveFont(1));
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jLabel3);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        jPanel.add((Component)jPanel3, "South");
        jPanel.setBorder(border);
        return jPanel;
    }

    private class NotifyAppsTabType
    implements NotificationType {
        private final Toolstrip toolstrip;

        public NotifyAppsTabType(Toolstrip toolstrip) {
            this.toolstrip = toolstrip;
        }

        @Override
        public JComponent getComponent() {
            AppGalleryPathConfiguration appGalleryPathConfiguration = UserAppToolSetFactory.getAppGalleryPathConfiguration();
            String[] stringArray = appGalleryPathConfiguration.getPathToAppsTab();
            TSRobot tSRobot = new TSRobot(this.toolstrip);
            TSRobot.Target target = tSRobot.getPreceedingTrigger(stringArray);
            return target.getComponent();
        }

        @Override
        public boolean shouldShowNotification() {
            return true;
        }

        @Override
        public boolean isType(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            return !bl && !bl2 && bl3;
        }
    }

    private class NotifyMoreButtonType
    implements NotificationType {
        private final Toolstrip toolstrip;

        public NotifyMoreButtonType(Toolstrip toolstrip) {
            this.toolstrip = toolstrip;
        }

        @Override
        public JComponent getComponent() {
            AppGalleryPathConfiguration appGalleryPathConfiguration = UserAppToolSetFactory.getAppGalleryPathConfiguration();
            String[] stringArray = appGalleryPathConfiguration.getPathToOpenedGallery();
            TSRobot tSRobot = new TSRobot(this.toolstrip);
            TSRobot.Target target = tSRobot.getPreceedingTrigger(stringArray);
            return target.getComponent();
        }

        @Override
        public boolean shouldShowNotification() {
            return true;
        }

        @Override
        public boolean isType(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            return !bl && bl2 && bl4;
        }
    }

    private class NoNotificationType
    implements NotificationType {
        private NoNotificationType() {
        }

        @Override
        public JComponent getComponent() {
            throw new UnsupportedOperationException("getComponent is not support for NoNotificationType.  Caller should use shouldShowNotification first");
        }

        @Override
        public boolean shouldShowNotification() {
            return false;
        }

        @Override
        public boolean isType(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            return bl || !bl2 && !bl3;
        }
    }

    private static interface NotificationType {
        public JComponent getComponent();

        public boolean shouldShowNotification();

        public boolean isType(boolean var1, boolean var2, boolean var3, boolean var4);
    }
}

