/*
 * Decompiled with CFR 0.152.
 */
package net.jini.id;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class Uuid
implements Serializable {
    private static final long serialVersionUID = -106268922535833151L;
    private final long bits0;
    private final long bits1;

    protected Uuid(long l, long l2) {
        if (!this.isValid()) {
            throw new SecurityException("invalid class: " + this.getClass().getName());
        }
        this.bits0 = l;
        this.bits1 = l2;
    }

    public final long getMostSignificantBits() {
        return this.bits0;
    }

    public final long getLeastSignificantBits() {
        return this.bits1;
    }

    public final int hashCode() {
        return (int)(this.bits0 >>> 32 ^ this.bits0 ^ this.bits1 >>> 32 ^ this.bits1);
    }

    public final boolean equals(Object object) {
        if (object instanceof Uuid) {
            Uuid uuid = (Uuid)object;
            return this.bits0 == uuid.bits0 && this.bits1 == uuid.bits1;
        }
        return false;
    }

    public final String toString() {
        return this.toHexString(this.bits0 >>> 32, 8) + "-" + this.toHexString(this.bits0 >>> 16, 4) + "-" + this.toHexString(this.bits0 >>> 0, 4) + "-" + this.toHexString(this.bits1 >>> 48, 4) + "-" + this.toHexString(this.bits1 >>> 0, 12);
    }

    private String toHexString(long l, int n) {
        long l2 = 1L << n * 4;
        return Long.toHexString(l2 | l & l2 - 1L).substring(1);
    }

    public final void write(OutputStream outputStream) throws IOException {
        Uuid.writeLong(this.bits0, outputStream);
        Uuid.writeLong(this.bits1, outputStream);
    }

    private static void writeLong(long l, OutputStream outputStream) throws IOException {
        outputStream.write((int)(l >>> 56) & 0xFF);
        outputStream.write((int)(l >>> 48) & 0xFF);
        outputStream.write((int)(l >>> 40) & 0xFF);
        outputStream.write((int)(l >>> 32) & 0xFF);
        outputStream.write((int)(l >>> 24) & 0xFF);
        outputStream.write((int)(l >>> 16) & 0xFF);
        outputStream.write((int)(l >>> 8) & 0xFF);
        outputStream.write((int)(l >>> 0) & 0xFF);
    }

    protected final void finalize() throws Throwable {
        super.finalize();
    }

    protected final Object writeReplace() {
        return this;
    }

    protected final Object readResolve() {
        return this;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (!this.isValid()) {
            throw new InvalidObjectException("invalid class: " + this.getClass().getName());
        }
        objectInputStream.defaultReadObject();
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("no data in stream; class: " + this.getClass().getName());
    }

    private boolean isValid() {
        return !(this instanceof Externalizable);
    }
}

