/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import com.sun.jini.discovery.internal.EndpointInternals;
import com.sun.jini.discovery.ssl.EndpointInternalsAccess;
import com.sun.jini.jeri.internal.connection.ConnManagerFactory;
import com.sun.jini.jeri.internal.connection.ServerConnManager;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import javax.net.SocketFactory;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.jeri.Endpoint;
import net.jini.jeri.OutboundRequestIterator;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.connection.OutboundRequestHandle;
import net.jini.jeri.ssl.CallContext;
import net.jini.jeri.ssl.SslEndpointImpl;
import net.jini.jeri.ssl.SslServerEndpoint;
import net.jini.jeri.ssl.SslServerEndpointImpl;
import net.jini.jeri.ssl.Utilities;
import net.jini.security.Security;
import net.jini.security.proxytrust.TrustEquivalence;

public final class SslEndpoint
implements Endpoint,
Serializable,
TrustEquivalence {
    private static final long serialVersionUID = 5311538504705775156L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("serverHost", String.class), new ObjectStreamField("port", Integer.TYPE), new ObjectStreamField("socketFactory", SocketFactory.class)};
    transient SslEndpointImpl impl;

    public static SslEndpoint getInstance(String string, int n) {
        return new SslEndpoint(string, n, null);
    }

    public static SslEndpoint getInstance(String string, int n, SocketFactory socketFactory) {
        return new SslEndpoint(string, n, socketFactory);
    }

    private SslEndpoint(String string, int n, SocketFactory socketFactory) {
        this.impl = new SslEndpointImpl(this, string, n, socketFactory);
    }

    public String getHost() {
        return this.impl.serverHost;
    }

    public int getPort() {
        return this.impl.port;
    }

    public SocketFactory getSocketFactory() {
        return this.impl.socketFactory;
    }

    public String toString() {
        return "SslEndpoint" + this.impl.fieldsToString();
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof SslEndpoint && this.impl.equals(((SslEndpoint)object).impl);
    }

    public OutboundRequestIterator newRequest(InvocationConstraints invocationConstraints) {
        return this.impl.newRequest(invocationConstraints);
    }

    public boolean checkTrustEquivalence(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof SslEndpoint && this.impl.equals(((SslEndpoint)object).impl);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("serverHost", this.impl.serverHost);
        putField.put("port", this.impl.port);
        putField.put("socketFactory", this.impl.socketFactory);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        String string = (String)getField.get("serverHost", null);
        int n = getField.get("port", 0);
        SocketFactory socketFactory = (SocketFactory)getField.get("socketFactory", null);
        if (string == null) {
            throw new InvalidObjectException("serverHost cannot be null");
        }
        if (n <= 0 || n > 65535) {
            throw new InvalidObjectException("Invalid port: " + n);
        }
        this.impl = new SslEndpointImpl(this, string, n, socketFactory);
    }

    static {
        SslEndpointInternals.registerDiscoveryBackDoor();
    }

    private static final class SslEndpointInternals
    extends Utilities
    implements EndpointInternals {
        private SslEndpointInternals() {
        }

        static void registerDiscoveryBackDoor() {
            final SslEndpointInternals sslEndpointInternals = new SslEndpointInternals();
            try {
                Security.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        EndpointInternalsAccess.set(sslEndpointInternals);
                        return null;
                    }
                });
            }
            catch (RuntimeException runtimeException) {
                initLogger.log(Level.WARNING, "Problem registering with discovery provider", runtimeException);
            }
            catch (Error error) {
                initLogger.log(Level.WARNING, "Problem registering with discovery provider", error);
            }
        }

        public void disableSocketConnect(Endpoint endpoint) {
            SslEndpointInternals.coerce((Endpoint)endpoint).disableSocketConnect = true;
        }

        private static SslEndpointImpl coerce(Endpoint endpoint) {
            if (!(endpoint instanceof SslEndpoint)) {
                throw new IllegalArgumentException("Endpoint must be an SslEndpoint: " + endpoint);
            }
            return ((SslEndpoint)endpoint).impl;
        }

        private static SslServerEndpointImpl coerce(ServerEndpoint serverEndpoint) {
            if (!(serverEndpoint instanceof SslServerEndpoint)) {
                throw new IllegalArgumentException("Server endpoint must be an SslServerEndpoint: " + serverEndpoint);
            }
            return ((SslServerEndpoint)serverEndpoint).impl;
        }

        public void setConnManagerFactory(Endpoint endpoint, ConnManagerFactory connManagerFactory) {
            SslEndpointImpl sslEndpointImpl = SslEndpointInternals.coerce(endpoint);
            sslEndpointImpl.connectionManager = connManagerFactory.create(sslEndpointImpl);
        }

        public void setServerConnManager(ServerEndpoint serverEndpoint, ServerConnManager serverConnManager) {
            SslEndpointInternals.coerce((ServerEndpoint)serverEndpoint).serverConnectionManager = serverConnManager;
        }

        public InvocationConstraints getUnfulfilledConstraints(OutboundRequestHandle outboundRequestHandle) {
            return SslEndpointInternals.coerce(outboundRequestHandle).getUnfulfilledConstraints();
        }

        private static CallContext coerce(OutboundRequestHandle outboundRequestHandle) {
            if (!(outboundRequestHandle instanceof CallContext)) {
                throw new IllegalArgumentException("Handle must be a CallContext: " + outboundRequestHandle);
            }
            return (CallContext)outboundRequestHandle;
        }
    }
}

