/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import com.sun.jini.action.GetPropertyAction;
import com.sun.jini.collection.WeakSoftTable;
import java.lang.ref.ReferenceQueue;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import net.jini.core.constraint.ClientMaxPrincipal;
import net.jini.core.constraint.ClientMinPrincipal;
import net.jini.core.constraint.ConstraintAlternatives;
import net.jini.core.constraint.Integrity;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.ServerMinPrincipal;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.Endpoint;
import net.jini.jeri.ssl.AuthManager;
import net.jini.jeri.ssl.CallContext;
import net.jini.jeri.ssl.ClientAuthManager;
import net.jini.jeri.ssl.ServerAuthManager;
import net.jini.jeri.ssl.SubjectCredentials;
import net.jini.security.Security;

abstract class Utilities {
    private static final String[] ANONYMOUS_KEY_EXCHANGE_ALGORITHMS = new String[]{"DH_anon", "DH_anon_EXPORT"};
    private static final String[] RSA_KEY_EXCHANGE_ALGORITHMS = new String[]{"DHE_RSA", "DHE_RSA_EXPORT", "DH_RSA", "DH_RSA_EXPORT", "RSA", "RSA_EXPORT"};
    private static final String[] DSA_KEY_EXCHANGE_ALGORITHMS = new String[]{"DHE_DSS", "DHE_DSS_EXPORT", "DH_DSS", "DH_DSS_EXPORT"};
    private static final String[] SUPPORTED_KEY_EXCHANGE_ALGORITHMS = new String[]{"DH_anon", "DH_anon_EXPORT", "DHE_RSA", "DHE_RSA_EXPORT", "DH_RSA", "DH_RSA_EXPORT", "RSA", "RSA_EXPORT", "DHE_DSS", "DHE_DSS_EXPORT", "DH_DSS", "DH_DSS_EXPORT"};
    private static final String NO_INTEGRITY_MIC_ALGORITHM = "NULL";
    private static final String NO_ENCRYPTION_CIPHER_ALGORITHM = "NULL";
    private static final String[] STRONG_ENCRYPTION_CIPHERS = new String[]{"3DES_EDE_CBC", "AES_128_CBC", "AES_256_CBC", "IDEA_CBC", "RC4_128"};
    private static final String[] SUPPORTED_ENCRYPTION_CIPHERS = new String[]{"3DES_EDE_CBC", "AES_128_CBC", "AES_256_CBC", "DES40_CBC", "DES_CBC", "IDEA_CBC", "NULL", "RC2_CBC_40", "RC4_128", "RC4_40"};
    static final Logger clientLogger = Logger.getLogger("net.jini.jeri.ssl.client");
    static final Logger serverLogger = Logger.getLogger("net.jini.jeri.ssl.server");
    static final Logger initLogger = Logger.getLogger("net.jini.jeri.ssl.init");
    static final int ANY_KEY_ALGORITHM = -1;
    static final int DSA_KEY_ALGORITHM = 1;
    static final int RSA_KEY_ALGORITHM = 2;
    private static final WeakSoftTable sslContextMap = new WeakSoftTable();
    private static String[] supportedCipherSuitesInternal = null;
    private static String[] requestedCipherSuites;
    private static CertificateFactory certFactory;
    static final Principal UNKNOWN_PRINCIPAL;
    static final InvocationConstraints INTEGRITY_REQUIRED;
    static final InvocationConstraints INTEGRITY_PREFERRED;
    private static final String sslProtocol;
    static final AuthPermission getSubjectPermission;
    static /* synthetic */ Class class$net$jini$jeri$ssl$Utilities;

    Utilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getSupportedCipherSuites() {
        WeakSoftTable weakSoftTable = sslContextMap;
        synchronized (weakSoftTable) {
            if (supportedCipherSuitesInternal == null) {
                SSLContextInfo sSLContextInfo = Utilities.getServerSSLContextInfo(null, null);
                SSLSocketFactory sSLSocketFactory = sSLContextInfo.sslContext.getSocketFactory();
                supportedCipherSuitesInternal = Utilities.getSupportedCipherSuites(sSLSocketFactory);
            }
            return supportedCipherSuitesInternal;
        }
    }

    private static String[] getSupportedCipherSuites(SSLSocketFactory sSLSocketFactory) {
        String[] stringArray;
        if (requestedCipherSuites == null) {
            stringArray = sSLSocketFactory.getSupportedCipherSuites();
        } else if (requestedCipherSuites.length == 0) {
            initLogger.log(Level.WARNING, "Problem with requested cipher suites: No suites specified -- using default suites");
            stringArray = sSLSocketFactory.getSupportedCipherSuites();
        } else {
            try {
                SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket();
                sSLSocket.setEnabledCipherSuites(requestedCipherSuites);
                stringArray = requestedCipherSuites;
            }
            catch (Exception exception) {
                initLogger.log(Level.WARNING, "Problem with requested cipher suites -- using default suites", exception);
                stringArray = sSLSocketFactory.getSupportedCipherSuites();
            }
        }
        return Utilities.getSupportedCipherSuites(stringArray);
    }

    private static String[] getSupportedCipherSuites(String[] stringArray) {
        int n = stringArray.length;
        int n2 = stringArray.length;
        while (--n2 >= 0) {
            if (Utilities.supportedCipherSuite(stringArray[n2])) continue;
            if (n2 < n - 1) {
                System.arraycopy(stringArray, n2 + 1, stringArray, n2, n - n2 - 1);
            }
            --n;
        }
        if (n == stringArray.length) {
            return stringArray;
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        return stringArray2;
    }

    static Set getClientPrincipals(InvocationConstraints invocationConstraints) {
        return Utilities.getPrincipals(invocationConstraints, true);
    }

    static Set getClientPrincipals(Set set) {
        return Utilities.getPrincipals(set, true);
    }

    static Set getServerPrincipals(InvocationConstraints invocationConstraints) {
        return Utilities.getPrincipals(invocationConstraints, false);
    }

    private static Set getPrincipals(InvocationConstraints invocationConstraints, boolean bl) {
        Set set = Utilities.getPrincipals(invocationConstraints.requirements(), bl);
        Set set2 = Utilities.getPrincipals(invocationConstraints.preferences(), bl);
        if (set == null) {
            return set2;
        }
        if (set2 == null) {
            return set;
        }
        set.addAll(set2);
        return set;
    }

    private static Set getPrincipals(Set set, boolean bl) {
        HashSet hashSet = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Set set2 = Utilities.getPrincipals((InvocationConstraint)iterator.next(), bl);
            if (set2 == null) continue;
            if (hashSet == null) {
                hashSet = new HashSet();
            }
            hashSet.addAll(set2);
        }
        return hashSet;
    }

    private static Set getPrincipals(InvocationConstraint invocationConstraint, boolean bl) {
        Set set;
        if (invocationConstraint instanceof ConstraintAlternatives) {
            Set set2 = ((ConstraintAlternatives)invocationConstraint).elements();
            return Utilities.getPrincipals(set2, bl);
        }
        if (invocationConstraint instanceof ServerMinPrincipal) {
            if (bl) {
                return null;
            }
            set = ((ServerMinPrincipal)invocationConstraint).elements();
        } else {
            if (!bl) {
                return null;
            }
            if (invocationConstraint instanceof ClientMinPrincipal) {
                set = ((ClientMinPrincipal)invocationConstraint).elements();
            } else if (invocationConstraint instanceof ClientMaxPrincipal) {
                set = ((ClientMaxPrincipal)invocationConstraint).elements();
            } else {
                return null;
            }
        }
        HashSet hashSet = new HashSet(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof X500Principal)) continue;
            hashSet.add(e);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SSLContextInfo getClientSSLContextInfo(CallContext callContext) {
        ClientAuthManager clientAuthManager;
        ClientKey clientKey = new ClientKey(callContext);
        Object object = sslContextMap;
        synchronized (object) {
            Value value;
            int n = 0;
            while ((value = (Value)sslContextMap.get(clientKey, n)) != null) {
                block16: {
                    SSLContext sSLContext = value.getSSLContext();
                    if (sSLContext != null) {
                        ClientAuthManager clientAuthManager2 = (ClientAuthManager)value.authManager;
                        try {
                            clientAuthManager2.checkAuthentication();
                        }
                        catch (SecurityException securityException) {
                            break block16;
                        }
                        catch (UnsupportedConstraintException unsupportedConstraintException) {
                            break block16;
                        }
                        sslContextMap.remove(clientKey, n);
                        if (clientLogger.isLoggable(Level.FINEST)) {
                            clientLogger.log(Level.FINEST, "get client SSL context for {0}\nreturns existing {1}", new Object[]{callContext, sSLContext});
                        }
                        return new SSLContextInfo(sSLContext, clientAuthManager2);
                    }
                }
                ++n;
            }
        }
        try {
            object = SSLContext.getInstance(sslProtocol);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw Utilities.initializationError(noSuchAlgorithmException, "finding SSL context");
        }
        try {
            clientAuthManager = new ClientAuthManager(callContext.clientSubject, callContext.clientPrincipals, callContext.serverPrincipals);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw Utilities.initializationError(noSuchAlgorithmException, "creating key or trust manager");
        }
        try {
            ((SSLContext)object).init(new KeyManager[]{clientAuthManager}, new TrustManager[]{clientAuthManager}, null);
        }
        catch (KeyManagementException keyManagementException) {
            throw Utilities.initializationError(keyManagementException, "initializing SSL context");
        }
        if (clientLogger.isLoggable(Level.FINEST)) {
            clientLogger.log(Level.FINEST, "get client SSL context for {0}\nreturns new {1}", new Object[]{callContext, object});
        }
        return new SSLContextInfo((SSLContext)object, clientAuthManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SSLContextInfo getServerSSLContextInfo(Subject subject, Set set) {
        ServerKey serverKey = new ServerKey(subject, set);
        WeakSoftTable weakSoftTable = sslContextMap;
        synchronized (weakSoftTable) {
            ServerAuthManager serverAuthManager;
            SSLContext sSLContext;
            Value value = (Value)sslContextMap.get(serverKey, 0);
            if (value != null && (sSLContext = value.getSSLContext()) != null) {
                if (serverLogger.isLoggable(Level.FINEST)) {
                    serverLogger.log(Level.FINEST, "get server SSL context for {0}\nand principals {1}\nreturns existing {2}", new Object[]{Utilities.subjectString(subject), set, sSLContext});
                }
                return new SSLContextInfo(sSLContext, value.authManager);
            }
            try {
                sSLContext = SSLContext.getInstance(sslProtocol);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw Utilities.initializationError(noSuchAlgorithmException, "finding SSL context");
            }
            try {
                serverAuthManager = new ServerAuthManager(subject, set, sSLContext.getServerSessionContext());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw Utilities.initializationError(noSuchAlgorithmException, "creating key or trust manager");
            }
            try {
                sSLContext.init(new KeyManager[]{serverAuthManager}, new TrustManager[]{serverAuthManager}, null);
            }
            catch (KeyManagementException keyManagementException) {
                throw Utilities.initializationError(keyManagementException, "initializing SSL context");
            }
            sslContextMap.add(serverKey, new Value(serverKey, sSLContext, serverAuthManager));
            if (serverLogger.isLoggable(Level.FINEST)) {
                serverLogger.log(Level.FINEST, "get server SSL context for {0}\nand principals {1}\nreturns new {2}", new Object[]{Utilities.subjectString(subject), set, sSLContext});
            }
            return new SSLContextInfo(sSLContext, serverAuthManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void releaseClientSSLContextInfo(CallContext callContext, SSLContext sSLContext, ClientAuthManager clientAuthManager) {
        ClientKey clientKey = new ClientKey(callContext);
        WeakSoftTable weakSoftTable = sslContextMap;
        synchronized (weakSoftTable) {
            sslContextMap.add(clientKey, new Value(clientKey, sSLContext, clientAuthManager));
        }
    }

    private static RuntimeException initializationError(Exception exception, String string) {
        RuntimeException runtimeException = new RuntimeException("Error during initialization of SSL or HTTPS provider, while " + string + ": " + exception.getMessage(), exception);
        initLogger.log(Level.WARNING, "Initialization error", runtimeException);
        return runtimeException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CertificateFactory getCertFactory() {
        WeakSoftTable weakSoftTable = sslContextMap;
        synchronized (weakSoftTable) {
            if (certFactory == null) {
                try {
                    certFactory = CertificateFactory.getInstance("X.509");
                }
                catch (CertificateException certificateException) {
                    throw Utilities.initializationError(certificateException, "getting certificate factory");
                }
            }
            return certFactory;
        }
    }

    static X509Certificate firstX509Cert(CertPath certPath) {
        return (X509Certificate)certPath.getCertificates().get(0);
    }

    static void checkValidity(CertPath certPath, X500Principal[] x500PrincipalArray) throws CertificateException {
        boolean bl = x500PrincipalArray == null;
        List<? extends Certificate> list = certPath.getCertificates();
        int n = list.size();
        block0: while (--n >= 0) {
            X509Certificate x509Certificate = (X509Certificate)list.get(n);
            x509Certificate.checkValidity();
            if (bl) continue;
            X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
            int n2 = x500PrincipalArray.length;
            while (--n2 >= 0) {
                if (!x500Principal.equals(x500PrincipalArray[n2])) continue;
                bl = true;
                continue block0;
            }
        }
        if (!bl) {
            throw new CertificateException("No match for permitted issuers: " + Utilities.toString(x500PrincipalArray) + "\nCertificate chain: " + certPath);
        }
    }

    static boolean doesServerAuthentication(String string) {
        String string2 = Utilities.getKeyExchangeAlgorithm(string);
        return Utilities.position(string2, ANONYMOUS_KEY_EXCHANGE_ALGORITHMS) == -1;
    }

    static boolean doesEncryption(String string) {
        return !Utilities.getCipherAlgorithm(string).equals("NULL");
    }

    static boolean maintainsIntegrity(String string) {
        return !Utilities.getMICAlgorithm(string).equals("NULL");
    }

    static String getKeyExchangeAlgorithm(String string) {
        int n;
        int n2 = string.indexOf(95) + 1;
        if (n2 >= 1 && (n = string.indexOf("_WITH_", n2)) >= n2) {
            return string.substring(n2, n);
        }
        return "NULL";
    }

    static String getKeyAlgorithm(String string) {
        String string2 = Utilities.getKeyExchangeAlgorithm(string);
        if (Utilities.position(string2, RSA_KEY_EXCHANGE_ALGORITHMS) != -1) {
            return "RSA";
        }
        if (Utilities.position(string2, DSA_KEY_EXCHANGE_ALGORITHMS) != -1) {
            return "DSA";
        }
        if (Utilities.position(string2, ANONYMOUS_KEY_EXCHANGE_ALGORITHMS) != -1) {
            return "NULL";
        }
        throw new IllegalArgumentException("Unrecognized key exchange algorithm: " + string2);
    }

    static int getPermittedKeyAlgorithms(String string, boolean bl) {
        String string2 = Utilities.getKeyAlgorithm(string);
        if (string2.equals("RSA")) {
            return bl ? 3 : 2;
        }
        if (string2.equals("DSA")) {
            return bl ? 3 : 1;
        }
        if (string2.equals("NULL")) {
            return 0;
        }
        throw new AssertionError((Object)("Unrecognized key algorithm: " + string2));
    }

    static boolean permittedKeyAlgorithm(String string, int n) {
        if (n == -1) {
            return true;
        }
        if ("DSA".equals(string)) {
            return (n & 1) != 0;
        }
        if ("RSA".equals(string)) {
            return (n & 2) != 0;
        }
        return false;
    }

    static String getCipherAlgorithm(String string) {
        int n;
        int n2 = string.indexOf("_WITH_") + 6;
        if (n2 >= 6 && (n = string.lastIndexOf(95)) >= n2) {
            return string.substring(n2, n);
        }
        return "NULL";
    }

    static boolean hasStrongCipherAlgorithm(String string) {
        String string2 = Utilities.getCipherAlgorithm(string);
        return Utilities.position(string2, STRONG_ENCRYPTION_CIPHERS) != -1;
    }

    private static String getMICAlgorithm(String string) {
        return string.substring(string.lastIndexOf(95));
    }

    private static boolean supportedCipherSuite(String string) {
        return Utilities.position(Utilities.getKeyExchangeAlgorithm(string), SUPPORTED_KEY_EXCHANGE_ALGORITHMS) != -1 && Utilities.position(Utilities.getCipherAlgorithm(string), SUPPORTED_ENCRYPTION_CIPHERS) != -1;
    }

    static String subjectString(Subject subject) {
        if (subject == null) {
            return "null subject";
        }
        return "Subject@" + Integer.toHexString(System.identityHashCode(subject)) + "{\n" + SubjectCredentials.credentialsString(subject) + "}";
    }

    static boolean safeEquals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    static boolean contains(Object[] objectArray, Object object) {
        int n = objectArray.length;
        while (--n >= 0) {
            if (!Utilities.safeEquals(objectArray[n], object)) continue;
            return true;
        }
        return false;
    }

    static String toString(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < objectArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(objectArray[i]);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static boolean equals(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            return objectArray2 == null;
        }
        if (objectArray2 == null) {
            return false;
        }
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        int n = objectArray.length;
        while (--n >= 0) {
            if (Utilities.safeEquals(objectArray[n], objectArray2[n])) continue;
            return false;
        }
        return true;
    }

    static String getClassName(Object object) {
        String string = object.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        string = string.substring(string.lastIndexOf(36) + 1);
        return string;
    }

    static int position(String string, String[] stringArray) {
        int n = stringArray.length;
        while (--n >= 0) {
            if (!string.equals(stringArray[n])) continue;
            return n;
        }
        return -1;
    }

    static void logThrow(Logger logger, Level level, Class clazz, String string, String string2, Object[] objectArray, Throwable throwable) {
        LogRecord logRecord = new LogRecord(level, string2);
        logRecord.setLoggerName(logger.getName());
        logRecord.setSourceClassName(clazz.getName());
        logRecord.setSourceMethodName(string);
        logRecord.setParameters(objectArray);
        logRecord.setThrown(throwable);
        logger.log(logRecord);
    }

    static {
        String string = (String)Security.doPrivileged(new GetPropertyAction("com.sun.jini.jeri.ssl.cipherSuites"));
        if (string == null) {
            requestedCipherSuites = null;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = stringTokenizer.countTokens();
            requestedCipherSuites = new String[n];
            for (int i = 0; i < n; ++i) {
                Utilities.requestedCipherSuites[i] = stringTokenizer.nextToken();
            }
        }
        UNKNOWN_PRINCIPAL = new Principal(){

            public String toString() {
                return "UNKNOWN_PRINCIPAL";
            }

            public String getName() {
                return this.toString();
            }
        };
        INTEGRITY_REQUIRED = new InvocationConstraints(Integrity.YES, null);
        INTEGRITY_PREFERRED = new InvocationConstraints(null, Integrity.YES);
        sslProtocol = (String)Security.doPrivileged(new GetPropertyAction("com.sun.jini.jeri.ssl.sslProtocol", "TLS"));
        getSubjectPermission = new AuthPermission("getSubject");
    }

    private static final class Value
    extends WeakSoftTable.SoftValue {
        final AuthManager authManager;

        Value(ServerKey serverKey, SSLContext sSLContext, AuthManager authManager) {
            super(serverKey, sSLContext);
            this.authManager = authManager;
        }

        private Value(Value value, ReferenceQueue referenceQueue) {
            super(value, referenceQueue);
            this.authManager = value.authManager;
        }

        public WeakSoftTable.RemovableReference copy(ReferenceQueue referenceQueue) {
            return new Value(this, referenceQueue);
        }

        SSLContext getSSLContext() {
            return (SSLContext)this.get();
        }
    }

    private static final class ClientKey
    extends ServerKey {
        final Set permittedRemotePrincipals;
        final Endpoint endpoint;
        final boolean clientAuthRequired;
        final String[] cipherSuites;
        static final /* synthetic */ boolean $assertionsDisabled;

        ClientKey(CallContext callContext) {
            super(callContext.clientSubject, callContext.clientPrincipals);
            this.permittedRemotePrincipals = callContext.serverPrincipals;
            this.endpoint = callContext.endpoint;
            this.clientAuthRequired = callContext.clientAuthRequired;
            this.cipherSuites = callContext.cipherSuites;
            if (!($assertionsDisabled || this.cipherSuites != null && this.cipherSuites.length > 0 && this.cipherSuites[0] != null)) {
                throw new AssertionError();
            }
        }

        private ClientKey(ClientKey clientKey, ReferenceQueue referenceQueue) {
            super(clientKey, referenceQueue);
            this.permittedRemotePrincipals = clientKey.permittedRemotePrincipals;
            this.endpoint = clientKey.endpoint;
            this.clientAuthRequired = clientKey.clientAuthRequired;
            this.cipherSuites = clientKey.cipherSuites;
        }

        public WeakSoftTable.RemovableReference copy(ReferenceQueue referenceQueue) {
            return new ClientKey(this, referenceQueue);
        }

        public int hashCode() {
            return super.hashCode() ^ (this.permittedRemotePrincipals == null ? 2 : ((Object)this.permittedRemotePrincipals).hashCode()) ^ this.endpoint.hashCode() ^ (this.clientAuthRequired ? 4 : 0) ^ this.cipherSuites[0].hashCode();
        }

        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            ClientKey clientKey = (ClientKey)object;
            return Utilities.safeEquals(this.permittedRemotePrincipals, clientKey.permittedRemotePrincipals) && this.endpoint.equals(clientKey.endpoint) && this.clientAuthRequired == clientKey.clientAuthRequired && Arrays.equals(this.cipherSuites, clientKey.cipherSuites);
        }

        static {
            $assertionsDisabled = !(class$net$jini$jeri$ssl$Utilities == null ? (class$net$jini$jeri$ssl$Utilities = Utilities.class$("net.jini.jeri.ssl.Utilities")) : class$net$jini$jeri$ssl$Utilities).desiredAssertionStatus();
        }
    }

    private static class ServerKey
    extends WeakSoftTable.WeakKey {
        final Set permittedLocalPrincipals;

        ServerKey(Subject subject, Set set) {
            super(subject);
            this.permittedLocalPrincipals = set;
        }

        ServerKey(ServerKey serverKey, ReferenceQueue referenceQueue) {
            super(serverKey, referenceQueue);
            this.permittedLocalPrincipals = serverKey.permittedLocalPrincipals;
        }

        public WeakSoftTable.RemovableReference copy(ReferenceQueue referenceQueue) {
            return new ServerKey(this, referenceQueue);
        }

        public int hashCode() {
            return super.hashCode() ^ (this.permittedLocalPrincipals == null ? 1 : ((Object)this.permittedLocalPrincipals).hashCode());
        }

        public boolean equals(Object object) {
            return super.equals(object) && Utilities.safeEquals(this.permittedLocalPrincipals, ((ServerKey)object).permittedLocalPrincipals);
        }
    }

    static class SSLContextInfo {
        final SSLContext sslContext;
        final AuthManager authManager;

        SSLContextInfo(SSLContext sSLContext, AuthManager authManager) {
            this.sslContext = sSLContext;
            this.authManager = authManager;
        }
    }
}

