/*
 * Decompiled with CFR 0.152.
 */
package net.jini.security;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.UnresolvedPermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class GrantPermission
extends Permission {
    private static final long serialVersionUID = 4668259055340724280L;
    private static final Class[] PARAMS0 = new Class[0];
    private static final Class[] PARAMS1 = new Class[]{String.class};
    private static final Class[] PARAMS2 = new Class[]{String.class, String.class};
    private static final Logger logger = Logger.getLogger("net.jini.security.policy");
    private transient Permission[] grants;
    private transient boolean unserializable;
    private volatile transient Implier implier;
    private volatile transient Integer hash;
    static /* synthetic */ Class class$java$security$Permission;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$ArrayList;

    public GrantPermission(String string) {
        super(string);
        this.initFromName(string);
    }

    public GrantPermission(Permission permission) {
        this(new Permission[]{permission});
    }

    public GrantPermission(Permission[] permissionArray) {
        permissionArray = (Permission[])permissionArray.clone();
        super(GrantPermission.constructName(permissionArray));
        this.grants = GrantPermission.flatten(permissionArray);
        for (int i = 0; i < permissionArray.length; ++i) {
            if (!(permissionArray[i] instanceof UnresolvedPermission)) continue;
            this.unserializable = true;
            return;
        }
    }

    public String getActions() {
        return "";
    }

    public PermissionCollection newPermissionCollection() {
        return new GrantPermissionCollection();
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof GrantPermission)) {
            return false;
        }
        if (this.implier == null) {
            Implier implier = new Implier();
            implier.add(this);
            this.implier = implier;
        }
        return this.implier.implies(permission);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof GrantPermission) {
            GrantPermission grantPermission = (GrantPermission)object;
            return this.implies(grantPermission) && grantPermission.implies(this);
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == null) {
            this.hash = new Integer(this.computeHashCode());
        }
        return this.hash;
    }

    private int computeHashCode() {
        int n = 0;
        HashSet<String> hashSet = new HashSet<String>(this.grants.length);
        for (int i = 0; i < this.grants.length; ++i) {
            Permission permission = this.grants[i];
            String string = permission.getClass().getName();
            if (permission instanceof AllPermission) {
                return string.hashCode();
            }
            if (permission instanceof UnresolvedPermission) {
                string = string + ":" + permission.getName();
            }
            if (hashSet.contains(string)) continue;
            hashSet.add(string);
            n += string.hashCode();
        }
        return n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.unserializable) {
            throw new NotSerializableException(GrantPermission.class.getName());
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.initFromName(this.getName());
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException instanceof NullPointerException || runtimeException instanceof IllegalArgumentException) {
                InvalidObjectException invalidObjectException = new InvalidObjectException(runtimeException.getMessage());
                invalidObjectException.initCause(runtimeException);
                throw invalidObjectException;
            }
            throw runtimeException;
        }
    }

    private void initFromName(String string) {
        PermissionInfo[] permissionInfoArray = GrantPermission.parsePermissions(string);
        ArrayList<UnresolvedPermission> arrayList = new ArrayList<UnresolvedPermission>();
        for (int i = 0; i < permissionInfoArray.length; ++i) {
            Constructor<?> constructor;
            Class<?> clazz;
            int n;
            PermissionInfo permissionInfo = permissionInfoArray[i];
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null && (n = permissionInfo.type.lastIndexOf(46)) != -1) {
                securityManager.checkPackageAccess(permissionInfo.type.substring(0, n));
            }
            try {
                clazz = Class.forName(permissionInfo.type);
            }
            catch (ClassNotFoundException classNotFoundException) {
                arrayList.add(new UnresolvedPermission(permissionInfo.type, permissionInfo.name, permissionInfo.actions, null));
                continue;
            }
            if (!(class$java$security$Permission == null ? GrantPermission.class$("java.security.Permission") : class$java$security$Permission).isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("not a permission class: " + clazz);
            }
            if (!Modifier.isPublic(clazz.getModifiers())) {
                throw new IllegalArgumentException("non-public permission class: " + clazz);
            }
            if (permissionInfo.name == null) {
                try {
                    constructor = clazz.getConstructor(PARAMS0);
                    arrayList.add((UnresolvedPermission)constructor.newInstance(new Object[0]));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (permissionInfo.actions == null) {
                try {
                    constructor = clazz.getConstructor(PARAMS1);
                    arrayList.add((UnresolvedPermission)constructor.newInstance(permissionInfo.name));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                constructor = clazz.getConstructor(PARAMS2);
                arrayList.add((UnresolvedPermission)constructor.newInstance(permissionInfo.name, permissionInfo.actions));
                continue;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("uninstantiable permission class: " + clazz);
            }
        }
        this.grants = GrantPermission.flatten(arrayList.toArray(new Permission[arrayList.size()]));
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "parsed {0} from {1}", new Object[]{arrayList, string});
        }
    }

    private static PermissionInfo[] parsePermissions(String string) {
        try {
            ArrayList<PermissionInfo> arrayList = new ArrayList<PermissionInfo>();
            StreamTokenizer streamTokenizer = GrantPermission.createTokenizer(string);
            int n = 34;
            if (streamTokenizer.nextToken() == -3 && streamTokenizer.sval.equals("delim")) {
                if (streamTokenizer.nextToken() == 61) {
                    if (streamTokenizer.nextToken() == -3) {
                        if (streamTokenizer.sval.length() > 1) {
                            throw new IllegalArgumentException("excess delimiter characters");
                        }
                        n = streamTokenizer.sval.charAt(0);
                    } else {
                        n = (char)streamTokenizer.ttype;
                    }
                    if (n == 59) {
                        throw new IllegalArgumentException("illegal delimiter ';'");
                    }
                } else {
                    streamTokenizer = GrantPermission.createTokenizer(string);
                }
                streamTokenizer.nextToken();
            }
            streamTokenizer.quoteChar(n);
            do {
                String string2 = null;
                String string3 = null;
                if (streamTokenizer.ttype != -3) {
                    throw new IllegalArgumentException("expected permission type");
                }
                String string4 = streamTokenizer.sval;
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == -1 || streamTokenizer.ttype == 59) {
                    arrayList.add(new PermissionInfo(string4, null, null));
                    continue;
                }
                if (streamTokenizer.ttype != n) {
                    throw new IllegalArgumentException("expected permission name or ';'");
                }
                string2 = streamTokenizer.sval;
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == -1 || streamTokenizer.ttype == 59) {
                    arrayList.add(new PermissionInfo(string4, string2, null));
                    continue;
                }
                if (streamTokenizer.ttype != 44) {
                    throw new IllegalArgumentException("expected ',' or ';'");
                }
                if (streamTokenizer.nextToken() != n) {
                    throw new IllegalArgumentException("expected permission actions");
                }
                string3 = streamTokenizer.sval;
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == -1 || streamTokenizer.ttype == 59) {
                    arrayList.add(new PermissionInfo(string4, string2, string3));
                    continue;
                }
                throw new IllegalArgumentException("expected ';'");
            } while (streamTokenizer.nextToken() != -1);
            return arrayList.toArray(new PermissionInfo[arrayList.size()]);
        }
        catch (IOException iOException) {
            throw (Error)new InternalError().initCause(iOException);
        }
    }

    private static StreamTokenizer createTokenizer(String string) {
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(97, 122);
        streamTokenizer.wordChars(65, 90);
        streamTokenizer.wordChars(46, 46);
        streamTokenizer.wordChars(48, 57);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(36, 36);
        streamTokenizer.wordChars(160, 255);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.lowerCaseMode(false);
        streamTokenizer.ordinaryChar(47);
        streamTokenizer.slashSlashComments(false);
        streamTokenizer.slashStarComments(false);
        return streamTokenizer;
    }

    private static String constructName(Permission[] permissionArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < permissionArray.length; ++i) {
            Permission permission = permissionArray[i];
            if (permission instanceof UnresolvedPermission) {
                stringBuffer.append(permission + "; ");
                continue;
            }
            Class<?> clazz = permission.getClass();
            int n = GrantPermission.maxConsArgs(clazz);
            String string = clazz.getName();
            String string2 = permission.getName();
            String string3 = permission.getActions();
            if (n == 2 && string3 != null) {
                stringBuffer.append(string + " " + GrantPermission.quote(string2) + ", " + GrantPermission.quote(string3) + "; ");
                continue;
            }
            if (n >= 1 && string2 != null) {
                stringBuffer.append(string + " " + GrantPermission.quote(string2) + "; ");
                continue;
            }
            stringBuffer.append(string + "; ");
        }
        return stringBuffer.toString().trim();
    }

    private static int maxConsArgs(Class clazz) {
        try {
            clazz.getConstructor(PARAMS2);
            return 2;
        }
        catch (Exception exception) {
            try {
                clazz.getConstructor(PARAMS1);
                return 1;
            }
            catch (Exception exception2) {
                try {
                    clazz.getConstructor(PARAMS0);
                    return 0;
                }
                catch (Exception exception3) {
                    return -1;
                }
            }
        }
    }

    private static String quote(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
        stringBuffer.append('\"');
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '\\' || c == '\"') {
                stringBuffer.append("\\").append(c);
                continue;
            }
            if (c == '\n') {
                stringBuffer.append("\\n");
                continue;
            }
            if (c == '\r') {
                stringBuffer.append("\\r");
                continue;
            }
            if (c == '\t') {
                stringBuffer.append("\\t");
                continue;
            }
            if (c == '\f') {
                stringBuffer.append("\\f");
                continue;
            }
            if (c == '\b') {
                stringBuffer.append("\\b");
                continue;
            }
            if (c < ' ') {
                stringBuffer.append("\\").append(Integer.toOctalString(c));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.append('\"').toString();
    }

    private static Permission[] flatten(Permission[] permissionArray) {
        ArrayList<Permission> arrayList = new ArrayList<Permission>(permissionArray.length);
        for (int i = 0; i < permissionArray.length; ++i) {
            Permission permission = permissionArray[i];
            if (permission instanceof GrantPermission) {
                arrayList.addAll(Arrays.asList(((GrantPermission)permission).grants));
                continue;
            }
            arrayList.add(permission);
        }
        return arrayList.toArray(new Permission[arrayList.size()]);
    }

    static class GrantPermissionCollection
    extends PermissionCollection {
        private static final long serialVersionUID = 8227621799817733985L;
        private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("perms", class$java$util$List == null ? (class$java$util$List = GrantPermission.class$("java.util.List")) : class$java$util$List, true)};
        private List perms = new ArrayList();
        private Implier implier = new Implier();

        GrantPermissionCollection() {
        }

        public synchronized void add(Permission permission) {
            if (!(permission instanceof GrantPermission)) {
                throw new IllegalArgumentException("invalid permission: " + permission);
            }
            if (this.isReadOnly()) {
                throw new SecurityException("can't add to read-only PermissionCollection");
            }
            this.perms.add(permission);
            this.implier.add((GrantPermission)permission);
        }

        public synchronized Enumeration elements() {
            return Collections.enumeration(this.perms);
        }

        public synchronized boolean implies(Permission permission) {
            return this.implier.implies(permission);
        }

        public synchronized void setReadOnly() {
            super.setReadOnly();
        }

        public synchronized boolean isReadOnly() {
            return super.isReadOnly();
        }

        private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            GrantPermission[] grantPermissionArray;
            objectInputStream.defaultReadObject();
            if (this.perms == null) {
                throw new InvalidObjectException("list cannot be null");
            }
            if (!this.perms.getClass().equals(class$java$util$ArrayList == null ? (class$java$util$ArrayList = GrantPermission.class$("java.util.ArrayList")) : class$java$util$ArrayList)) {
                this.perms = new ArrayList(this.perms);
            }
            if (this.perms.contains(null)) {
                throw new InvalidObjectException("element must be a GrantPermission");
            }
            try {
                grantPermissionArray = this.perms.toArray(new GrantPermission[this.perms.size()]);
            }
            catch (ArrayStoreException arrayStoreException) {
                throw new InvalidObjectException("element must be a GrantPermission");
            }
            this.implier = new Implier();
            for (int i = 0; i < grantPermissionArray.length; ++i) {
                this.implier.add(grantPermissionArray[i]);
            }
        }
    }

    private static class Implier {
        private final PermissionCollection perms = new Permissions();
        private final ArrayList unresolved = new ArrayList();

        private Implier() {
        }

        void add(GrantPermission grantPermission) {
            for (int i = 0; i < grantPermission.grants.length; ++i) {
                Permission permission = grantPermission.grants[i];
                if (this.impliesContained(permission)) continue;
                this.perms.add(permission);
                if (!(permission instanceof UnresolvedPermission)) continue;
                this.unresolved.add(permission);
            }
        }

        boolean implies(Permission permission) {
            if (!(permission instanceof GrantPermission)) {
                return false;
            }
            Permission[] permissionArray = ((GrantPermission)permission).grants;
            for (int i = 0; i < permissionArray.length; ++i) {
                if (this.impliesContained(permissionArray[i])) continue;
                return false;
            }
            return true;
        }

        private boolean impliesContained(Permission permission) {
            if (permission instanceof UnresolvedPermission) {
                Iterator iterator = this.unresolved.iterator();
                while (iterator.hasNext()) {
                    if (!Implier.implies((UnresolvedPermission)iterator.next(), (UnresolvedPermission)permission)) continue;
                    return true;
                }
                return false;
            }
            return this.perms.implies(permission);
        }

        private static boolean implies(UnresolvedPermission unresolvedPermission, UnresolvedPermission unresolvedPermission2) {
            if (unresolvedPermission == unresolvedPermission2) {
                return true;
            }
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                byteArrayOutputStream.reset();
                objectOutputStream.writeObject(unresolvedPermission);
                objectOutputStream.flush();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                objectOutputStream.reset();
                byteArrayOutputStream.reset();
                objectOutputStream.writeObject(unresolvedPermission2);
                objectOutputStream.flush();
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                return Arrays.equals(byArray, byArray2);
            }
            catch (IOException iOException) {
                throw (Error)new InternalError().initCause(iOException);
            }
        }
    }

    private static class PermissionInfo {
        final String type;
        final String name;
        final String actions;

        PermissionInfo(String string, String string2, String string3) {
            this.type = string;
            this.name = string2;
            this.actions = string3;
        }
    }
}

