/*
 * Decompiled with CFR 0.152.
 */
package net.jini.url.httpmd;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.StringTokenizer;
import net.jini.security.Security;
import net.jini.url.httpmd.Handler;

public class HttpmdUtil {
    private static final Handler handler = new Handler();

    private HttpmdUtil() {
    }

    public static String computeDigest(URL uRL, String string) throws IOException, NoSuchAlgorithmException {
        return HttpmdUtil.computeDigest(uRL.openStream(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String computeDigest(InputStream inputStream, String string) throws IOException, NoSuchAlgorithmException {
        String string2;
        try {
            int n;
            if (!(inputStream instanceof BufferedInputStream)) {
                inputStream = new BufferedInputStream(inputStream, 2048);
            }
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            byte[] byArray = new byte[2048];
            while ((n = inputStream.read(byArray)) >= 0) {
                messageDigest.update(byArray, 0, n);
            }
            string2 = HttpmdUtil.digestString(messageDigest.digest());
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string2;
    }

    public static String computeDigestCodebase(String string, String string2) throws IOException, MalformedURLException, NullPointerException {
        if (string.endsWith(File.separator)) {
            string = string.substring(0, string.length() - 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            URI uRI;
            URL uRL;
            final String string4 = stringTokenizer.nextToken();
            if (!"httpmd:".regionMatches(true, 0, string4, 0, 7)) {
                throw new IllegalArgumentException("Codebase URL does not specify HTTPMD protocol: " + string4);
            }
            try {
                uRL = (URL)Security.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws MalformedURLException {
                        return new URL(null, string4, handler);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (MalformedURLException)privilegedActionException.getCause();
            }
            String string5 = uRL.getPath();
            int n = string5.lastIndexOf(59);
            int n2 = string5.indexOf(61, n);
            int n3 = string5.indexOf(44, n2);
            String string6 = string5.substring(n + 1, n2);
            try {
                uRI = new URI("file:" + (string5.startsWith("/") ? "" : "/") + string5.substring(0, string5.indexOf(59)));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new MalformedURLException("Problem with codebase URL " + string4 + ": " + uRISyntaxException.getMessage());
            }
            String string7 = uRI.getPath();
            if ('/' != File.separatorChar) {
                string7 = string7.replace('/', File.separatorChar);
            }
            try {
                string3 = HttpmdUtil.computeDigest(new FileInputStream(string + string7), string6);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("Shouldn't happen: " + noSuchAlgorithmException);
            }
            URL uRL2 = new URL(uRL, string5.substring(0, n2 + 1) + string3 + (n3 < 0 ? "" : string5.substring(n3)) + (uRL.getQuery() == null ? "" : '?' + uRL.getQuery()) + (uRL.getRef() == null ? "" : '#' + uRL.getRef()));
            if (!bl) {
                stringBuffer.append(' ');
            } else {
                bl = false;
            }
            stringBuffer.append(uRL2);
        }
        return stringBuffer.toString();
    }

    static String digestString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            stringBuffer.append(Character.forDigit(by >> 4 & 0xF, 16));
            stringBuffer.append(Character.forDigit(by & 0xF, 16));
        }
        return stringBuffer.toString();
    }

    static byte[] stringDigest(String string) throws NumberFormatException {
        byte[] byArray = new byte[(string.length() + 1) / 2];
        int n = byArray.length;
        int n2 = -1;
        int n3 = string.length();
        while (--n3 >= 0) {
            int n4 = Character.digit(string.charAt(n3), 16);
            if (n4 < 0) {
                throw new NumberFormatException("Illegal hex digit: '" + string.charAt(n3) + "'");
            }
            if (n2 < 0) {
                n2 = n4;
                continue;
            }
            byArray[--n] = (byte)(n2 + (n4 << 4));
            n2 = -1;
        }
        if (n2 >= 0) {
            byArray[--n] = (byte)n2;
        }
        return byArray;
    }

    static boolean commentChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || "-_.~*'():@&=+$,".indexOf(c) >= 0;
    }
}

