/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.table.RestrictedSortTableModel;
import com.mathworks.mwswing.table.SortedTable;
import com.mathworks.mwswing.table.SortedTableHeaderRenderer;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public abstract class AbstractSortableTable
extends MJTable
implements SortedTable {
    protected boolean fHeaderSortingEnabled;
    private MouseAdapter fSortMouseListener;
    private Vector fChangeListeners;
    private boolean fBidirectionalSortingEnabled;

    public abstract void sortByColumn(int var1, int var2);

    public AbstractSortableTable() {
        this.addSortingCapabilities();
    }

    public AbstractSortableTable(int n, int n2) {
        super(n, n2);
        this.addSortingCapabilities();
    }

    public AbstractSortableTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.addSortingCapabilities();
    }

    public AbstractSortableTable(TableModel tableModel) {
        super(tableModel);
        this.addSortingCapabilities();
    }

    public AbstractSortableTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.addSortingCapabilities();
    }

    public AbstractSortableTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.addSortingCapabilities();
    }

    public AbstractSortableTable(Vector vector, Vector vector2) {
        super((Vector<?>)vector, (Vector<?>)vector2);
        this.addSortingCapabilities();
    }

    public void setHeaderSortingEnabled(boolean bl) {
        if (this.fHeaderSortingEnabled != bl) {
            if (bl) {
                this.installHeaderMouseListener();
            } else {
                this.removeHeaderMouseListener();
                this.sortByColumn(-1, 0);
            }
        }
        this.fHeaderSortingEnabled = bl;
    }

    public boolean isHeaderSortingEnabled() {
        return this.fHeaderSortingEnabled;
    }

    public void setBidrectionalSortEnabled(boolean bl) {
        this.fBidirectionalSortingEnabled = bl;
        bl = false;
        if (false) {
            this.sortByColumn(this.getSortColumn(), 0);
        }
    }

    public boolean isBidirectionalSortEnabled() {
        return this.fBidirectionalSortingEnabled;
    }

    public void addSortingChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.add(changeListener);
    }

    public void removeSortingChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.remove(changeListener);
    }

    protected void fireSortingChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Enumeration enumeration = this.fChangeListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ChangeListener)enumeration.nextElement()).stateChanged(changeEvent);
        }
        this.tableHeader.repaint();
    }

    private void addSortingCapabilities() {
        this.fChangeListeners = new Vector();
        this.fBidirectionalSortingEnabled = true;
        this.setHeaderRenderer();
        this.setHeaderSortingEnabled(true);
    }

    private void setHeaderRenderer() {
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setDefaultRenderer(new SortedTableHeaderRenderer(jTableHeader.getDefaultRenderer()));
    }

    protected void installHeaderMouseListener() {
        this.fSortMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 1 && SwingUtilities.isLeftMouseButton(mouseEvent) && (n = AbstractSortableTable.this.convertColumnIndexToModel(AbstractSortableTable.this.getColumnModel().getColumnIndexAtX(mouseEvent.getX()))) != -1) {
                    RestrictedSortTableModel restrictedSortTableModel = null;
                    if (AbstractSortableTable.this.getModel() instanceof RestrictedSortTableModel) {
                        restrictedSortTableModel = (RestrictedSortTableModel)AbstractSortableTable.this.getModel();
                    }
                    if (restrictedSortTableModel != null) {
                        int[] nArray = restrictedSortTableModel.getUnsortableColumns();
                        for (int i = 0; i < nArray.length; ++i) {
                            if (nArray[i] != n) continue;
                            return;
                        }
                    }
                    if (n != AbstractSortableTable.this.getSortColumn()) {
                        AbstractSortableTable.this.sortByColumn(n, AbstractSortableTable.this.getDefaultSortDirection(n));
                    } else if (AbstractSortableTable.this.fBidirectionalSortingEnabled) {
                        AbstractSortableTable.this.sortByColumn(n, AbstractSortableTable.this.getSortDirection() == 0 ? 1 : 0);
                    }
                }
            }
        };
        this.getTableHeader().addMouseListener(this.fSortMouseListener);
    }

    protected int getDefaultSortDirection(int n) {
        return 0;
    }

    protected void removeHeaderMouseListener() {
        this.getTableHeader().removeMouseListener(this.fSortMouseListener);
    }
}

