/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.MJFrame;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;

public class MJCornerGrip
extends JComponent {
    private Component fComponentToResize;
    private boolean fEnforceMinimumSize;
    private boolean fIsBeingDragged;
    private static final int WINDOWS_WIDTH = 12;
    private static final int WINDOWS_HEIGHT = 16;
    private static final int MAC_HEIGHT = 16;
    private static final int MAC_WIDTH = 16;
    private static final String UI_CLASS_ID = "CornerGripUI";
    private static final Color MAC_BOX_COLOR = new Color(217, 217, 217);
    private static final Color MAC_STRIPE_COLOR = new Color(125, 125, 125);
    private static final Color XP_PATCH_COLOR = new Color(184, 180, 163);
    private static final int WM_ENTERSIZEMOVE = 561;
    private static final int WM_EXITSIZEMOVE = 562;

    public static MJCornerGrip createAlwaysVisibleCornerGrip() {
        MJCornerGrip mJCornerGrip = new MJCornerGrip();
        if (mJCornerGrip.getUI().getClass().equals(BasicUI.class)) {
            mJCornerGrip.setUI(new WindowsUI());
        }
        return mJCornerGrip;
    }

    public MJCornerGrip() {
        this.updateUI();
    }

    @Override
    private ComponentUI getUI() {
        return this.ui;
    }

    public void setComponentToResize(Component component) {
        this.fComponentToResize = component;
    }

    public Component getComponentToResize() {
        Container container;
        if (this.fComponentToResize != null) {
            return this.fComponentToResize;
        }
        for (container = this.getParent(); container != null && !(container instanceof Window) && !(container instanceof JInternalFrame); container = container.getParent()) {
        }
        return container;
    }

    public void setEnforceMinimumSize(boolean bl) {
        this.fEnforceMinimumSize = bl;
    }

    public boolean enforceMinimumSize() {
        return this.fEnforceMinimumSize;
    }

    public boolean isBeingDragged() {
        return this.fIsBeingDragged;
    }

    @Override
    public void updateUI() {
        this.setUI(UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    static {
        UIDefaults uIDefaults = UIManager.getDefaults();
        if (PlatformInfo.isWindows()) {
            if (PlatformInfo.isWindowsModernAppearance()) {
                uIDefaults.put(UI_CLASS_ID, "com.mathworks.mwswing.MJCornerGrip$WindowsXPUI");
            } else {
                uIDefaults.put(UI_CLASS_ID, "com.mathworks.mwswing.MJCornerGrip$WindowsUI");
            }
        } else if (PlatformInfo.isMacintosh()) {
            if (!"com.mathworks.mlwidgets.actionbrowser.MACCornerGrip$MacUI".equals(uIDefaults.get(UI_CLASS_ID))) {
                uIDefaults.put(UI_CLASS_ID, "com.mathworks.mwswing.MJCornerGrip$MacUI");
            }
        } else {
            uIDefaults.put(UI_CLASS_ID, "com.mathworks.mwswing.MJCornerGrip$BasicUI");
        }
    }

    public static class MacUI
    extends BasicUI {
        public static ComponentUI createUI(JComponent jComponent) {
            return new MacUI();
        }

        @Override
        public Dimension getPreferredSize(JComponent jComponent) {
            return new Dimension(16, 16);
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            Color color = graphics.getColor();
            int n = jComponent.getWidth();
            int n2 = jComponent.getHeight();
            graphics.setColor(MAC_STRIPE_COLOR);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n3 = n - 11;
            int n4 = n2 - 2;
            int n5 = n - 2;
            int n6 = n2 - 11;
            for (int i = 0; i < 3; ++i) {
                graphics.drawLine(n3, n4, n5, n6);
                n3 += 4;
                n6 += 4;
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            graphics.setColor(color);
        }
    }

    public static class WindowsXPUI
    extends BasicUI {
        public static ComponentUI createUI(JComponent jComponent) {
            return new WindowsXPUI();
        }

        @Override
        public Dimension getPreferredSize(JComponent jComponent) {
            return new Dimension(12, 16);
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            Color color = graphics.getColor();
            int n = jComponent.getWidth();
            int n2 = jComponent.getHeight();
            graphics.setColor(Color.white);
            this.paintPatches(graphics, n, n2);
            graphics.translate(-1, -1);
            graphics.setColor(XP_PATCH_COLOR);
            this.paintPatches(graphics, n, n2);
            graphics.translate(1, 1);
            graphics.setColor(color);
        }

        private void paintPatches(Graphics graphics, int n, int n2) {
            int n3 = 0;
            int n4 = n2 - 3;
            while (n3 < 3) {
                int n5 = n3;
                int n6 = n - 3;
                while (n5 < 3) {
                    graphics.fillRect(n6, n4, 2, 2);
                    ++n5;
                    n6 -= 4;
                }
                ++n3;
                n4 -= 4;
            }
        }
    }

    public static class WindowsUI
    extends BasicUI {
        public static ComponentUI createUI(JComponent jComponent) {
            return new WindowsUI();
        }

        @Override
        public Dimension getPreferredSize(JComponent jComponent) {
            return new Dimension(12, 16);
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            Color color = graphics.getColor();
            Color color2 = UIManager.getColor("controlLtHighlight");
            Color color3 = UIManager.getColor("controlShadow");
            int n = jComponent.getWidth();
            int n2 = jComponent.getHeight();
            int n3 = n - 12;
            int n4 = n2 - 1;
            int n5 = n - 1;
            int n6 = n2 - 12;
            for (int i = 0; i < 3; ++i) {
                graphics.setColor(color2);
                graphics.drawLine(n3++, n4, n5, n6++);
                graphics.setColor(color3);
                graphics.drawLine(n3++, n4, n5, n6++);
                graphics.drawLine(n3++, n4, n5, n6++);
                ++n3;
                ++n6;
            }
            graphics.setColor(color);
        }
    }

    public static class BasicUI
    extends ComponentUI {
        protected MouseInputListener fMouseListener = new CornerMouseListener();

        public static ComponentUI createUI(JComponent jComponent) {
            return new BasicUI();
        }

        @Override
        public void installUI(JComponent jComponent) {
            jComponent.addMouseListener(this.fMouseListener);
            jComponent.addMouseMotionListener(this.fMouseListener);
        }

        @Override
        public void uninstallUI(JComponent jComponent) {
            jComponent.removeMouseListener(this.fMouseListener);
            jComponent.removeMouseMotionListener(this.fMouseListener);
        }

        @Override
        public Dimension getPreferredSize(JComponent jComponent) {
            return new Dimension(0, 0);
        }

        int getCursorType(JComponent jComponent, Point point) {
            if (jComponent.contains(point)) {
                return 5;
            }
            return 0;
        }

        class CornerMouseListener
        extends MouseInputAdapter {
            int fCurrentCursor = 0;
            Point fPressedPoint;
            Dimension fInitialSize;
            Component fResizeComponent;
            boolean fChangedBounds;

            CornerMouseListener() {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.fPressedPoint = mouseEvent.getPoint();
                MJCornerGrip mJCornerGrip = (MJCornerGrip)mouseEvent.getSource();
                SwingUtilities.convertPointToScreen(this.fPressedPoint, mJCornerGrip);
                this.fResizeComponent = mJCornerGrip.getComponentToResize();
                this.fInitialSize = this.fResizeComponent.getSize();
                mJCornerGrip.fIsBeingDragged = true;
                if (this.fResizeComponent instanceof MJFrame) {
                    MJFrame mJFrame = (MJFrame)this.fResizeComponent;
                    mJFrame.beginDragResize();
                    if (NativeJava.nativeLibraryExists() && PlatformInfo.isWindows()) {
                        NativeJava.winPostMessage((long)mJFrame.getHWnd(), (int)561, (long)0L, (long)0L);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                MJCornerGrip mJCornerGrip = (MJCornerGrip)mouseEvent.getSource();
                mJCornerGrip.fIsBeingDragged = false;
                if (this.fResizeComponent instanceof MJFrame) {
                    MJFrame mJFrame = (MJFrame)this.fResizeComponent;
                    mJFrame.endDragResize();
                    if (NativeJava.nativeLibraryExists() && PlatformInfo.isWindows()) {
                        NativeJava.winPostMessage((long)mJFrame.getHWnd(), (int)562, (long)0L, (long)0L);
                    }
                }
                if (this.fChangedBounds) {
                    this.fResizeComponent.invalidate();
                    this.fResizeComponent.validate();
                    this.fResizeComponent.repaint();
                    this.fChangedBounds = false;
                }
                this.fResizeComponent = null;
                this.fPressedPoint = null;
                this.fInitialSize = null;
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (this.fResizeComponent == null && this.fCurrentCursor != 0) {
                    MJCornerGrip mJCornerGrip = (MJCornerGrip)mouseEvent.getSource();
                    mJCornerGrip.setCursor(Cursor.getDefaultCursor());
                    this.fCurrentCursor = 0;
                }
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                MJCornerGrip mJCornerGrip = (MJCornerGrip)mouseEvent.getSource();
                int n = BasicUI.this.getCursorType(mJCornerGrip, mouseEvent.getPoint());
                if (n != this.fCurrentCursor) {
                    this.fCurrentCursor = n;
                    mJCornerGrip.setCursor(Cursor.getPredefinedCursor(n));
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (this.fCurrentCursor == 0 || this.fResizeComponent == null || this.fPressedPoint == null) {
                    return;
                }
                MJCornerGrip mJCornerGrip = (MJCornerGrip)mouseEvent.getSource();
                Point point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, mJCornerGrip);
                int n = this.fInitialSize.width + point.x - this.fPressedPoint.x;
                int n2 = this.fInitialSize.height + point.y - this.fPressedPoint.y;
                if (mJCornerGrip.enforceMinimumSize()) {
                    Dimension dimension = this.fResizeComponent.getMinimumSize();
                    if (n < dimension.width) {
                        n = dimension.width;
                    }
                    if (n2 < dimension.height) {
                        n2 = dimension.height;
                    }
                }
                if (this.fResizeComponent instanceof Window && NativeJava.nativeLibraryExists() && PlatformInfo.isWindows()) {
                    NativeJava.setBounds((Window)((Window)this.fResizeComponent), (int)this.fResizeComponent.getX(), (int)this.fResizeComponent.getY(), (int)n, (int)n2);
                } else {
                    this.fResizeComponent.setSize(n, n2);
                    this.fResizeComponent.invalidate();
                    this.fResizeComponent.validate();
                }
                this.fChangedBounds = true;
            }
        }
    }
}

