/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.AppearanceFocusDispatcher;
import com.mathworks.mwswing.AppearanceFocusEvent;
import com.mathworks.mwswing.AppearanceFocusListener;
import com.mathworks.mwswing.CellViewerCustomizer;
import com.mathworks.mwswing.CellViewerUtils;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.DefaultTableCellViewerCustomizer;
import com.mathworks.mwswing.MJComponent;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.PropertySafetyListener;
import com.mathworks.mwswing.TableCell;
import com.mathworks.mwswing.TableUtils;
import com.mathworks.mwswing.table.AccessibleTextProvider;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleText;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class MJTable
extends JTable
implements CellViewerCustomizer<TableCell> {
    private boolean fRightSelectionEnabled;
    private boolean fMiddleSelectionEnabled;
    private boolean fHorizontalAutoScrollEnabled;
    private CellViewerUtils.Context fCellViewerContext;
    private int fSuppressedIndex = -1;
    private MouseDragGestureRecognizer fDragRecognizer;
    private CellViewerCustomizer<TableCell> fDefaultCellViewerCustomizer;
    private TableModelListener fModelSafetyListener;
    private ListSelectionListener fSelectionSafetyListener;
    private TableColumnModelListener fColumnSafetyListener;
    private boolean fDragListening;
    private boolean fIsSelectionLocked;
    private boolean fSelectionAppearanceReflectsFocus = true;
    private Color fSaveSelectionBackground;
    private Color fSaveSelectionForeground;
    private boolean fAutoRowHeightResizing = true;
    private static AccessibleContext sAccessFailureContext;
    private static final AppearanceFocusDispatcher sAppearanceFocusDispatcher;
    private JPanel fColumnHeaderPanel;
    private boolean fFillEmptyColumnHeader;
    private AccessibleTextProvider fAccessibleTextProvider;

    public MJTable() {
        this.initialize();
    }

    public MJTable(TableModel tableModel) {
        super(tableModel);
        this.initialize();
    }

    public MJTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.initialize();
    }

    public MJTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.initialize();
    }

    public MJTable(int n, int n2) {
        super(n, n2);
        this.initialize();
    }

    public MJTable(Vector<?> vector, Vector<?> vector2) {
        super(vector, vector2);
        this.initialize();
    }

    public MJTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.initialize();
    }

    private void initialize() {
        this.fDefaultCellViewerCustomizer = new DefaultTableCellViewerCustomizer(this);
        this.addSelfListeners();
        this.repairInputMap();
        TableUtils.adjustRowHeight(this);
        if (this.selectionAppearanceReflectsFocus()) {
            this.useUnfocusedSelectionColors();
        }
    }

    private void addSelfListeners() {
        LocalMouseListener localMouseListener = new LocalMouseListener();
        this.addMouseListener(localMouseListener);
        this.addMouseMotionListener(localMouseListener);
        if (this.selectionAppearanceReflectsFocus()) {
            this.addFocusListener(sAppearanceFocusDispatcher);
        }
        if (MJUtilities.threadingChecksEnabled()) {
            this.fModelSafetyListener = new ModelSafetyListener();
            this.fSelectionSafetyListener = new SelectionSafetyListener();
            this.fColumnSafetyListener = new ColumnSafetyListener();
            this.getModel().addTableModelListener(this.fModelSafetyListener);
            this.getSelectionModel().addListSelectionListener(this.fSelectionSafetyListener);
            this.getColumnModel().addColumnModelListener(this.fColumnSafetyListener);
            this.addPropertyChangeListener(new PropertySafetyListener(this));
        }
    }

    private void repairInputMap() {
        if (PlatformInfo.isMacintosh()) {
            InputMap inputMap = this.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke("ENTER"), "selectNextRowCell");
            inputMap.put(KeyStroke.getKeyStroke("shift ENTER"), "selectPreviousRowCell");
        }
    }

    public void setRightSelectionEnabled(boolean bl) {
        this.fRightSelectionEnabled = bl;
    }

    public boolean isRightSelectionEnabled() {
        return this.fRightSelectionEnabled;
    }

    public void setMiddleSelectionEnabled(boolean bl) {
        this.fMiddleSelectionEnabled = bl;
    }

    public boolean isMiddleSelectionEnabled() {
        return this.fMiddleSelectionEnabled;
    }

    public void setHorizontalAutoScrollEnabled(boolean bl) {
        this.fHorizontalAutoScrollEnabled = bl;
    }

    public boolean isHorizontalAutoScrollEnabled() {
        return this.fHorizontalAutoScrollEnabled;
    }

    public void setCellViewerEnabled(boolean bl) {
        if (bl && this.fCellViewerContext == null) {
            this.fCellViewerContext = CellViewerUtils.installCellViewer(this);
        } else if (!bl && this.fCellViewerContext != null) {
            this.fCellViewerContext.uninstall();
            this.fCellViewerContext = null;
        }
    }

    public boolean isCellViewerEnabled() {
        return this.fCellViewerContext != null;
    }

    public void setSelectionAppearanceReflectsFocus(boolean bl) {
        if (bl && !this.selectionAppearanceReflectsFocus()) {
            this.addFocusListener(sAppearanceFocusDispatcher);
        } else if (!bl && this.selectionAppearanceReflectsFocus()) {
            this.removeFocusListener(sAppearanceFocusDispatcher);
            this.useFocusedSelectionColors();
        }
        this.fSelectionAppearanceReflectsFocus = bl;
    }

    public boolean selectionAppearanceReflectsFocus() {
        return this.fSelectionAppearanceReflectsFocus;
    }

    @Override
    public void setModel(TableModel tableModel) {
        if (this.fModelSafetyListener != null) {
            TableModel tableModel2 = this.getModel();
            tableModel2.removeTableModelListener(this.fModelSafetyListener);
            if (tableModel != null) {
                tableModel.addTableModelListener(this.fModelSafetyListener);
            }
        }
        super.setModel(tableModel);
    }

    @Override
    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (this.fSelectionSafetyListener != null) {
            ListSelectionModel listSelectionModel2 = this.getSelectionModel();
            listSelectionModel2.removeListSelectionListener(this.fSelectionSafetyListener);
            listSelectionModel.addListSelectionListener(this.fSelectionSafetyListener);
        }
        super.setSelectionModel(listSelectionModel);
    }

    @Override
    public void setColumnModel(TableColumnModel tableColumnModel) {
        if (this.fColumnSafetyListener != null) {
            TableColumnModel tableColumnModel2 = this.getColumnModel();
            tableColumnModel2.removeColumnModelListener(this.fColumnSafetyListener);
            tableColumnModel.addColumnModelListener(this.fColumnSafetyListener);
        }
        super.setColumnModel(tableColumnModel);
    }

    @Override
    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        if (this.fIsSelectionLocked) {
            return;
        }
        if (this.fHorizontalAutoScrollEnabled) {
            super.changeSelection(n, n2, bl, bl2);
            return;
        }
        boolean bl3 = this.getAutoscrolls();
        if (bl3) {
            this.setAutoscrolls(false);
        }
        super.changeSelection(n, n2, bl, bl2);
        if (bl3) {
            this.setAutoscrolls(true);
            Rectangle rectangle = this.getCellRect(n, n2, false);
            if (rectangle != null) {
                Rectangle rectangle2 = this.getVisibleRect();
                rectangle.x = rectangle2.x;
                rectangle.width = rectangle2.width;
                this.scrollRectToVisible(rectangle);
            }
        }
    }

    @Override
    public int getSelectedRow() {
        int n = super.getSelectedRow();
        return n < this.getModel().getRowCount() ? n : -1;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.fAutoRowHeightResizing) {
            TableUtils.adjustRowHeight(this);
        }
    }

    public void disableAutoRowHeightResizing() {
        this.fAutoRowHeightResizing = false;
    }

    @Override
    public int[] getSelectedRows() {
        int[] nArray = super.getSelectedRows();
        int n = this.getModel().getRowCount();
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < n) continue;
            nArray[i] = -1;
            ++n2;
        }
        if (n2 > 0) {
            int[] nArray2 = nArray;
            nArray = new int[nArray2.length - n2];
            int n3 = 0;
            for (int i = 0; i < nArray2.length; ++i) {
                if (nArray2[i] == -1) continue;
                nArray[n3++] = nArray2[i];
            }
        }
        return nArray;
    }

    @Override
    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        if (this.getFillEmptyColumnHeader()) {
            this.fillEmptyColumnHeader();
        }
    }

    @Override
    protected void unconfigureEnclosingScrollPane() {
        if (this.getFillEmptyColumnHeader()) {
            this.unfillEmptyColumnHeader();
        }
        super.unconfigureEnclosingScrollPane();
    }

    public void setFillEmptyColumnHeader(boolean bl) {
        if (bl != this.getFillEmptyColumnHeader()) {
            if (bl) {
                this.fillEmptyColumnHeader();
            } else {
                this.unfillEmptyColumnHeader();
            }
        }
        this.fFillEmptyColumnHeader = bl;
    }

    public boolean getFillEmptyColumnHeader() {
        return this.fFillEmptyColumnHeader;
    }

    private void fillEmptyColumnHeader() {
        Container container = this.getParent();
        if (container instanceof JViewport) {
            Container container2 = container.getParent();
            JTableHeader jTableHeader = this.getTableHeader();
            if (jTableHeader != null && container2 instanceof JScrollPane) {
                if (this.fColumnHeaderPanel == null) {
                    this.fColumnHeaderPanel = new JPanel(new BorderLayout());
                }
                JScrollPane jScrollPane = (JScrollPane)container2;
                this.fColumnHeaderPanel.removeAll();
                this.fColumnHeaderPanel.add((Component)jTableHeader, "West");
                this.fColumnHeaderPanel.add((Component)new FinalEmptyColumnHeader(), "Center");
                jScrollPane.setColumnHeaderView(this.fColumnHeaderPanel);
            }
        }
    }

    private void unfillEmptyColumnHeader() {
        Container container;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            jScrollPane.setColumnHeaderView(this.getTableHeader());
            if (this.fColumnHeaderPanel != null) {
                this.fColumnHeaderPanel.removeAll();
                this.fColumnHeaderPanel = null;
            }
        }
    }

    public void useUnfocusedSelectionColors() {
        Color color;
        if (this.fSaveSelectionBackground == null) {
            color = this.getSelectionBackground();
            this.setSelectionBackground(ColorUtils.getUnfocusedSelectionBackgroundColor(this));
            this.fSaveSelectionBackground = color;
        }
        if (this.fSaveSelectionForeground == null) {
            color = this.getSelectionForeground();
            this.setSelectionForeground(ColorUtils.getUnfocusedSelectionForegroundColor(this));
            this.fSaveSelectionForeground = color;
        }
        this.repaint();
    }

    public void useFocusedSelectionColors() {
        Color color;
        if (this.fSaveSelectionBackground != null) {
            color = this.fSaveSelectionBackground;
            this.fSaveSelectionBackground = null;
            this.setSelectionBackground(color);
        }
        if (this.fSaveSelectionForeground != null) {
            color = this.fSaveSelectionForeground;
            this.fSaveSelectionForeground = null;
            this.setSelectionForeground(color);
        }
        this.repaint();
    }

    @Override
    public Component getCellPainter(TableCell tableCell) {
        return this.fDefaultCellViewerCustomizer.getCellPainter(tableCell);
    }

    @Override
    public Dimension getCellViewerOffset(TableCell tableCell) {
        return this.fDefaultCellViewerCustomizer.getCellViewerOffset(tableCell);
    }

    @Override
    public boolean shouldShowCellViewer(TableCell tableCell) {
        return this.fDefaultCellViewerCustomizer.shouldShowCellViewer(tableCell);
    }

    @Override
    public boolean constrainViewerToCellHeight() {
        return this.fDefaultCellViewerCustomizer.constrainViewerToCellHeight();
    }

    public void enableDragHandling(boolean bl) {
        this.fDragListening = bl;
    }

    @Override
    public synchronized void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        if (mouseListener instanceof MouseDragGestureRecognizer) {
            this.fDragRecognizer = (MouseDragGestureRecognizer)mouseListener;
        }
    }

    @Override
    public synchronized void removeMouseListener(MouseListener mouseListener) {
        super.removeMouseListener(mouseListener);
        if (mouseListener == this.fDragRecognizer) {
            this.fDragRecognizer = null;
            this.fSuppressedIndex = -1;
        }
    }

    public void setAccessibleTextProvider(AccessibleTextProvider accessibleTextProvider) {
        this.fAccessibleTextProvider = accessibleTextProvider;
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.fDragRecognizer != null && this.fDragListening && mouseEvent.getID() == 506 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.fDragRecognizer.mouseDragged(mouseEvent);
        } else {
            super.processMouseMotionEvent(mouseEvent);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        this.processMouseEventImpl(mouseEvent);
    }

    public final void processMouseEventImpl(MouseEvent mouseEvent) {
        int n;
        int n2;
        if (this.fCellViewerContext != null) {
            mouseEvent = this.fCellViewerContext.adjustMouseEvent(mouseEvent);
        }
        if (this.fDragRecognizer != null && this.fDragListening) {
            int n3 = mouseEvent.getID();
            if (n3 == 501) {
                n2 = this.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                n = mouseEvent.getModifiers();
                if ((n & 0x10) != 0 && this.getSelectedRows().length > 1 && this.isRowSelected(n2)) {
                    this.fIsSelectionLocked = true;
                    this.fSuppressedIndex = n2;
                } else {
                    this.fSuppressedIndex = -1;
                }
            } else if (n3 == 502 && this.fSuppressedIndex != -1) {
                MJUtilities.handleMouseReleased(mouseEvent, this.fSuppressedIndex, this.getSelectionModel());
                this.fSuppressedIndex = -1;
            }
        }
        if (PlatformInfo.isMacintosh() && mouseEvent.isPopupTrigger() && SwingUtilities.isLeftMouseButton(mouseEvent) && !mouseEvent.isShiftDown() && this.getSelectionModel().getSelectionMode() != 0) {
            Point point = mouseEvent.getPoint();
            n2 = this.rowAtPoint(point);
            n = this.columnAtPoint(point);
            this.fIsSelectionLocked = n2 != -1 && n != -1 && this.isCellSelected(n2, n);
        }
        super.processMouseEvent(mouseEvent);
        this.fIsSelectionLocked = false;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (keyEvent == null) {
            return super.processKeyBinding(keyStroke, keyEvent, n, bl);
        }
        if (n == 1 && this.isFocusOwner() && keyEvent.getID() == 401 && !this.mayAutoStartEdit(keyStroke, keyEvent, n, bl)) {
            Boolean bl2 = (Boolean)this.getClientProperty("JTable.autoStartsEdit");
            this.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
            boolean bl3 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
            this.putClientProperty("JTable.autoStartsEdit", bl2);
            return bl3;
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    protected boolean mayAutoStartEdit(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        int n2 = keyEvent.getKeyCode();
        return n2 != 0 && keyEvent.getKeyCode() != 20 && keyEvent.getKeyCode() != 144 && (!PlatformInfo.isMacintosh() || n2 != 157 || keyEvent.getModifiers() != 4);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        Container container;
        if (this.getColumnCount() <= 16) {
            if (this.accessibleContext == null) {
                this.accessibleContext = new ExtAccessibleJTable();
            }
            return this.accessibleContext;
        }
        if (sAccessFailureContext == null) {
            sAccessFailureContext = new MJLabel("Sorry, this is a table which is too large to be properly handled by screen readers.").getAccessibleContext();
        }
        if ((container = this.getParent()) instanceof Accessible) {
            sAccessFailureContext.setAccessibleParent((Accessible)((Object)container));
        } else {
            sAccessFailureContext.setAccessibleParent(null);
        }
        return sAccessFailureContext;
    }

    static {
        sAppearanceFocusDispatcher = new AppearanceFocusDispatcher();
        sAppearanceFocusDispatcher.addAppearanceFocusListener(new TableAppearanceFocusListener());
    }

    private class ExtAccessibleJTable
    extends JTable.AccessibleJTable {
        private ExtAccessibleJTable() {
            super(MJTable.this);
        }

        @Override
        public Accessible getAccessibleAt(Point point) {
            if (MJTable.this.fAccessibleTextProvider == null) {
                return super.getAccessibleAt(point);
            }
            int n = MJTable.this.columnAtPoint(point);
            int n2 = MJTable.this.rowAtPoint(point);
            if (n == -1 || n2 == -1) {
                return super.getAccessibleAt(point);
            }
            return this.createAccessibleCell(n2, n);
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            if (MJTable.this.fAccessibleTextProvider == null) {
                return super.getAccessibleChild(n);
            }
            if (n < 0 || n >= this.getAccessibleChildrenCount()) {
                return super.getAccessibleChild(n);
            }
            return this.createAccessibleCell(this.getAccessibleRowAtIndex(n), this.getAccessibleColumnAtIndex(n));
        }

        private Accessible createAccessibleCell(int n, int n2) {
            Serializable serializable;
            TableColumn tableColumn = MJTable.this.getColumnModel().getColumn(n2);
            TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
            if (tableCellRenderer == null) {
                serializable = MJTable.this.getColumnClass(n2);
                tableCellRenderer = MJTable.this.getDefaultRenderer((Class<?>)serializable);
            }
            serializable = tableCellRenderer.getTableCellRendererComponent(MJTable.this, null, false, false, n, n2);
            String string = MJTable.this.fAccessibleTextProvider.getAccessibleText(n, n2);
            return new ExtAccessibleJTableCell(MJTable.this, n, n2, this.getAccessibleIndexAt(n, n2), (Component)serializable, string);
        }

        private class ExtAccessibleJTableCell
        extends JTable.AccessibleJTable.AccessibleJTableCell {
            private final Component iComponent;
            private final String iText;

            ExtAccessibleJTableCell(JTable jTable, int n, int n2, int n3, Component component, String string) {
                super(ExtAccessibleJTable.this, jTable, n, n2, n3);
                this.iComponent = component;
                this.iText = string;
            }

            @Override
            public AccessibleText getAccessibleText() {
                this.iComponent.getAccessibleContext().setAccessibleName(this.iText);
                return this.iComponent.getAccessibleContext().getAccessibleText();
            }
        }
    }

    private static class TableAppearanceFocusListener
    implements AppearanceFocusListener {
        private TableAppearanceFocusListener() {
        }

        @Override
        public void appearanceFocusLost(AppearanceFocusEvent appearanceFocusEvent) {
            if (appearanceFocusEvent.getComponent() instanceof MJTable) {
                ((MJTable)appearanceFocusEvent.getComponent()).useUnfocusedSelectionColors();
            }
        }

        @Override
        public void appearanceFocusGained(AppearanceFocusEvent appearanceFocusEvent) {
            if (appearanceFocusEvent.getComponent() instanceof MJTable) {
                ((MJTable)appearanceFocusEvent.getComponent()).useFocusedSelectionColors();
            }
        }
    }

    private class ColumnSafetyListener
    implements TableColumnModelListener {
        private ColumnSafetyListener() {
        }

        @Override
        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            if (MJTable.this.isShowing()) {
                MJUtilities.assertIsEventThread();
            }
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            if (MJTable.this.isShowing()) {
                MJUtilities.assertIsEventThread();
            }
        }

        @Override
        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            if (MJTable.this.isShowing()) {
                MJUtilities.assertIsEventThread();
            }
        }

        @Override
        public void columnMarginChanged(ChangeEvent changeEvent) {
            if (MJTable.this.isShowing()) {
                MJUtilities.assertIsEventThread();
            }
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            if (MJTable.this.isShowing()) {
                MJUtilities.assertIsEventThread();
            }
        }
    }

    private class SelectionSafetyListener
    implements ListSelectionListener {
        private SelectionSafetyListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (MJTable.this.isShowing()) {
                MJUtilities.assertIsEventThread();
            }
        }
    }

    private class ModelSafetyListener
    implements TableModelListener {
        private ModelSafetyListener() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (MJTable.this.isShowing()) {
                MJUtilities.assertIsEventThread();
            }
        }
    }

    private class LocalMouseListener
    extends MouseInputAdapter {
        private LocalMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!MJTable.this.isEnabled()) {
                return;
            }
            if (!(MJTable.this.isRightSelectionEnabled() && MJUtilities.isRightMouseButton(mouseEvent) || MJTable.this.isMiddleSelectionEnabled() && SwingUtilities.isMiddleMouseButton(mouseEvent))) {
                return;
            }
            int n = MJTable.this.rowAtPoint(mouseEvent.getPoint());
            int n2 = MJTable.this.columnAtPoint(mouseEvent.getPoint());
            if (n == -1 || n2 == -1) {
                return;
            }
            if (!MJTable.this.isCellSelected(n, n2)) {
                MJTable.this.changeSelection(n, n2, mouseEvent.isControlDown(), mouseEvent.isShiftDown());
            }
        }
    }

    private class FinalEmptyColumnHeader
    extends MJComponent {
        FinalEmptyColumnHeader() {
            this.setOpaque(true);
        }

        @Override
        public void paint(Graphics graphics) {
            Component component = MJTable.this.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(MJTable.this, null, false, false, -1, Integer.MAX_VALUE);
            Rectangle rectangle = SwingUtilities.convertRectangle(MJTable.this.getTableHeader(), MJTable.this.getTableHeader().getBounds(), this);
            rectangle.x = 0;
            rectangle.width = this.getWidth();
            SwingUtilities.paintComponent(graphics, component, this, rectangle);
        }
    }
}

