/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.ItemSafetyListener;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.PropertySafetyListener;
import com.mathworks.mwswing.WeakPropertyChangeCoupler;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.AccessibleContext;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MJToggleButton
extends JToggleButton {
    protected boolean fFlyOverAppearance = false;
    protected boolean fTextHidden = false;
    protected boolean fAcceptFocus = true;
    protected boolean fAutoMnemonicEnabled = true;
    protected String fOriginalString = "";
    private boolean fInPaint;
    private PropertyChangeListener fActionPropertyHandler;
    private ItemListener fSelectionSafetyListener;
    protected static final String BASE_NAME = "Button";

    public MJToggleButton() {
        this.setText("");
        this.doCustomSetup();
        this.addSafetyListeners();
    }

    public MJToggleButton(Action action) {
        this.setAction(action);
        this.doCustomSetup();
        this.addSafetyListeners();
    }

    public MJToggleButton(Icon icon) {
        super(icon);
        this.setText("");
        this.doCustomSetup();
        this.addSafetyListeners();
    }

    public MJToggleButton(Icon icon, boolean bl) {
        super(icon, bl);
        this.setText("");
        this.doCustomSetup();
        this.addSafetyListeners();
    }

    public MJToggleButton(String string) {
        this.setText(string);
        this.doCustomSetup();
        this.addSafetyListeners();
    }

    public MJToggleButton(String string, boolean bl) {
        super(string, bl);
        this.setText(string);
        this.doCustomSetup();
        this.addSafetyListeners();
    }

    public MJToggleButton(String string, Icon icon) {
        super(icon);
        this.setText(string);
        this.doCustomSetup();
        this.addSafetyListeners();
    }

    public MJToggleButton(String string, Icon icon, boolean bl) {
        super(icon, bl);
        this.setText(string);
        this.doCustomSetup();
        this.addSafetyListeners();
    }

    @Override
    public Color getForeground() {
        return PlatformInfo.isWindowsModernAppearance() && !this.isEnabled() ? UIManager.getColor("ToggleButton.foreground") : super.getForeground();
    }

    protected void doCustomSetup() {
        this.setBorderPainted(!this.fFlyOverAppearance);
        FlyOverListener flyOverListener = new FlyOverListener();
        this.addMouseListener(flyOverListener);
        this.addChangeListener(flyOverListener);
    }

    private void addSafetyListeners() {
        if (MJUtilities.threadingChecksEnabled()) {
            this.fSelectionSafetyListener = new ItemSafetyListener(this);
            this.getModel().addItemListener(this.fSelectionSafetyListener);
            this.addPropertyChangeListener(new PropertySafetyListener(this));
        }
    }

    @Override
    public void setText(String string) {
        if (string != null || !this.fTextHidden) {
            this.fOriginalString = string;
        }
        if (!this.fAutoMnemonicEnabled) {
            super.setText(string);
            return;
        }
        if (string == null) {
            super.setText(null);
            this.setMnemonic('\u0000');
            return;
        }
        super.setText(MJUtilities.exciseAmpersand(string));
        MJUtilities.setMnemonicFromText(this, string);
    }

    public void setAutoMnemonicEnabled(boolean bl) {
        this.fAutoMnemonicEnabled = bl;
        this.setText(this.fOriginalString);
    }

    public boolean isAutoMnemonicEnabled() {
        return this.fAutoMnemonicEnabled;
    }

    public void setFlyOverAppearance(boolean bl) {
        this.fFlyOverAppearance = bl;
        this.setBorderPainted(this.isSelected() || !bl);
    }

    public void setFocusTraversable(boolean bl) {
        this.fAcceptFocus = bl;
        this.setRequestFocusEnabled(bl);
    }

    public boolean hasFlyOverAppearance() {
        return this.fFlyOverAppearance;
    }

    @Override
    public boolean isFocusTraversable() {
        return this.fAcceptFocus;
    }

    protected boolean super_isFocusTraversable() {
        return super.isFocusTraversable();
    }

    @Override
    public void setAction(Action action) {
        Object object;
        String string;
        Action action2 = this.getAction();
        if (action2 != null) {
            WeakPropertyChangeCoupler.detach(action2, this.fActionPropertyHandler);
        }
        if (action2 instanceof MJAbstractAction) {
            this.removeItemListener((ItemListener)((Object)action2));
        }
        super.setAction(action);
        if (action == null) {
            if (action2 instanceof MJAbstractAction) {
                this.setName(BASE_NAME);
            }
            return;
        }
        if (this.fActionPropertyHandler == null) {
            this.fActionPropertyHandler = new ActionPropertyHandler();
        }
        WeakPropertyChangeCoupler.attach(action, this.fActionPropertyHandler);
        Integer n = (Integer)action.getValue("MnemonicIndex");
        if (n != null) {
            this.setDisplayedMnemonicIndex(n);
        }
        if ((string = (String)action.getValue("ComponentName")) != null) {
            this.setName(string + BASE_NAME);
        }
        if (action instanceof MJAbstractAction) {
            object = ((MJAbstractAction)action).getButtonOnlyIcon();
            if (object != null) {
                this.setIcon((Icon)object);
            }
            this.setSelected(((MJAbstractAction)action).isSelected());
            this.addItemListener((ItemListener)((Object)action));
        }
        if ((object = this.getParent()) instanceof MJToolBar) {
            this.hideText();
        }
    }

    public void hideText() {
        this.fTextHidden = true;
        AccessibleContext accessibleContext = this.getAccessibleContext();
        String string = accessibleContext.getAccessibleName();
        this.setText(null);
        if (accessibleContext.getAccessibleName() == null) {
            accessibleContext.setAccessibleName(string);
        }
        this.revalidate();
        this.repaint();
    }

    public void unHideText() {
        if (this.fTextHidden) {
            this.fTextHidden = false;
            this.setText(this.fOriginalString);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void setModel(ButtonModel buttonModel) {
        if (this.fSelectionSafetyListener != null) {
            ButtonModel buttonModel2 = this.getModel();
            buttonModel2.removeItemListener(this.fSelectionSafetyListener);
            buttonModel.addItemListener(this.fSelectionSafetyListener);
        }
        super.setModel(buttonModel);
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        boolean bl;
        boolean bl2 = bl = this.isEnabled() && PlatformInfo.isMacintosh() && mouseEvent.isPopupTrigger();
        if (bl) {
            this.setEnabled(false);
        }
        super.processMouseEvent(mouseEvent);
        if (bl) {
            this.setEnabled(true);
        }
    }

    @Override
    public Container getParent() {
        Container container = super.getParent();
        if (this.fFlyOverAppearance && this.fInPaint && PlatformInfo.useWindowsXPAppearance() && !(container instanceof JToolBar)) {
            if (MJButton.sDummyToolBarParent == null) {
                MJButton.sDummyToolBarParent = new MJToolBar();
            }
            container = MJButton.sDummyToolBarParent;
        }
        return container;
    }

    @Override
    public void paint(Graphics graphics) {
        this.fInPaint = true;
        super.paint(graphics);
        this.fInPaint = false;
    }

    private class FlyOverListener
    extends MouseAdapter
    implements ChangeListener {
        boolean fIsOverButton;

        private FlyOverListener() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.fIsOverButton = true;
            if (MJToggleButton.this.fFlyOverAppearance && !MJToggleButton.this.isBorderPainted() && MJToggleButton.this.isEnabled() && !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                MJToggleButton.this.setBorderPainted(true);
                MJToggleButton.this.invalidate();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.fIsOverButton = false;
            if (MJToggleButton.this.fFlyOverAppearance && MJToggleButton.this.isBorderPainted() && !MJToggleButton.this.isSelected() && !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                MJToggleButton.this.setBorderPainted(false);
                MJToggleButton.this.invalidate();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (MJToggleButton.this.fFlyOverAppearance && !this.fIsOverButton && !MJToggleButton.this.isSelected() && MJToggleButton.this.isBorderPainted()) {
                MJToggleButton.this.setBorderPainted(false);
                MJToggleButton.this.invalidate();
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (MJToggleButton.this.fFlyOverAppearance) {
                if (MJToggleButton.this.isSelected()) {
                    if (!MJToggleButton.this.isBorderPainted()) {
                        MJToggleButton.this.setBorderPainted(true);
                        MJToggleButton.this.invalidate();
                    }
                } else if (!this.fIsOverButton && MJToggleButton.this.isBorderPainted()) {
                    MJToggleButton.this.setBorderPainted(false);
                    MJToggleButton.this.invalidate();
                }
            }
        }
    }

    class ActionPropertyHandler
    implements PropertyChangeListener {
        ActionPropertyHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("buttonIcon")) {
                MJToggleButton.this.setIcon((Icon)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName().equals("checked")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                MJToggleButton.this.setSelected(bl);
            } else if (MJToggleButton.this.getParent() instanceof MJToolBar || MJToggleButton.this.fTextHidden) {
                if (propertyChangeEvent.getPropertyName().equals("Name")) {
                    MJToggleButton.this.hideText();
                } else if (propertyChangeEvent.getPropertyName().equals("MnemonicKey")) {
                    MJToggleButton.this.setMnemonic('\u0000');
                }
            }
        }
    }
}

