/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class MouseLatch
implements MouseListener {
    protected MouseListener fWrappedListener;
    protected int fLatchedButton = -1;

    public MouseLatch(MouseListener mouseListener) {
        this.fWrappedListener = mouseListener;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.getButtonCount(mouseEvent) > 1) {
            return;
        }
        this.fLatchedButton = mouseEvent.getButton();
        this.fWrappedListener.mousePressed(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == this.fLatchedButton) {
            this.fWrappedListener.mouseReleased(mouseEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == this.fLatchedButton) {
            this.fWrappedListener.mouseClicked(mouseEvent);
        }
        if (this.getButtonCount(mouseEvent) == 0) {
            this.fLatchedButton = -1;
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.fWrappedListener.mouseEntered(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.fWrappedListener.mouseExited(mouseEvent);
    }

    protected int getButtonCount(MouseEvent mouseEvent) {
        int n = 0;
        int n2 = mouseEvent.getModifiersEx();
        if ((n2 & 0x400) != 0) {
            ++n;
        }
        if ((n2 & 0x800) != 0) {
            ++n;
        }
        if ((n2 & 0x1000) != 0) {
            ++n;
        }
        return n;
    }
}

