/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.SimpleNode;
import com.mathworks.mwswing.SimpleNodeList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SimpleElement
extends SimpleNode {
    private String tagName;
    private String text;
    private HashMap attributes;

    public SimpleElement(String string) {
        this.tagName = string;
        this.attributes = new HashMap();
    }

    public SimpleElement(Element element) {
        this(element.getTagName());
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap.getLength() > 0) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node = namedNodeMap.item(i);
                this.setAttribute(node.getNodeName(), node.getNodeValue());
            }
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                this.addChildElement(new SimpleElement((Element)node));
                continue;
            }
            if (!(node instanceof Text)) continue;
            this.setText(((Text)node).getTextContent());
        }
    }

    void addChildElement(SimpleElement simpleElement) {
        super.addChildNode(simpleElement);
    }

    @Override
    public SimpleNode getFirstChild() {
        SimpleNode simpleNode = super.getFirstChild();
        if (simpleNode != null) {
            return simpleNode;
        }
        if (this.getText() != null) {
            return this;
        }
        return null;
    }

    @Override
    public boolean hasChildNodes() {
        SimpleNode simpleNode = super.getFirstChild();
        if (simpleNode != null) {
            return true;
        }
        return this.getText() != null;
    }

    @Override
    public String getNodeName() {
        return this.getTagName();
    }

    public String getTagName() {
        return this.tagName;
    }

    @Override
    public String getNodeValue() {
        return this.getText();
    }

    public void setTagName(String string) {
        this.tagName = string;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String[] getAttributes() {
        Set set = this.attributes.keySet();
        return set.toArray(new String[set.size()]);
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public String getAttribute(String string) {
        return (String)this.attributes.get(string);
    }

    public boolean hasAttribute(String string) {
        return this.attributes.get(string) != null;
    }

    public void setAttribute(String string, String string2) {
        this.attributes.put(string, string2);
    }

    public SimpleNodeList getChildElements() {
        return this.getChildNodes();
    }

    public SimpleNodeList getElementsByTagName(String string) {
        return this.getElementsByTagName(this.getChildElements(), string);
    }

    public SimpleNodeList getChildrenByTagName(String string) {
        return this.getChildrenByTagName(this.getChildElements(), string);
    }

    SimpleNodeList getElementsByTagName(SimpleNodeList simpleNodeList, String string) {
        SimpleNodeList simpleNodeList2 = new SimpleNodeList();
        if (simpleNodeList != null) {
            for (SimpleElement simpleElement : simpleNodeList) {
                if (simpleElement.getChildElements() != null) {
                    simpleNodeList2.addAll(this.getElementsByTagName(simpleElement.getChildElements(), string));
                }
                if (!simpleElement.getTagName().equals(string)) continue;
                simpleNodeList2.add(simpleElement);
            }
        }
        return simpleNodeList2;
    }

    SimpleNodeList getChildrenByTagName(SimpleNodeList simpleNodeList, String string) {
        SimpleNodeList simpleNodeList2 = new SimpleNodeList();
        if (simpleNodeList != null) {
            for (SimpleElement simpleElement : simpleNodeList) {
                if (!simpleElement.getTagName().equals(string)) continue;
                simpleNodeList2.add(simpleElement);
            }
        }
        return simpleNodeList2;
    }

    public Element convert(Document document) {
        Collection<Object> collection;
        Element element = document.createElement(this.tagName);
        if (this.attributes.size() > 0) {
            collection = this.attributes.entrySet();
            for (Map.Entry object : collection) {
                element.setAttribute((String)object.getKey(), (String)object.getValue());
            }
            element.setNodeValue(this.text);
        }
        collection = this.getChildElements();
        for (int i = 0; i < ((SimpleNodeList)collection).getLength(); ++i) {
            Object e = ((Vector)collection).get(i);
            if (!(e instanceof SimpleElement)) continue;
            Element element2 = ((SimpleElement)e).convert(document);
            element.appendChild(element2);
        }
        return element;
    }
}

