/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.checkboxlist;

import com.mathworks.mwswing.checkboxlist.ListCheckEvent;
import com.mathworks.mwswing.checkboxlist.ListCheckListener;
import com.mathworks.mwswing.checkboxlist.ListCheckModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DefaultListCheckModel
implements ListCheckModel {
    private final List fCheckList;
    private int fCheckOrder;
    private int fCheckCount;
    private int fCheckLimit = Integer.MAX_VALUE;
    private int fOrderThreshold = Integer.MAX_VALUE;
    private int fLimitType = 0;
    private JList fOwner;
    protected EventListenerList fListenerList = new EventListenerList();
    private ListDataListener fDataListener;
    public static final int NO_LIMIT = 0;
    public static final int HARD_LIMIT = 1;
    public static final int SOFT_LIMIT = 2;
    private static final Integer NOT_CHECKED = new Integer(-1);

    public DefaultListCheckModel() {
        this(0);
    }

    public DefaultListCheckModel(int n) {
        this.fCheckList = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.fCheckList.add(NOT_CHECKED);
        }
    }

    protected void setOwner(JList jList) {
        if (this.fDataListener == null) {
            this.fDataListener = new DataModelTracker();
        }
        if (this.fOwner != null) {
            this.fOwner.getModel().removeListDataListener(this.fDataListener);
        }
        this.fOwner = jList;
        if (this.fOwner != null) {
            jList.getModel().addListDataListener(this.fDataListener);
        }
    }

    @Override
    public void checkAll() {
        this.fCheckOrder = 0;
        this.fCheckCount = this.fCheckList.size();
        if (this.fCheckCount > this.fCheckLimit) {
            if (this.fLimitType == 1) {
                this.fCheckCount = this.fCheckLimit;
            } else {
                this.fOrderThreshold = this.fCheckLimit - 1;
            }
        }
        for (int i = 0; i < this.fCheckCount; ++i) {
            this.fCheckList.set(i, new Integer(this.fCheckOrder++));
        }
        this.fireValueChanged(-1);
    }

    @Override
    public void checkIndex(int n) {
        if (this.fLimitType == 1 && this.fCheckCount >= this.fCheckLimit) {
            return;
        }
        boolean bl = this.fCheckList.get(n) != NOT_CHECKED;
        this.fCheckList.set(n, new Integer(this.fCheckOrder++));
        if (!bl) {
            ++this.fCheckCount;
            if (this.fLimitType == 2 && this.fCheckCount - 1 == this.fCheckLimit) {
                this.updateThreshold();
                this.fireValueChanged(-1);
            } else {
                this.fireValueChanged(n);
            }
        }
    }

    @Override
    public void uncheckAll() {
        this.fCheckOrder = 0;
        this.fCheckCount = 0;
        this.fOrderThreshold = Integer.MAX_VALUE;
        int n = this.fCheckList.size();
        for (int i = 0; i < n; ++i) {
            this.fCheckList.set(i, NOT_CHECKED);
        }
        this.fireValueChanged(-1);
    }

    @Override
    public void uncheckIndex(int n) {
        if (this.fCheckList.get(n) == NOT_CHECKED) {
            return;
        }
        --this.fCheckCount;
        int n2 = (Integer)this.fCheckList.get(n);
        this.fCheckList.set(n, NOT_CHECKED);
        if (this.fLimitType == 2 && n2 <= this.fOrderThreshold) {
            this.updateThreshold();
            this.fireValueChanged(-1);
        } else {
            this.fireValueChanged(n);
        }
    }

    @Override
    public int[] getCheckedIndicies() {
        int[] nArray = new int[this.fCheckCount];
        int n = 0;
        for (int i = 0; n < this.fCheckCount && i < this.fCheckList.size(); ++i) {
            if (this.fCheckList.get(i) == NOT_CHECKED) continue;
            nArray[n++] = i;
        }
        return nArray;
    }

    public int[] getIndiciesInCheckedOrder() {
        List list = this.getCheckedDataInOrder();
        int[] nArray = new int[list.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = ((SortableData)list.get((int)i)).iIndex;
        }
        return nArray;
    }

    public int getCheckedCount() {
        return this.fCheckCount;
    }

    @Override
    public boolean isIndexChecked(int n) {
        return this.fCheckList.get(n) != NOT_CHECKED;
    }

    public boolean exceedsLimit(int n) {
        Integer n2 = (Integer)this.fCheckList.get(n);
        return n2 != NOT_CHECKED && this.fLimitType == 2 && this.fCheckLimit < Integer.MAX_VALUE && n2 > this.fOrderThreshold;
    }

    public void setCheckLimit(int n, int n2) {
        this.fCheckLimit = n;
        this.fLimitType = n2;
        if (n2 == 2) {
            this.updateThreshold();
            this.fireValueChanged(-1);
        }
    }

    @Override
    public void addListCheckListener(ListCheckListener listCheckListener) {
        this.fListenerList.add(ListCheckListener.class, listCheckListener);
    }

    @Override
    public void removeListCheckListener(ListCheckListener listCheckListener) {
        this.fListenerList.remove(ListCheckListener.class, listCheckListener);
    }

    public ListCheckListener[] getListCheckListeners() {
        return (ListCheckListener[])this.fListenerList.getListeners(ListCheckListener.class);
    }

    protected void fireValueChanged(int n) {
        Object[] objectArray = this.fListenerList.getListenerList();
        ListCheckEvent listCheckEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ListCheckListener.class) continue;
            if (listCheckEvent == null) {
                listCheckEvent = new ListCheckEvent(this, n);
            }
            ((ListCheckListener)objectArray[i + 1]).valueChanged(listCheckEvent);
        }
    }

    private void updateThreshold() {
        if (this.fCheckCount <= this.fCheckLimit) {
            this.fOrderThreshold = Integer.MAX_VALUE;
        } else {
            List list = this.getCheckedDataInOrder();
            this.fOrderThreshold = ((SortableData)list.get((int)(this.fCheckLimit - 1))).iOrder;
        }
    }

    private List getCheckedDataInOrder() {
        ArrayList<SortableData> arrayList = new ArrayList<SortableData>();
        int n = this.fCheckList.size();
        for (int i = 0; i < n; ++i) {
            Integer n2 = (Integer)this.fCheckList.get(i);
            if (n2 == NOT_CHECKED) continue;
            arrayList.add(new SortableData(i, n2));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private class SortableData
    implements Comparable {
        final int iIndex;
        final int iOrder;

        SortableData(int n, int n2) {
            this.iIndex = n;
            this.iOrder = n2;
        }

        public boolean equals(Object object) {
            return object instanceof SortableData && this.iOrder == ((SortableData)object).iOrder;
        }

        public int compareTo(Object object) {
            if (!(object instanceof SortableData)) {
                return 0;
            }
            return this.iOrder - ((SortableData)object).iOrder;
        }
    }

    class DataModelTracker
    implements ListDataListener {
        DataModelTracker() {
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            for (int i = listDataEvent.getIndex0(); i <= listDataEvent.getIndex1(); ++i) {
                DefaultListCheckModel.this.fCheckList.add(i, NOT_CHECKED);
            }
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            for (int i = listDataEvent.getIndex1(); i >= listDataEvent.getIndex0(); --i) {
                DefaultListCheckModel.this.fCheckList.remove(i);
            }
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            DefaultListCheckModel.this.fCheckList.clear();
            int n = ((ListModel)listDataEvent.getSource()).getSize();
            for (int i = 0; i < n; ++i) {
                DefaultListCheckModel.this.fCheckList.add(NOT_CHECKED);
            }
        }
    }
}

