/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.datatransfer;

import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.datatransfer.MJDataFlavor;
import com.mathworks.mwswing.datatransfer.MJTransferable;
import com.mathworks.util.LanguageUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.datatransfer.Transferable;
import java.awt.font.TextAttribute;
import java.io.ByteArrayInputStream;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RTFStringUtils {
    public static Transferable getTransferable(String string) {
        return new MJTransferable(new ByteArrayInputStream(string.getBytes()), MJDataFlavor.RTF_FLAVOR);
    }

    public static String convertCharsToRTF(List<AttributedCharacterIterator> list) {
        return RTFStringUtils.convertCharsToRTF(list, 0, list.get(list.size() - 1).getEndIndex(), list.size());
    }

    public static String convertCharsToRTF(List<AttributedCharacterIterator> list, int n, int n2, int n3) {
        if (n3 > list.size()) {
            throw new IllegalArgumentException("NumLines (" + n3 + ") is greater than the " + "size of the character iterator list (" + list.size() + ").");
        }
        HashMap<Color, String> hashMap = new HashMap<Color, String>();
        HashMap<Font, String> hashMap2 = new HashMap<Font, String>();
        StringBuffer stringBuffer = new StringBuffer("{\\rtf1\\ansi{\\fonttbl");
        StringBuffer stringBuffer2 = new StringBuffer("}{\\colortbl;");
        StringBuffer stringBuffer3 = new StringBuffer("}");
        Iterator<AttributedCharacterIterator> iterator = list.iterator();
        for (int i = 0; iterator.hasNext() && i < n3; ++i) {
            AttributedCharacterIterator attributedCharacterIterator = iterator.next();
            iterator.remove();
            char c = attributedCharacterIterator.first();
            stringBuffer3.append("\\pard\\plain ");
            int n4 = 0;
            while (c != '\uffff') {
                stringBuffer3.append("{");
                int n5 = attributedCharacterIterator.getIndex();
                int n6 = attributedCharacterIterator.getRunLimit() - n5;
                if (n6 < 1) {
                    n6 = 1;
                }
                Color color = (Color)attributedCharacterIterator.getAttribute(TextAttribute.FOREGROUND);
                Font font = (Font)attributedCharacterIterator.getAttribute(TextAttribute.FONT);
                RTFStringUtils.addColor(hashMap, color, stringBuffer2);
                RTFStringUtils.addFont(hashMap2, font, stringBuffer);
                stringBuffer3.append("\\fs").append(font.getSize() * 2).append(" ");
                if (font.isBold()) {
                    stringBuffer3.append("\\b");
                }
                if (font.isItalic()) {
                    stringBuffer3.append("\\i");
                }
                stringBuffer3.append((String)hashMap2.get(font)).append((String)hashMap.get(color)).append(" ");
                for (int j = 0; j != n6; ++j) {
                    if (i == 0) {
                        if (n4 >= n && (i != n3 - 1 || n4 < n2)) {
                            RTFStringUtils.addChar(stringBuffer3, c);
                        }
                    } else if (i == n3 - 1) {
                        if (n4 < n2) {
                            RTFStringUtils.addChar(stringBuffer3, c);
                        }
                    } else {
                        RTFStringUtils.addChar(stringBuffer3, c);
                    }
                    c = attributedCharacterIterator.next();
                    ++n4;
                }
                stringBuffer3.append("}");
            }
            stringBuffer3.append("\\par ");
        }
        stringBuffer3.append("}");
        return stringBuffer.toString() + stringBuffer2.toString() + stringBuffer3.toString();
    }

    private static void addFont(Map<Font, String> map, Font font, StringBuffer stringBuffer) {
        if (map.containsKey(font)) {
            return;
        }
        String string = LanguageUtils.isJapanese() ? "\\fnil\\fcharset128 " + FontUtils.getOSFontName(font.getName()) : " " + FontUtils.getOSFontName(font.getName());
        String string2 = "\\f" + map.size();
        stringBuffer.append("{").append(string2).append(string).append(";}");
        map.put(font, string2);
    }

    private static void addColor(Map<Color, String> map, Color color, StringBuffer stringBuffer) {
        if (map.containsKey(color)) {
            return;
        }
        String string = "\\cf" + (map.size() + 1);
        stringBuffer.append("\\red").append(color.getRed()).append("\\green").append(color.getGreen()).append("\\blue").append(color.getBlue()).append(";");
        map.put(color, string);
    }

    private static void addChar(StringBuffer stringBuffer, char c) {
        if (c == '{' || c == '}' || c == '\\') {
            stringBuffer.append("\\");
        }
        stringBuffer.append(c);
    }
}

