/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.table;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class ListColorUtils {
    private ListColorUtils() {
    }

    public static void setupForList(JTable jTable) {
        jTable.setShowGrid(false);
        jTable.setIntercellSpacing(new Dimension(0, 0));
        jTable.setFocusTraversalKeys(0, null);
        jTable.setFocusTraversalKeys(1, null);
        jTable.getInputMap().put(KeyStroke.getKeyStroke(36, 0), "home");
        jTable.getInputMap().put(KeyStroke.getKeyStroke(35, 0), "end");
        jTable.getInputMap().put(KeyStroke.getKeyStroke(39, 0), "donothing");
        jTable.getInputMap().put(KeyStroke.getKeyStroke(37, 0), "donothing");
        jTable.getActionMap().put("home", jTable.getActionMap().get("selectFirstRow"));
        jTable.getActionMap().put("end", jTable.getActionMap().get("selectLastRow"));
        jTable.getActionMap().put("donothing", new DoNothingAction());
    }

    public static void installListRenderer(JTable jTable) {
        jTable.setDefaultRenderer(Object.class, new GeneralListCellRenderer());
    }

    public static Color getListAlternatingBackgroundColor(JTable jTable, int n, boolean bl, boolean bl2) {
        return ListColorUtils.getListBackgroundColor(jTable, n, bl, bl2, true);
    }

    public static Color getListBackgroundColor(JTable jTable, int n, boolean bl, boolean bl2) {
        return ListColorUtils.getListBackgroundColor(jTable, n, bl, bl2, false);
    }

    public static Color getListForegroundColor(JTable jTable, boolean bl, boolean bl2) {
        Color color;
        Color color2 = color = bl ? jTable.getSelectionForeground() : jTable.getForeground();
        if (PlatformInfo.isMacintosh() && (SystemColor.textText.equals(color) || UIManager.getColor("Table.foreground").getRGB() == color.getRGB() || bl)) {
            color = bl ? (bl2 ? ColorUtils.getSelectionForegroundColor() : ColorUtils.getUnfocusedSelectionForegroundColor(jTable)) : UIManager.getColor("List.foreground");
        }
        return color;
    }

    private static Color getListBackgroundColor(JTable jTable, int n, boolean bl, boolean bl2, boolean bl3) {
        Color color;
        Color color2 = color = bl ? jTable.getSelectionBackground() : jTable.getBackground();
        if (PlatformInfo.isMacintosh() && (SystemColor.text.equals(color) || UIManager.getColor("Table.background").getRGB() == color.getRGB() || bl)) {
            color = bl ? (bl2 ? ColorUtils.getSelectionBackgroundColor() : ColorUtils.getUnfocusedSelectionBackgroundColor(jTable)) : (bl3 ? (n % 2 == 0 ? UIManager.getColor("com.mathworks.alternatingBackgroundEven") : UIManager.getColor("com.mathworks.alternatingBackgroundOdd")) : UIManager.getColor("List.background"));
        }
        return color;
    }

    private static class DoNothingAction
    extends AbstractAction {
        private DoNothingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private static class GeneralListCellRenderer
    extends MJLabel
    implements TableCellRenderer {
        private GeneralListCellRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
            this.setIcon(null);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setFont(jTable.getFont());
            this.setText((String)object);
            this.setBackground(ListColorUtils.getListAlternatingBackgroundColor(jTable, n, bl, jTable.hasFocus()));
            this.setForeground(ListColorUtils.getListForegroundColor(jTable, bl, jTable.hasFocus()));
            return this;
        }
    }
}

