/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors;

import com.mathworks.beans.editors.EnhancedPropertyEditor;
import java.awt.Frame;
import java.awt.Image;
import java.beans.PropertyEditorSupport;
import javax.swing.ImageIcon;

public class BooleanEditor
extends PropertyEditorSupport
implements EnhancedPropertyEditor {
    private static Image sTrueIcon = null;
    private static Image sFalseIcon = null;
    private static Image sMixedIcon = null;
    private volatile Boolean fValue;

    @Override
    public Object getValue() {
        return this.fValue;
    }

    @Override
    public void setValue(Object object) {
        if (object != null && !(object instanceof Boolean)) {
            if (object instanceof String) {
                throw new IllegalArgumentException((String)object);
            }
            throw new IllegalArgumentException();
        }
        this.fValue = (Boolean)object;
        this.firePropertyChange();
    }

    @Override
    public String getAsText() {
        if (this.fValue != null && this.fValue.booleanValue()) {
            return "On";
        }
        return "Off";
    }

    @Override
    public void setAsText(String string) {
        this.setValue(string.equals("On"));
    }

    @Override
    public String[] getTags() {
        return new String[]{"On", "Off"};
    }

    @Override
    public Image getIcon() {
        Image image = null;
        this.initIcons();
        Object object = this.getValue();
        if (object == null) {
            image = sMixedIcon;
        } else if (object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            image = bl != false ? sTrueIcon : sFalseIcon;
        }
        return image;
    }

    @Override
    public void setFrame(Frame frame) {
    }

    @Override
    public boolean hasAttachedData() {
        return false;
    }

    @Override
    public String getDataKey() {
        return null;
    }

    @Override
    public void setData(Object object) {
    }

    private void initIcons() {
        if (sTrueIcon == null || sFalseIcon == null || sMixedIcon == null) {
            if (sTrueIcon == null) {
                sTrueIcon = new ImageIcon(this.getClass().getResource("resources/LightbulbOnIcon.gif")).getImage();
            }
            if (sFalseIcon == null) {
                sFalseIcon = new ImageIcon(this.getClass().getResource("resources/LightbulbOffIcon.gif")).getImage();
            }
            if (sMixedIcon == null) {
                sMixedIcon = new ImageIcon(this.getClass().getResource("resources/LightbulbMixedIcon.gif")).getImage();
            }
        }
    }
}

