/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors;

import com.mathworks.beans.editors.ColorBar;
import com.mathworks.beans.editors.ColorSwatch;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJSlider;
import com.mathworks.mwswing.MJTextField;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorPicker
extends MJPanel
implements ItemSelectable {
    private static final int RED = 0;
    private static final int GREEN = 1;
    private static final int BLUE = 2;
    private static final int NCOLORS = 3;
    private static final int RED_MASK = 1;
    private static final int GREEN_MASK = 2;
    private static final int BLUE_MASK = 4;
    private static final int ALL_MASK = 7;
    private static final int GAP = 8;
    private ColorBar[] fBars;
    private MJSlider[] fSliders;
    private MJTextField[] fFields;
    private int fMaxValue;
    private int fR;
    private int fG;
    private int fB;
    private ColorSwatch fOriginal;
    private ColorSwatch fSelected;
    private EventHandler fHandler;
    private transient ItemListener fItemListener;
    private static ResourceBundle sRes = null;

    public ColorPicker(int n, int n2, int n3, int n4) {
        MJLabel[] mJLabelArray = new MJLabel[3];
        if (sRes == null) {
            sRes = ResourceBundle.getBundle("com.mathworks.beans.editors.resources.RES_Editors");
        }
        this.fHandler = new EventHandler();
        this.fMaxValue = n4;
        this.fR = n;
        this.fG = n2;
        this.fB = n3;
        this.fOriginal = new ColorSwatch(this.fR, this.fG, this.fB, this.fMaxValue);
        MJPanel mJPanel = this.makeSwatchPanel(this.fOriginal, "Original");
        this.fSelected = new ColorSwatch(this.fR, this.fG, this.fB, this.fMaxValue);
        MJPanel mJPanel2 = this.makeSwatchPanel(this.fSelected, "New");
        this.setLayout(new BorderLayout(8, 8));
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new GridLayout(2, 1, 8, 8));
        mJPanel3.add((Component)mJPanel2);
        mJPanel3.add((Component)mJPanel);
        this.fSliders = new MJSlider[3];
        this.fBars = new ColorBar[3];
        this.fFields = new MJTextField[3];
        this.fSliders[0] = this.makeColorSlider(this.fR);
        this.fBars[0] = new ColorBar(-1, this.valueToNative(this.fG), this.valueToNative(this.fB), 2);
        this.fFields[0] = this.makeColorField(this.valueToPercent(this.fR));
        mJLabelArray[0] = new MJLabel(sRes.getString("label.red"));
        this.fSliders[1] = this.makeColorSlider(this.fG);
        this.fBars[1] = new ColorBar(this.valueToNative(this.fR), -1, this.valueToNative(this.fB), 2);
        this.fFields[1] = this.makeColorField(this.valueToPercent(this.fG));
        mJLabelArray[1] = new MJLabel(sRes.getString("label.green"));
        this.fSliders[2] = this.makeColorSlider(this.fB);
        this.fBars[2] = new ColorBar(this.valueToNative(this.fR), this.valueToNative(this.fG), -1, 2);
        this.fFields[2] = this.makeColorField(this.valueToPercent(this.fB));
        mJLabelArray[2] = new MJLabel(sRes.getString("label.blue"));
        MJPanel mJPanel4 = new MJPanel((LayoutManager)new GridLayout(3, 1, 8, 8));
        for (int i = 0; i < 3; ++i) {
            MJPanel mJPanel5 = new MJPanel((LayoutManager)new BorderLayout());
            mJPanel5.add((Component)this.fSliders[i], (Object)"Center");
            mJPanel5.add((Component)((Object)this.fBars[i]), (Object)"South");
            MJPanel mJPanel6 = new MJPanel((LayoutManager)new FlowLayout(2));
            mJPanel6.add((Component)mJLabelArray[i]);
            mJPanel6.add((Component)mJPanel5);
            mJPanel6.add((Component)this.fFields[i]);
            mJPanel6.add((Component)new MJLabel("%"));
            mJPanel4.add((Component)mJPanel6);
        }
        this.add((Component)mJPanel4, "Center");
        this.add((Component)mJPanel3, "East");
    }

    public ColorPicker(Color color) {
        this(color.getRed(), color.getGreen(), color.getBlue(), 255);
    }

    public ColorPicker() {
        this(0, 0, 0, 100);
    }

    public int getRed() {
        return this.fR;
    }

    public int getGreen() {
        return this.fG;
    }

    public int getBlue() {
        return this.fB;
    }

    public Color getSelectedColor() {
        int n = 255 * this.fR / this.fMaxValue;
        int n2 = 255 * this.fG / this.fMaxValue;
        int n3 = 255 * this.fB / this.fMaxValue;
        return new Color(n, n2, n3);
    }

    public void setSelectedColor(int n, int n2, int n3) {
        this.fR = n;
        this.fG = n2;
        this.fB = n3;
        if (this.fR < 0) {
            this.fR = 0;
        } else if (this.fR > this.fMaxValue) {
            this.fR = this.fMaxValue;
        }
        if (this.fG < 0) {
            this.fG = 0;
        } else if (this.fG > this.fMaxValue) {
            this.fG = this.fMaxValue;
        }
        if (this.fB < 0) {
            this.fB = 0;
        } else if (this.fB > this.fMaxValue) {
            this.fB = this.fMaxValue;
        }
        this.fSelected.setColor(this.fR, this.fG, this.fB, this.fMaxValue);
        this.updateSliders(7);
        this.updateTextFields(7);
        this.updateColorBars(7);
    }

    public void setInitialColor(int n, int n2, int n3) {
        if (n < 0) {
            n = 0;
        } else if (n > this.fMaxValue) {
            n = this.fMaxValue;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > this.fMaxValue) {
            n2 = this.fMaxValue;
        }
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > this.fMaxValue) {
            n3 = this.fMaxValue;
        }
        this.fOriginal.setColor(n, n2, n3, this.fMaxValue);
    }

    @Override
    public Object[] getSelectedObjects() {
        Object[] objectArray = new Object[]{this.getSelectedColor()};
        return objectArray;
    }

    @Override
    public synchronized void addItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.add(this.fItemListener, itemListener);
    }

    @Override
    public synchronized void removeItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.remove(this.fItemListener, itemListener);
    }

    private void updateSliders(int n) {
        if ((n & 1) != 0) {
            this.fSliders[0].setValue(this.fR);
            this.fSliders[0].repaint();
        }
        if ((n & 2) != 0) {
            this.fSliders[1].setValue(this.fG);
            this.fSliders[1].repaint();
        }
        if ((n & 4) != 0) {
            this.fSliders[2].setValue(this.fB);
            this.fSliders[2].repaint();
        }
    }

    private void updateTextFields(int n) {
        if ((n & 1) != 0) {
            this.fFields[0].setText("" + this.valueToPercent(this.fR));
        }
        if ((n & 2) != 0) {
            this.fFields[1].setText("" + this.valueToPercent(this.fG));
        }
        if ((n & 4) != 0) {
            this.fFields[2].setText("" + this.valueToPercent(this.fB));
        }
    }

    private void updateColorBars(int n) {
        if ((n & 1) != 0) {
            this.fBars[0].applyFilter(-1, this.valueToNative(this.fG), this.valueToNative(this.fB));
            this.fBars[0].repaint();
        }
        if ((n & 2) != 0) {
            this.fBars[1].applyFilter(this.valueToNative(this.fR), -1, this.valueToNative(this.fB));
            this.fBars[1].repaint();
        }
        if ((n & 4) != 0) {
            this.fBars[2].applyFilter(this.valueToNative(this.fR), this.valueToNative(this.fG), -1);
            this.fBars[2].repaint();
        }
    }

    private synchronized void fireItemStateChanged() {
        if (this.fItemListener != null) {
            ItemEvent itemEvent = new ItemEvent(this, 701, this.getSelectedColor(), 1);
            this.fItemListener.itemStateChanged(itemEvent);
        }
    }

    private MJPanel makeSwatchPanel(ColorSwatch colorSwatch, String string) {
        MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout(1));
        mJPanel.add((Component)new MJLabel(string));
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel2.add((Component)((Object)colorSwatch), (Object)"Center");
        mJPanel2.add((Component)mJPanel, (Object)"South");
        return mJPanel2;
    }

    private MJTextField makeColorField(int n) {
        MJTextField mJTextField = new MJTextField("" + n, 3);
        mJTextField.addActionListener((ActionListener)this.fHandler);
        mJTextField.addFocusListener((FocusListener)this.fHandler);
        return mJTextField;
    }

    private MJSlider makeColorSlider(int n) {
        MJSlider mJSlider = new MJSlider(0, 0, this.fMaxValue, n);
        mJSlider.addChangeListener((ChangeListener)this.fHandler);
        return mJSlider;
    }

    private int valueToPercent(int n) {
        return Math.round(100.0f * (float)n / (float)this.fMaxValue);
    }

    private int valueToNative(int n) {
        return Math.round(255.0f * (float)n / (float)this.fMaxValue);
    }

    private int percentToValue(int n) {
        return Math.round((float)this.fMaxValue * ((float)n / 100.0f));
    }

    private int getValFromString(String string, int n) {
        int n2;
        try {
            n2 = this.percentToValue(Integer.parseInt(string));
        }
        catch (Exception exception) {
            n2 = n;
        }
        return n2;
    }

    private void updateViaField(Object object) {
        String string = this.fFields[0].getText();
        String string2 = this.fFields[1].getText();
        String string3 = this.fFields[2].getText();
        int n = 7;
        if (object == this.fFields[0]) {
            if (string.equals("")) {
                this.fR = 0;
            } else {
                this.fR = this.getValFromString(string, this.fR);
                if (this.fR < 0) {
                    this.fR = 0;
                } else if (this.fR > this.fMaxValue) {
                    this.fR = this.fMaxValue;
                }
            }
            n = 1;
        } else if (object == this.fFields[1]) {
            if (string2.equals("")) {
                this.fG = 0;
            } else {
                this.fG = this.getValFromString(string2, this.fG);
                if (this.fG < 0) {
                    this.fG = 0;
                } else if (this.fG > this.fMaxValue) {
                    this.fG = this.fMaxValue;
                }
            }
            n = 2;
        } else if (object == this.fFields[2]) {
            if (string3.equals("")) {
                this.fB = 0;
            } else {
                this.fB = this.getValFromString(string3, this.fB);
                if (this.fB < 0) {
                    this.fB = 0;
                } else if (this.fB > this.fMaxValue) {
                    this.fB = this.fMaxValue;
                }
            }
            n = 4;
        }
        this.fSelected.setColor(this.fR, this.fG, this.fB, this.fMaxValue);
        this.fSelected.repaint();
        this.updateTextFields(n);
        this.updateSliders(n);
        this.updateColorBars(~n);
        this.fireItemStateChanged();
    }

    private class EventHandler
    extends FocusAdapter
    implements ActionListener,
    ChangeListener {
        private EventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColorPicker.this.updateViaField(actionEvent.getSource());
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            ColorPicker.this.updateViaField(focusEvent.getSource());
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            int n = 7;
            if (object == ColorPicker.this.fSliders[0]) {
                ColorPicker.this.fR = ColorPicker.this.fSliders[0].getValue();
                n = 1;
            } else if (object == ColorPicker.this.fSliders[1]) {
                ColorPicker.this.fG = ColorPicker.this.fSliders[1].getValue();
                n = 2;
            } else if (object == ColorPicker.this.fSliders[2]) {
                ColorPicker.this.fB = ColorPicker.this.fSliders[2].getValue();
                n = 4;
            }
            ColorPicker.this.fSelected.setColor(ColorPicker.this.fR, ColorPicker.this.fG, ColorPicker.this.fB, ColorPicker.this.fMaxValue);
            ColorPicker.this.fSelected.repaint();
            ColorPicker.this.updateTextFields(n);
            ColorPicker.this.updateColorBars(~n);
            ColorPicker.this.fireItemStateChanged();
        }
    }
}

