/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import net.sf.saxon.Configuration;
import net.sf.saxon.javax.xml.xquery.XQException;
import net.sf.saxon.javax.xml.xquery.XQExpression;
import net.sf.saxon.javax.xml.xquery.XQResultSequence;
import net.sf.saxon.javax.xml.xquery.XQStaticContext;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.xqj.SaxonXQConnection;
import net.sf.saxon.xqj.SaxonXQDataFactory;
import net.sf.saxon.xqj.SaxonXQDynamicContext;
import net.sf.saxon.xqj.SaxonXQPreparedExpression;
import net.sf.saxon.xqj.SaxonXQStaticContext;

public class SaxonXQExpression
extends SaxonXQDynamicContext
implements XQExpression {
    SaxonXQConnection connection;
    StaticQueryContext sqc;
    DynamicQueryContext context;
    Configuration config;
    boolean closed;

    SaxonXQExpression(SaxonXQConnection connection) {
        this.connection = connection;
        this.config = connection.getConfiguration();
        this.context = new DynamicQueryContext(this.config);
        this.sqc = new StaticQueryContext(this.config);
    }

    SaxonXQExpression(SaxonXQConnection connection, SaxonXQStaticContext staticContext) {
        this.connection = connection;
        this.config = connection.getConfiguration();
        this.context = new DynamicQueryContext(this.config);
        this.sqc = staticContext.getSaxonStaticQueryContext();
    }

    protected DynamicQueryContext getDynamicContext() {
        return this.context;
    }

    protected SaxonXQDataFactory getDataFactory() throws XQException {
        return this.connection;
    }

    protected void checkNotClosed() throws XQException {
        if (this.connection.isClosed()) {
            this.close();
        }
        if (this.isClosed()) {
            throw new XQException("Expression has been closed");
        }
    }

    public void cancel() throws XQException {
        this.checkNotClosed();
    }

    public void close() {
        this.closed = true;
    }

    public void executeCommand(Reader command) throws XQException {
        this.checkNotClosed();
        throw new XQException("Saxon does not recognize any non-XQuery commands");
    }

    public void executeCommand(String command) throws XQException {
        this.checkNotClosed();
        throw new XQException("Saxon does not recognize any non-XQuery commands");
    }

    public XQResultSequence executeQuery(InputStream query) throws XQException {
        this.checkNotClosed();
        try {
            XQueryExpression exp = this.sqc.compileQuery(query, null);
            SaxonXQPreparedExpression pe = new SaxonXQPreparedExpression(this.connection, exp, this.context);
            return pe.executeQuery();
        }
        catch (XPathException e) {
            XQException xqe = new XQException(e.getMessage());
            xqe.initCause(e);
            throw xqe;
        }
        catch (IOException e) {
            XQException xqe = new XQException(e.getMessage());
            xqe.initCause(e);
            throw xqe;
        }
    }

    public XQResultSequence executeQuery(Reader query) throws XQException {
        this.checkNotClosed();
        try {
            XQueryExpression exp = this.sqc.compileQuery(query);
            SaxonXQPreparedExpression pe = new SaxonXQPreparedExpression(this.connection, exp, this.context);
            return pe.executeQuery();
        }
        catch (XPathException e) {
            XQException xqe = new XQException(e.getMessage());
            xqe.initCause(e);
            throw xqe;
        }
        catch (IOException e) {
            XQException xqe = new XQException(e.getMessage());
            xqe.initCause(e);
            throw xqe;
        }
    }

    public XQResultSequence executeQuery(String query) throws XQException {
        this.checkNotClosed();
        try {
            XQueryExpression exp = this.sqc.compileQuery(query);
            SaxonXQPreparedExpression pe = new SaxonXQPreparedExpression(this.connection, exp, this.context);
            return pe.executeQuery();
        }
        catch (XPathException e) {
            XQException xqe = new XQException(e.getMessage());
            xqe.initCause(e);
            throw xqe;
        }
    }

    public XQStaticContext getStaticContext() throws XQException {
        return this.connection.getStaticContext();
    }

    public boolean isClosed() {
        if (this.connection.isClosed()) {
            this.closed = true;
        }
        return this.closed;
    }
}

