/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services.settings;

import com.mathworks.services.settings.Setting;
import com.mathworks.services.settings.SettingConverter;
import com.mathworks.services.settings.SettingException;
import com.mathworks.services.settings.SettingLevel;
import com.mathworks.services.settings.SettingNotFoundException;
import com.mathworks.services.settings.SettingPath;
import com.mathworks.services.settings.SettingTypeException;
import com.mathworks.services.settings.SettingValidationException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public abstract class SettingKeyConverter<T, K>
extends SettingConverter<T> {
    private static final ResourceBundle RESOURCE = ResourceBundle.getBundle("com.mathworks.services.settings.resources.RES_Settings");

    @Override
    public T get(SettingPath settingPath, String string, SettingLevel settingLevel) throws SettingTypeException, SettingNotFoundException {
        Object t;
        Setting setting = new Setting(settingPath, string);
        try {
            t = setting.get(settingLevel);
        }
        catch (ClassCastException classCastException) {
            throw new SettingTypeException(setting, this.getType(), new Setting(settingPath, string).get().getClass(), this.getKeyValueType());
        }
        try {
            return this.createObject(t);
        }
        catch (SettingTypeException settingTypeException) {
            assert (t.getClass().isArray());
            Object[] objectArray = (Object[])t;
            String string2 = settingTypeException.getMessage() != null ? MessageFormat.format(RESOURCE.getString("SettingWrongSizeArrayError"), settingTypeException.getMessage(), objectArray.length) : MessageFormat.format(RESOURCE.getString("SettingWrongUnknownSizeArrayError"), objectArray.length);
            throw new SettingTypeException(setting, this.getType(), string2);
        }
        catch (SettingValidationException settingValidationException) {
            throw new SettingTypeException(setting, this.getType(), settingValidationException.getMessage());
        }
        catch (ClassCastException classCastException) {
            throw new SettingTypeException(setting, this.getType(), new Setting(settingPath, string).get().getClass(), this.getKeyValueType());
        }
    }

    @Override
    protected void set(long l, SettingPath settingPath, String string, T t, SettingLevel settingLevel) throws SettingException {
        Setting<K> setting = new Setting<K>(settingPath, string);
        setting.set(l, this.createKeyValue(t), settingLevel);
    }

    @Override
    protected void create(SettingPath settingPath, String string, T t, SettingLevel settingLevel, Method method) throws SettingException {
        settingPath.addSetting(string, this.createKeyValue(t), settingLevel, (Class)null, method);
    }

    protected abstract T createObject(K var1) throws SettingTypeException, SettingValidationException;

    protected abstract K createKeyValue(T var1);

    private Class<?> getKeyValueType() {
        Method[] methodArray = this.getClass().getDeclaredMethods();
        Class<?> clazz = null;
        for (Method method : methodArray) {
            Class<?> clazz2;
            Class<?>[] classArray;
            if (!method.getName().equals("createObject") || method.isBridge() || (classArray = method.getParameterTypes()).length != 1 || (clazz2 = classArray[0]).equals(Object.class)) continue;
            if (clazz == null) {
                clazz = clazz2;
                continue;
            }
            return null;
        }
        return clazz;
    }
}

