/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTException;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.JobAttributes;
import java.awt.KeyboardFocusManager;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.PageAttributes;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.Robot;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.SystemTray;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.event.MouseEvent;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethodDescriptor;
import java.awt.image.ColorModel;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.ComponentPeer;
import java.awt.peer.DesktopPeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.KeyboardFocusManagerPeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.MouseInfoPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.RobotPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.SystemTrayPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.TrayIconPeer;
import java.awt.peer.WindowPeer;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.awt.UNIXToolkit;
import sun.awt.X11.AwtGraphicsConfigData;
import sun.awt.X11.AwtScreenData;
import sun.awt.X11.ComponentAccessor;
import sun.awt.X11.MotifColorUtilities;
import sun.awt.X11.Native;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAWTLookAndFeel;
import sun.awt.X11.XAWTXSettings;
import sun.awt.X11.XAnyEvent;
import sun.awt.X11.XAtom;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XButtonPeer;
import sun.awt.X11.XCanvasPeer;
import sun.awt.X11.XCheckboxMenuItemPeer;
import sun.awt.X11.XCheckboxPeer;
import sun.awt.X11.XChoicePeer;
import sun.awt.X11.XClipboard;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XConstants;
import sun.awt.X11.XCrossingEvent;
import sun.awt.X11.XCustomCursor;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XDesktopPeer;
import sun.awt.X11.XDialogPeer;
import sun.awt.X11.XDragSourceContextPeer;
import sun.awt.X11.XDropTargetEventProcessor;
import sun.awt.X11.XEmbedCanvasPeer;
import sun.awt.X11.XEmbedChildProxy;
import sun.awt.X11.XEmbedChildProxyPeer;
import sun.awt.X11.XEmbeddedFrame;
import sun.awt.X11.XEmbeddedFramePeer;
import sun.awt.X11.XErrorEvent;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XFileDialogPeer;
import sun.awt.X11.XFontPeer;
import sun.awt.X11.XFramePeer;
import sun.awt.X11.XInputMethod;
import sun.awt.X11.XInputMethodDescriptor;
import sun.awt.X11.XKeyboardFocusManagerPeer;
import sun.awt.X11.XLabelPeer;
import sun.awt.X11.XLayerProtocol;
import sun.awt.X11.XListPeer;
import sun.awt.X11.XMenuBarPeer;
import sun.awt.X11.XMenuItemPeer;
import sun.awt.X11.XMenuPeer;
import sun.awt.X11.XModifierKeymap;
import sun.awt.X11.XMotionEvent;
import sun.awt.X11.XMouseDragGestureRecognizer;
import sun.awt.X11.XMouseInfoPeer;
import sun.awt.X11.XNETProtocol;
import sun.awt.X11.XPanelPeer;
import sun.awt.X11.XPopupMenuPeer;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XQueryTree;
import sun.awt.X11.XRobotPeer;
import sun.awt.X11.XRootWindow;
import sun.awt.X11.XScrollPanePeer;
import sun.awt.X11.XScrollbarPeer;
import sun.awt.X11.XSelectionEvent;
import sun.awt.X11.XSystemTrayPeer;
import sun.awt.X11.XTextAreaPeer;
import sun.awt.X11.XTextFieldPeer;
import sun.awt.X11.XTrayIconPeer;
import sun.awt.X11.XWM;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibUtil;
import sun.awt.X11.XlibWrapper;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11GraphicsDevice;
import sun.awt.X11GraphicsEnvironment;
import sun.awt.XSettings;
import sun.font.FontManager;
import sun.java2d.x11.X11SurfaceData;
import sun.misc.PerformanceLogger;
import sun.print.PrintJob2D;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XToolkit
extends UNIXToolkit
implements Runnable,
XConstants {
    private static Logger log = Logger.getLogger("sun.awt.X11.XToolkit");
    private static Logger eventLog = Logger.getLogger("sun.awt.X11.event.XToolkit");
    private static final Logger timeoutTaskLog = Logger.getLogger("sun.awt.X11.timeoutTask.XToolkit");
    private static Logger keyEventLog = Logger.getLogger("sun.awt.X11.kye.XToolkit");
    private static final Logger backingStoreLog = Logger.getLogger("sun.awt.X11.backingStore.XToolkit");
    static final boolean PRIMARY_LOOP = false;
    static final boolean SECONDARY_LOOP = true;
    private static String awtAppClassName = null;
    XClipboard clipboard;
    XClipboard selection;
    protected static boolean dynamicLayoutSetting = false;
    private boolean loadedXSettings;
    private XSettings xs;
    static int arrowCursor;
    static TreeMap winMap;
    static HashMap specialPeerMap;
    static HashMap winToDispatcher;
    static long display;
    static UIDefaults uidefaults;
    static X11GraphicsEnvironment localEnv;
    static X11GraphicsDevice device;
    static final X11GraphicsConfig config;
    static int awt_multiclick_time;
    static boolean securityWarningEnabled;
    private static int screenWidth;
    private static int screenHeight;
    static long awt_defaultFg;
    private static XMouseInfoPeer xPeer;
    private static Method m_removeSourceEvents;
    static XErrorEvent saved_error;
    static long saved_error_handler;
    static XErrorHandler curErrorHandler;
    static XErrorHandler IgnoreBadWindowHandler;
    static Thread toolkitThread;
    static Object displayLock;
    static final String DATA_TRANSFERER_CLASS_NAME = "sun.awt.X11.XDataTransferer";
    private Point lastCursorPos;
    private Collection<XEventListener> listeners = new LinkedList<XEventListener>();
    static ColorModel screenmodel;
    private static boolean initialized;
    private static boolean timeStampUpdated;
    private static long timeStamp;
    private static final XEventDispatcher timeFetcher;
    private static XAtom _XA_JAVA_TIME_PROPERTY_ATOM;
    private static final String prefix = "DnD.Cursor.";
    private static final String postfix = ".32x32";
    private static final String dndPrefix = "DnD.";
    static int altMask;
    static int metaMask;
    static int numLockMask;
    static int modeSwitchMask;
    static int modLockIsShiftLock;
    private static SortedMap timeoutTasks;
    static long reset_time_utc;
    static final long WRAP_TIME_MILLIS = Integer.MAX_VALUE;
    private static int backingStoreType;
    static boolean awt_ServerInquired;
    static boolean awt_IsXsunServer;
    static boolean awt_XKBInquired;
    static boolean awt_UseXKB;
    private static long eventNumber;
    private static XEventDispatcher oops_waiter;
    private static boolean oops_updated;
    private static boolean oops_failed;
    private XAtom oops;
    private static final long WORKAROUND_SLEEP = 100L;

    static void WITH_XERROR_HANDLER(XErrorHandler xErrorHandler) {
        saved_error = null;
        curErrorHandler = xErrorHandler;
        XToolkit.XSync();
        saved_error_handler = XlibWrapper.SetToolkitErrorHandler();
    }

    static void XERROR_SAVE(XErrorEvent xErrorEvent) {
        saved_error = xErrorEvent;
    }

    static void RESTORE_XERROR_HANDLER() {
        XToolkit.XSync();
        XlibWrapper.XSetErrorHandler(saved_error_handler);
        curErrorHandler = null;
    }

    static int SAVED_ERROR_HANDLER(long l, XErrorEvent xErrorEvent) {
        return XlibWrapper.CallErrorHandler(saved_error_handler, l, xErrorEvent.pData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int GlobalErrorHandler(long l, long l2) {
        XErrorEvent xErrorEvent;
        block3: {
            xErrorEvent = new XErrorEvent(l2);
            if (curErrorHandler == null) break block3;
            int n = curErrorHandler.handleError(l, xErrorEvent);
            return n;
        }
        int n = XToolkit.SAVED_ERROR_HANDLER(l, xErrorEvent);
        return n;
    }

    private static native void initIDs();

    static native void waitForEvents(long var0);

    static boolean isToolkitThread() {
        return Thread.currentThread() == toolkitThread;
    }

    static void initSecurityWarning() {
        String string = XToolkit.getSystemProperty("java.runtime.version");
        securityWarningEnabled = string != null && string.contains("internal");
    }

    static boolean isSecurityWarningEnabled() {
        return securityWarningEnabled;
    }

    static native void awt_output_flush();

    static final void awtFUnlock() {
        XToolkit.awtUnlock();
        XToolkit.awt_output_flush();
    }

    public native void nativeLoadSystemColors(int[] var1);

    static UIDefaults getUIDefaults() {
        if (uidefaults == null) {
            XToolkit.initUIDefaults();
        }
        return uidefaults;
    }

    @Override
    public void loadSystemColors(int[] nArray) {
        this.nativeLoadSystemColors(nArray);
        MotifColorUtilities.loadSystemColors(nArray);
    }

    static void initUIDefaults() {
        try {
            SystemColor systemColor = SystemColor.text;
            XAWTLookAndFeel xAWTLookAndFeel = new XAWTLookAndFeel();
            uidefaults = ((LookAndFeel)xAWTLookAndFeel).getDefaults();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static long getDisplay() {
        return display;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getDefaultRootWindow() {
        XToolkit.awtLock();
        try {
            long l = XlibWrapper.RootWindow(XToolkit.getDisplay(), XlibWrapper.DefaultScreen(XToolkit.getDisplay()));
            if (l == 0L) {
                throw new IllegalStateException("Root window must not be null");
            }
            long l2 = l;
            return l2;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        XToolkit.awtLock();
        try {
            XlibWrapper.XSupportsLocale();
            if (XlibWrapper.XSetLocaleModifiers("") == null) {
                log.finer("X locale modifiers are not supported, using default");
            }
            AwtScreenData awtScreenData = new AwtScreenData(XToolkit.getDefaultScreenData());
            awt_defaultFg = awtScreenData.get_blackpixel();
            arrowCursor = XlibWrapper.XCreateFontCursor(XToolkit.getDisplay(), 2);
        }
        finally {
            XToolkit.awtUnlock();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                XSystemTrayPeer xSystemTrayPeer = XSystemTrayPeer.getPeerInstance();
                if (xSystemTrayPeer != null) {
                    xSystemTrayPeer.dispose();
                }
                if (log.isLoggable(Level.FINE)) {
                    XToolkit.dumpPeers();
                }
            }
        });
    }

    static String getCorrectXIDString(String string) {
        if (string != null) {
            return string.replace('.', '-');
        }
        return string;
    }

    static native String getEnv(String var0);

    static String getAWTAppClassName() {
        return awtAppClassName;
    }

    public XToolkit() {
        if (PerformanceLogger.loggingEnabled()) {
            PerformanceLogger.setTime("XToolkit construction");
        }
        if (!GraphicsEnvironment.isHeadless()) {
            String string = null;
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            int n = stackTraceElementArray.length - 1;
            if (n >= 0) {
                string = stackTraceElementArray[n].getClassName();
            }
            if (string == null || string.equals("")) {
                string = "AWT";
            }
            awtAppClassName = XToolkit.getCorrectXIDString(string);
            this.init();
            XWM.init();
            SunToolkit.setDataTransfererClassName(DATA_TRANSFERER_CLASS_NAME);
            toolkitThread = new Thread(this, "AWT-XAWT");
            toolkitThread.setPriority(6);
            toolkitThread.setDaemon(true);
            ThreadGroup threadGroup = (ThreadGroup)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                    ThreadGroup threadGroup2 = threadGroup.getParent();
                    while (threadGroup2 != null) {
                        threadGroup = threadGroup2;
                        threadGroup2 = threadGroup.getParent();
                    }
                    return threadGroup;
                }
            });
            toolkitThread.start();
        }
    }

    @Override
    public ButtonPeer createButton(Button button) {
        XButtonPeer xButtonPeer = new XButtonPeer(button);
        XToolkit.targetCreatedPeer(button, xButtonPeer);
        return xButtonPeer;
    }

    @Override
    public FramePeer createFrame(Frame frame) {
        XFramePeer xFramePeer = new XFramePeer(frame);
        XToolkit.targetCreatedPeer(frame, xFramePeer);
        return xFramePeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addToWinMap(long l, XBaseWindow xBaseWindow) {
        TreeMap treeMap = winMap;
        synchronized (treeMap) {
            winMap.put(l, xBaseWindow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeFromWinMap(long l, XBaseWindow xBaseWindow) {
        TreeMap treeMap = winMap;
        synchronized (treeMap) {
            winMap.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static XBaseWindow windowToXWindow(long l) {
        TreeMap treeMap = winMap;
        synchronized (treeMap) {
            return (XBaseWindow)winMap.get(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addEventDispatcher(long l, XEventDispatcher xEventDispatcher) {
        HashMap hashMap = winToDispatcher;
        synchronized (hashMap) {
            Long l2 = l;
            Vector<XEventDispatcher> vector = (Vector<XEventDispatcher>)winToDispatcher.get(l2);
            if (vector == null) {
                vector = new Vector<XEventDispatcher>();
                winToDispatcher.put(l2, vector);
            }
            vector.add(xEventDispatcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeEventDispatcher(long l, XEventDispatcher xEventDispatcher) {
        HashMap hashMap = winToDispatcher;
        synchronized (hashMap) {
            Long l2 = l;
            Collection collection = (Collection)winToDispatcher.get(l2);
            if (collection != null) {
                collection.remove(xEventDispatcher);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getLastCursorPos(Point point) {
        XToolkit.awtLock();
        try {
            if (this.lastCursorPos == null) {
                boolean bl = false;
                return bl;
            }
            point.setLocation(this.lastCursorPos);
            boolean bl = true;
            return bl;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processGlobalMotionEvent(XEvent xEvent) {
        if (xEvent.get_type() == 6) {
            XMotionEvent xMotionEvent = xEvent.get_xmotion();
            XToolkit.awtLock();
            try {
                if (this.lastCursorPos == null) {
                    this.lastCursorPos = new Point(xMotionEvent.get_x_root(), xMotionEvent.get_y_root());
                }
                this.lastCursorPos.setLocation(xMotionEvent.get_x_root(), xMotionEvent.get_y_root());
            }
            finally {
                XToolkit.awtUnlock();
            }
        } else {
            if (xEvent.get_type() == 8) {
                XToolkit.awtLock();
                try {
                    this.lastCursorPos = null;
                }
                finally {
                    XToolkit.awtUnlock();
                }
            }
            if (xEvent.get_type() == 7) {
                XCrossingEvent xCrossingEvent = xEvent.get_xcrossing();
                XToolkit.awtLock();
                try {
                    if (this.lastCursorPos == null) {
                        this.lastCursorPos = new Point(xCrossingEvent.get_x_root(), xCrossingEvent.get_y_root());
                    } else {
                        this.lastCursorPos.setLocation(xCrossingEvent.get_x_root(), xCrossingEvent.get_y_root());
                    }
                }
                finally {
                    XToolkit.awtUnlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addXEventListener(XEventListener xEventListener) {
        Collection<XEventListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(xEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(XEvent xEvent) {
        Collection<XEventListener> collection = this.listeners;
        synchronized (collection) {
            if (this.listeners.size() == 0) {
                return;
            }
            XEvent xEvent2 = xEvent.clone();
            try {
                for (XEventListener xEventListener : this.listeners) {
                    xEventListener.eventProcessed(xEvent2);
                }
            }
            finally {
                xEvent2.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchEvent(XEvent xEvent) {
        XAnyEvent xAnyEvent = xEvent.get_xany();
        if (XToolkit.windowToXWindow(xAnyEvent.get_window()) != null && (xEvent.get_type() == 6 || xEvent.get_type() == 7 || xEvent.get_type() == 8)) {
            this.processGlobalMotionEvent(xEvent);
        }
        XBaseWindow.dispatchToWindow(xEvent);
        Vector vector = null;
        HashMap hashMap = winToDispatcher;
        synchronized (hashMap) {
            Object object = xAnyEvent.get_window();
            vector = (Vector)winToDispatcher.get(object);
            if (vector != null) {
                vector = new Vector(vector);
            }
        }
        if (vector != null) {
            for (Object object : vector) {
                object.dispatchEvent(xEvent);
            }
        }
        this.notifyListeners(xEvent);
    }

    static void processException(Throwable throwable) {
        if (log.isLoggable(Level.WARNING)) {
            log.log(Level.WARNING, "Exception on Toolkit thread", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static XFramePeer getParentFramePeer(Component component) {
        if (component == null) {
            return null;
        }
        ComponentPeer componentPeer = component.getPeer();
        Object object = component.getTreeLock();
        synchronized (object) {
            while (component != null && !(componentPeer instanceof XFramePeer)) {
                component = component.getParent();
                componentPeer = component.getPeer();
            }
        }
        if (componentPeer != null && componentPeer instanceof XFramePeer) {
            return (XFramePeer)componentPeer;
        }
        return null;
    }

    static native void awt_toolkit_init();

    @Override
    public void run() {
        XToolkit.awt_toolkit_init();
        this.run(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(boolean bl) {
        XEvent xEvent = new XEvent();
        while (true) {
            XToolkit.awtLock();
            try {
                XWindow xWindow;
                Component component;
                if (bl) {
                    if (!XlibWrapper.XNextSecondaryLoopEvent(XToolkit.getDisplay(), xEvent.pData)) {
                        break;
                    }
                } else {
                    XToolkit.callTimeoutTasks();
                    while (XlibWrapper.XEventsQueued(XToolkit.getDisplay(), 1) == 0 && XlibWrapper.XEventsQueued(XToolkit.getDisplay(), 2) == 0) {
                        XToolkit.callTimeoutTasks();
                        XToolkit.waitForEvents(this.getNextTaskTime());
                    }
                    XlibWrapper.XNextEvent(XToolkit.getDisplay(), xEvent.pData);
                }
                if (xEvent.get_type() != 14) {
                    ++eventNumber;
                }
                if (XDropTargetEventProcessor.processEvent(xEvent) || XDragSourceContextPeer.processEvent(xEvent)) continue;
                if (eventLog.isLoggable(Level.FINER)) {
                    eventLog.log(Level.FINER, "{0}", String.valueOf(xEvent));
                }
                long l = 0L;
                if (XToolkit.windowToXWindow(xEvent.get_xany().get_window()) != null && (component = XKeyboardFocusManagerPeer.getCurrentNativeFocusOwner()) != null && (xWindow = (XWindow)((Object)ComponentAccessor.getPeer(component))) != null) {
                    l = xWindow.getContentWindow();
                }
                if (keyEventLog.isLoggable(Level.FINE) && (xEvent.get_type() == 2 || xEvent.get_type() == 3)) {
                    keyEventLog.fine("before XFilterEvent:" + xEvent);
                }
                if (XlibWrapper.XFilterEvent(xEvent.getPData(), l)) continue;
                if (keyEventLog.isLoggable(Level.FINE) && (xEvent.get_type() == 2 || xEvent.get_type() == 3)) {
                    keyEventLog.fine("after XFilterEvent:" + xEvent);
                }
                this.dispatchEvent(xEvent);
                continue;
            }
            catch (ThreadDeath threadDeath) {
                XBaseWindow.ungrabInput();
                return;
            }
            catch (Throwable throwable) {
                XBaseWindow.ungrabInput();
                XToolkit.processException(throwable);
                continue;
            }
            finally {
                XToolkit.awtUnlock();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getDefaultScreenWidth() {
        if (screenWidth == -1) {
            long l = XToolkit.getDisplay();
            XToolkit.awtLock();
            try {
                screenWidth = (int)XlibWrapper.DisplayWidth(l, XlibWrapper.DefaultScreen(l));
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        return screenWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getDefaultScreenHeight() {
        if (screenHeight == -1) {
            long l = XToolkit.getDisplay();
            XToolkit.awtLock();
            try {
                screenHeight = (int)XlibWrapper.DisplayHeight(l, XlibWrapper.DefaultScreen(l));
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        return screenHeight;
    }

    @Override
    protected int getScreenWidth() {
        return XToolkit.getDefaultScreenWidth();
    }

    @Override
    protected int getScreenHeight() {
        return XToolkit.getDefaultScreenHeight();
    }

    protected static final Object targetToPeer(Object object) {
        Object var1_1 = null;
        if (object != null && !GraphicsEnvironment.isHeadless()) {
            var1_1 = specialPeerMap.get(object);
        }
        if (var1_1 != null) {
            return var1_1;
        }
        return SunToolkit.targetToPeer(object);
    }

    protected static final void targetDisposedPeer(Object object, Object object2) {
        SunToolkit.targetDisposedPeer(object, object2);
    }

    @Override
    public RobotPeer createRobot(Robot robot, GraphicsDevice graphicsDevice) {
        return new XRobotPeer(graphicsDevice.getDefaultConfiguration());
    }

    @Override
    public void setDynamicLayout(boolean bl) {
        dynamicLayoutSetting = bl;
    }

    @Override
    protected boolean isDynamicLayoutSet() {
        return dynamicLayoutSetting;
    }

    protected boolean isDynamicLayoutSupported() {
        return XWM.getWM().supportsDynamicLayout();
    }

    @Override
    public boolean isDynamicLayoutActive() {
        return this.isDynamicLayoutSupported();
    }

    @Override
    public FontPeer getFontPeer(String string, int n) {
        return new XFontPeer(string, n);
    }

    @Override
    public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dragGestureEvent) throws InvalidDnDOperationException {
        return XDragSourceContextPeer.createDragSourceContextPeer(dragGestureEvent);
    }

    @Override
    public <T extends DragGestureRecognizer> T createDragGestureRecognizer(Class<T> clazz, DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener) {
        if (MouseDragGestureRecognizer.class.equals(clazz)) {
            return (T)new XMouseDragGestureRecognizer(dragSource, component, n, dragGestureListener);
        }
        return null;
    }

    @Override
    public CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem checkboxMenuItem) {
        XCheckboxMenuItemPeer xCheckboxMenuItemPeer = new XCheckboxMenuItemPeer(checkboxMenuItem);
        return xCheckboxMenuItemPeer;
    }

    @Override
    public MenuItemPeer createMenuItem(MenuItem menuItem) {
        XMenuItemPeer xMenuItemPeer = new XMenuItemPeer(menuItem);
        return xMenuItemPeer;
    }

    @Override
    public TextFieldPeer createTextField(TextField textField) {
        XTextFieldPeer xTextFieldPeer = new XTextFieldPeer(textField);
        XToolkit.targetCreatedPeer(textField, xTextFieldPeer);
        return xTextFieldPeer;
    }

    @Override
    public LabelPeer createLabel(Label label) {
        XLabelPeer xLabelPeer = new XLabelPeer(label);
        XToolkit.targetCreatedPeer(label, xLabelPeer);
        return xLabelPeer;
    }

    @Override
    public ListPeer createList(List list) {
        XListPeer xListPeer = new XListPeer(list);
        XToolkit.targetCreatedPeer(list, xListPeer);
        return xListPeer;
    }

    @Override
    public CheckboxPeer createCheckbox(Checkbox checkbox) {
        XCheckboxPeer xCheckboxPeer = new XCheckboxPeer(checkbox);
        XToolkit.targetCreatedPeer(checkbox, xCheckboxPeer);
        return xCheckboxPeer;
    }

    @Override
    public ScrollbarPeer createScrollbar(Scrollbar scrollbar) {
        XScrollbarPeer xScrollbarPeer = new XScrollbarPeer(scrollbar);
        XToolkit.targetCreatedPeer(scrollbar, xScrollbarPeer);
        return xScrollbarPeer;
    }

    @Override
    public ScrollPanePeer createScrollPane(ScrollPane scrollPane) {
        XScrollPanePeer xScrollPanePeer = new XScrollPanePeer(scrollPane);
        XToolkit.targetCreatedPeer(scrollPane, xScrollPanePeer);
        return xScrollPanePeer;
    }

    @Override
    public TextAreaPeer createTextArea(TextArea textArea) {
        XTextAreaPeer xTextAreaPeer = new XTextAreaPeer(textArea);
        XToolkit.targetCreatedPeer(textArea, xTextAreaPeer);
        return xTextAreaPeer;
    }

    @Override
    public ChoicePeer createChoice(Choice choice) {
        XChoicePeer xChoicePeer = new XChoicePeer(choice);
        XToolkit.targetCreatedPeer(choice, xChoicePeer);
        return xChoicePeer;
    }

    @Override
    public CanvasPeer createCanvas(Canvas canvas) {
        XCanvasPeer xCanvasPeer = this.isXEmbedServerRequested() ? new XEmbedCanvasPeer(canvas) : new XCanvasPeer(canvas);
        XToolkit.targetCreatedPeer(canvas, xCanvasPeer);
        return xCanvasPeer;
    }

    @Override
    public PanelPeer createPanel(Panel panel) {
        XPanelPeer xPanelPeer = new XPanelPeer(panel);
        XToolkit.targetCreatedPeer(panel, xPanelPeer);
        return xPanelPeer;
    }

    @Override
    public WindowPeer createWindow(Window window) {
        XWindowPeer xWindowPeer = new XWindowPeer(window);
        XToolkit.targetCreatedPeer(window, xWindowPeer);
        return xWindowPeer;
    }

    @Override
    public DialogPeer createDialog(Dialog dialog) {
        XDialogPeer xDialogPeer = new XDialogPeer(dialog);
        XToolkit.targetCreatedPeer(dialog, xDialogPeer);
        return xDialogPeer;
    }

    @Override
    public FileDialogPeer createFileDialog(FileDialog fileDialog) {
        XFileDialogPeer xFileDialogPeer = new XFileDialogPeer(fileDialog);
        XToolkit.targetCreatedPeer(fileDialog, xFileDialogPeer);
        return xFileDialogPeer;
    }

    @Override
    public MenuBarPeer createMenuBar(MenuBar menuBar) {
        XMenuBarPeer xMenuBarPeer = new XMenuBarPeer(menuBar);
        XToolkit.targetCreatedPeer(menuBar, xMenuBarPeer);
        return xMenuBarPeer;
    }

    @Override
    public MenuPeer createMenu(Menu menu) {
        XMenuPeer xMenuPeer = new XMenuPeer(menu);
        return xMenuPeer;
    }

    @Override
    public PopupMenuPeer createPopupMenu(PopupMenu popupMenu) {
        XPopupMenuPeer xPopupMenuPeer = new XPopupMenuPeer(popupMenu);
        XToolkit.targetCreatedPeer(popupMenu, xPopupMenuPeer);
        return xPopupMenuPeer;
    }

    @Override
    public synchronized MouseInfoPeer getMouseInfoPeer() {
        if (xPeer == null) {
            xPeer = new XMouseInfoPeer();
        }
        return xPeer;
    }

    public XEmbeddedFramePeer createEmbeddedFrame(XEmbeddedFrame xEmbeddedFrame) {
        XEmbeddedFramePeer xEmbeddedFramePeer = new XEmbeddedFramePeer(xEmbeddedFrame);
        XToolkit.targetCreatedPeer(xEmbeddedFrame, xEmbeddedFramePeer);
        return xEmbeddedFramePeer;
    }

    XEmbedChildProxyPeer createEmbedProxy(XEmbedChildProxy xEmbedChildProxy) {
        XEmbedChildProxyPeer xEmbedChildProxyPeer = new XEmbedChildProxyPeer(xEmbedChildProxy);
        XToolkit.targetCreatedPeer(xEmbedChildProxy, xEmbedChildProxyPeer);
        return xEmbedChildProxyPeer;
    }

    @Override
    public KeyboardFocusManagerPeer createKeyboardFocusManagerPeer(KeyboardFocusManager keyboardFocusManager) throws HeadlessException {
        XKeyboardFocusManagerPeer xKeyboardFocusManagerPeer = new XKeyboardFocusManagerPeer(keyboardFocusManager);
        return xKeyboardFocusManagerPeer;
    }

    @Override
    public Cursor createCustomCursor(Image image, Point point, String string) throws IndexOutOfBoundsException {
        return new XCustomCursor(image, point, string);
    }

    @Override
    public TrayIconPeer createTrayIcon(TrayIcon trayIcon) throws HeadlessException, AWTException {
        XTrayIconPeer xTrayIconPeer = new XTrayIconPeer(trayIcon);
        XToolkit.targetCreatedPeer(trayIcon, xTrayIconPeer);
        return xTrayIconPeer;
    }

    @Override
    public SystemTrayPeer createSystemTray(SystemTray systemTray) throws HeadlessException {
        XSystemTrayPeer xSystemTrayPeer = new XSystemTrayPeer(systemTray);
        return xSystemTrayPeer;
    }

    @Override
    public boolean isTraySupported() {
        XSystemTrayPeer xSystemTrayPeer = XSystemTrayPeer.getPeerInstance();
        if (xSystemTrayPeer != null) {
            return xSystemTrayPeer.isAvailable();
        }
        return false;
    }

    @Override
    public Dimension getBestCursorSize(int n, int n2) {
        return XCustomCursor.getBestCursorSize(Math.max(1, n), Math.max(1, n2));
    }

    @Override
    public int getMaximumCursorColors() {
        return 2;
    }

    public Map mapInputMethodHighlight(InputMethodHighlight inputMethodHighlight) {
        return XInputMethod.mapInputMethodHighlight(inputMethodHighlight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clipboard getSystemClipboard() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSystemClipboardAccess();
        }
        XToolkit xToolkit = this;
        synchronized (xToolkit) {
            if (this.clipboard == null) {
                this.clipboard = new XClipboard("System", "CLIPBOARD");
            }
        }
        return this.clipboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clipboard getSystemSelection() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSystemClipboardAccess();
        }
        XToolkit xToolkit = this;
        synchronized (xToolkit) {
            if (this.selection == null) {
                this.selection = new XClipboard("Selection", "PRIMARY");
            }
        }
        return this.selection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beep() {
        XToolkit.awtLock();
        try {
            XlibWrapper.XBell(XToolkit.getDisplay(), 0);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    static String getSystemProperty(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string);
            }
        });
    }

    @Override
    public PrintJob getPrintJob(Frame frame, String string, Properties properties) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException();
        }
        PrintJob2D printJob2D = new PrintJob2D(frame, string, properties);
        if (!printJob2D.printDialog()) {
            printJob2D = null;
        }
        return printJob2D;
    }

    @Override
    public PrintJob getPrintJob(Frame frame, String string, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException();
        }
        PrintJob2D printJob2D = new PrintJob2D(frame, string, jobAttributes, pageAttributes);
        if (!printJob2D.printDialog()) {
            printJob2D = null;
        }
        return printJob2D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void XSync() {
        XToolkit.awtLock();
        try {
            XlibWrapper.XSync(XToolkit.getDisplay(), 0);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getScreenResolution() {
        long l = XToolkit.getDisplay();
        XToolkit.awtLock();
        try {
            int n = (int)((double)XlibWrapper.DisplayWidth(l, XlibWrapper.DefaultScreen(l)) * 25.4 / (double)XlibWrapper.DisplayWidthMM(l, XlibWrapper.DefaultScreen(l)));
            return n;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    static native long getDefaultXColormap();

    static native long getDefaultScreenData();

    static ColorModel getStaticColorModel() {
        if (screenmodel == null) {
            screenmodel = config.getColorModel();
        }
        return screenmodel;
    }

    @Override
    public ColorModel getColorModel() {
        return XToolkit.getStaticColorModel();
    }

    @Override
    public InputMethodDescriptor getInputMethodAdapterDescriptor() throws AWTException {
        return new XInputMethodDescriptor();
    }

    static int getMultiClickTime() {
        if (awt_multiclick_time == 0) {
            XToolkit.initializeMultiClickTime();
        }
        return awt_multiclick_time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initializeMultiClickTime() {
        block9: {
            XToolkit.awtLock();
            try {
                try {
                    String string = XlibWrapper.XGetDefault(XToolkit.getDisplay(), "*", "multiClickTime");
                    if (string != null) {
                        awt_multiclick_time = (int)Long.parseLong(string);
                        break block9;
                    }
                    string = XlibWrapper.XGetDefault(XToolkit.getDisplay(), "OpenWindows", "MultiClickTimeout");
                    if (string != null) {
                        awt_multiclick_time = (int)Long.parseLong(string) * 100;
                        break block9;
                    }
                    awt_multiclick_time = 200;
                }
                catch (NumberFormatException numberFormatException) {
                    awt_multiclick_time = 200;
                }
                catch (NullPointerException nullPointerException) {
                    awt_multiclick_time = 200;
                }
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        if (awt_multiclick_time == 0) {
            awt_multiclick_time = 200;
        }
    }

    @Override
    public boolean isFrameStateSupported(int n) throws HeadlessException {
        if (n == 0 || n == 1) {
            return true;
        }
        return XWM.getWM().supportsExtendedState(n);
    }

    static void dumpPeers() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Mapped windows:");
            for (Map.Entry entry : winMap.entrySet()) {
                log.fine(entry.getKey() + "->" + entry.getValue());
                if (!(entry.getValue() instanceof XComponentPeer)) continue;
                Component component = (Component)((XComponentPeer)entry.getValue()).getTarget();
                log.fine("\ttarget: " + component);
            }
            log.fine("Mapped peers:");
            for (Map.Entry entry : SunToolkit.peerMap.entrySet()) {
                log.fine(entry.getKey() + "->" + entry.getValue());
            }
            log.fine("Mapped special peers:");
            for (Map.Entry entry : specialPeerMap.entrySet()) {
                log.fine(entry.getKey() + "->" + entry.getValue());
            }
            log.fine("Mapped dispatchers:");
            for (Map.Entry entry : winToDispatcher.entrySet()) {
                log.fine(entry.getKey() + "->" + entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getCurrentServerTime() {
        block12: {
            XToolkit.awtLock();
            try {
                try {
                    if (!initialized) {
                        XToolkit.addEventDispatcher(XBaseWindow.getXAWTRootWindow().getWindow(), timeFetcher);
                        _XA_JAVA_TIME_PROPERTY_ATOM = XAtom.get("_SUNW_JAVA_AWT_TIME");
                        initialized = true;
                    }
                    timeStampUpdated = false;
                    XlibWrapper.XChangeProperty(XToolkit.getDisplay(), XBaseWindow.getXAWTRootWindow().getWindow(), _XA_JAVA_TIME_PROPERTY_ATOM.getAtom(), 4L, 32, 2, 0L, 0);
                    XlibWrapper.XFlush(XToolkit.getDisplay());
                    if (XToolkit.isToolkitThread()) {
                        XEvent xEvent = new XEvent();
                        try {
                            XlibWrapper.XWindowEvent(XToolkit.getDisplay(), XBaseWindow.getXAWTRootWindow().getWindow(), 0x400000L, xEvent.pData);
                            XPropertyEvent xPropertyEvent = new XPropertyEvent(xEvent.pData);
                            timeFetcher.dispatchEvent(xEvent);
                            break block12;
                        }
                        finally {
                            xEvent.dispose();
                        }
                    }
                    while (!timeStampUpdated) {
                        XToolkit.awtLockWait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Catched exception, timeStamp may not be correct (ie = " + interruptedException + ")");
                    }
                }
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        return timeStamp;
    }

    @Override
    protected void initializeDesktopProperties() {
        this.desktopProperties.put("DnD.Autoscroll.initialDelay", 50);
        this.desktopProperties.put("DnD.Autoscroll.interval", 50);
        this.desktopProperties.put("DnD.Autoscroll.cursorHysteresis", 5);
        if (!GraphicsEnvironment.isHeadless()) {
            this.desktopProperties.put("awt.multiClickInterval", XToolkit.getMultiClickTime());
            this.desktopProperties.put("awt.mouse.numButtons", this.getNumMouseButtons());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNumMouseButtons() {
        XToolkit.awtLock();
        try {
            int n = XlibWrapper.XGetPointerMapping(XToolkit.getDisplay(), 0L, 0);
            return n;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    @Override
    protected Object lazilyLoadDesktopProperty(String string) {
        if (string.startsWith(prefix)) {
            String string2 = string.substring(prefix.length(), string.length()) + postfix;
            try {
                return Cursor.getSystemCustomCursor(string2);
            }
            catch (AWTException aWTException) {
                throw new RuntimeException("cannot load system cursor: " + string2, aWTException);
            }
        }
        if (string.equals("awt.dynamicLayoutSupported")) {
            return this.isDynamicLayoutSupported();
        }
        if (this.initXSettingsIfNeeded(string)) {
            return this.desktopProperties.get(string);
        }
        return super.lazilyLoadDesktopProperty(string);
    }

    @Override
    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.initXSettingsIfNeeded(string);
        super.addPropertyChangeListener(string, propertyChangeListener);
    }

    private boolean initXSettingsIfNeeded(String string) {
        if (!this.loadedXSettings && (string.startsWith("gnome.") || string.equals("awt.font.desktophints") || string.startsWith(dndPrefix))) {
            this.loadedXSettings = true;
            if (!GraphicsEnvironment.isHeadless()) {
                this.loadXSettings();
                if (this.desktopProperties.get("awt.font.desktophints") == null) {
                    Object object;
                    if (XWM.isKDE2() && (object = FontManager.getFontConfigAAHint()) != null) {
                        this.desktopProperties.put("fontconfig/Antialias", object);
                    }
                    this.desktopProperties.put("awt.font.desktophints", SunToolkit.getDesktopFontHints());
                }
                return true;
            }
        }
        return false;
    }

    private void loadXSettings() {
        this.xs = new XAWTXSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseXSettings(int n, Map map) {
        Integer n2;
        Object object;
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry object22 : map.entrySet()) {
            object = (String)object22.getKey();
            object = "gnome." + (String)object;
            this.setDesktopProperty((String)object, object22.getValue());
            log.fine("name = " + (String)object + " value = " + object22.getValue());
        }
        this.setDesktopProperty("awt.font.desktophints", SunToolkit.getDesktopFontHints());
        Object var4_5 = null;
        object = this;
        synchronized (object) {
            n2 = (Integer)this.desktopProperties.get("gnome.Net/DndDragThreshold");
        }
        if (n2 != null) {
            this.setDesktopProperty("DnD.gestureMotionThreshold", n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int keysymToPrimaryKeycode(long l) {
        XToolkit.awtLock();
        try {
            int n = XlibWrapper.XKeysymToKeycode(XToolkit.getDisplay(), l);
            if (n == 0) {
                int n2 = 0;
                return n2;
            }
            long l2 = XlibWrapper.XKeycodeToKeysym(XToolkit.getDisplay(), n, 0);
            if (l != l2) {
                int n3 = 0;
                return n3;
            }
            int n4 = n;
            return n4;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setupModifierMap() {
        int n = XToolkit.keysymToPrimaryKeycode(65511L);
        int n2 = XToolkit.keysymToPrimaryKeycode(65512L);
        int n3 = XToolkit.keysymToPrimaryKeycode(65513L);
        int n4 = XToolkit.keysymToPrimaryKeycode(65514L);
        int n5 = XToolkit.keysymToPrimaryKeycode(65407L);
        int n6 = XToolkit.keysymToPrimaryKeycode(65406L);
        int n7 = XToolkit.keysymToPrimaryKeycode(65510L);
        int n8 = XToolkit.keysymToPrimaryKeycode(65509L);
        int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        log.fine("In setupModifierMap");
        XToolkit.awtLock();
        try {
            int n9;
            int n10;
            XModifierKeymap xModifierKeymap = new XModifierKeymap(XlibWrapper.XGetModifierMapping(XToolkit.getDisplay()));
            int n11 = xModifierKeymap.get_max_keypermod();
            long l = xModifierKeymap.get_modifiermap();
            block3: for (n10 = 3; n10 <= 7; ++n10) {
                short s;
                for (n9 = 0; n9 < n11 && (s = Native.getUByte(l, n10 * n11 + n9)) != 0; ++n9) {
                    if (metaMask == 0 && (s == n || s == n2)) {
                        metaMask = nArray[n10];
                        continue block3;
                    }
                    if (altMask == 0 && (s == n3 || s == n4)) {
                        altMask = nArray[n10];
                        continue block3;
                    }
                    if (numLockMask == 0 && s == n5) {
                        numLockMask = nArray[n10];
                        continue block3;
                    }
                    if (modeSwitchMask != 0 || s != n6) continue;
                    modeSwitchMask = nArray[n10];
                    continue block3;
                }
            }
            modLockIsShiftLock = 0;
            for (n10 = 0; n10 < n11 && (n9 = (int)Native.getUByte(l, 1 * n11 + n10)) != 0; ++n10) {
                if (n9 == n7) {
                    modLockIsShiftLock = 1;
                    break;
                }
                if (n9 == n8) break;
            }
            XlibWrapper.XFreeModifiermap(xModifierKeymap.pData);
        }
        finally {
            XToolkit.awtUnlock();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("metaMask = " + metaMask);
            log.fine("altMask = " + altMask);
            log.fine("numLockMask = " + numLockMask);
            log.fine("modeSwitchMask = " + modeSwitchMask);
            log.fine("modLockIsShiftLock = " + modLockIsShiftLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void remove(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("task is null");
        }
        XToolkit.awtLock();
        try {
            if (timeoutTaskLog.isLoggable(Level.FINER)) {
                timeoutTaskLog.finer("Removing task " + runnable);
            }
            if (timeoutTasks == null) {
                if (timeoutTaskLog.isLoggable(Level.FINER)) {
                    timeoutTaskLog.finer("Task is not scheduled");
                }
                return;
            }
            Collection collection = timeoutTasks.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                java.util.List list = (java.util.List)iterator.next();
                boolean bl = false;
                if (!list.contains(runnable)) continue;
                list.remove(runnable);
                if (list.isEmpty()) {
                    iterator.remove();
                }
                break;
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    static native void wakeup_poll();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void schedule(Runnable runnable, long l) {
        if (runnable == null) {
            throw new NullPointerException("task is null");
        }
        if (l <= 0L) {
            throw new IllegalArgumentException("interval " + l + " is not positive");
        }
        XToolkit.awtLock();
        try {
            Long l2;
            ArrayList<Runnable> arrayList;
            if (timeoutTaskLog.isLoggable(Level.FINER)) {
                timeoutTaskLog.log(Level.FINER, "XToolkit.schedule(): current time={0};  interval={1};  task being added={2};  tasks before addition={3}", new Object[]{System.currentTimeMillis(), l, String.valueOf(runnable), String.valueOf(timeoutTasks)});
            }
            if (timeoutTasks == null) {
                timeoutTasks = new TreeMap();
            }
            if ((arrayList = (ArrayList<Runnable>)timeoutTasks.get(l2 = Long.valueOf(System.currentTimeMillis() + l))) == null) {
                arrayList = new ArrayList<Runnable>(1);
                timeoutTasks.put(l2, arrayList);
            }
            arrayList.add(runnable);
            if (timeoutTasks.get(timeoutTasks.firstKey()) == arrayList && arrayList.size() == 1) {
                XToolkit.wakeup_poll();
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextTaskTime() {
        XToolkit.awtLock();
        try {
            if (timeoutTasks == null || timeoutTasks.isEmpty()) {
                long l = -1L;
                return l;
            }
            long l = (Long)timeoutTasks.firstKey();
            return l;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    private static void callTimeoutTasks() {
        if (timeoutTaskLog.isLoggable(Level.FINER)) {
            timeoutTaskLog.log(Level.FINER, "XToolkit.callTimeoutTasks(): current time={0};  tasks={1}", new Object[]{System.currentTimeMillis(), String.valueOf(timeoutTasks)});
        }
        if (timeoutTasks == null || timeoutTasks.isEmpty()) {
            return;
        }
        Long l = System.currentTimeMillis();
        Long l2 = (Long)timeoutTasks.firstKey();
        while (l2.compareTo(l) <= 0) {
            java.util.List list = (java.util.List)timeoutTasks.remove(l2);
            for (Runnable runnable : list) {
                if (timeoutTaskLog.isLoggable(Level.FINER)) {
                    timeoutTaskLog.log(Level.FINER, "XToolkit.callTimeoutTasks(): current time={0};  about to run task={1}", new Object[]{(long)l, String.valueOf(runnable)});
                }
                try {
                    runnable.run();
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    XToolkit.processException(throwable);
                }
            }
            if (timeoutTasks.isEmpty()) break;
            l2 = (Long)timeoutTasks.firstKey();
        }
    }

    static long getAwtDefaultFg() {
        return awt_defaultFg;
    }

    static boolean isLeftMouseButton(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: 
            case 502: {
                return mouseEvent.getButton() == 1;
            }
            case 500: 
            case 504: 
            case 505: 
            case 506: {
                return (mouseEvent.getModifiersEx() & 0x400) != 0;
            }
        }
        return false;
    }

    static boolean isRightMouseButton(MouseEvent mouseEvent) {
        int n = (Integer)XToolkit.getDefaultToolkit().getDesktopProperty("awt.mouse.numButtons");
        switch (mouseEvent.getID()) {
            case 501: 
            case 502: {
                return n == 2 && mouseEvent.getButton() == 2 || n > 2 && mouseEvent.getButton() == 3;
            }
            case 500: 
            case 504: 
            case 505: 
            case 506: {
                return n == 2 && (mouseEvent.getModifiersEx() & 0x800) != 0 || n > 2 && (mouseEvent.getModifiersEx() & 0x1000) != 0;
            }
        }
        return false;
    }

    static Field getField(final Class clazz, final String string) {
        Field field = null;
        try {
            field = (Field)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Field field = clazz.getDeclaredField(string);
                    field.setAccessible(true);
                    return field;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            privilegedActionException.printStackTrace();
        }
        return field;
    }

    static Method getMethod(final Class clazz, final String string, final Class[] classArray) {
        Method method = null;
        try {
            method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Method method = clazz.getDeclaredMethod(string, classArray);
                    method.setAccessible(true);
                    return method;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            privilegedActionException.printStackTrace();
        }
        return method;
    }

    static long nowMillisUTC_offset(long l) {
        long l2 = System.currentTimeMillis();
        if (log.isLoggable(Level.FINER)) {
            log.finer("reset_time=" + reset_time_utc + ", current_time=" + l2 + ", server_offset=" + l + ", wrap_time=" + Integer.MAX_VALUE);
        }
        if (l2 - reset_time_utc > Integer.MAX_VALUE) {
            reset_time_utc = System.currentTimeMillis() - XToolkit.getCurrentServerTime();
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("result = " + (reset_time_utc + l));
        }
        return reset_time_utc + l;
    }

    @Override
    protected boolean needsXEmbedImpl() {
        return true;
    }

    @Override
    public boolean isModalityTypeSupported(Dialog.ModalityType modalityType) {
        return modalityType == null || modalityType == Dialog.ModalityType.MODELESS || modalityType == Dialog.ModalityType.DOCUMENT_MODAL || modalityType == Dialog.ModalityType.APPLICATION_MODAL || modalityType == Dialog.ModalityType.TOOLKIT_MODAL;
    }

    @Override
    public boolean isModalExclusionTypeSupported(Dialog.ModalExclusionType modalExclusionType) {
        return modalExclusionType == null || modalExclusionType == Dialog.ModalExclusionType.NO_EXCLUDE || modalExclusionType == Dialog.ModalExclusionType.APPLICATION_EXCLUDE || modalExclusionType == Dialog.ModalExclusionType.TOOLKIT_EXCLUDE;
    }

    static EventQueue getEventQueue(Object object) {
        AppContext appContext = XToolkit.targetToAppContext(object);
        if (appContext != null) {
            return (EventQueue)appContext.get(AppContext.EVENT_QUEUE_KEY);
        }
        return null;
    }

    static void removeSourceEvents(EventQueue eventQueue, Object object, boolean bl) {
        try {
            m_removeSourceEvents.invoke(eventQueue, object, bl);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    @Override
    public boolean isAlwaysOnTopSupported() {
        for (XLayerProtocol xLayerProtocol : XWM.getWM().getProtocols(XLayerProtocol.class)) {
            if (!xLayerProtocol.supportsLayer(1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean useBufferPerWindow() {
        return XToolkit.getBackingStoreType() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<Long> getChildren(long l) {
        XBaseWindow xBaseWindow = XToolkit.windowToXWindow(l);
        if (xBaseWindow != null) {
            return xBaseWindow.getChildren();
        }
        XQueryTree xQueryTree = new XQueryTree(l);
        try {
            int n = xQueryTree.execute();
            if (n == 0) {
                Set<Long> set = Collections.emptySet();
                return set;
            }
            long l2 = xQueryTree.get_children();
            if (l2 == 0L) {
                Set<Long> set = Collections.emptySet();
                return set;
            }
            int n2 = xQueryTree.get_nchildren();
            HashSet<Long> hashSet = new HashSet<Long>(n2);
            for (int i = 0; i < n2; ++i) {
                hashSet.add(Native.getWindow(l2, i));
            }
            HashSet<Long> hashSet2 = hashSet;
            return hashSet2;
        }
        finally {
            xQueryTree.dispose();
        }
    }

    static boolean isXAWTToplevelWindow(long l) {
        return XToolkit.windowToXWindow(l) instanceof XWindowPeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isToplevelWindow(long l) {
        if (XToolkit.windowToXWindow(l) instanceof XDecoratedPeer) {
            return true;
        }
        WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l, XWM.XA_WM_STATE, 0L, 1L, false, XWM.XA_WM_STATE);
        try {
            windowPropertyGetter.execute(IgnoreBadWindowHandler);
            if (windowPropertyGetter.getActualType() == XWM.XA_WM_STATE.getAtom()) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            windowPropertyGetter.dispose();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isTrueToplevelWindow(long l) {
        XBaseWindow xBaseWindow = XToolkit.windowToXWindow(l);
        if (xBaseWindow instanceof XWindowPeer && !(xBaseWindow instanceof XEmbeddedFramePeer)) {
            return true;
        }
        WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l, XWM.XA_WM_STATE, 0L, 1L, false, XWM.XA_WM_STATE);
        try {
            windowPropertyGetter.execute(IgnoreBadWindowHandler);
            if (windowPropertyGetter.getActualType() == XWM.XA_WM_STATE.getAtom()) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            windowPropertyGetter.dispose();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getParentWindow(long l) {
        XBaseWindow xBaseWindow = XToolkit.windowToXWindow(l);
        if (xBaseWindow != null && xBaseWindow.getParentWindow() != null) {
            return xBaseWindow.getParentWindow().getWindow();
        }
        XQueryTree xQueryTree = new XQueryTree(l);
        try {
            if (xQueryTree.execute() == 0) {
                long l2 = 0L;
                return l2;
            }
            long l3 = xQueryTree.get_parent();
            return l3;
        }
        finally {
            xQueryTree.dispose();
        }
    }

    static int getBackingStoreType() {
        return backingStoreType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setBackingStoreType() {
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.awt.backingStore"));
        if (string == null) {
            backingStoreType = 0;
            if (backingStoreLog.isLoggable(Level.CONFIG)) {
                backingStoreLog.config("The system property sun.awt.backingStore is not set, by default backingStore=NotUseful");
            }
            return;
        }
        if (backingStoreLog.isLoggable(Level.CONFIG)) {
            backingStoreLog.config("The system property sun.awt.backingStore is " + string);
        }
        backingStoreType = (string = string.toLowerCase()).equals("always") ? 2 : (string.equals("whenmapped") ? 1 : 0);
        if (backingStoreLog.isLoggable(Level.CONFIG)) {
            backingStoreLog.config("backingStore(as provided by the system property)=" + (backingStoreType == 0 ? "NotUseful" : (backingStoreType == 1 ? "WhenMapped" : "Always")));
        }
        if (X11SurfaceData.isDgaAvailable()) {
            backingStoreType = 0;
            if (backingStoreLog.isLoggable(Level.CONFIG)) {
                backingStoreLog.config("DGA is available, backingStore=NotUseful");
            }
            return;
        }
        XToolkit.awtLock();
        try {
            int n = XlibWrapper.ScreenCount(XToolkit.getDisplay());
            for (int i = 0; i < n; ++i) {
                if (XlibWrapper.DoesBackingStore(XlibWrapper.ScreenOfDisplay(XToolkit.getDisplay(), i)) != 0) continue;
                backingStoreType = 0;
                if (backingStoreLog.isLoggable(Level.CONFIG)) {
                    backingStoreLog.config("Backing store is not available on the screen " + i + ", backingStore=NotUseful");
                }
                return;
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isMapped(long l) {
        XToolkit.awtLock();
        try {
            XWindowAttributes xWindowAttributes;
            block8: {
                xWindowAttributes = new XWindowAttributes();
                try {
                    XToolkit.WITH_XERROR_HANDLER(IgnoreBadWindowHandler);
                    int n = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l, xWindowAttributes.pData);
                    XToolkit.RESTORE_XERROR_HANDLER();
                    if (n != 0 && (saved_error == null || saved_error.get_error_code() == 0)) break block8;
                    boolean bl = false;
                    xWindowAttributes.dispose();
                    return bl;
                }
                catch (Throwable throwable) {
                    xWindowAttributes.dispose();
                    throw throwable;
                }
            }
            boolean bl = xWindowAttributes.get_map_state() != 0;
            xWindowAttributes.dispose();
            return bl;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isXsunServer() {
        XToolkit.awtLock();
        try {
            if (awt_ServerInquired) {
                boolean bl = awt_IsXsunServer;
                return bl;
            }
            if (!XlibWrapper.ServerVendor(display).startsWith("Sun Microsystems")) {
                awt_ServerInquired = true;
                awt_IsXsunServer = false;
                boolean bl = false;
                return bl;
            }
            if (XlibWrapper.VendorRelease(display) > 10000) {
                awt_ServerInquired = true;
                awt_IsXsunServer = false;
                boolean bl = false;
                return bl;
            }
            awt_ServerInquired = true;
            awt_IsXsunServer = true;
            boolean bl = true;
            return bl;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isXKBenabled() {
        XToolkit.awtLock();
        try {
            if (awt_XKBInquired) {
                boolean bl = awt_UseXKB;
                return bl;
            }
            awt_XKBInquired = true;
            String string = "XKEYBOARD";
            boolean bl = awt_UseXKB = XlibWrapper.XQueryExtension(display, string, XlibWrapper.larg1, XlibWrapper.larg2, XlibWrapper.larg3);
            return bl;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getEventNumber() {
        XToolkit.awtLock();
        try {
            long l = eventNumber;
            return l;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean syncNativeQueue() {
        XRootWindow xRootWindow = XBaseWindow.getXAWTRootWindow();
        if (oops_waiter == null) {
            oops_waiter = new XEventDispatcher(){

                public void dispatchEvent(XEvent xEvent) {
                    if (xEvent.get_type() == 31) {
                        XSelectionEvent xSelectionEvent = xEvent.get_xselection();
                        if (xSelectionEvent.get_property() == XToolkit.this.oops.getAtom()) {
                            oops_updated = true;
                            SunToolkit.awtLockNotifyAll();
                        } else if (xSelectionEvent.get_selection() == XAtom.get("WM_S0").getAtom() && xSelectionEvent.get_target() == XAtom.get("VERSION").getAtom() && xSelectionEvent.get_property() == 0L && XlibWrapper.XGetSelectionOwner(XToolkit.getDisplay(), XAtom.get("WM_S0").getAtom()) == 0L) {
                            oops_failed = true;
                            SunToolkit.awtLockNotifyAll();
                        }
                    }
                }
            };
        }
        if (this.oops == null) {
            this.oops = XAtom.get("OOPS");
        }
        XToolkit.awtLock();
        try {
            XToolkit.addEventDispatcher(xRootWindow.getWindow(), oops_waiter);
            oops_updated = false;
            oops_failed = false;
            long l = XToolkit.getEventNumber();
            XAtom xAtom = XAtom.get("WM_S0");
            if (eventLog.isLoggable(Level.FINER)) {
                eventLog.log(Level.FINER, "WM_S0 selection owner {0}", new Object[]{String.valueOf(XlibWrapper.XGetSelectionOwner(XToolkit.getDisplay(), xAtom.getAtom()))});
            }
            XlibWrapper.XConvertSelection(XToolkit.getDisplay(), xAtom.getAtom(), XAtom.get("VERSION").getAtom(), this.oops.getAtom(), xRootWindow.getWindow(), 0L);
            XToolkit.XSync();
            eventLog.finer("Requested OOPS");
            long l2 = System.currentTimeMillis();
            while (!oops_updated && !oops_failed) {
                try {
                    XToolkit.awtLockWait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
                if (System.currentTimeMillis() - l2 <= 10000L) continue;
                throw new SunToolkit.OperationTimedOut(Long.toString(System.currentTimeMillis() - l2));
            }
            if (oops_failed && XToolkit.getEventNumber() - l == 1L) {
                XToolkit.awtUnlock();
                eventLog.log(Level.FINEST, "Emergency sleep");
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
                finally {
                    XToolkit.awtLock();
                }
            }
            boolean bl = XToolkit.getEventNumber() - l > 2L;
            return bl;
        }
        finally {
            XToolkit.removeEventDispatcher(xRootWindow.getWindow(), oops_waiter);
            eventLog.log(Level.FINER, "Exiting syncNativeQueue");
            XToolkit.awtUnlock();
        }
    }

    @Override
    public void grab(Window window) {
        if (window.getPeer() != null) {
            ((XWindowPeer)window.getPeer()).setGrab(true);
        }
    }

    @Override
    public void ungrab(Window window) {
        if (window.getPeer() != null) {
            ((XWindowPeer)window.getPeer()).setGrab(false);
        }
    }

    @Override
    public boolean isDesktopSupported() {
        return XDesktopPeer.isDesktopSupported();
    }

    @Override
    public DesktopPeer createDesktopPeer(Desktop desktop) {
        return new XDesktopPeer();
    }

    @Override
    public boolean isWindowOpacityControlSupported() {
        XNETProtocol xNETProtocol = XWM.getWM().getNETProtocol();
        if (xNETProtocol == null) {
            return false;
        }
        return xNETProtocol.doOpacityProtocol();
    }

    @Override
    public boolean isWindowShapingSupported() {
        return XlibUtil.isShapingSupported();
    }

    @Override
    public boolean isWindowTranslucencySupported() {
        return true;
    }

    @Override
    public boolean isTranslucencyCapable(GraphicsConfiguration graphicsConfiguration) {
        if (!(graphicsConfiguration instanceof X11GraphicsConfig)) {
            return false;
        }
        AwtGraphicsConfigData awtGraphicsConfigData = new AwtGraphicsConfigData(((X11GraphicsConfig)graphicsConfiguration).getAData());
        return 0 != awtGraphicsConfigData.get_isTranslucencySupported();
    }

    public static boolean getSunAwtDisableGrab() {
        return AccessController.doPrivileged(new GetBooleanAction("sun.awt.disablegrab"));
    }

    static {
        winMap = new TreeMap();
        specialPeerMap = new HashMap();
        winToDispatcher = new HashMap();
        screenWidth = -1;
        screenHeight = -1;
        XToolkit.initSecurityWarning();
        if (GraphicsEnvironment.isHeadless()) {
            config = null;
        } else {
            localEnv = (X11GraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment();
            device = (X11GraphicsDevice)localEnv.getDefaultScreenDevice();
            config = (X11GraphicsConfig)device.getDefaultConfiguration();
            if (device != null) {
                display = device.getDisplay();
            }
            XToolkit.setupModifierMap();
            XToolkit.initIDs();
            XToolkit.setBackingStoreType();
        }
        m_removeSourceEvents = XToolkit.getMethod(EventQueue.class, "removeSourceEvents", new Class[]{Object.class, Boolean.TYPE});
        IgnoreBadWindowHandler = new XErrorHandler(){

            public int handleError(long l, XErrorEvent xErrorEvent) {
                XToolkit.XERROR_SAVE(xErrorEvent);
                if (xErrorEvent.get_error_code() == 3) {
                    return 0;
                }
                return XToolkit.SAVED_ERROR_HANDLER(l, xErrorEvent);
            }
        };
        displayLock = new Object();
        timeFetcher = new XEventDispatcher(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispatchEvent(XEvent xEvent) {
                switch (xEvent.get_type()) {
                    case 28: {
                        XPropertyEvent xPropertyEvent = xEvent.get_xproperty();
                        SunToolkit.awtLock();
                        try {
                            timeStamp = xPropertyEvent.get_time();
                            timeStampUpdated = true;
                            SunToolkit.awtLockNotifyAll();
                            break;
                        }
                        finally {
                            SunToolkit.awtUnlock();
                        }
                    }
                }
            }
        };
        awt_ServerInquired = false;
        awt_IsXsunServer = false;
        awt_XKBInquired = false;
        awt_UseXKB = false;
    }

    static interface XErrorHandler {
        public int handleError(long var1, XErrorEvent var3);
    }

    public static interface XEventListener {
        public void eventProcessed(XEvent var1);
    }
}

