/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import net.sf.saxon.Configuration;
import net.sf.saxon.javax.xml.xquery.XQException;
import net.sf.saxon.javax.xml.xquery.XQItemType;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.SingletonNode;
import net.sf.saxon.xqj.SaxonXQDataFactory;

public class SaxonXQItemType
implements XQItemType {
    private ItemType itemType;
    private Configuration config;

    protected SaxonXQItemType(ItemType itemType, Configuration config) {
        this.itemType = itemType;
        this.config = config;
    }

    protected SaxonXQItemType(NodeInfo node) {
        this.config = node.getConfiguration();
        this.itemType = new SingletonNode(node).getItemType(this.config.getTypeHierarchy());
    }

    public int getBaseType() {
        if (this.itemType instanceof AtomicType) {
            int fp = this.itemType instanceof BuiltInAtomicType ? ((AtomicType)this.itemType).getFingerprint() : this.itemType.getPrimitiveType();
            return SaxonXQDataFactory.mapSaxonTypeToXQJ(fp);
        }
        if (this.itemType instanceof NodeTest) {
            int k = this.itemType.getPrimitiveType();
            switch (k) {
                case 9: {
                    return 4;
                }
                case 1: {
                    return 7;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 11;
                }
                case 8: {
                    return 3;
                }
                case 7: {
                    return 10;
                }
            }
            return 9;
        }
        return 8;
    }

    public int getItemKind() {
        if (this.itemType instanceof AtomicType) {
            return 1;
        }
        if (this.itemType instanceof NodeTest) {
            if (this.itemType instanceof DocumentNodeTest) {
                return 5;
            }
            int x = this.itemType.getPrimitiveType();
            switch (x) {
                case 9: {
                    return 4;
                }
                case 1: {
                    return 7;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 11;
                }
                case 8: {
                    return 3;
                }
                case 7: {
                    return 10;
                }
                case 0: {
                    return 9;
                }
            }
        }
        return 8;
    }

    public int getItemOccurrence() {
        return 2;
    }

    public QName getNodeName() throws XQException {
        ItemType type = this.itemType;
        if (type instanceof DocumentNodeTest) {
            type = ((DocumentNodeTest)type).getElementTest();
        }
        if (type instanceof NodeTest) {
            IntHashSet set = ((NodeTest)this.itemType).getRequiredNodeNames();
            if (set.size() == 1) {
                int fp = set.getFirst(-1);
                NamePool pool = this.config.getNamePool();
                String uri = pool.getURI(fp);
                String local = pool.getLocalName(fp);
                return new QName(uri, local);
            }
            return null;
        }
        throw new XQException("getNodeName() is not defined for this kind of item type");
    }

    public String getPIName() throws XQException {
        if (this.itemType instanceof NameTest && this.itemType.getPrimitiveType() == 7) {
            return this.getNodeName().getLocalPart();
        }
        if (this.itemType instanceof NodeKindTest && this.itemType.getPrimitiveType() == 7) {
            return null;
        }
        throw new XQException("Item kind is not a processing instruction");
    }

    public URI getSchemaURI() {
        try {
            if (this.itemType instanceof NodeTest) {
                SchemaType content = ((NodeTest)this.itemType).getContentType();
                return new URI(content.getSystemId());
            }
            if (this.itemType instanceof AtomicType) {
                return new URI(((AtomicType)this.itemType).getSystemId());
            }
            return null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public String toString() {
        return this.itemType.toString(this.config.getNamePool());
    }

    public QName getTypeName() throws XQException {
        SchemaType t;
        ItemType type = this.itemType;
        if (type instanceof AtomicType) {
            int fp = ((AtomicType)type).getFingerprint();
            NamePool pool = this.config.getNamePool();
            String uri = pool.getURI(fp);
            String local = pool.getLocalName(fp);
            return new QName(uri, local);
        }
        if (type instanceof DocumentNodeTest) {
            type = ((DocumentNodeTest)type).getElementTest();
        }
        if (type instanceof NodeTest && (t = ((NodeTest)type).getContentType()) != null) {
            int fp = ((NodeTest)type).getContentType().getFingerprint();
            NamePool pool = this.config.getNamePool();
            String uri = pool.getURI(fp);
            String local = pool.getLocalName(fp);
            return new QName(uri, local);
        }
        throw new XQException("getTypeName() failed: itemType is not a document, element, or attribute test");
    }

    public boolean isAnonymousType() {
        SchemaType t;
        ItemType type = this.itemType;
        if (type instanceof DocumentNodeTest) {
            type = ((DocumentNodeTest)type).getElementTest();
        }
        if (type instanceof NodeTest && (t = ((NodeTest)type).getContentType()) != null) {
            return t.isAnonymousType();
        }
        return false;
    }

    public boolean isElementNillable() {
        return this.itemType instanceof NodeTest && ((NodeTest)this.itemType).isNillable();
    }

    public XQItemType getItemType() {
        return this;
    }

    AtomicType getAtomicType() {
        if (this.itemType instanceof AtomicType) {
            return (AtomicType)this.itemType;
        }
        return null;
    }

    ItemType getSaxonItemType() {
        return this.itemType;
    }
}

