/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import com.sun.jini.config.Config;
import com.sun.jini.start.ActivateWrapper;
import com.sun.jini.start.ClassLoaderUtil;
import com.sun.jini.start.HTTPDStatus;
import com.sun.jini.start.NonActivatableServiceDescriptor;
import com.sun.jini.start.ServiceProxyAccessor;
import com.sun.jini.start.ServiceStarter;
import com.sun.jini.start.SharedActivationGroupDescriptor;
import java.io.IOException;
import java.rmi.MarshalledObject;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;

public class SharedActivatableServiceDescriptor
extends NonActivatableServiceDescriptor {
    private final String sharedGroupLog;
    private final boolean restart;
    private final String host;
    private final int port;
    private static final Logger logger = ServiceStarter.logger;

    public SharedActivatableServiceDescriptor(String string, String string2, String string3, String string4, String string5, String[] stringArray, boolean bl) {
        this(string, string2, string3, string4, string5, stringArray, bl, null, ServiceStarter.getActivationSystemPort());
    }

    public SharedActivatableServiceDescriptor(String string, String string2, String string3, String string4, String string5, String[] stringArray, boolean bl, String string6, int n) {
        super(string, string2, string3, string4, stringArray);
        if (string5 == null) {
            throw new NullPointerException("Shared VM log cannot be null");
        }
        this.sharedGroupLog = string5;
        this.restart = bl;
        this.host = string6 == null ? "" : string6;
        this.port = n <= 0 ? ServiceStarter.getActivationSystemPort() : n;
    }

    public final String getSharedGroupLog() {
        return this.sharedGroupLog;
    }

    public final boolean getRestart() {
        return this.restart;
    }

    public final String getActivationSystemHost() {
        return this.host;
    }

    public final int getActivationSystemPort() {
        return this.port;
    }

    public Object create(Configuration configuration) throws Exception {
        ServiceStarter.ensureSecurityManager();
        logger.entering(SharedActivatableServiceDescriptor.class.getName(), "create", new Object[]{configuration});
        if (configuration == null) {
            throw new NullPointerException("Configuration argument cannot be null");
        }
        Created created = null;
        ActivationSystem activationSystem = ServiceStarter.getActivationSystem(this.getActivationSystemHost(), this.getActivationSystemPort(), configuration);
        ProxyPreparer proxyPreparer = (ProxyPreparer)Config.getNonNullEntry(configuration, "com.sun.jini.start", "activationIdPreparer", ProxyPreparer.class, new BasicProxyPreparer());
        ProxyPreparer proxyPreparer2 = (ProxyPreparer)Config.getNonNullEntry(configuration, "com.sun.jini.start", "servicePreparer", ProxyPreparer.class, new BasicProxyPreparer());
        HTTPDStatus.httpdWarning(this.getCodebase());
        ActivationGroupID activationGroupID = null;
        ActivationID activationID = null;
        Object object = null;
        try {
            MarshalledObject<String[]> marshalledObject = new MarshalledObject<String[]>(this.getServerConfigArgs());
            ActivateWrapper.ActivateDesc activateDesc = new ActivateWrapper.ActivateDesc(this.getImplClassName(), ClassLoaderUtil.getClasspathURLs(this.getClasspath()), ClassLoaderUtil.getCodebaseURLs(this.getCodebase()), this.getPolicy(), marshalledObject);
            logger.finest("ActivateDesc: " + activateDesc);
            activationGroupID = SharedActivationGroupDescriptor.restoreGroupID(this.getSharedGroupLog());
            activationID = ActivateWrapper.register(activationGroupID, activateDesc, this.getRestart(), activationSystem);
            activationID = (ActivationID)proxyPreparer.prepareProxy(activationID);
            object = activationID.activate(true);
            if (object != null && (object = proxyPreparer2.prepareProxy(object)) instanceof ServiceProxyAccessor) {
                object = ((ServiceProxyAccessor)object).getServiceProxy();
                object = proxyPreparer2.prepareProxy(object);
            }
        }
        catch (Exception exception) {
            try {
                if (activationID != null) {
                    activationSystem.unregisterObject(activationID);
                }
            }
            catch (Exception exception2) {
                logger.log(Level.FINEST, "Unable to unregister with activation system", exception2);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof ActivationException) {
                throw (ActivationException)exception;
            }
            if (exception instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)exception;
            }
            throw new RuntimeException("Unexpected Exception", exception);
        }
        created = new Created(activationGroupID, activationID, object);
        logger.exiting(SharedActivatableServiceDescriptor.class.getName(), "create", created);
        return created;
    }

    public String toString() {
        ArrayList<Object> arrayList = new ArrayList<Object>(10);
        arrayList.add(this.getCodebase());
        arrayList.add(this.getPolicy());
        arrayList.add(this.getClasspath());
        arrayList.add(this.getImplClassName());
        arrayList.add(Arrays.asList(this.getServerConfigArgs()));
        arrayList.add(this.getLifeCycle());
        arrayList.add(this.sharedGroupLog);
        arrayList.add(new Boolean(this.restart));
        arrayList.add(this.host);
        arrayList.add(new Integer(this.port));
        return arrayList.toString();
    }

    public static class Created {
        public final ActivationGroupID gid;
        public final ActivationID aid;
        public final Object proxy;

        public Created(ActivationGroupID activationGroupID, ActivationID activationID, Object object) {
            this.gid = activationGroupID;
            this.aid = activationID;
            this.proxy = object;
        }
    }
}

