/*
 * Decompiled with CFR 0.152.
 */
package ice.ssl;

import ice.debug.Debug;
import ice.ssl.Alert;
import ice.ssl.ConnectionState;
import ice.ssl.SSLPlaintext;
import ice.ssl.SSLSocket;
import ice.ssl.SessionState;
import ice.ssl.SimpleKey;
import ice.ssl.Util;
import ice.util.ICEException;
import ice.util.memory.MemoryManager;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import xjava.security.Cipher;
import xjava.security.FeedbackCipher;

final class ReadRecord
extends FilterInputStream {
    private boolean J;
    private SessionState MACAlgorithm;
    private ConnectionState OEAB;
    private Cipher append;
    private Key arraycopy;
    private boolean available;
    private SSLSocket blockCipher;
    private byte[] bulkCipherAlgorithm = null;
    private int bulkCipherAlgorithmName = 0;
    private static MemoryManager byteArrayToInt = null;
    int haveRead = 0;

    ReadRecord(InputStream inputStream, SessionState sessionState, ConnectionState connectionState, SSLSocket sSLSocket) {
        super(inputStream);
        this.MACAlgorithm = sessionState;
        this.OEAB = connectionState;
        this.blockCipher = sSLSocket;
    }

    void setHandshake(boolean bl) {
        this.available = bl;
    }

    void setStates(ConnectionState connectionState, SessionState sessionState) {
        block11: {
            block10: {
                if (sessionState.nowProto == 1) {
                    connectionState.serverSeqNum = this.OEAB.serverSeqNum;
                }
                this.OEAB = connectionState;
                this.MACAlgorithm = sessionState;
                this.append = null;
                if (sessionState.bulkCipherAlgorithm == 0) {
                    return;
                }
                try {
                    if (!sessionState.blockCipher) {
                        this.append = Cipher.getInstance(sessionState.bulkCipherAlgorithmName);
                    } else {
                        Cipher cipher = Cipher.getInstance(sessionState.bulkCipherAlgorithmName + "/CBC");
                        ((FeedbackCipher)((Object)cipher)).setInitializationVector(sessionState.serverWriteIV);
                        this.append = cipher;
                    }
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    if (Debug.ex) {
                        Debug.ex((Throwable)noSuchAlgorithmException);
                    }
                    if (!Debug.trace) break block10;
                    Debug.trace((String)("WARNING: NoSuchAlgorithmException " + noSuchAlgorithmException));
                }
            }
            if (this.append != null) {
                this.arraycopy = new SimpleKey(sessionState.bulkCipherAlgorithmName, connectionState.serverWriteKey);
                try {
                    this.append.initDecrypt(this.arraycopy);
                }
                catch (KeyException keyException) {
                    if (!Debug.ex) break block11;
                    Debug.ex((Throwable)keyException);
                }
            }
        }
    }

    SessionState getSessionState() {
        return this.MACAlgorithm;
    }

    public void close() throws IOException {
        this.J = true;
        super.close();
    }

    public int available() throws IOException {
        if (this.J || this.bulkCipherAlgorithm == null || this.available) {
            return 0;
        }
        return this.bulkCipherAlgorithm.length - this.bulkCipherAlgorithmName;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = 0;
        while ((n = this.read(byArray, 0, 1)) == 0) {
        }
        if (n < 0) {
            return -1;
        }
        return byArray[0];
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.J) {
            return -1;
        }
        if (this.available) {
            return 0;
        }
        this.haveRead = 0;
        while (n2 > 0) {
            if (this.bulkCipherAlgorithm == null && (this.in.available() > 0 || this.haveRead < 1)) {
                this.J();
            }
            if (this.bulkCipherAlgorithm == null) {
                return this.haveRead > 0 ? this.haveRead : -1;
            }
            if (this.bulkCipherAlgorithm.length - this.bulkCipherAlgorithmName <= n2) {
                int n3 = this.bulkCipherAlgorithm.length - this.bulkCipherAlgorithmName;
                System.arraycopy(this.bulkCipherAlgorithm, this.bulkCipherAlgorithmName, byArray, n, n3);
                n2 -= n3;
                n += n3;
                this.haveRead += n3;
                this.bulkCipherAlgorithm = null;
                continue;
            }
            System.arraycopy(this.bulkCipherAlgorithm, this.bulkCipherAlgorithmName, byArray, n, n2);
            this.bulkCipherAlgorithmName += n2;
            this.haveRead += n2;
            n2 = 0;
        }
        return this.haveRead;
    }

    private void J() throws IOException {
        SSLPlaintext sSLPlaintext = this.readNext();
        if (sSLPlaintext == null) {
            return;
        }
        if (sSLPlaintext.contentType == 22) {
            if (sSLPlaintext.data[0] == 0) {
                this.blockCipher.startHandshake();
                return;
            }
            this.blockCipher.close(10);
            throw new IOException("Unexpected message recieved from the server: Expecting application data - received Handshake Message " + (sSLPlaintext.data[0] & 0xFF));
        }
        if (sSLPlaintext.contentType == 21) {
            if (sSLPlaintext.data[1] == 0) {
                this.blockCipher.close();
                return;
            }
            Alert alert = new Alert(sSLPlaintext);
            this.blockCipher.close();
            throw new IOException("Fatal alert recieved from the server: " + alert.getDescriptionString());
        }
        if (sSLPlaintext.contentType == 20) {
            this.blockCipher.close(10);
            throw new IOException("Unexpected change_cipher_spec message");
        }
        this.bulkCipherAlgorithm = sSLPlaintext.data;
        this.bulkCipherAlgorithmName = 0;
    }

    SSLPlaintext readNext() throws IOException {
        int n;
        if (this.J) {
            return null;
        }
        int n2 = -1;
        if (this.haveRead > 0 && this.in.available() > 0) {
            return null;
        }
        n2 = this.in.read();
        if (n2 < 0) {
            return null;
        }
        if (this.MACAlgorithm.nowProto == 1 && (n2 < 20 || n2 > 23)) {
            return this.append(n2);
        }
        SSLPlaintext sSLPlaintext = new SSLPlaintext();
        byte[] byArray = new byte[5];
        int n3 = 1;
        byArray[0] = (byte)n2;
        while (!this.J && n3 < 5) {
            n = this.in.read(byArray, n3, 5 - n3);
            if (n < 0) {
                return null;
            }
            n3 += n;
        }
        sSLPlaintext.contentType = byArray[0];
        sSLPlaintext.major = byArray[1];
        sSLPlaintext.minor = byArray[2];
        n = Util.byteArrayToInt(byArray, 3, 2);
        byteArrayToInt = MemoryManager.getInstance();
        if (!byteArrayToInt.canAllocate(n)) {
            throw new ICEException(3, 3, 2);
        }
        sSLPlaintext.data = new byte[n];
        n3 = 0;
        while (!this.J && n3 < n) {
            int n4 = this.in.read(sSLPlaintext.data, n3, n - n3);
            if (n4 < 0) {
                return null;
            }
            n3 += n4;
        }
        sSLPlaintext.data = this.OEAB(sSLPlaintext.contentType, this.MACAlgorithm(sSLPlaintext.data));
        ++this.OEAB.serverSeqNum;
        return sSLPlaintext;
    }

    private byte[] MACAlgorithm(byte[] byArray) {
        return byArray;
    }

    private byte[] OEAB(int n, byte[] byArray) throws IOException {
        byte[] byArray2;
        byte[] byArray3 = this.append == null ? byArray : this.append.crypt(byArray);
        if (this.MACAlgorithm.blockCipher) {
            byte by = byArray3[byArray3.length - 1];
            byArray2 = new byte[byArray3.length - by - 1];
            System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length - by - 1);
            byArray3 = byArray2;
        }
        if (this.MACAlgorithm.MACAlgorithm != 0) {
            byte[] byArray4 = new byte[this.MACAlgorithm.hashSize];
            System.arraycopy(byArray3, byArray3.length - this.MACAlgorithm.hashSize, byArray4, 0, this.MACAlgorithm.hashSize);
            byteArrayToInt = MemoryManager.getInstance();
            if (!byteArrayToInt.canAllocate(byArray3.length - this.MACAlgorithm.hashSize)) {
                throw new ICEException(3, 2, 2);
            }
            byArray2 = new byte[byArray3.length - this.MACAlgorithm.hashSize];
            System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length - this.MACAlgorithm.hashSize);
            byArray3 = byArray2;
            byte[] byArray5 = Util.v3generateHash(true, this.MACAlgorithm, this.OEAB, n, byArray3);
            int n2 = 0;
            while (n2 < this.MACAlgorithm.hashSize) {
                if (byArray4[n2] != byArray5[n2]) {
                    this.blockCipher.close(20);
                    throw new IOException("A message received from the server is wrongly authenticated.");
                }
                ++n2;
            }
        }
        return byArray3;
    }

    private SSLPlaintext append(int n) throws IOException {
        SSLPlaintext sSLPlaintext = new SSLPlaintext();
        int n2 = 0;
        int n3 = 0;
        int n4 = n;
        int n5 = this.in.read();
        if ((n4 & 0x80) == 0) {
            n3 = this.in.read();
            n2 = ((n4 & 0x3F) << 8) + n5;
        } else {
            n2 = ((n4 & 0x7F) << 8) + n5;
        }
        if (n4 == -1 || n5 == -1) {
            return null;
        }
        sSLPlaintext.contentType = 23;
        sSLPlaintext.major = Util.majorVersion(1);
        sSLPlaintext.minor = Util.minorVersion(1);
        sSLPlaintext.data = new byte[n2];
        int n6 = 0;
        while (!this.J && n6 < n2) {
            int n7 = this.in.read(sSLPlaintext.data, n6, n2 - n6);
            if (n7 < 0) {
                return null;
            }
            n6 += n7;
        }
        sSLPlaintext.data = this.arraycopy(sSLPlaintext.contentType, sSLPlaintext.data, n3);
        if (this.available) {
            sSLPlaintext.contentType = sSLPlaintext.data[0] == 0 ? 21 : 22;
        }
        ++this.OEAB.serverSeqNum;
        return sSLPlaintext;
    }

    private byte[] arraycopy(int n, byte[] byArray, int n2) throws IOException {
        byte[] byArray2;
        byte[] byArray3 = this.append == null ? byArray : this.append.crypt(byArray);
        if (this.MACAlgorithm.MACAlgorithm != 0) {
            byte[] byArray4 = new byte[this.MACAlgorithm.hashSize];
            System.arraycopy(byArray3, 0, byArray4, 0, this.MACAlgorithm.hashSize);
            byArray2 = new byte[byArray3.length - this.MACAlgorithm.hashSize];
            System.arraycopy(byArray3, this.MACAlgorithm.hashSize, byArray2, 0, byArray3.length - this.MACAlgorithm.hashSize);
            byArray3 = byArray2;
            byte[] byArray5 = Util.v2generateHash(true, this.MACAlgorithm, this.OEAB, byArray3);
            int n3 = 0;
            while (n3 < this.MACAlgorithm.hashSize) {
                if (byArray4[n3] != byArray5[n3]) {
                    this.blockCipher.close(20);
                    throw new IOException("A message received from the server is wrongly authenticated.");
                }
                ++n3;
            }
        }
        if (this.MACAlgorithm.blockCipher && n2 > 0) {
            int n4 = byArray3.length - n2;
            byArray2 = new byte[n4];
            System.arraycopy(byArray3, 0, byArray2, 0, n4);
            byArray3 = byArray2;
        }
        return byArray3;
    }
}

