/*
 * Decompiled with CFR 0.152.
 */
package ice.ssl;

import ice.ssl.ConnectionState;
import ice.ssl.HandshakeState;
import ice.ssl.SSLSocket;
import ice.ssl.ServerHandshake;
import ice.ssl.SessionState;
import ice.ssl.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

final class ServerFinished
extends ServerHandshake {
    private static final byte[] I = new byte[]{83, 82, 86, 82};
    private static final int[] OEAB = new int[]{-1};
    private boolean append;

    ServerFinished(SSLSocket sSLSocket, SessionState sessionState, ConnectionState connectionState, HandshakeState handshakeState) {
        super(sSLSocket, sessionState, connectionState, handshakeState);
        Object[] objectArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = handshakeState.messages.toByteArray();
        byte[] byArray2 = new byte[byArray.length - this.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length - this.length);
        MessageDigest messageDigest = null;
        MessageDigest messageDigest2 = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest2 = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException("Algorithm not found : " + (messageDigest == null ? "MD5" : "SHA") + " digest");
        }
        if (sessionState.nowProto == 2) {
            objectArray = new MessageDigest[]{messageDigest, messageDigest2};
            int n = 0;
            while (n < 2) {
                objectArray[n].reset();
                objectArray[n].update(byArray2);
                objectArray[n].update(I);
                objectArray[n].update(sessionState.masterSecret);
                objectArray[n].update(Util.pad1, 0, n == 0 ? 48 : 40);
                byte[] byArray3 = objectArray[n].digest();
                objectArray[n].reset();
                objectArray[n].update(sessionState.masterSecret);
                objectArray[n].update(Util.pad2, 0, n == 0 ? 48 : 40);
                objectArray[n].update(byArray3);
                try {
                    byteArrayOutputStream.write(objectArray[n].digest());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ++n;
            }
        } else {
            messageDigest.reset();
            messageDigest.update(byArray2);
            messageDigest2.reset();
            messageDigest2.update(byArray2);
            try {
                byteArrayOutputStream.write(Util.prf(12, sessionState.masterSecret, "server finished", Util.concat(messageDigest.digest(), messageDigest2.digest())));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        objectArray = byteArrayOutputStream.toByteArray();
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.append = objectArray.length == this.length - 4;
        int n = 0;
        while (this.append && n < this.length - 4) {
            if (objectArray[n] != handshakeState.data[handshakeState.offset + n]) {
                this.append = false;
            }
            ++n;
        }
        handshakeState.next = OEAB;
        handshakeState.offset += this.length - 4;
    }

    public boolean verified() {
        return this.append;
    }
}

