/*
 * Decompiled with CFR 0.152.
 */
package ice.ssl;

import ice.ssl.ClientHandshake;
import ice.ssl.ConnectionState;
import ice.ssl.SSLSocket;
import ice.ssl.SessionState;
import ice.ssl.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

final class V2ClientHello
extends ClientHandshake {
    private int[] I;

    public V2ClientHello(SessionState sessionState, ConnectionState connectionState, int[] nArray) {
        super(1, sessionState, connectionState);
        this.I = nArray;
    }

    public byte[] toByteArray() throws IOException {
        byte[] byArray = new byte[]{};
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(super.toByteArray());
        byte[] byArray2 = new byte[8];
        int n = SSLSocket.highestProto;
        if (this.sesState.sessionID.length > 0) {
            n = this.sesState.nowProto;
        }
        if (n == 1) {
            byArray2[0] = 0;
            byArray2[1] = 2;
        } else if (n == 2) {
            byArray2[0] = (byte)Util.majorVersion(2);
            byArray2[1] = (byte)Util.minorVersion(2);
        } else if (n == 4) {
            byArray2[0] = (byte)Util.majorVersion(4);
            byArray2[1] = (byte)Util.minorVersion(4);
        }
        byArray2[2] = (byte)(this.I.length * 3 >> 8);
        byArray2[3] = (byte)(this.I.length * 3 & 0x7F);
        byArray2[4] = (byte)(this.sesState.sessionID.length >> 8);
        byArray2[5] = (byte)(this.sesState.sessionID.length & 0xFF);
        byArray2[6] = 0;
        byArray2[7] = 16;
        byteArrayOutputStream.write(byArray2);
        int n2 = 0;
        while (n2 < this.I.length) {
            byteArrayOutputStream.write(Util.toByteArray(this.I[n2], 3));
            ++n2;
        }
        if (this.sesState.sessionID.length > 0) {
            byteArrayOutputStream.write(this.sesState.sessionID);
        }
        byArray2 = new byte[16];
        Util.secureRandom(byArray2);
        byteArrayOutputStream.write(byArray2);
        this.conState.clientRandom = byArray2;
        byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray;
    }
}

