/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import [Lcom.sun.jini.start.ServiceDescriptor;;
import com.sun.jini.start.ServiceDescriptor;
import com.sun.jini.start.ServiceStarter;
import com.sun.jini.start.SharedActivatableServiceDescriptor;
import com.sun.jini.start.SharedGroup;
import com.sun.jini.system.FileSystem;
import java.io.File;
import java.rmi.activation.ActivationSystem;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;

public class DestroySharedGroup {
    private static final Logger logger = ServiceStarter.logger;

    public static void main(String[] stringArray) {
        ServiceStarter.ensureSecurityManager();
        logger.entering(DestroySharedGroup.class.getName(), "main", stringArray);
        try {
            Configuration configuration = ConfigurationProvider.getInstance(stringArray);
            ServiceDescriptor[] serviceDescriptorArray = (ServiceDescriptor[])configuration.getEntry("com.sun.jini.start", "serviceDestructors", ServiceDescriptor;.class, null);
            if (serviceDescriptorArray == null || serviceDescriptorArray.length == 0) {
                logger.log(Level.WARNING, "service.config.empty");
                return;
            }
            LoginContext loginContext = (LoginContext)configuration.getEntry("com.sun.jini.start", "loginContext", LoginContext.class, null);
            if (loginContext != null) {
                DestroySharedGroup.destroyWithLogin(serviceDescriptorArray, configuration, loginContext);
            } else {
                DestroySharedGroup.destroy(serviceDescriptorArray, configuration);
            }
        }
        catch (ConfigurationException configurationException) {
            logger.log(Level.SEVERE, "destroy.config.exception", configurationException);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "destroy.unexpected.exception", exception);
        }
        logger.exiting(DestroySharedGroup.class.getName(), "main");
    }

    private static void destroy(ServiceDescriptor[] serviceDescriptorArray, Configuration configuration) throws Exception {
        logger.entering(DestroySharedGroup.class.getName(), "destroy", new Object[]{Arrays.asList(serviceDescriptorArray), configuration});
        SharedActivatableServiceDescriptor.Created created = null;
        SharedActivatableServiceDescriptor sharedActivatableServiceDescriptor = null;
        ActivationSystem activationSystem = null;
        for (int i = 0; i < serviceDescriptorArray.length; ++i) {
            if (serviceDescriptorArray[i] instanceof SharedActivatableServiceDescriptor) {
                sharedActivatableServiceDescriptor = (SharedActivatableServiceDescriptor)serviceDescriptorArray[i];
                activationSystem = ServiceStarter.getActivationSystem(sharedActivatableServiceDescriptor.getActivationSystemHost(), sharedActivatableServiceDescriptor.getActivationSystemPort(), configuration);
                try {
                    created = (SharedActivatableServiceDescriptor.Created)sharedActivatableServiceDescriptor.create(configuration);
                    if (created != null && created.proxy instanceof SharedGroup) {
                        SharedGroup sharedGroup = (SharedGroup)created.proxy;
                        try {
                            sharedGroup.destroyVM();
                            try {
                                File file = new File(sharedActivatableServiceDescriptor.getSharedGroupLog());
                                FileSystem.destroy(file, true);
                            }
                            catch (Exception exception) {
                                logger.log(Level.WARNING, "destroy.group.deletion", exception);
                            }
                        }
                        catch (Exception exception) {
                            logger.log(Level.SEVERE, "destroy.group.exception", exception);
                        }
                        continue;
                    }
                    logger.log(Level.WARNING, "destroy.unexpected.proxy", created == null ? null : created.proxy);
                    if (created == null || created.aid == null) continue;
                    try {
                        activationSystem.unregisterObject(created.aid);
                    }
                    catch (Exception exception) {
                        logger.log(Level.WARNING, "destroy.unregister.exception", exception);
                    }
                }
                catch (Exception exception) {
                    logger.log(Level.SEVERE, "destroy.creation.exception", exception);
                    if (created == null || created.aid == null) continue;
                    try {
                        activationSystem.unregisterObject(created.aid);
                    }
                    catch (Exception exception2) {
                        logger.log(Level.WARNING, "destroy.unregister.exception", exception);
                    }
                }
                continue;
            }
            logger.log(Level.WARNING, "destroy.unexpected.type", serviceDescriptorArray[i]);
        }
        logger.exiting(DestroySharedGroup.class.getName(), "destroy");
    }

    /*
     * Loose catch block
     */
    private static void destroyWithLogin(final ServiceDescriptor[] serviceDescriptorArray, final Configuration configuration, LoginContext loginContext) throws Exception {
        block7: {
            logger.entering(DestroySharedGroup.class.getName(), "destroyWithLogin", new Object[]{serviceDescriptorArray, configuration, loginContext});
            loginContext.login();
            Subject.doAsPrivileged(loginContext.getSubject(), new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    DestroySharedGroup.destroy(serviceDescriptorArray, configuration);
                    return null;
                }
            }, null);
            Object var5_3 = null;
            try {
                loginContext.logout();
            }
            catch (LoginException loginException) {
                logger.log(Level.FINE, "service.logout.exception", loginException);
            }
            break block7;
            {
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                try {
                    loginContext.logout();
                }
                catch (LoginException loginException) {
                    logger.log(Level.FINE, "service.logout.exception", loginException);
                }
                throw throwable;
            }
        }
        logger.exiting(DestroySharedGroup.class.getName(), "destroyWithLogin");
    }
}

