/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.BinarySwapBytes;
import com.mathworks.toolbox.instrument.InstrumentReader;
import com.mathworks.toolbox.instrument.Poller;
import com.mathworks.toolbox.instrument.events.ICEvent;
import com.mathworks.toolbox.testmeas.util.TMException;
import java.util.Calendar;

public abstract class InstrumentAsync
extends InstrumentReader {
    protected static final int READACTION_SUCCESS = 0;
    protected static final int READACTION_SIZE = 1;
    protected static final int WRITEACTION = 2;
    protected static final int INTERRUPTACTION = 3;
    protected static final int READASYNCMODE_ACTION = 4;
    protected static final int WRITEASYNC_ACTION = 5;
    protected static final int TRIGGERACTION = 10;
    protected static final Integer IREADASYNCMODE_ACTION = new Integer(4);
    protected static final Integer IWRITEASYNC_ACTION = new Integer(5);
    protected boolean readingFromHardware = false;
    protected int valuesToOutput = 0;
    protected long writeAsyncStartTime = InstrumentAsync.nanoBadTime();
    protected boolean ignoreReadEvents = false;
    protected boolean completedAction = false;
    private int actionCode;
    private int actionCount;
    public int outputDataType = 0;

    public void readasync() throws TMException {
        try {
            this.readasync(this.inputBufferSize - this.bytesAvailable);
        }
        catch (Exception exception) {
            InstrumentAsync.displayError(exception.getMessage());
        }
    }

    public void readasync(int n) throws TMException {
        this.verifyObjectState();
        if (n == 0) {
            return;
        }
        if (n > this.inputBufferSize - this.bytesAvailable) {
            InstrumentAsync.displayError("SIZE must be less than or equal to InputBufferSize-BytesAvailable.");
        }
        this.verifyReadOperation();
        this.flushForReadAsync();
        this.readAsyncCount = n;
        this.readAsyncStartTime = InstrumentAsync.currentNanoTicTime();
    }

    protected void flushForReadAsync() {
    }

    @Override
    public void stopasync() throws Exception {
        if (!this.isvalid()) {
            InstrumentAsync.displayError("Instrument object OBJ is an invalid object.");
        }
        this.readAsyncCount = 0;
        this.readAsyncStartTime = InstrumentAsync.nanoBadTime();
        this.flushOutputVector();
        this.hardwareStopAsync();
        this.transferStatus = 0;
    }

    protected boolean okToPollRead() {
        return this.readAsyncCount > 0 && !this.readingFromHardware;
    }

    protected void setCompletedAction(boolean bl) {
        this.completedAction = bl;
    }

    @Override
    public boolean poll() {
        this.completedAction = false;
        try {
            if (this.dataAvailableOutputVector()) {
                this.pollingWrite();
            }
            if (this.okToPollRead()) {
                this.pollingRead();
            }
            if (this.isActionAvailable()) {
                this.completedAction = true;
                this.actionCode = this.getNextAction();
                this.actionCount = this.getNextAction();
                this.actionCode = this.getAsyncActionType(this.actionCode, this.actionCount);
                switch (this.actionCode) {
                    case -1: {
                        break;
                    }
                    case 0: {
                        this.pollingReadActionSuccess(this.actionCount);
                        break;
                    }
                    case 1: {
                        this.pollingReadActionSize(this.actionCount);
                        break;
                    }
                    case 2: {
                        this.pollingWriteAction();
                        break;
                    }
                    case 4: {
                        this.pollingReadAsyncModeAction(this.actionCount);
                        break;
                    }
                    case 5: {
                        this.pollingWriteAsyncBlockAction(this.actionCount);
                        break;
                    }
                    case 3: {
                        this.interruptAction();
                        break;
                    }
                    default: {
                        if (this.actionCode < 10) break;
                        this.triggerAction(this.actionCode);
                    }
                }
            }
            this.checkForAsynchronousTimeouts();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.completedAction;
    }

    public void pollingRead() {
        int n;
        this.updateReadTransferStatus(true);
        this.readingFromHardware = true;
        if (this.bytesAvailableFcnMode == 1) {
            n = this.bytesAvailableFcnCount - this.bytesAvailable % this.bytesAvailableFcnCount;
            if (n > this.readAsyncCount) {
                n = this.readAsyncCount;
            }
        } else {
            n = this.readAsyncCount;
        }
        try {
            int n2 = this.readBinaryFromHardwareAsync(n);
            if (n2 < this.getSuccessValue()) {
                this.updateReadTransferStatus(false);
                this.readAsyncCount = 0;
                this.readingFromHardware = false;
                this.readAsyncStartTime = InstrumentAsync.nanoBadTime();
                this.executeErrorEvent(Calendar.getInstance(), this.getErrorMessageFromHardware(n2));
            }
        }
        catch (TMException tMException) {
            tMException.printStackTrace();
        }
    }

    protected void pollingReadActionSuccess(int n) {
        try {
            this.hardwareStopAsync();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            byte[] byArray = this.readAsynchronousDataFromHardware(n);
            int n2 = this.bytesAvailable;
            this.inputBuffer.addData(byArray, 1);
            this.bytesAvailable = this.inputBuffer.getBytesAvailable();
            this.checkForBytesAvailableEvents(byArray, n2);
            byArray = null;
            this.updateReadTransferStatus(false);
            this.readAsyncCount = 0;
            this.readingFromHardware = false;
            this.readAsyncStartTime = InstrumentAsync.nanoBadTime();
        }
        catch (TMException tMException) {
            tMException.printStackTrace();
        }
    }

    protected void pollingReadAsyncModeAction(int n) {
        int n2 = this.bytesAvailable;
        try {
            byte[] byArray = this.readAsynchronousDataFromHardware(n);
            this.bytesAvailable = this.inputBuffer.getBytesAvailable();
            if (!this.ignoreReadEvents) {
                this.checkForBytesAvailableEvents(byArray, n2);
            }
        }
        catch (TMException tMException) {
            tMException.printStackTrace();
        }
    }

    protected void pollingReadActionSize(int n) {
        try {
            this.hardwareStopAsync();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            byte[] byArray = this.readAsynchronousDataFromHardware(n);
            int n2 = this.bytesAvailable;
            this.inputBuffer.addData(byArray, 0);
            this.bytesAvailable = this.inputBuffer.getBytesAvailable();
            this.checkForBytesAvailableEvents(byArray, n2);
            this.readAsyncCount -= byArray.length;
            byArray = null;
            if (this.readAsyncCount == 0) {
                this.updateReadTransferStatus(false);
                this.readAsyncStartTime = InstrumentAsync.nanoBadTime();
            }
            this.readingFromHardware = false;
        }
        catch (TMException tMException) {
            tMException.printStackTrace();
        }
    }

    protected void checkForBytesAvailableEvents(byte[] byArray, int n) {
        if (this.bytesAvailableFcn.equals(ACTION)) {
            return;
        }
        switch (this.bytesAvailableFcnMode) {
            case 0: {
                try {
                    int n2 = this.okToGenerateTerminatorBytesAvailableEvent(byArray);
                    for (int i = 0; i < n2; ++i) {
                        this.generateBytesAvailableEvent();
                    }
                    break;
                }
                catch (TMException tMException) {
                    tMException.printStackTrace();
                }
            }
            case 1: {
                int n3 = this.okToGenerateSizeBytesAvailableEvent(n);
                for (int i = 0; i < n3; ++i) {
                    this.generateBytesAvailableEvent();
                }
                break;
            }
        }
    }

    protected int okToGenerateSizeBytesAvailableEvent(int n) {
        return (this.bytesAvailable - n / this.bytesAvailableFcnCount * this.bytesAvailableFcnCount) / this.bytesAvailableFcnCount;
    }

    protected void generateBytesAvailableEvent() {
        this.eventTime = Calendar.getInstance();
        this.executeEvent(1, "BytesAvailable", this.eventTime, new ICEvent("BytesAvailable", InstrumentAsync.constructClockVector(this.eventTime)));
    }

    public int GetOutputDataType() {
        return this.outputDataType;
    }

    public void SetOutputDataType(int n) {
        this.outputDataType = n;
    }

    public void pollingWrite() {
        try {
            int n = this.getIntFromOutputVector();
            this.SetOutputDataType(n);
            Object object = this.getObjectFromOutputVector();
            byte[] byArray = this.breakDownToBytes(object, n);
            int n2 = this.writeBinaryToHardwareAsync(byArray);
            if (n2 < this.getSuccessValue()) {
                this.transferStatus = 0;
                this.bytesToOutput = 0;
                this.valuesSent += (long)this.valuesToOutput;
                this.executeErrorEvent(Calendar.getInstance(), this.getErrorMessageFromHardware(n2));
            } else {
                this.writeAsyncStartTime = InstrumentAsync.currentNanoTicTime();
                this.valuesToOutput = byArray.length / DATASIZE[n];
                this.bytesToOutput = byArray.length;
            }
        }
        catch (Exception exception) {
            this.executeErrorEvent(Calendar.getInstance(), "An error occurred while writing.");
            return;
        }
    }

    public void pollingWriteAction() {
        try {
            this.hardwareStopAsync();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bytesToOutput = 0;
        this.valuesSent += (long)this.valuesToOutput;
        if (!this.outputEmptyFcn.equals(ACTION)) {
            this.eventTime = Calendar.getInstance();
            this.executeEvent(4, "OutputEmpty", this.eventTime, new ICEvent("OutputEmpty", InstrumentAsync.constructClockVector(this.eventTime)));
        }
        this.transferStatus = 0;
    }

    public void pollingWriteAsyncBlockAction(int n) {
        this.writeAsyncData(n);
    }

    protected void writeAsyncData(int n) {
    }

    public void interruptAction() {
    }

    public void triggerAction(int n) {
    }

    public void checkForAsynchronousTimeouts() {
        if (InstrumentAsync.nanoTicTimeout(this.writeAsyncStartTime, this.timeout) && (this.transferStatus == 2 || this.transferStatus == 3) && this.bytesToOutput > 0) {
            this.stopHardwareDueToWriteTimeout();
            this.bytesToOutput = 0;
            this.updateWriteTransferStatus(false);
            this.executeErrorEvent(Calendar.getInstance(), "The asynchronous write operation timed out.");
        }
        if (this.ignoreReadEvents) {
            return;
        }
        if (InstrumentAsync.nanoTicTimeout(this.readAsyncStartTime, this.timeout) && this.readAsyncCount > 0) {
            this.stopHardwareDueToReadTimeout();
            this.readAsyncCount = 0;
            this.readAsyncStartTime = InstrumentAsync.nanoBadTime();
            this.updateReadTransferStatus(false);
            this.readingFromHardware = false;
            if (this.okToGenerateReadAsyncTimeoutEvents()) {
                this.executeErrorEvent(Calendar.getInstance(), "The asynchronous read operation timed out.");
            }
        }
    }

    protected boolean okToGenerateReadAsyncTimeoutEvents() {
        return true;
    }

    protected void stopHardwareDueToReadTimeout() {
        try {
            this.hardwareStopAsync();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void stopHardwareDueToWriteTimeout() {
        try {
            this.hardwareStopAsync();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected byte[] breakDownToBytes(Object object, int n) throws Exception {
        byte[] byArray = null;
        byArray = platformByteOrder != this.byteOrder ? BinarySwapBytes.breakdownToBytesAndSwap(object, n) : BinarySwapBytes.breakdownToBytes(object, n);
        return byArray;
    }

    @Override
    protected boolean supportReadAsyncMode() {
        return false;
    }

    @Override
    protected boolean isReadAsyncOperationComplete(int n, int n2) {
        return this.getBytesAvailable() >= n || this.readAsyncCount == 0 || this.inputBuffer.isReadComplete(2, 1);
    }

    protected void updateReadTransferStatus(boolean bl) {
        this.transferStatus = bl ? 1 : 0;
    }

    @Override
    protected void addToPoller() {
        Poller.addInstrument(this);
        if (this.timerFcn == ACTION) {
            return;
        }
        if (!this.wasTimerStarted) {
            this.createTimer();
        } else {
            this.timer.setDelay((int)(this.timerPeriod * 1000.0));
            this.timer.reset();
        }
    }

    protected abstract int getAsyncActionType(int var1, int var2);

    protected abstract int writeBinaryToHardwareAsync(byte[] var1) throws TMException;

    protected abstract int readBinaryFromHardwareAsync(int var1) throws TMException;

    protected abstract byte[] readAsynchronousDataFromHardware(int var1) throws TMException;

    protected abstract void hardwareStopAsync() throws Exception;

    protected abstract void verifyReadOperation() throws TMException;

    protected abstract int okToGenerateTerminatorBytesAvailableEvent(byte[] var1) throws TMException;
}

