/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.ICProp;
import com.mathworks.toolbox.instrument.Poller;
import com.mathworks.toolbox.instrument.VISA;
import com.mathworks.toolbox.instrument.Vxi;
import com.mathworks.toolbox.instrument.events.ICEvent;
import com.mathworks.toolbox.instrument.util.DefaultICProp;
import com.mathworks.toolbox.instrument.util.Displays;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import com.mathworks.util.Timer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Vector;

public final class VxiGpibVisa
extends Vxi
implements ActionListener {
    private int boardIndex = 0;
    private int primaryAddress = 0;
    private int secondaryAddress = 0;
    private VISA visa;
    private int defaultRM;
    static ICProp[] objectICProps = new ICProp[]{new ICProp("Alias", "string", "none", "", "", "always", 1, 0), new ICProp("BoardIndex", "double", "none", "", "", "always", 1, 0), new ICProp("ByteOrder", "string", "enum", byteOVals, "littleEndian", "never", 0, 0), new ICProp("BytesAvailableFcnMode", "string", "enum", dModeVals, "eosCharCode", "whileOpen", 0, 0), new ICProp("ChassisIndex", "double", "none", "", "", "whileopen", 1, 0), new ICProp("CompareBits", "double", "bounded", comVals, new Integer(8), "never", 1, 2), new ICProp("EOIMode", "string", "enum", boolVals, "on", "never", 1, 0), new ICProp("EOSCharCode", "ASCII Value", "ASCII Value", AsciiVals, "LF", "never", 1, 0), new ICProp("EOSMode", "string", "enum", EOSMVals, "none", "never", 1, 0), new ICProp("LogicalAddress", "double", "none", "", new Integer(0), "whileOpen", 1, 0), new ICProp("MappedMemoryBase", "string", "none", "", "0H", "always", 1, 0), new ICProp("MappedMemorySize", "double", "none", "", new Integer(0), "always", 1, 0), new ICProp("MemoryBase", "string", "none", "", "0H", "always", 1, 0), new ICProp("MemoryIncrement", "string", "enum", MIncVals, "block", "never", 1, 0), new ICProp("MemorySize", "double", "none", "", new Integer(0), "always", 1, 0), new ICProp("MemorySpace", "string", "enum", MSpVals, "A16", "always", 1, 0), new ICProp("PrimaryAddress", "double", "none", "", "", "always", 1, 0), new ICProp("RsrcName", "string", "none", "", "", "always", 1, 0), new ICProp("SecondaryAddress", "double", "none", "", "", "always", 1, 0), new ICProp("Slot", "double", "none", "", new Integer(0), "always", 1, 0), new ICProp("Type", "string", "none", "", "visa-gpib-vxi", "always", 0, 0)};

    public VxiGpibVisa() {
        this.deleteInstrumentObject(this);
    }

    public VxiGpibVisa(String string, String string2, String string3, String string4) throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            VxiGpibVisa.displayError("Undefined function or variable 'visa'.");
        }
        try {
            this.rsrcName = this.visaName = string3;
            try {
                this.parseName(this.visaName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.alias = string4;
            this.useAlias = !this.alias.equals("");
            this.info[0] = string + FILESEP + string2;
            this.info[1] = VxiGpibVisa.jarVersion();
            this.info[2] = this.getVendorName(string2);
            this.visa = VISA.createVisaObject((String)this.info[2], (String)this.info[0]);
            this.name = "VISA-GPIB-VXI" + this.chassisIndex + "-" + this.logicalAddress;
            this.type = "visa-gpib-vxi";
            this.objectProps = DefaultICProp.addObjectProps(objectICProps);
            this.displayName = "VISA-GPIB-VXI";
            this.visaobj = this.visa;
            this.objectPolls = this.visa.VerifyAsyncVISARead();
        }
        catch (Exception exception) {
            this.deleteInstrumentObject(this);
            throw new TMException(exception.getMessage());
        }
    }

    public String getInspectorToolbarObjectName() {
        return "VISA-GPIB-VXI";
    }

    @Override
    public Object[] getNonDefaultPVPairs() {
        Vector<Comparable<?>> vector = this.getPVPairs();
        this.addPVPair(vector, "CompareBits", this.compareBits);
        this.addPVPair(vector, "EOIMode", this.bool2OnOff(this.eoiMode));
        this.addPVPair(vector, "EOSMode", EOSMODES[this.eosMode]);
        this.addPVPair(vector, "MemoryIncrement", MEMINC[this.memoryIncrement]);
        if (this.bytesAvailableFcnMode == 1) {
            vector.addElement((Comparable<?>)((Object)"BytesAvailableFcnMode"));
            vector.addElement((Comparable<?>)((Object)"byte"));
        }
        if (this.eosCharCode != 10) {
            vector.addElement((Comparable<?>)((Object)"EOSCharCode"));
            vector.addElement(new Integer(this.eosCharCode));
        }
        Object[] objectArray = new Object[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            objectArray[i] = vector.elementAt(i);
        }
        return objectArray;
    }

    public void setBoardIndex(int n) throws TMException {
        VxiGpibVisa.displayError(this.createReadOnlyPropertyError("BoardIndex"));
    }

    public int getBoardIndex() {
        return this.boardIndex;
    }

    public void setPrimaryAddress(int n) throws TMException {
        VxiGpibVisa.displayError(this.createReadOnlyPropertyError("PrimaryAddress"));
    }

    public int getPrimaryAddress() {
        return this.primaryAddress;
    }

    public void setSecondaryAddress(int n) throws TMException {
        VxiGpibVisa.displayError(this.createReadOnlyPropertyError("SecondaryAddress"));
    }

    public int getSecondaryAddress() {
        return this.secondaryAddress;
    }

    @Override
    protected void nameStandardFormat() {
        this.nameStandardFormat = this.name.equals("VISA-GPIB-VXI" + this.chassisIndex + "-" + this.logicalAddress);
    }

    @Override
    protected final void updateNameProperties() {
        this.rsrcName = "GPIB-VXI" + this.chassisIndex + "::" + this.logicalAddress + "::INSTR";
        if (this.nameStandardFormat) {
            this.setName("VISA-GPIB-VXI" + this.chassisIndex + "-" + this.logicalAddress);
        }
    }

    private void parseName(String string) {
        int n = string.indexOf("::");
        if (n == -1) {
            return;
        }
        this.chassisIndex = n == 8 ? 0 : this.str2num(string.substring(8, n));
        if (this.chassisIndex < 0) {
            return;
        }
        String string2 = string.substring(n + 2, string.length());
        if ((n = string2.indexOf("::")) == -1) {
            return;
        }
        this.logicalAddress = this.str2num(string2.substring(0, n));
        if (this.logicalAddress < 0) {
            return;
        }
        if (!(string2 = string2.substring(n + 2, string2.length())).toUpperCase().equals("INSTR")) {
            return;
        }
        this.rsrcName = "GPIB-VXI" + this.chassisIndex + "::" + this.logicalAddress + "::INSTR";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.eventTime = Calendar.getInstance();
        if (this.timerFcn != ACTION) {
            this.executeEvent(6, "Timer", this.eventTime, new ICEvent("Timer", VxiGpibVisa.constructClockVector(this.eventTime)));
        }
    }

    @Override
    protected void createTimer() {
        this.timer = new Timer((int)(this.timerPeriod * 1000.0), (ActionListener)this, 1, 5, "VxiGpibVisaTimer");
        this.timer.start();
        this.wasTimerStarted = true;
    }

    @Override
    protected void openHardware() throws TMException {
        int[] nArray;
        if (this.isInUse()) {
            VxiGpibVisa.displayError("The specified configuration: " + this.rsrcName + " is not available. " + LINESEP + "Use INSTRHWINFO for a list of available configurations." + " Use INSTRFIND to " + LINESEP + "determine if other instrument " + "objects are connected to the requested instrument.");
        }
        if ((nArray = this.visa.Create(this, this.rsrcName)) != null) {
            this.handle = nArray[0];
            this.defaultRM = nArray[1];
            int n = this.visa.Get(this.handle, 210);
            if (n >= 0) {
                this.boardIndex = n;
            }
            if ((n = this.visa.Get(this.handle, 211)) >= 0) {
                this.primaryAddress = n;
            }
            if ((n = this.visa.Get(this.handle, 212)) >= 0) {
                this.secondaryAddress = n;
            }
            this.getPropertyValuesUponConnecting();
        } else {
            VxiGpibVisa.displayError("Could not open VISA object. Use INSTRHWINFO for a list of available configurations.");
        }
        Object[] objectArray = this.visa.GetAliasInfo(this.visaName);
        if (objectArray != null) {
            this.parseName((String)objectArray[1]);
        }
    }

    @Override
    protected void closeHardware() throws TMException {
        int n;
        if (this.objectPolls) {
            Poller.removeInstrument(this);
        }
        if (this.wasTimerStarted) {
            this.timer.hold();
        }
        if (this.mappedMemorySize != 0) {
            this.visa.UnMapAddress(this.handle);
            this.mappedMemorySize = 0;
            this.mappedMemoryBase = "0H";
        }
        if ((n = this.visa.Close(this.handle, this.defaultRM)) < 0) {
            VxiGpibVisa.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n));
        }
    }

    @Override
    protected void updatePropsOnOpen() throws TMException {
        String[] stringArray = new String[7];
        int n = 0;
        this.eosCharByteArray[0] = (byte)this.eosCharCode;
        try {
            this.setHardwareEOIMode(this.eoiMode);
        }
        catch (Exception exception) {
            stringArray[n++] = "EOIMode";
        }
        try {
            this.setHardwareEOSMode(this.eosMode);
        }
        catch (Exception exception) {
            stringArray[n++] = "EOSMode";
        }
        try {
            this.setHardwareEOSChar(this.eosCharCode);
        }
        catch (Exception exception) {
            stringArray[n++] = "EOSCharCode";
        }
        try {
            this.setHardwareMemoryIncrement(this.memoryIncrement);
        }
        catch (Exception exception) {
            stringArray[n++] = "MemoryIncrement";
        }
        try {
            this.setHardwareTimeout(this.timeout);
            this.timeout = this.getHardwareTimeout();
        }
        catch (Exception exception) {
            stringArray[n++] = "Timeout";
        }
        if (n == 0) {
            return;
        }
        TMStringUtil.warning((String)this.constrctUpdatePropsOnOpenWarning(stringArray));
    }

    private boolean isInUse() {
        for (int i = 0; i < allInstrumentObjects.size(); ++i) {
            Object e = allInstrumentObjects.elementAt(i);
            if (!(e instanceof VxiGpibVisa)) continue;
            VxiGpibVisa vxiGpibVisa = (VxiGpibVisa)e;
            if (!(vxiGpibVisa.rsrcName.equals(this.rsrcName) & vxiGpibVisa.status == 1)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void disposeMLArrayRefs() {
        this.superDisposeMLArrayRef();
        if (this.timer != null) {
            this.timer.removeActionListener((ActionListener)this);
        }
    }

    @Override
    public char spoll(int n) throws TMException {
        return this.visa.spoll(this.handle, n, this.getHardwareTimeout());
    }

    @Override
    protected void updateObjectSpecificProperties(ICProp[] iCPropArray) {
        for (int i = 0; i < iCPropArray.length; ++i) {
            String string = iCPropArray[i].name;
            if (string.equals("BoardIndex")) {
                iCPropArray[i].setDefaultValue(new Integer(this.boardIndex));
                continue;
            }
            if (string.equals("ChassisIndex")) {
                iCPropArray[i].setDefaultValue(new Integer(this.chassisIndex));
                continue;
            }
            if (string.equals("LogicalAddress")) {
                iCPropArray[i].setDefaultValue(new Integer(this.logicalAddress));
                continue;
            }
            if (string.equals("Name")) {
                iCPropArray[i].setDefaultValue("VISA-GPIB-VXI" + this.chassisIndex + "-" + this.logicalAddress);
                continue;
            }
            if (string.equals("PrimaryAddress")) {
                iCPropArray[i].setDefaultValue(new Integer(this.primaryAddress));
                continue;
            }
            if (string.equals("RsrcName")) {
                iCPropArray[i].setDefaultValue(this.rsrcName);
                continue;
            }
            if (string.equals("Alias")) {
                iCPropArray[i].setDefaultValue(this.alias);
                continue;
            }
            if (!string.equals("SecondaryAddress")) continue;
            iCPropArray[i].setDefaultValue(new Integer(this.secondaryAddress));
        }
    }

    public static ICProp[] getProperties() {
        return DefaultICProp.addObjectProps(objectICProps);
    }

    @Override
    public String display() {
        if (!this.isvalid()) {
            return Displays.invalidDisplay();
        }
        return LINESEP + "   VISA-GPIB-VXI Object Using " + this.info[2] + " Adaptor : " + this.name + LINESEP + LINESEP + "   Communication Address " + LINESEP + "      ChassisIndex:       " + this.chassisIndex + LINESEP + "      LogicalAddress:     " + this.logicalAddress + LINESEP + LINESEP + "   Communication State " + LINESEP + "      Status:             " + STATUS_ENUM[this.status] + LINESEP + "      RecordStatus:       " + RECORD_STATUS_ENUM[this.bool2int(this.recordStatus)] + LINESEP + LINESEP + "   Read/Write State  " + LINESEP + "      TransferStatus:     " + TRANSFER_STATUS_ENUM[this.transferStatus] + LINESEP + "      BytesAvailable:     " + this.bytesAvailable + LINESEP + "      ValuesReceived:     " + this.getValuesReceived() + LINESEP + "      ValuesSent:         " + this.getValuesSent() + LINESEP + " " + LINESEP;
    }

    @Override
    public String setDisplay() {
        return Displays.getSetDisplay() + "    VISA-GPIB-VXI specific properties:" + LINESEP + "    ChassisIndex" + LINESEP + "    EOIMode: [ {on} | off ]" + LINESEP + "    EOSCharCode" + LINESEP + "    EOSMode: [ {none} | read | write | read&write ]" + LINESEP + "    LogicalAddress" + LINESEP + "    MemoryIncrement [ {block} | FIFO ] " + LINESEP + " " + LINESEP;
    }
}

