/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser;

import com.mathworks.common.icons.ApplicationIcon;
import com.mathworks.common.icons.FileTypeIcon;
import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.InstrumentObjectListener;
import com.mathworks.toolbox.instrument.PropertyChangedListener;
import com.mathworks.toolbox.instrument.SerialComm;
import com.mathworks.toolbox.instrument.browser.DriverTablePage;
import com.mathworks.toolbox.instrument.browser.ICTBrowserDesktop;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowserPage;
import com.mathworks.toolbox.instrument.browser.ObjectTablePage;
import com.mathworks.toolbox.instrument.browser.ScanOptionPanel;
import com.mathworks.toolbox.instrument.browser.deviceobj.DeviceObjectPage;
import com.mathworks.toolbox.instrument.browser.deviceobj.DeviceObjectPageInfo;
import com.mathworks.toolbox.instrument.browser.driver.CreateObjectDialog;
import com.mathworks.toolbox.instrument.browser.driver.DriverPage;
import com.mathworks.toolbox.instrument.browser.driver.DriverPageInfo;
import com.mathworks.toolbox.instrument.browser.driver.IVIPage;
import com.mathworks.toolbox.instrument.browser.driver.MLDriverPageInfo;
import com.mathworks.toolbox.instrument.browser.hardware.BluetoothHardwarePage;
import com.mathworks.toolbox.instrument.browser.hardware.BoardPage;
import com.mathworks.toolbox.instrument.browser.hardware.GPIBPage;
import com.mathworks.toolbox.instrument.browser.hardware.GPIBVXIPage;
import com.mathworks.toolbox.instrument.browser.hardware.NetworkPage;
import com.mathworks.toolbox.instrument.browser.hardware.PXIPage;
import com.mathworks.toolbox.instrument.browser.hardware.SerialHardwarePage;
import com.mathworks.toolbox.instrument.browser.hardware.VXIPage;
import com.mathworks.toolbox.instrument.browser.hardware.VisaMorePage;
import com.mathworks.toolbox.instrument.browser.hardware.VisaTCPIPPage;
import com.mathworks.toolbox.instrument.browser.hardware.VisaUSBPage;
import com.mathworks.toolbox.instrument.browser.interfaceobj.CommunicationInfo;
import com.mathworks.toolbox.instrument.browser.interfaceobj.CommunicationInfoStore;
import com.mathworks.toolbox.instrument.browser.interfaceobj.CommunicationPage;
import com.mathworks.toolbox.instrument.browser.ivicWrapper.IviCClassCompliantInstrumentTablePage;
import com.mathworks.toolbox.instrument.browser.ivicWrapper.IviCInstrumentObjectStore;
import com.mathworks.toolbox.instrument.browser.objects.BrowserObject;
import com.mathworks.toolbox.instrument.device.Device;
import com.mathworks.toolbox.instrument.device.DeviceClient;
import com.mathworks.toolbox.instrument.device.DeviceObjectListener;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.MIDTool;
import com.mathworks.toolbox.instrument.device.icdevice.ICDevice;
import com.mathworks.toolbox.instrument.guiutil.ICSaveDialog;
import com.mathworks.toolbox.instrument.guiutil.InstrumentObjectExporter;
import com.mathworks.toolbox.instrument.guiutil.NewObjectDialog;
import com.mathworks.toolbox.instrument.guiutil.ToolboxHelpRunnable;
import com.mathworks.toolbox.testmeas.browser.BaseBrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserConfigFileReader;
import com.mathworks.toolbox.testmeas.browser.BrowserConfigFileWriter;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import com.mathworks.toolbox.testmeas.browser.TreeViewListener;
import com.mathworks.toolbox.testmeas.guiutil.AboutWindow;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InstrumentControlBrowser
extends BaseBrowserClient
implements Runnable,
com.mathworks.toolbox.instrument.device.PropertyChangedListener,
PropertyChangedListener,
BrowserClient,
DeviceObjectListener,
InstrumentObjectListener,
ActionListener {
    private static ImageIcon sMatlabImage = ApplicationIcon.MATLAB.getIcon();
    private static ImageIcon sHwImage = new ImageIcon(InstrumentControlBrowser.class.getResource("/com/mathworks/toolbox/instrument/resources/hardware.gif"));
    private static ImageIcon sObjsImage = new ImageIcon(InstrumentControlBrowser.class.getResource("/com/mathworks/toolbox/instrument/resources/instr_obj.gif"));
    private static ImageIcon sObjImage = new ImageIcon(InstrumentControlBrowser.class.getResource("/com/mathworks/toolbox/instrument/resources/instrument.gif"));
    private static ImageIcon sSerialImage = new ImageIcon(InstrumentControlBrowser.class.getResource("/com/mathworks/toolbox/instrument/resources/serial.gif"));
    private static ImageIcon sBluetoothImage = new ImageIcon(InstrumentControlBrowser.class.getResource("/com/mathworks/toolbox/instrument/resources/network.gif"));
    private static ImageIcon sGpibImage = new ImageIcon(InstrumentControlBrowser.class.getResource("/com/mathworks/toolbox/instrument/resources/boardicon.gif"));
    private static ImageIcon sVxiImage = new ImageIcon(InstrumentControlBrowser.class.getResource("/com/mathworks/toolbox/instrument/resources/chassis.gif"));
    private static ImageIcon sPxiImage = new ImageIcon(InstrumentControlBrowser.class.getResource("/com/mathworks/toolbox/instrument/resources/chassis.gif"));
    private static ImageIcon sNetworkImage = new ImageIcon(InstrumentControlBrowser.class.getResource("/com/mathworks/toolbox/instrument/resources/network.gif"));
    private static ImageIcon sUsbImage = new ImageIcon(InstrumentControlBrowser.class.getResource("/com/mathworks/toolbox/instrument/resources/usb.gif"));
    private static ImageIcon sDriverImage = FileTypeIcon.GENERIC.getIcon();
    public static final int ROOT = 0;
    public static final int HARDWARE_LEVEL = 1;
    public static final int INTERFACE_NODE = 2;
    public static final int INTERFACE_NODE_2 = 3;
    public static final int BROWSER_OBJECT = 4;
    public static final int INSTRUMENT_OBJECT_LEVEL = 5;
    public static final int INTERFACE_OBJECT_LEVEL = 6;
    public static final int DEVICE_OBJECT_LEVEL = 7;
    public static final int INTERFACE_OBJECT = 8;
    public static final int INSTRUMENT_DRIVER_LEVEL = 9;
    public static final int DEVICE_OBJECT = 10;
    public static final int MATLAB_DRIVER_TABLE_PAGE = 11;
    public static final int VXIPNP_DRIVER_TABLE_PAGE = 12;
    public static final int IVI_PAGE = 13;
    public static final int MATLAB_DRIVER_PAGE = 14;
    public static final int VXIPNP_DRIVER_PAGE = 15;
    public static final int EMPTY_PAGE = 16;
    public static final int IVIC_INSTRUMENT_TABLE_PAGE = 17;
    public static final int IVIC_INSTRUMENT_PAGE = 18;
    public static final int IVIC_INSTRUMENT_OBJECT_PAGE = 19;
    public static final String ACTION = "ACTION";
    public static final String OBJECT = "OBJECT";
    public static final String PANEL = "PANEL";
    private static final int ICHELP = 0;
    private static final int ICABOUT = 1;
    private static final int SHOW_HARDWARE = 2;
    private static final int SHOW_INSTRUMENT_OBJECT = 3;
    private static final int SHOW_INSTRUMENT_DRIVER = 4;
    private static final int NEW_OBJECT = 5;
    private static final int SCAN = 6;
    private static final int EXPORT_OBJECT = 7;
    public static final int SAVE_COMMUNICATION = 8;
    private static final int DELETE_OBJECT = 9;
    private static final int EXPORT_HISTORY = 10;
    private static final int EXPORT_ALL_OBJECTS = 11;
    private static final int DELETE_ALL_OBJECTS = 12;
    private static final int RIGHT_CLICK_SCAN = 13;
    private static final int EXPORT_OBJECT_MENU = 14;
    private static final int SCAN_OPTIONS = 15;
    private static final int SCAN_DRIVER = 16;
    private static final int CREATE_DRIVER = 17;
    private static final int EDIT_DRIVER = 18;
    private static final int IDENTIFY_NETWORK = 19;
    private static final int CREATE_OBJ_DRIVER = 20;
    private static final int REMOVE_DUPLICATES = 21;
    private static final int SAVE_AS_CONFIG_STORE = 22;
    private static final int SAVE_CONFIG_STORE = 23;
    private static final int LOAD_CONFIG_STORE = 24;
    private static final int COPY_RESOURCE = 25;
    private static final int SCAN_VISA = 26;
    private static final int DELETE_IVICINSTRUMENT_OBJ = 27;
    private static final int RENAME_IVICINSTRUMENT_OBJ = 28;
    private static final int HW_SERIAL = 0;
    private static final int HW_GPIB = 1;
    private static final int HW_TCP = 2;
    private static final int HW_UDP = 3;
    private static final int HW_VXI = 4;
    private static final int HW_GPIB_VXI = 5;
    private static final int HW_VXI_11 = 6;
    private static final int HW_USB = 7;
    private static final int HW_PXI = 8;
    private static final int HW_VISAMORE = 9;
    private static final int HW_BLUETOOTH = 10;
    public static final Integer ALL = new Integer(0);
    public static final Integer MATLAB = new Integer(1);
    public static final Integer VXIPNP = new Integer(2);
    public static final Integer IVI = new Integer(3);
    private static final Integer INSTRUMENT_OBJECT_LEVEL_INT = new Integer(5);
    private static final Integer INTERFACE_OBJECT_LEVEL_INT = new Integer(6);
    private static final Integer DEVICE_OBJECT_LEVEL_INT = new Integer(7);
    private BrowserTreeNode fRootNode = new BrowserTreeNode("Instrument Control Toolbox", (BrowserClient)this);
    private BrowserTreeNode fLevel1 = new BrowserTreeNode("Hardware", (BrowserClient)this);
    private BrowserTreeNode fLevel2 = new BrowserTreeNode("Instrument Objects", (BrowserClient)this);
    private BrowserTreeNode fLevel3 = new BrowserTreeNode("Instrument Drivers", (BrowserClient)this);
    public static final String fIviInstruments = "IVI Instruments";
    private BrowserTreeNode IviCInstrumentsNode = new BrowserTreeNode("IVI Instruments", (BrowserClient)this);
    private BrowserTreeNode[] fLevelNodes;
    private BrowserTreeNode fInterfaceObjectNode;
    private BrowserTreeNode fDeviceObjectNode;
    private BrowserTreeNode fMatlabDriverNode;
    private BrowserTreeNode fVxipnpDriverNode;
    private BrowserTreeNode fIviNode;
    private BrowserTreeNode fSerialNode;
    private BrowserTreeNode fBluetoothNode;
    public static boolean bluetoothSupportInTMTOOL = true;
    private BrowserTreeNode fGpibNode;
    private BrowserTreeNode fTcpipNode;
    private BrowserTreeNode fUdpNode;
    private BrowserTreeNode fVisaNode;
    private BrowserTreeNode fVxiNode;
    private BrowserTreeNode fGpibVxiNode;
    private BrowserTreeNode fVisaTcpipNode;
    private BrowserTreeNode fVisaUsbNode;
    private BrowserTreeNode fPxiNode;
    private BrowserTreeNode fvisaMoreNode;
    private static final int HARDWARE_PAGE_COUNT = 11;
    private InstrumentControlBrowserPage[] fHardwarePages;
    private ObjectTablePage fObjectTablePage;
    private DriverTablePage fDriverTablePage = null;
    private IVIPage fIviPage;
    private IviCClassCompliantInstrumentTablePage fIviCInstrumentTablePage;
    private CommunicationInfoStore fCommunicationInfoStore = null;
    private boolean fNodeEventsEnable = true;
    private String[] fAvailablePorts;
    private boolean fOkToAddInstrumentObjects = true;
    private Vector<BrowserTreeNode> fInstrumentObjectsToAdd = new Vector();
    private Vector<Object> fInstrumentObjectsToRemove = new Vector();
    private Vector<Object> fAllInterfaceObjects = new Vector();
    private Vector<Object> fAllDeviceObjects = new Vector();
    private MJMenu[] fMenus = null;
    private MJMenuItem fCopyIntrumentResourse = new MJMenuItem("Copy Resource...");
    private MJMenuItem fExportInstrumentObject = new MJMenuItem("Export Object...");
    private MJMenuItem fSaveCommunication = new MJMenuItem("Save Session Log...");
    private MJMenuItem fDeleteObject = new MJMenuItem("Delete Object");
    private MJMenuItem fExportHistory = new MJMenuItem("Export Instrument Response(s)...");
    private MJMenuItem fScanVisa = new MJMenuItem("Scan VISA resources...");
    private MJMenuItem fNewObject = new MJMenuItem("Create New Instrument Object...");
    private MJMenuItem fExportObjects = new MJMenuItem("Export Instrument Object(s)...");
    private MJMenuItem fDeleteObjects = new MJMenuItem("Delete Instrument Object(s)");
    private MJMenuItem fScanForDriver = new MJMenuItem("Scan For Instrument Drivers");
    private MJMenuItem fScanForHardware = new MJMenuItem("Scan for serial instruments");
    private MJMenuItem fCreateDeviceObject = new MJMenuItem("Create Device Object Using Driver...");
    private MJMenuItem editDriver = new MJMenuItem("Edit MATLAB Instrument Driver...");
    private JMenuItem fDeleteIVICInstrumentObject = new JMenuItem("Delete IVI Instrument Object ...");
    private JMenuItem fRenameIVICInstrumentObject = new JMenuItem("Rename IVI Instrument Object");
    private MJMenuItem fSaveAsConfigStore = new MJMenuItem("Save IVI Configuration Store As...");
    private MJMenuItem fSaveConfigStore = new MJMenuItem("Save IVI Configuration Store");
    private MJMenuItem fLoadConfigStore = new MJMenuItem("Load IVI Configuration Store...");
    private MJMenuItem fIdentifyNetworkInstruments = new MJMenuItem("Identify instruments");
    private MJMenuItem fIdentifyBluetooth = new MJMenuItem("Identify Bluetooth devices");
    private MJMenuItem fInstrumentNodeObjectMenu;
    private MJMenuItem fInstrumentNodeExportComm;
    private MJMenuItem fInstrumentNodeSaveComm;
    private MJMenuItem fInstrumentChildNodeObjectMenu;
    private MJMenuItem fInstrumentChildNodeExportComm;
    private MJMenuItem fInstrumentChildNodeSaveComm;
    private MJMenuItem fInstrumentChildNodeDeleteMenu;
    private MJMenuItem saveConfigurationStoreMenu;
    private MJMenu[] fInstrumentObjectNodeMenusToInsert = null;
    private MJMenu[] fInstrumentObjectChildNodeMenusToInsert = null;
    private MJMenu[] fIndividualMLDriverNodeMenusToInsert = null;
    private MJMenu[] fIndividualDriverNodeMenusToInsert = null;
    private MJMenu[] fInstrumentNodeMenusToInsert = null;
    private MJMenu[] fIviNodeMenusToInsert = null;
    public MJMenu[] fCurrentMenu = null;
    private MJMenuItem fEditMLDriverMenu;
    private MJMenuItem fCreateMLDeviceObjMenu;
    private MJMenuItem fRemoveDuplicatesMenu;
    private CreateObjectDialog fCreateObjectFromDriverDialog;
    private Object[] fMatlabArgs = new Object[]{"privateDisconnect", ""};
    private NewObjectDialog fNewObjectDialog = null;
    private Hashtable<String, BrowserTreeNode> fHardwareInstrumentNodes = new Hashtable();
    public Hashtable<Instrument, BrowserTreeNode> fInstrumentObjectNodes = new Hashtable();
    private boolean fFullScan = false;
    private int fNextScanType;
    private static boolean sVisaSupported = false;
    private String[] fVisaPorts;
    private static boolean sLinux = false;
    private static boolean sWindows = true;
    private ToolboxHelpRunnable fToolboxHelpRunnable = null;
    private TreeViewListener fTreeViewListener;
    private BrowserTreeNode selectedNode;
    private BrowserTreeNode lastDeviceObjectNode = null;

    public InstrumentControlBrowser() {
        this.fCommunicationInfoStore = new CommunicationInfoStore();
        Device.addDeviceObjectListener(this);
        Device.addPropertyChangedListener(this);
        Instrument.addInstrumentObjectListener(this);
        Instrument.addPropertyChangedListener(this);
    }

    public void save(BrowserConfigFileWriter browserConfigFileWriter, Element element) {
        if (!sLinux) {
            ((BluetoothHardwarePage)((Object)this.fBluetoothNode.getPanel())).save(browserConfigFileWriter, element);
        }
        ((SerialHardwarePage)((Object)this.fSerialNode.getPanel())).save(browserConfigFileWriter, element);
        ((NetworkPage)((Object)this.fTcpipNode.getPanel())).save(browserConfigFileWriter, element);
        ((NetworkPage)((Object)this.fUdpNode.getPanel())).save(browserConfigFileWriter, element);
        ((GPIBPage)((Object)this.fGpibNode.getPanel())).save(browserConfigFileWriter, element);
        ((VXIPage)((Object)this.fVxiNode.getPanel())).save(browserConfigFileWriter, element);
        ((GPIBVXIPage)((Object)this.fGpibVxiNode.getPanel())).save(browserConfigFileWriter, element);
        ((VisaTCPIPPage)((Object)this.fVisaTcpipNode.getPanel())).save(browserConfigFileWriter, element);
        ((VisaUSBPage)((Object)this.fVisaUsbNode.getPanel())).save(browserConfigFileWriter, element);
        ((NetworkPage)((Object)this.fTcpipNode.getPanel())).save(browserConfigFileWriter, element);
        ((NetworkPage)((Object)this.fUdpNode.getPanel())).save(browserConfigFileWriter, element);
        ((PXIPage)((Object)this.fPxiNode.getPanel())).save(browserConfigFileWriter, element);
        ((VisaMorePage)((Object)this.fvisaMoreNode.getPanel())).save(browserConfigFileWriter, element);
        this.fDriverTablePage.save(browserConfigFileWriter, element);
        this.fObjectTablePage.save(browserConfigFileWriter, element);
    }

    public void load(BrowserConfigFileReader browserConfigFileReader, Node node) {
        if (node == null) {
            ((SerialHardwarePage)((Object)this.fSerialNode.getPanel())).addInitialNodes(this.fAvailablePorts);
            return;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = nodeList.item(i).getNodeName();
            if (!string.equals("Instrument")) continue;
            String string2 = ((Element)nodeList.item(i)).getAttribute("Type").toLowerCase();
            String string3 = ((Element)nodeList.item(i)).getAttribute("Identification");
            String string4 = ((Element)nodeList.item(i)).getAttribute("LastScanDate");
            if (string2.equals("serial")) {
                ((SerialHardwarePage)((Object)this.fSerialNode.getPanel())).load(string3, string4, (Element)nodeList.item(i));
                continue;
            }
            if (string2.equals("tcpip")) {
                ((NetworkPage)((Object)this.fTcpipNode.getPanel())).load(string3, string4, (Element)nodeList.item(i));
                continue;
            }
            if (string2.equals("udp")) {
                ((NetworkPage)((Object)this.fUdpNode.getPanel())).load(string3, string4, (Element)nodeList.item(i));
                continue;
            }
            if (string2.equals("bluetooth")) {
                ((BluetoothHardwarePage)((Object)this.fBluetoothNode.getPanel())).load(string3, string4, (Element)nodeList.item(i));
                continue;
            }
            try {
                if (string.equals("Driver")) {
                    this.fDriverTablePage.load((Element)nodeList.item(i));
                    continue;
                }
                if (string.equals("HistoryObjects")) {
                    this.fObjectTablePage.load((Element)nodeList.item(i));
                    continue;
                }
                if (string2.equals("gpibboard")) {
                    ((GPIBPage)((Object)this.fGpibNode.getPanel())).load(string4, (Element)nodeList.item(i));
                    continue;
                }
                if (string2.equals("gpib")) {
                    ((GPIBPage)((Object)this.fGpibNode.getPanel())).load(string3, string4, (Element)nodeList.item(i));
                    continue;
                }
                if (string2.equals("vxiboard")) {
                    ((VXIPage)((Object)this.fVxiNode.getPanel())).load(string4, (Element)nodeList.item(i));
                    continue;
                }
                if (string2.equals("vxi")) {
                    ((VXIPage)((Object)this.fVxiNode.getPanel())).load(string3, string4, (Element)nodeList.item(i));
                    continue;
                }
                if (string2.equals("pxiboard")) {
                    ((PXIPage)((Object)this.fPxiNode.getPanel())).load(string4, (Element)nodeList.item(i));
                    continue;
                }
                if (string2.equals("pxi")) {
                    ((PXIPage)((Object)this.fPxiNode.getPanel())).load(string3, string4, (Element)nodeList.item(i));
                    continue;
                }
                if (string2.equals("gpib-vxiboard")) {
                    ((GPIBVXIPage)((Object)this.fGpibVxiNode.getPanel())).load(string4, (Element)nodeList.item(i));
                    continue;
                }
                if (string2.equals("gpib-vxi")) {
                    ((GPIBVXIPage)((Object)this.fGpibVxiNode.getPanel())).load(string3, string4, (Element)nodeList.item(i));
                    continue;
                }
                if (string2.equals("visa-tcpip")) {
                    ((VisaTCPIPPage)((Object)this.fVisaTcpipNode.getPanel())).load(string3, string4, (Element)nodeList.item(i));
                    continue;
                }
                if (string2.equals("visa-usb")) {
                    ((VisaUSBPage)((Object)this.fVisaUsbNode.getPanel())).load(string3, string4, (Element)nodeList.item(i));
                    continue;
                }
                if (!string2.equals("visa-more")) continue;
                ((VisaMorePage)((Object)this.fvisaMoreNode.getPanel())).load(string3, string4, (Element)nodeList.item(i));
                continue;
            }
            catch (NullPointerException nullPointerException) {
                System.out.println("We probably missed a node");
            }
        }
        this.fDriverTablePage.finishLoad();
    }

    public void init() {
        sLinux = PlatformInfo.isLinux();
        sWindows = PlatformInfo.isWindows();
        Matlab.whenMatlabReady((Runnable)new VISAInfoRunnable());
        this.fObjectTablePage = new ObjectTablePage();
        this.fLevel2.setPanel((JPanel)((Object)this.fObjectTablePage));
        this.fDriverTablePage = new DriverTablePage(this);
        this.fLevel3.setUserData((Object)new Integer(0));
        this.fLevel3.setPanel((JPanel)((Object)this.fDriverTablePage));
        this.initHardware();
        String[] stringArray = new String[]{"Instrument Control Toolbox", "Instrument Objects"};
        this.fInterfaceObjectNode = new BrowserTreeNode("Interface Objects", (BrowserClient)this);
        this.fInterfaceObjectNode.setType(6);
        this.fInterfaceObjectNode.setIcon(sObjsImage);
        this.fInterfaceObjectNode.setPanel((JPanel)((Object)this.fObjectTablePage));
        this.fInterfaceObjectNode.setUserData((Object)new Integer(1));
        this.fInterfaceObjectNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\objects_interface.html");
        this.fInterfaceObjectNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "interface_object");
        this.postNodeAddedEvent("Interface Objects", stringArray, this.fInterfaceObjectNode, 3, false);
        this.fDeviceObjectNode = new BrowserTreeNode("Device Objects", (BrowserClient)this);
        this.fDeviceObjectNode.setType(7);
        this.fDeviceObjectNode.setIcon(sObjsImage);
        this.fDeviceObjectNode.setPanel((JPanel)((Object)this.fObjectTablePage));
        this.fDeviceObjectNode.setUserData((Object)new Integer(2));
        this.fDeviceObjectNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\objects_device.html");
        this.fDeviceObjectNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "device_object");
        this.postNodeAddedEvent("Device Objects", stringArray, this.fDeviceObjectNode, 3, false);
        this.initObjects();
        stringArray[1] = "Instrument Drivers";
        this.fMatlabDriverNode = new BrowserTreeNode("MATLAB Instrument Drivers", (BrowserClient)this);
        this.fMatlabDriverNode.setType(11);
        this.fMatlabDriverNode.setIcon(sDriverImage);
        this.fMatlabDriverNode.setPanel((JPanel)((Object)this.fDriverTablePage));
        this.fMatlabDriverNode.setUserData((Object)new Integer(1));
        this.fMatlabDriverNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\drivers_matlab.html");
        this.fMatlabDriverNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "matlab_driver");
        this.postNodeAddedEvent("MATLAB Instrument Drivers", stringArray, this.fMatlabDriverNode, 3, false);
        this.fVxipnpDriverNode = new BrowserTreeNode("VXIplug&&play Drivers", (BrowserClient)this);
        this.fVxipnpDriverNode.setType(12);
        this.fVxipnpDriverNode.setIcon(sDriverImage);
        this.fVxipnpDriverNode.setPanel((JPanel)((Object)this.fDriverTablePage));
        this.fVxipnpDriverNode.setUserData((Object)new Integer(2));
        this.fVxipnpDriverNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\drivers_vxipnp.html");
        this.fVxipnpDriverNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "vxi_pnp");
        this.fIviPage = new IVIPage(this);
        this.fIviNode = new BrowserTreeNode("IVI", (BrowserClient)this);
        this.fIviNode.setType(13);
        this.fIviNode.setIcon(sDriverImage);
        this.fIviNode.setPanel((JPanel)((Object)this.fIviPage));
        this.fIviNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\drivers_ivi.html");
        this.fIviNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "ivi_driver");
        if (sWindows) {
            this.postNodeAddedEvent("VXIplug&&play Drivers", stringArray, this.fVxipnpDriverNode, 3, false);
            this.postNodeAddedEvent("IVI", stringArray, this.fIviNode, 3, false);
        }
        this.initRightClickMenuItems();
    }

    private void initHardware() {
        String[] stringArray = new String[]{"Instrument Control Toolbox", "Hardware"};
        try {
            this.fAvailablePorts = SerialComm.findAllPorts();
        }
        catch (SecurityException securityException) {
            this.fAvailablePorts = null;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.fAvailablePorts = null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.fAvailablePorts = null;
        }
        this.fSerialNode = new BrowserTreeNode("Serial", (BrowserClient)this);
        this.fBluetoothNode = new BrowserTreeNode("Bluetooth", (BrowserClient)this);
        this.fTcpipNode = new BrowserTreeNode("TCPIP", (BrowserClient)this);
        this.fUdpNode = new BrowserTreeNode("UDP", (BrowserClient)this);
        this.fSerialNode.setIcon(sSerialImage);
        this.fBluetoothNode.setIcon(sBluetoothImage);
        this.fTcpipNode.setIcon(sNetworkImage);
        this.fUdpNode.setIcon(sNetworkImage);
        this.fSerialNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\serial.html");
        this.fSerialNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "serial_node");
        this.fBluetoothNode.setHelpDirectoryAndPage("instrument", "tmtool csh\\bluetooth.html");
        this.fBluetoothNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "bluetooth_node");
        this.fTcpipNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\tcpip.html");
        this.fTcpipNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "tcpip_node");
        this.fUdpNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\udp.html");
        this.fUdpNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "udp_node");
        SerialHardwarePage serialHardwarePage = new SerialHardwarePage(this);
        this.fSerialNode.setPanel((JPanel)((Object)serialHardwarePage));
        BluetoothHardwarePage bluetoothHardwarePage = new BluetoothHardwarePage(this);
        this.fBluetoothNode.setPanel((JPanel)((Object)bluetoothHardwarePage));
        this.fTcpipNode.setPanel((JPanel)((Object)new NetworkPage(0, this)));
        this.fUdpNode.setPanel((JPanel)((Object)new NetworkPage(1, this)));
        this.fSerialNode.setTag("Scan for serial instruments");
        this.fBluetoothNode.setTag("Scan for Bluetooth devices");
        this.fTcpipNode.setTag("Add new TCPIP instrument");
        this.fUdpNode.setTag("Add new UDP instrument");
        this.fSerialNode.setType(2);
        this.fBluetoothNode.setType(2);
        this.fTcpipNode.setType(2);
        this.fUdpNode.setType(2);
        this.fGpibNode = new BrowserTreeNode("GPIB", (BrowserClient)this);
        this.fVisaNode = new BrowserTreeNode("VISA", (BrowserClient)this);
        this.fVxiNode = new BrowserTreeNode("VXI", (BrowserClient)this);
        this.fPxiNode = new BrowserTreeNode("PXI", (BrowserClient)this);
        this.fGpibVxiNode = new BrowserTreeNode("GPIB-VXI", (BrowserClient)this);
        this.fVisaTcpipNode = new BrowserTreeNode("TCPIP (VXI-11)", (BrowserClient)this);
        this.fVisaUsbNode = new BrowserTreeNode("USB", (BrowserClient)this);
        this.fvisaMoreNode = new BrowserTreeNode("More", (BrowserClient)this);
        this.fGpibNode.setIcon(sGpibImage);
        this.fVxiNode.setIcon(sVxiImage);
        this.fPxiNode.setIcon(sPxiImage);
        this.fGpibVxiNode.setIcon(sVxiImage);
        this.fVisaTcpipNode.setIcon(sNetworkImage);
        this.fVisaUsbNode.setIcon(sUsbImage);
        this.fVisaNode.setIcon(sUsbImage);
        this.fvisaMoreNode.setIcon(sUsbImage);
        this.fGpibNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\gpib.html");
        this.fGpibNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "gpib_node");
        this.fVxiNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\vxi.html");
        this.fVxiNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "vxi_node");
        this.fPxiNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "pxi_node");
        this.fGpibVxiNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\gpib_vxi.html");
        this.fGpibVxiNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "gpib_vxi_node");
        this.fVisaTcpipNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\tcpipvxi11.html");
        this.fVisaTcpipNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "tcpip_vxi-11_node");
        this.fVisaUsbNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\usb.html");
        this.fVisaUsbNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "usb_node");
        this.fVisaNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "VISA_node");
        this.fvisaMoreNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "VISA_More_node");
        this.fGpibNode.setPanel((JPanel)((Object)new GPIBPage(this)));
        this.fVxiNode.setPanel((JPanel)((Object)new VXIPage(this)));
        this.fPxiNode.setPanel((JPanel)((Object)new PXIPage(this)));
        this.fGpibVxiNode.setPanel((JPanel)((Object)new GPIBVXIPage(this)));
        this.fVisaTcpipNode.setPanel((JPanel)((Object)new VisaTCPIPPage(this)));
        this.fVisaUsbNode.setPanel((JPanel)((Object)new VisaUSBPage(this)));
        this.fvisaMoreNode.setPanel((JPanel)((Object)new VisaMorePage(this)));
        this.fBluetoothNode.setTag("Scan for Bluetooth devices");
        this.fGpibNode.setTag("Scan for GPIB instruments");
        this.fVxiNode.setTag("Scan for VXI instruments");
        this.fPxiNode.setTag("Scan for PXI instruments");
        this.fVisaNode.setTag("Scan for VISA instruments");
        this.fGpibVxiNode.setTag("Scan for GPIB-VXI instruments");
        this.fVisaTcpipNode.setTag("Scan for TCPIP instruments using VXI-11");
        this.fVisaUsbNode.setTag("Scan for USB instruments");
        this.fvisaMoreNode.setTag("Scan for more VISA instruments");
        this.fGpibNode.setType(2);
        this.fVxiNode.setType(2);
        this.fPxiNode.setType(2);
        this.fVisaNode.setType(2);
        this.fGpibVxiNode.setType(2);
        this.fVisaTcpipNode.setType(2);
        this.fVisaUsbNode.setType(2);
        this.fvisaMoreNode.setType(2);
        this.fHardwarePages = new InstrumentControlBrowserPage[11];
        this.fHardwarePages[0] = (InstrumentControlBrowserPage)((Object)this.fSerialNode.getPanel());
        this.fHardwarePages[10] = (InstrumentControlBrowserPage)((Object)this.fBluetoothNode.getPanel());
        this.fHardwarePages[1] = (InstrumentControlBrowserPage)((Object)this.fGpibNode.getPanel());
        this.fHardwarePages[2] = (InstrumentControlBrowserPage)((Object)this.fTcpipNode.getPanel());
        this.fHardwarePages[3] = (InstrumentControlBrowserPage)((Object)this.fUdpNode.getPanel());
        this.fHardwarePages[4] = (InstrumentControlBrowserPage)((Object)this.fVxiNode.getPanel());
        this.fHardwarePages[5] = (InstrumentControlBrowserPage)((Object)this.fGpibVxiNode.getPanel());
        this.fHardwarePages[6] = (InstrumentControlBrowserPage)((Object)this.fVisaTcpipNode.getPanel());
        this.fHardwarePages[7] = (InstrumentControlBrowserPage)((Object)this.fVisaUsbNode.getPanel());
        this.fHardwarePages[9] = (InstrumentControlBrowserPage)((Object)this.fvisaMoreNode.getPanel());
        this.postNodeAddedEvent("Serial", stringArray, this.fSerialNode, 1, false);
        this.postNodeAddedEvent("TCPIP", stringArray, this.fTcpipNode, 1, false);
        this.postNodeAddedEvent("UDP", stringArray, this.fUdpNode, 1, false);
        if (!sLinux && bluetoothSupportInTMTOOL) {
            this.postNodeAddedEvent("Bluetooth", stringArray, this.fBluetoothNode, 1, false);
        }
        this.postNodeAddedEvent("GPIB", stringArray, this.fGpibNode, 1, false);
        this.postNodeAddedEvent("VISA", stringArray, this.fVisaNode, 1, false);
        String[] stringArray2 = new String[]{"Instrument Control Toolbox", "Hardware", "VISA"};
        this.postNodeAddedEvent("VXI", stringArray2, this.fVxiNode, 1, false);
        this.postNodeAddedEvent("GPIB-VXI", stringArray2, this.fGpibVxiNode, 1, false);
        this.postNodeAddedEvent("TCPIP (VXI-11)", stringArray2, this.fVisaTcpipNode, 1, false);
        this.postNodeAddedEvent("USB", stringArray2, this.fVisaUsbNode, 1, false);
        this.postNodeAddedEvent("More", stringArray2, this.fvisaMoreNode, 1, false);
    }

    private void initObjects() {
        Vector<Instrument> vector = Instrument.getNonLockedObjects();
        for (int i = 0; i < vector.size(); ++i) {
            Instrument instrument = vector.elementAt(i);
            this.instrumentObjectAdded(instrument, instrument.getType(), instrument.getName());
        }
        Vector<DeviceClient> vector2 = Device.getNonLockedObjects();
        for (int i = 0; i < vector2.size(); ++i) {
            Device device = (Device)vector2.elementAt(i);
            this.deviceObjectAdded(device, device.getType());
        }
    }

    private void initRightClickMenuItems() {
        this.fScanVisa.addActionListener((ActionListener)this);
        this.fScanVisa.putClientProperty((Object)ACTION, (Object)new Integer(26));
        this.fCopyIntrumentResourse.addActionListener((ActionListener)this);
        this.fCopyIntrumentResourse.putClientProperty((Object)ACTION, (Object)new Integer(25));
        this.fExportInstrumentObject.addActionListener((ActionListener)this);
        this.fExportInstrumentObject.putClientProperty((Object)ACTION, (Object)new Integer(7));
        this.fSaveCommunication.addActionListener((ActionListener)this);
        this.fSaveCommunication.putClientProperty((Object)ACTION, (Object)new Integer(8));
        this.fDeleteObject.addActionListener((ActionListener)this);
        this.fDeleteObject.putClientProperty((Object)ACTION, (Object)new Integer(9));
        this.fExportHistory.addActionListener((ActionListener)this);
        this.fExportHistory.putClientProperty((Object)ACTION, (Object)new Integer(10));
        this.fNewObject.addActionListener((ActionListener)this);
        this.fNewObject.putClientProperty((Object)ACTION, (Object)new Integer(5));
        this.fExportObjects.addActionListener((ActionListener)this);
        this.fExportObjects.putClientProperty((Object)ACTION, (Object)new Integer(11));
        this.fDeleteObjects.addActionListener((ActionListener)this);
        this.fDeleteObjects.putClientProperty((Object)ACTION, (Object)new Integer(12));
        this.fScanForDriver.addActionListener((ActionListener)this);
        this.fScanForDriver.putClientProperty((Object)ACTION, (Object)new Integer(16));
        this.editDriver.addActionListener((ActionListener)this);
        this.editDriver.putClientProperty((Object)ACTION, (Object)new Integer(18));
        this.fDeleteIVICInstrumentObject.addActionListener(this);
        this.fDeleteIVICInstrumentObject.putClientProperty(ACTION, new Integer(27));
        this.fRenameIVICInstrumentObject.addActionListener(this);
        this.fRenameIVICInstrumentObject.putClientProperty(ACTION, new Integer(28));
        this.fCreateDeviceObject.addActionListener((ActionListener)this);
        this.fCreateDeviceObject.putClientProperty((Object)ACTION, (Object)new Integer(20));
        this.fSaveAsConfigStore.addActionListener((ActionListener)this);
        this.fSaveAsConfigStore.putClientProperty((Object)ACTION, (Object)new Integer(22));
        this.fSaveConfigStore.addActionListener((ActionListener)this);
        this.fSaveConfigStore.putClientProperty((Object)ACTION, (Object)new Integer(23));
        this.fLoadConfigStore.addActionListener((ActionListener)this);
        this.fLoadConfigStore.putClientProperty((Object)ACTION, (Object)new Integer(24));
        this.fScanForHardware.addActionListener((ActionListener)this);
        this.fScanForHardware.putClientProperty((Object)ACTION, (Object)new Integer(13));
        this.fIdentifyNetworkInstruments.addActionListener((ActionListener)this);
        this.fIdentifyNetworkInstruments.putClientProperty((Object)ACTION, (Object)new Integer(19));
    }

    public void cleanup() {
        Device.removeDeviceObjectListener(this);
        Device.removePropertyChangedListener(this);
        Instrument.removeInstrumentObjectListener(this);
        Instrument.removePropertyChangedListener(this);
        if (!sLinux) {
            ((InstrumentControlBrowserPage)((Object)this.fBluetoothNode.getPanel())).dispose();
        }
        ((InstrumentControlBrowserPage)((Object)this.fGpibNode.getPanel())).dispose();
        ((InstrumentControlBrowserPage)((Object)this.fVxiNode.getPanel())).dispose();
        ((InstrumentControlBrowserPage)((Object)this.fPxiNode.getPanel())).dispose();
        ((InstrumentControlBrowserPage)((Object)this.fGpibVxiNode.getPanel())).dispose();
        ((InstrumentControlBrowserPage)((Object)this.fVisaTcpipNode.getPanel())).dispose();
        ((InstrumentControlBrowserPage)((Object)this.fVisaUsbNode.getPanel())).dispose();
        ((InstrumentControlBrowserPage)((Object)this.fvisaMoreNode.getPanel())).dispose();
        ((InstrumentControlBrowserPage)((Object)this.fSerialNode.getPanel())).dispose();
        ((InstrumentControlBrowserPage)((Object)this.fTcpipNode.getPanel())).dispose();
        ((InstrumentControlBrowserPage)((Object)this.fUdpNode.getPanel())).dispose();
        this.fObjectTablePage.cleanup();
        this.fDriverTablePage.dispose();
        this.fCommunicationInfoStore.dispose();
        IviCInstrumentObjectStore.dispose();
        if (CommunicationPage.hasInstance()) {
            CommunicationPage.getInstance(this).dispose();
        }
        if (DeviceObjectPage.hasInstance()) {
            DeviceObjectPage.getInstance().dispose();
        }
        this.fIviPage.dispose();
        if (this.fHardwareInstrumentNodes != null) {
            this.fHardwareInstrumentNodes.clear();
        }
        this.fHardwareInstrumentNodes = null;
        this.postNodeRemovedEvent(this.fInterfaceObjectNode);
        this.postNodeRemovedEvent(this.fDeviceObjectNode);
        this.fMatlabArgs = null;
    }

    public BrowserTreeNode getRootNode() {
        this.fRootNode.setIcon(sMatlabImage);
        this.fRootNode.setShowHelpOnly(true);
        this.fRootNode.setType(0);
        this.fRootNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\top_page\\ic_tmtool.html");
        this.fRootNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "tmtool_intro");
        return this.fRootNode;
    }

    public BrowserTreeNode[] getLevelOneNodes() {
        boolean bl;
        boolean bl2 = bl = Instrument.getPreferenceFile().read("EnableIviCInstruments").equals("enabled");
        if (bl) {
            this.fLevelNodes = new BrowserTreeNode[]{this.fLevel1, this.fLevel2, this.fLevel3, this.IviCInstrumentsNode};
            this.fIviCInstrumentTablePage = new IviCClassCompliantInstrumentTablePage(this);
            this.IviCInstrumentsNode.setPanel((JPanel)((Object)this.fIviCInstrumentTablePage));
            this.IviCInstrumentsNode.setType(17);
            this.IviCInstrumentsNode.setIcon(sDriverImage);
            this.IviCInstrumentsNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\drivers_ivi.html");
            this.IviCInstrumentsNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "ivi_instrumentTable");
        } else {
            this.fLevelNodes = new BrowserTreeNode[]{this.fLevel1, this.fLevel2, this.fLevel3};
        }
        this.fLevel1.setIcon(sHwImage);
        this.fLevel1.setHelpDirectoryAndPage("instrument", "tmtool_csh\\top_page\\ic_hardware.html");
        this.fLevel1.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "hardware");
        this.fLevel1.setType(1);
        this.fLevel1.setShowHelpOnly(true);
        this.fLevel2.setIcon(sObjsImage);
        this.fLevel2.setType(5);
        this.fLevel2.setUserData((Object)new Integer(0));
        this.fLevel2.setHelpDirectoryAndPage("instrument", "tmtool_csh\\objects_instrument.html");
        this.fLevel2.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "instrument_object");
        this.fLevel3.setIcon(sDriverImage);
        this.fLevel3.setType(9);
        this.fLevel3.setHelpDirectoryAndPage("instrument", "tmtool_csh\\drivers_instrument.html");
        this.fLevel3.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "instrument_driver");
        return this.fLevelNodes;
    }

    public void doubleClickOnNode(BrowserTreeNode browserTreeNode) {
    }

    public String getToolTipString(BrowserTreeNode browserTreeNode) {
        return null;
    }

    public ImageIcon getNodeIcon(BrowserTreeNode browserTreeNode) {
        return browserTreeNode.getIcon();
    }

    public void cleanupNode(BrowserTreeNode browserTreeNode, BrowserTreeNode browserTreeNode2, BrowserTreeNode[] browserTreeNodeArray) {
        if (browserTreeNodeArray.length > 1) {
            return;
        }
        if (browserTreeNode.getPanel() != null && browserTreeNode2 != null && browserTreeNode.getPanel().equals(browserTreeNode2.getPanel())) {
            if (!browserTreeNode.equals(browserTreeNode2) && browserTreeNode.getPanel() instanceof ObjectTablePage) {
                ((InstrumentControlBrowserPage)((Object)browserTreeNode2.getPanel())).cleanup();
            } else if (!browserTreeNode.equals(browserTreeNode2) && browserTreeNode.getPanel() instanceof DeviceObjectPage) {
                ((InstrumentControlBrowserPage)((Object)browserTreeNode2.getPanel())).cleanup();
            } else if (!browserTreeNode.equals(browserTreeNode2) && browserTreeNode.getPanel() instanceof DriverPage) {
                ((InstrumentControlBrowserPage)((Object)browserTreeNode2.getPanel())).cleanup();
            } else if (!browserTreeNode.equals(browserTreeNode2) && browserTreeNode.getPanel() instanceof IVIPage) {
                ((InstrumentControlBrowserPage)((Object)browserTreeNode2.getPanel())).cleanup();
            }
            return;
        }
        if (browserTreeNode2 != null && browserTreeNode2.getPanel() != null && browserTreeNode2.getPanel() instanceof InstrumentControlBrowserPage) {
            ((InstrumentControlBrowserPage)((Object)browserTreeNode2.getPanel())).cleanup();
        }
    }

    public JPanel getPanel(BrowserTreeNode browserTreeNode, BrowserTreeNode browserTreeNode2, BrowserTreeNode[] browserTreeNodeArray) {
        if (browserTreeNodeArray.length > 1) {
            return null;
        }
        if (browserTreeNode2 != null && browserTreeNode2.equals(browserTreeNode)) {
            browserTreeNode.updatePanel(false);
            return null;
        }
        if (browserTreeNode.getPanel() != null && browserTreeNode2 != null && browserTreeNode.getPanel().equals(browserTreeNode2.getPanel())) {
            browserTreeNode.updatePanel(false);
            if (browserTreeNode2.getUserData() instanceof MLDriverPageInfo) {
                ((MLDriverPageInfo)browserTreeNode2.getUserData()).dispose();
            }
            JPanel jPanel = browserTreeNode.getPanel();
            ((InstrumentControlBrowserPage)((Object)jPanel)).update(browserTreeNode);
            return browserTreeNode.getPanel();
        }
        browserTreeNode.updatePanel(true);
        JPanel jPanel = browserTreeNode.getPanel();
        if (jPanel != null) {
            ((InstrumentControlBrowserPage)((Object)jPanel)).setup();
            ((InstrumentControlBrowserPage)((Object)jPanel)).update(browserTreeNode);
            return jPanel;
        }
        return null;
    }

    public void enableNodeEvents(boolean bl) {
        this.fNodeEventsEnable = bl;
    }

    public String getToolboxVersion() {
        String string = Instrument.jarVersion();
        return string.substring(8);
    }

    public String getToolboxName() {
        return "Instrument Control Toolbox";
    }

    public void addToCommunicationInfoStore(CommunicationInfo communicationInfo) {
        this.fCommunicationInfoStore.add(communicationInfo);
    }

    public void synchronizeCommunicationInfo(CommunicationInfo communicationInfo) {
        this.fCommunicationInfoStore.synchronize(communicationInfo);
    }

    public void removeBrowserObjectFromCommunicationInfoStore(CommunicationInfo communicationInfo) {
        this.fCommunicationInfoStore.removeBrowserObject(communicationInfo);
    }

    public boolean isVISASupported() {
        return sVisaSupported;
    }

    public String[] getVISAPorts() {
        return this.fVisaPorts;
    }

    public void refresh() {
        this.postBlockEventsEvent(true);
        this.fFullScan = true;
        this.fNextScanType = 0;
        this.fHardwarePages[this.fNextScanType++].scanForAll(false, false);
    }

    public void scanVisa() {
        this.fHardwarePages[6].scanForAll(true, true);
        this.fHardwarePages[9].scanForAll(true, true);
        this.fHardwarePages[4].scanForAll(true, true);
        this.fHardwarePages[7].scanForAll(true, true);
    }

    private void refresh(String string, MJPanel mJPanel) {
        this.fFullScan = false;
        if (string.equals("Scan for instrument hardware")) {
            this.refresh();
        } else if (string.equals("Scan for serial instruments")) {
            ((SerialHardwarePage)mJPanel).scanForAll();
        } else if (string.equals("Scan for GPIB instruments")) {
            if (mJPanel instanceof GPIBPage) {
                ((GPIBPage)mJPanel).scanForAll();
            } else {
                ((BoardPage)mJPanel).scanForAll();
            }
        } else if (string.equals("Scan for VXI instruments")) {
            if (mJPanel instanceof VXIPage) {
                ((VXIPage)mJPanel).scanForAll();
            } else {
                ((BoardPage)mJPanel).scanForAll();
            }
        } else if (string.equals("Scan for PXI instruments")) {
            if (mJPanel instanceof PXIPage) {
                ((PXIPage)mJPanel).scanForAll();
            } else {
                ((BoardPage)mJPanel).scanForAll();
            }
        } else if (string.equals("Scan for GPIB-VXI instruments")) {
            if (mJPanel instanceof GPIBVXIPage) {
                ((GPIBVXIPage)mJPanel).scanForAll();
            } else {
                ((BoardPage)mJPanel).scanForAll();
            }
        } else if (string.equals("Scan for USB instruments")) {
            ((VisaUSBPage)mJPanel).scanForAll();
        } else if (string.equals("Scan for TCPIP instruments using VXI-11")) {
            ((VisaTCPIPPage)mJPanel).scanForAll();
        } else if (string.equals("Add new TCPIP instrument")) {
            ((NetworkPage)mJPanel).showAddBox(this.getBrowserFrame());
        } else if (string.equals("Add new UDP instrument")) {
            ((NetworkPage)mJPanel).showAddBox(this.getBrowserFrame());
        } else if (string.equals("Identify TCPIP instruments")) {
            ((NetworkPage)mJPanel).identify();
        } else if (string.equals("Identify UDP instruments")) {
            ((NetworkPage)mJPanel).identify();
        } else if (string.equals("Scan for more VISA instruments")) {
            ((VisaMorePage)mJPanel).scanForAll();
        } else if (string.equals("Scan for VISA instruments")) {
            ((VisaMorePage)mJPanel).scanForAll();
        } else if (string.equals("Scan for Bluetooth devices")) {
            ((BluetoothHardwarePage)mJPanel).scanForAll();
        }
    }

    public void postRefreshFinishedEvent() {
        if (!this.fFullScan) {
            this.postStatusBarUpdateEvent("Ready");
            return;
        }
        if (this.fNextScanType < 11) {
            if (this.fNextScanType == 8) {
                ++this.fNextScanType;
            }
            this.fHardwarePages[this.fNextScanType++].scanForAll(false, false);
        } else {
            this.postBlockEventsEvent(false);
            this.postStatusBarUpdateEvent("Ready");
        }
    }

    public MJMenu getToolsMenu() {
        MJMenu mJMenu = new MJMenu("Tools");
        MJMenu mJMenu2 = new MJMenu("Instrument Control Toolbox");
        mJMenu.add((JMenuItem)mJMenu2);
        this.fNewObject = new MJMenuItem("New Instrument Control Object...");
        this.fNewObject.putClientProperty((Object)ACTION, (Object)new Integer(5));
        this.fNewObject.putClientProperty((Object)OBJECT, (Object)INSTRUMENT_OBJECT_LEVEL_INT);
        this.fNewObject.addActionListener((ActionListener)this);
        MJMenuItem mJMenuItem = new MJMenuItem("Scan For Instrument Hardware");
        mJMenuItem.putClientProperty((Object)ACTION, (Object)new Integer(6));
        mJMenuItem.addActionListener((ActionListener)this);
        MJMenuItem mJMenuItem2 = new MJMenuItem("Define Scan Commands...");
        mJMenuItem2.putClientProperty((Object)ACTION, (Object)new Integer(15));
        mJMenuItem2.addActionListener((ActionListener)this);
        MJMenuItem mJMenuItem3 = new MJMenuItem("Scan For Instrument Drivers");
        mJMenuItem3.putClientProperty((Object)ACTION, (Object)new Integer(16));
        mJMenuItem3.putClientProperty((Object)OBJECT, (Object)ALL);
        mJMenuItem3.addActionListener((ActionListener)this);
        mJMenu2.add((JMenuItem)this.fNewObject);
        mJMenu2.addSeparator();
        mJMenu2.add((JMenuItem)mJMenuItem);
        mJMenu2.add((JMenuItem)mJMenuItem2);
        mJMenu2.addSeparator();
        mJMenu2.add((JMenuItem)mJMenuItem3);
        return mJMenu;
    }

    public MJMenu getViewMenu() {
        MJMenu mJMenu = new MJMenu("View");
        MJMenu mJMenu2 = new MJMenu("Instrument Control Toolbox");
        mJMenu.add((JMenuItem)mJMenu2);
        MJCheckBoxMenuItem mJCheckBoxMenuItem = new MJCheckBoxMenuItem("Hardware", true);
        mJCheckBoxMenuItem.putClientProperty((Object)ACTION, (Object)new Integer(2));
        mJCheckBoxMenuItem.addActionListener((ActionListener)this);
        MJCheckBoxMenuItem mJCheckBoxMenuItem2 = new MJCheckBoxMenuItem("Instrument Objects", true);
        mJCheckBoxMenuItem2.putClientProperty((Object)ACTION, (Object)new Integer(3));
        mJCheckBoxMenuItem2.addActionListener((ActionListener)this);
        MJCheckBoxMenuItem mJCheckBoxMenuItem3 = new MJCheckBoxMenuItem("Instrument Drivers", true);
        mJCheckBoxMenuItem3.putClientProperty((Object)ACTION, (Object)new Integer(4));
        mJCheckBoxMenuItem3.addActionListener((ActionListener)this);
        mJMenu2.add((JMenuItem)mJCheckBoxMenuItem);
        mJMenu2.add((JMenuItem)mJCheckBoxMenuItem2);
        mJMenu2.add((JMenuItem)mJCheckBoxMenuItem3);
        return mJMenu;
    }

    public MJMenu[] getMenus() {
        MJMenu mJMenu = this.getViewMenu();
        MJMenu mJMenu2 = this.getToolsMenu();
        this.fMenus = new MJMenu[2];
        this.fMenus[0] = mJMenu;
        this.fMenus[1] = mJMenu2;
        return this.fMenus;
    }

    public MJMenuItem getHelpMenuItem() {
        MJMenuItem mJMenuItem = new MJMenuItem("Instrument Control Toolbox");
        mJMenuItem.addActionListener((ActionListener)this);
        mJMenuItem.putClientProperty((Object)ACTION, (Object)new Integer(0));
        return mJMenuItem;
    }

    public MJMenuItem getAboutMenuItem() {
        MJMenuItem mJMenuItem = new MJMenuItem("About Instrument Control Toolbox");
        mJMenuItem.addActionListener((ActionListener)this);
        mJMenuItem.putClientProperty((Object)ACTION, (Object)new Integer(1));
        return mJMenuItem;
    }

    public MJMenu[] getMenus(BrowserTreeNode browserTreeNode, BrowserTreeNode browserTreeNode2, BrowserTreeNode[] browserTreeNodeArray) {
        int n = browserTreeNode.getType();
        int n2 = -1;
        if (browserTreeNode2 != null) {
            n2 = browserTreeNode2.getType();
        }
        if (n == 4 && n2 == 4) {
            browserTreeNode.updateMenu(false);
            this.updateInstrumentNodeMenus(((CommunicationInfo)browserTreeNode.getUserData()).getBrowserObject(), browserTreeNode);
            return null;
        }
        if (n == 8 && n2 == 8 || n == 8 && n2 == 10) {
            browserTreeNode.updateMenu(false);
            this.updateInstrumentChildNodeMenus(((CommunicationInfo)browserTreeNode.getUserData()).getInstrumentObject(), browserTreeNode);
            return null;
        }
        if (n == 10 && n2 == 10 || n == 10 && n2 == 8) {
            browserTreeNode.updateMenu(false);
            this.updateInstrumentChildNodeMenus(((DeviceObjectPageInfo)browserTreeNode.getUserData()).getObject(), browserTreeNode);
            return null;
        }
        browserTreeNode.updateMenu(true);
        switch (n) {
            case 4: {
                return this.getInstrumentNodeMenus(((CommunicationInfo)browserTreeNode.getUserData()).getBrowserObject(), browserTreeNode);
            }
            case 8: {
                return this.getInstrumentObjectChildNodeMenus(((CommunicationInfo)browserTreeNode.getUserData()).getInstrumentObject(), browserTreeNode);
            }
            case 10: {
                return this.getInstrumentObjectChildNodeMenus(((DeviceObjectPageInfo)browserTreeNode.getUserData()).getObject(), browserTreeNode);
            }
            case 5: {
                return this.getInstrumentObjectNodeMenus("Instrument", INSTRUMENT_OBJECT_LEVEL_INT);
            }
            case 6: {
                return this.getInstrumentObjectNodeMenus("Interface", INTERFACE_OBJECT_LEVEL_INT);
            }
            case 7: {
                return this.getInstrumentObjectNodeMenus("Device", DEVICE_OBJECT_LEVEL_INT);
            }
            case 14: {
                return this.getIndividualMLDriverNodeMenus((DriverPageInfo)browserTreeNode.getUserData());
            }
            case 15: {
                return this.getIndividualVXIPnPDriverNodeMenus((DriverPageInfo)browserTreeNode.getUserData());
            }
            case 13: {
                return this.getIVINodeMenus();
            }
        }
        return null;
    }

    private MJMenu[] getInstrumentObjectNodeMenus(String string, Integer n) {
        if (this.fInstrumentObjectNodeMenusToInsert == null) {
            MJMenu mJMenu = new MJMenu("File");
            MJMenuItem mJMenuItem = new MJMenuItem("Export " + string + " Object(s)...");
            mJMenuItem.addActionListener((ActionListener)this);
            mJMenuItem.putClientProperty((Object)ACTION, (Object)new Integer(11));
            mJMenuItem.putClientProperty((Object)OBJECT, (Object)n);
            MJMenuItem mJMenuItem2 = new MJMenuItem("Delete " + string + " Object(s)");
            mJMenuItem2.addActionListener((ActionListener)this);
            mJMenuItem2.putClientProperty((Object)ACTION, (Object)new Integer(12));
            mJMenuItem2.putClientProperty((Object)OBJECT, (Object)n);
            this.fRemoveDuplicatesMenu = new MJMenuItem("Remove Duplicates from History Table");
            this.fRemoveDuplicatesMenu.addActionListener((ActionListener)this);
            this.fRemoveDuplicatesMenu.putClientProperty((Object)ACTION, (Object)new Integer(21));
            this.fRemoveDuplicatesMenu.putClientProperty((Object)OBJECT, (Object)n);
            mJMenu.add((JMenuItem)mJMenuItem);
            mJMenu.add((JMenuItem)mJMenuItem2);
            mJMenu.add((JMenuItem)this.fRemoveDuplicatesMenu);
            mJMenu.addSeparator();
            this.fInstrumentObjectNodeMenusToInsert = new MJMenu[1];
            this.fInstrumentObjectNodeMenusToInsert[0] = mJMenu;
        }
        this.fRemoveDuplicatesMenu.putClientProperty((Object)OBJECT, (Object)n);
        return this.fInstrumentObjectNodeMenusToInsert;
    }

    private MJMenu[] getInstrumentObjectChildNodeMenus(Object object, BrowserTreeNode browserTreeNode) {
        if (this.fInstrumentObjectChildNodeMenusToInsert == null) {
            MJMenu mJMenu = this.getInstrumentObjectChildNodeMenu(object, browserTreeNode);
            this.fInstrumentObjectChildNodeMenusToInsert = new MJMenu[1];
            this.fInstrumentObjectChildNodeMenusToInsert[0] = mJMenu;
        }
        return this.fInstrumentObjectChildNodeMenusToInsert;
    }

    private MJMenu[] getIndividualVXIPnPDriverNodeMenus(DriverPageInfo driverPageInfo) {
        if (this.fIndividualDriverNodeMenusToInsert == null) {
            MJMenu mJMenu = new MJMenu("File");
            this.fIndividualDriverNodeMenusToInsert = new MJMenu[1];
            this.fIndividualDriverNodeMenusToInsert[0] = mJMenu;
        }
        return this.fIndividualDriverNodeMenusToInsert;
    }

    private MJMenu[] getIndividualMLDriverNodeMenus(DriverPageInfo driverPageInfo) {
        if (this.fIndividualMLDriverNodeMenusToInsert == null) {
            MJMenu mJMenu = this.getIndividualMLDriverNodeMenu(driverPageInfo);
            this.fIndividualMLDriverNodeMenusToInsert = new MJMenu[1];
            this.fIndividualMLDriverNodeMenusToInsert[0] = mJMenu;
        }
        this.fCreateMLDeviceObjMenu.putClientProperty((Object)OBJECT, (Object)driverPageInfo);
        this.fEditMLDriverMenu.putClientProperty((Object)OBJECT, (Object)driverPageInfo.getDriverNameWithPath());
        return this.fIndividualMLDriverNodeMenusToInsert;
    }

    private MJMenu[] getIVINodeMenus() {
        if (this.fIviNodeMenusToInsert == null) {
            MJMenu mJMenu = this.getIVINodeMenu();
            this.fIviNodeMenusToInsert = new MJMenu[1];
            this.fIviNodeMenusToInsert[0] = mJMenu;
        }
        return this.fIviNodeMenusToInsert;
    }

    private MJMenu[] getInstrumentNodeMenus(BrowserObject browserObject, BrowserTreeNode browserTreeNode) {
        if (this.fInstrumentNodeMenusToInsert == null) {
            MJMenu mJMenu = this.getInstrumentNodeMenu(browserObject, browserTreeNode);
            this.fInstrumentNodeMenusToInsert = new MJMenu[1];
            this.fInstrumentNodeMenusToInsert[0] = mJMenu;
        }
        return this.fInstrumentNodeMenusToInsert;
    }

    public void menuSelected(String string, MJMenu mJMenu, BrowserTreeNode browserTreeNode) {
        this.selectedNode = browserTreeNode;
        if (!string.equals("File")) {
            return;
        }
        switch (browserTreeNode.getType()) {
            case 5: {
                this.configureMenusForObjectLevelNodes(mJMenu, "Instrument", INSTRUMENT_OBJECT_LEVEL_INT, this.fAllInterfaceObjects.size() + this.fAllDeviceObjects.size());
                return;
            }
            case 6: {
                this.configureMenusForObjectLevelNodes(mJMenu, "Interface", INTERFACE_OBJECT_LEVEL_INT, this.fAllInterfaceObjects.size());
                return;
            }
            case 7: {
                this.configureMenusForObjectLevelNodes(mJMenu, "Device", DEVICE_OBJECT_LEVEL_INT, this.fAllDeviceObjects.size());
                return;
            }
            case 8: {
                this.updateInstrumentChildNodeMenus(((CommunicationInfo)browserTreeNode.getUserData()).getInstrumentObject(), browserTreeNode);
                break;
            }
            case 10: {
                this.updateInstrumentChildNodeMenus(((DeviceObjectPageInfo)browserTreeNode.getUserData()).getObject(), browserTreeNode);
                break;
            }
            case 4: {
                Instrument instrument = ((CommunicationInfo)browserTreeNode.getUserData()).getInstrumentObject();
                JMenuItem jMenuItem = mJMenu.getItem(1);
                if (instrument == null || !instrument.isvalid()) {
                    this.fInstrumentNodeObjectMenu.setEnabled(false);
                    this.fInstrumentNodeExportComm.setEnabled(false);
                    jMenuItem.setEnabled(false);
                    break;
                }
                this.fInstrumentNodeObjectMenu.setEnabled(true);
                this.fInstrumentNodeExportComm.setEnabled(true);
                jMenuItem.setEnabled(true);
                break;
            }
            case 13: {
                this.saveConfigurationStoreMenu.setEnabled(this.fIviPage.isDirty());
            }
        }
    }

    private void configureMenusForObjectLevelNodes(MJMenu mJMenu, String string, Integer n, int n2) {
        JMenuItem jMenuItem = mJMenu.getItem(0);
        JMenuItem jMenuItem2 = mJMenu.getItem(1);
        jMenuItem.setText("Export " + string + " Object(s)...");
        jMenuItem2.setText("Delete " + string + " Object(s)");
        jMenuItem.putClientProperty(OBJECT, n);
        jMenuItem2.putClientProperty(OBJECT, n);
        if (n2 == 0) {
            jMenuItem.setEnabled(false);
            jMenuItem2.setEnabled(false);
        } else {
            jMenuItem.setEnabled(true);
            jMenuItem2.setEnabled(true);
        }
    }

    private void configureMenusForIviObjectLevelNodes(MJMenu mJMenu, Integer n) {
        JMenuItem jMenuItem = mJMenu.getItem(0);
        jMenuItem.putClientProperty(OBJECT, n);
    }

    private void updateInstrumentNodeMenus(BrowserObject browserObject, BrowserTreeNode browserTreeNode) {
        CommunicationPage communicationPage = (CommunicationPage)((Object)browserTreeNode.getPanel());
        this.fInstrumentNodeObjectMenu.putClientProperty((Object)OBJECT, (Object)browserObject);
        this.fInstrumentNodeSaveComm.putClientProperty((Object)PANEL, (Object)communicationPage);
        this.fInstrumentNodeExportComm.putClientProperty((Object)PANEL, (Object)communicationPage);
    }

    private void updateInstrumentChildNodeMenus(Object object, BrowserTreeNode browserTreeNode) {
        this.fInstrumentChildNodeObjectMenu.putClientProperty((Object)OBJECT, object);
        this.fInstrumentChildNodeDeleteMenu.putClientProperty((Object)OBJECT, object);
        this.fInstrumentChildNodeSaveComm.putClientProperty((Object)PANEL, (Object)browserTreeNode.getPanel());
        this.fInstrumentChildNodeExportComm.putClientProperty((Object)PANEL, (Object)browserTreeNode.getPanel());
    }

    public boolean defineRightClickMenuItems(BrowserTreeNode browserTreeNode, JPopupMenu jPopupMenu) {
        this.selectedNode = browserTreeNode;
        switch (browserTreeNode.getType()) {
            case 1: {
                this.fScanForHardware.setText("Scan for instrument hardware");
                this.fScanForHardware.putClientProperty((Object)PANEL, (Object)browserTreeNode.getPanel());
                jPopupMenu.add((JMenuItem)this.fScanForHardware);
                return true;
            }
            case 5: {
                return this.configureRightClickMenusForObjectLevelNode(jPopupMenu, "Instrument", INSTRUMENT_OBJECT_LEVEL_INT, this.fInterfaceObjectNode.getChildCount() + this.fDeviceObjectNode.getChildCount());
            }
            case 6: {
                return this.configureRightClickMenusForObjectLevelNode(jPopupMenu, "Interface", INTERFACE_OBJECT_LEVEL_INT, this.fInterfaceObjectNode.getChildCount());
            }
            case 7: {
                return this.configureRightClickMenusForObjectLevelNode(jPopupMenu, "Device", DEVICE_OBJECT_LEVEL_INT, this.fDeviceObjectNode.getChildCount());
            }
            case 9: {
                this.fScanForDriver.setText("Scan for Instrument Drivers");
                this.fScanForDriver.putClientProperty((Object)OBJECT, (Object)ALL);
                jPopupMenu.add((JMenuItem)this.fScanForDriver);
                return true;
            }
            case 11: {
                this.fScanForDriver.setText("Scan for MATLAB Instrument Drivers");
                this.fScanForDriver.putClientProperty((Object)OBJECT, (Object)MATLAB);
                jPopupMenu.add((JMenuItem)this.fScanForDriver);
                return true;
            }
            case 12: {
                this.fScanForDriver.setText("Scan for VXIplug&play Drivers");
                this.fScanForDriver.putClientProperty((Object)OBJECT, (Object)VXIPNP);
                jPopupMenu.add((JMenuItem)this.fScanForDriver);
                return true;
            }
            case 13: {
                this.fSaveConfigStore.setEnabled(this.fIviPage.isDirty());
                jPopupMenu.add((JMenuItem)this.fSaveConfigStore);
                jPopupMenu.add((JMenuItem)this.fSaveAsConfigStore);
                jPopupMenu.add((JMenuItem)this.fLoadConfigStore);
                return true;
            }
            case 2: 
            case 3: {
                String string = browserTreeNode.getTag();
                if (string.equals("")) {
                    return false;
                }
                if (string.indexOf("Scan for VISA instruments") != -1) {
                    this.fScanVisa.setText("Scan for VISA instruments");
                    jPopupMenu.add((JMenuItem)this.fScanVisa);
                    return true;
                }
                JPanel jPanel = browserTreeNode.getPanel();
                if (string.indexOf("TCPIP") != -1 && string.indexOf("VXI-11") == -1) {
                    this.fIdentifyNetworkInstruments.setText("Identify TCPIP instruments");
                    this.fIdentifyNetworkInstruments.putClientProperty((Object)PANEL, (Object)jPanel);
                    this.fIdentifyNetworkInstruments.setEnabled(((NetworkPage)((Object)jPanel)).okToIdentify());
                    jPopupMenu.add((JMenuItem)this.fIdentifyNetworkInstruments);
                    jPopupMenu.addSeparator();
                } else if (string.indexOf("UDP") != -1) {
                    this.fIdentifyNetworkInstruments.setText("Identify UDP instruments");
                    this.fIdentifyNetworkInstruments.putClientProperty((Object)PANEL, (Object)jPanel);
                    this.fIdentifyNetworkInstruments.setEnabled(((NetworkPage)((Object)jPanel)).okToIdentify());
                    jPopupMenu.add((JMenuItem)this.fIdentifyNetworkInstruments);
                    jPopupMenu.addSeparator();
                }
                this.fScanForHardware.setText(string);
                this.fScanForHardware.putClientProperty((Object)PANEL, (Object)jPanel);
                jPopupMenu.add((JMenuItem)this.fScanForHardware);
                return true;
            }
            case 8: {
                Instrument instrument = ((CommunicationInfo)browserTreeNode.getUserData()).getInstrumentObject();
                return this.configureRightClickMenusForObjectNode(jPopupMenu, instrument, browserTreeNode.getPanel());
            }
            case 10: {
                ICDevice iCDevice = ((DeviceObjectPageInfo)browserTreeNode.getUserData()).getObject();
                return this.configureRightClickMenusForObjectNode(jPopupMenu, iCDevice, browserTreeNode.getPanel());
            }
            case 4: {
                BrowserObject browserObject = ((CommunicationInfo)browserTreeNode.getUserData()).getBrowserObject();
                CommunicationPage communicationPage = (CommunicationPage)((Object)browserTreeNode.getPanel());
                Instrument instrument = browserObject.getInstrumentObject();
                if (instrument == null || !instrument.isvalid()) {
                    this.fExportInstrumentObject.setEnabled(false);
                    this.fSaveCommunication.setEnabled(false);
                    this.fExportHistory.setEnabled(false);
                } else {
                    this.fExportInstrumentObject.setEnabled(true);
                    this.fSaveCommunication.setEnabled(true);
                    this.fExportHistory.setEnabled(true);
                }
                this.fCopyIntrumentResourse.putClientProperty((Object)OBJECT, (Object)browserTreeNode.toString());
                this.fExportInstrumentObject.putClientProperty((Object)OBJECT, (Object)instrument);
                this.fSaveCommunication.putClientProperty((Object)PANEL, (Object)communicationPage);
                this.fExportHistory.putClientProperty((Object)PANEL, (Object)communicationPage);
                jPopupMenu.add((JMenuItem)this.fCopyIntrumentResourse);
                jPopupMenu.add((JMenuItem)this.fExportInstrumentObject);
                jPopupMenu.addSeparator();
                jPopupMenu.add((JMenuItem)this.fSaveCommunication);
                jPopupMenu.add((JMenuItem)this.fExportHistory);
                return true;
            }
            case 14: {
                this.editDriver.putClientProperty((Object)OBJECT, (Object)((DriverPageInfo)browserTreeNode.getUserData()).getDriverNameWithPath());
                this.fCreateDeviceObject.putClientProperty((Object)OBJECT, (Object)((DriverPageInfo)browserTreeNode.getUserData()));
                jPopupMenu.add((JMenuItem)this.fCreateDeviceObject);
                jPopupMenu.add((JMenuItem)this.editDriver);
                return true;
            }
            case 19: {
                jPopupMenu.add(this.fRenameIVICInstrumentObject);
                jPopupMenu.add(this.fDeleteIVICInstrumentObject);
                return true;
            }
        }
        return false;
    }

    private boolean configureRightClickMenusForObjectLevelNode(JPopupMenu jPopupMenu, String string, Integer n, int n2) {
        jPopupMenu.add((JMenuItem)this.fNewObject);
        jPopupMenu.add((JMenuItem)this.fExportObjects);
        jPopupMenu.add((JMenuItem)this.fDeleteObjects);
        this.fNewObject.setText("Create New " + string + " Object...");
        this.fExportObjects.setText("Export " + string + " Object(s)...");
        this.fDeleteObjects.setText("Delete " + string + " Object(s)");
        this.fNewObject.putClientProperty((Object)OBJECT, (Object)n);
        this.fExportObjects.putClientProperty((Object)OBJECT, (Object)n);
        this.fDeleteObjects.putClientProperty((Object)OBJECT, (Object)n);
        if (n2 == 0) {
            this.fExportObjects.setEnabled(false);
            this.fDeleteObjects.setEnabled(false);
        } else {
            this.fExportObjects.setEnabled(true);
            this.fDeleteObjects.setEnabled(true);
        }
        return true;
    }

    private boolean configureRightClickMenusForObjectNode(JPopupMenu jPopupMenu, Object object, JComponent jComponent) {
        this.fExportInstrumentObject.putClientProperty((Object)OBJECT, object);
        this.fDeleteObject.putClientProperty((Object)OBJECT, object);
        this.fSaveCommunication.putClientProperty((Object)PANEL, (Object)jComponent);
        this.fExportHistory.putClientProperty((Object)PANEL, (Object)jComponent);
        this.fExportInstrumentObject.setEnabled(true);
        this.fSaveCommunication.setEnabled(true);
        this.fExportHistory.setEnabled(true);
        jPopupMenu.add((JMenuItem)this.fExportInstrumentObject);
        jPopupMenu.add((JMenuItem)this.fDeleteObject);
        jPopupMenu.addSeparator();
        jPopupMenu.add((JMenuItem)this.fSaveCommunication);
        jPopupMenu.add((JMenuItem)this.fExportHistory);
        return true;
    }

    @Override
    public void instrumentObjectAdded(Instrument instrument, String string, String string2) {
        if (!this.fNodeEventsEnable) {
            return;
        }
        if (instrument.getType().equals("visa-pxi") || instrument.getType().equals("i2c")) {
            return;
        }
        this.fAllInterfaceObjects.addElement(instrument);
        String[] stringArray = new String[]{"Instrument Control Toolbox", "Instrument Objects", "Interface Objects"};
        BrowserTreeNode browserTreeNode = new BrowserTreeNode(string2, (BrowserClient)this);
        browserTreeNode.setType(8);
        browserTreeNode.setIcon(sObjImage);
        CommunicationPage communicationPage = CommunicationPage.getInstance(this);
        CommunicationInfo communicationInfo = new CommunicationInfo(instrument);
        this.addToCommunicationInfoStore(communicationInfo);
        browserTreeNode.setPanel((JPanel)((Object)communicationPage));
        browserTreeNode.setUserData((Object)communicationInfo);
        browserTreeNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\object_interface_case.html");
        browserTreeNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "interface_object_comm");
        this.fObjectTablePage.addInterfaceData(string, instrument.getConstructorDescription(), instrument.getConstructor());
        if (!this.fOkToAddInstrumentObjects) {
            this.fInstrumentObjectsToAdd.addElement(browserTreeNode);
            return;
        }
        this.fInstrumentObjectNodes.put(instrument, browserTreeNode);
        this.postNodeAddedEvent(string2, stringArray, browserTreeNode, 2, false);
        this.postNodeExpandEvent(this.fInterfaceObjectNode);
    }

    @Override
    public void instrumentObjectDeleted(Instrument instrument, String string, String string2) {
        if (!this.fNodeEventsEnable) {
            return;
        }
        final String[] stringArray = new String[]{"Instrument Control Toolbox", "Instrument Objects", "Interface Objects"};
        this.fAllInterfaceObjects.removeElement(instrument);
        if (!this.fOkToAddInstrumentObjects) {
            this.fInstrumentObjectsToRemove.addElement(instrument);
            return;
        }
        final CommunicationInfo communicationInfo = this.fCommunicationInfoStore.findInstrument(instrument);
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        InstrumentControlBrowser.this.postNodeRemovedEvent(stringArray, communicationInfo, 4);
                    }
                });
            }
            catch (Throwable throwable) {}
        } else {
            this.postNodeRemovedEvent(stringArray, communicationInfo, 4);
        }
        this.fCommunicationInfoStore.removeInstrument(communicationInfo);
        this.fInstrumentObjectNodes.remove(instrument);
    }

    @Override
    public void propertyChanged(Instrument instrument, String string, Object object) {
        if (string.equals("Name")) {
            final BrowserTreeNode browserTreeNode = this.fInstrumentObjectNodes.get(instrument);
            if (browserTreeNode != null) {
                browserTreeNode.setName((String)object);
                try {
                    AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            InstrumentControlBrowser.this.postNodeUpdatedEvent(browserTreeNode);
                        }
                    });
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return;
        }
        if (!string.equals("ObjectVisibility")) {
            return;
        }
        if (object.equals("off")) {
            return;
        }
        if (this.fCommunicationInfoStore.findInstrument(instrument) == null) {
            this.instrumentObjectAdded(instrument, instrument.getType(), instrument.getName());
        }
    }

    @Override
    public void deviceObjectAdded(final Device device, final String string) {
        if (!this.fNodeEventsEnable) {
            return;
        }
        this.fAllDeviceObjects.addElement(device);
        final String string2 = device.getName();
        final String[] stringArray = new String[]{"Instrument Control Toolbox", "Instrument Objects", "Device Objects"};
        final BrowserTreeNode browserTreeNode = new BrowserTreeNode(string2, (BrowserClient)this, (Object)device);
        final DeviceObjectPageInfo deviceObjectPageInfo = new DeviceObjectPageInfo((ICDevice)device);
        final InstrumentControlBrowser instrumentControlBrowser = this;
        browserTreeNode.setType(10);
        browserTreeNode.setIcon(sObjImage);
        browserTreeNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\object_device_case.html");
        browserTreeNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "device_object_comm");
        browserTreeNode.setUserData((Object)deviceObjectPageInfo);
        try {
            AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    DeviceObjectPage deviceObjectPage = DeviceObjectPage.getInstance();
                    deviceObjectPage.setBrowser(instrumentControlBrowser);
                    browserTreeNode.setPanel((JPanel)((Object)deviceObjectPage));
                    deviceObjectPage.addToStore(deviceObjectPageInfo, (ICDevice)device);
                    InstrumentControlBrowser.this.fObjectTablePage.addDeviceData(string, ((ICDevice)device).getConstructorDescription(), ((ICDevice)device).getConstructorWithInterfaceConstructor());
                    if (!InstrumentControlBrowser.this.fOkToAddInstrumentObjects) {
                        InstrumentControlBrowser.this.fInstrumentObjectsToAdd.addElement(browserTreeNode);
                        return;
                    }
                    InstrumentControlBrowser.this.postNodeAddedEvent(string2, stringArray, browserTreeNode, 2, false);
                    InstrumentControlBrowser.this.lastDeviceObjectNode = browserTreeNode;
                    InstrumentControlBrowser.this.postNodeExpandEvent(InstrumentControlBrowser.this.fDeviceObjectNode);
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void selectLastDeviceObjectInTree() {
        try {
            AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!InstrumentControlBrowser.this.fOkToAddInstrumentObjects || InstrumentControlBrowser.this.lastDeviceObjectNode == null) {
                        return;
                    }
                    InstrumentControlBrowser.this.postNodeSelectedEvent(InstrumentControlBrowser.this.lastDeviceObjectNode);
                    InstrumentControlBrowser.this.lastDeviceObjectNode = null;
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void deviceObjectDeleted(Device device, String string) {
        if (!this.fNodeEventsEnable) {
            return;
        }
        final String[] stringArray = new String[]{"Instrument Control Toolbox", "Instrument Objects", "Device Objects"};
        this.fAllDeviceObjects.removeElement(device);
        if (!this.fOkToAddInstrumentObjects) {
            this.fInstrumentObjectsToRemove.addElement(device);
            return;
        }
        DeviceObjectPage deviceObjectPage = DeviceObjectPage.getInstance();
        final DeviceObjectPageInfo deviceObjectPageInfo = deviceObjectPage.getInfoFromStore((ICDevice)device);
        deviceObjectPage.removeFromStore(deviceObjectPageInfo);
        try {
            AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    InstrumentControlBrowser.this.postNodeRemovedEvent(stringArray, deviceObjectPageInfo, 4);
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void propertyChanged(Object object, String string, Object object2) {
        if (!(object instanceof ICDevice)) {
            return;
        }
        if (!string.equals("Name")) {
            return;
        }
        int n = this.fDeviceObjectNode.getChildCount();
        DeviceObjectPage deviceObjectPage = DeviceObjectPage.getInstance();
        ICDevice iCDevice = (ICDevice)object;
        for (int i = 0; i < n; ++i) {
            final BrowserTreeNode browserTreeNode = (BrowserTreeNode)this.fDeviceObjectNode.getChildAt(i);
            ICDevice iCDevice2 = deviceObjectPage.getObjectFromStore((DeviceObjectPageInfo)browserTreeNode.getUserData());
            if (!iCDevice.equals(iCDevice2)) continue;
            browserTreeNode.setName((String)object2);
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        InstrumentControlBrowser.this.postNodeUpdatedEvent(browserTreeNode);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
    }

    private void deleteObject(Vector<Object> vector) {
        Object[] objectArray = new Object[vector.size()];
        try {
            for (int i = vector.size() - 1; i >= 0; --i) {
                Object object = vector.elementAt(i);
                if (object instanceof Instrument) {
                    Instrument instrument = (Instrument)object;
                    instrument.stopasync();
                    instrument.fclose();
                    instrument.dispose();
                } else {
                    ((ICDevice)object).dispose();
                }
                objectArray[i] = object;
            }
        }
        catch (TMException tMException) {
            MJOptionPane.showMessageDialog((Component)this.frame, (Object)tMException.getMessage(), (String)"Test & Measurement Tool", (int)2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.fMatlabArgs[1] = objectArray;
        Matlab.whenMatlabReady((Runnable)this);
    }

    @Override
    public void run() {
        try {
            Matlab.mtFeval((String)"instrgate", (Object[])this.fMatlabArgs, (int)0);
        }
        catch (Exception exception) {
            System.out.println("InstrumentObjectBrowserClient Exception: " + exception.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        int n = (Integer)jComponent.getClientProperty(ACTION);
        switch (n) {
            case 0: {
                if (this.fToolboxHelpRunnable == null) {
                    this.fToolboxHelpRunnable = new ToolboxHelpRunnable();
                }
                Matlab.whenMatlabReady((Runnable)this.fToolboxHelpRunnable);
                break;
            }
            case 1: {
                new AboutWindow(1, this.getBrowserFrame());
                break;
            }
            case 5: {
                this.createNewObjectDialog((Integer)jComponent.getClientProperty(OBJECT));
                break;
            }
            case 6: {
                this.refresh();
                break;
            }
            case 19: {
                this.refresh(((MJMenuItem)jComponent).getText(), (MJPanel)jComponent.getClientProperty(PANEL));
                break;
            }
            case 15: {
                new ScanOptionPanel().showAsDialog(this.getBrowserFrame());
                break;
            }
            case 13: {
                this.refresh(((MJMenuItem)jComponent).getText(), (MJPanel)jComponent.getClientProperty(PANEL));
                break;
            }
            case 11: {
                switch ((Integer)jComponent.getClientProperty(OBJECT)) {
                    case 5: {
                        new InstrumentObjectExporter(this.combineVectors(this.fAllInterfaceObjects, this.fAllDeviceObjects)).showAsDialog(this.getBrowserFrame());
                        break;
                    }
                    case 6: {
                        new InstrumentObjectExporter(this.fAllInterfaceObjects).showAsDialog(this.getBrowserFrame());
                        break;
                    }
                    case 7: {
                        new InstrumentObjectExporter(this.fAllDeviceObjects).showAsDialog(this.getBrowserFrame());
                    }
                }
                break;
            }
            case 26: {
                this.scanVisa();
                break;
            }
            case 25: {
                String string = (String)jComponent.getClientProperty(OBJECT);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection stringSelection = new StringSelection(string);
                clipboard.setContents(stringSelection, null);
                break;
            }
            case 7: {
                Vector<Object> vector = new Vector<Object>();
                vector.addElement(jComponent.getClientProperty(OBJECT));
                new InstrumentObjectExporter(vector).showAsDialog(this.getBrowserFrame());
                break;
            }
            case 14: {
                Instrument instrument = ((BrowserObject)jComponent.getClientProperty(OBJECT)).getInstrumentObject();
                Vector<Object> vector = new Vector<Object>();
                vector.addElement(instrument);
                new InstrumentObjectExporter(vector).showAsDialog(this.getBrowserFrame());
                break;
            }
            case 10: {
                Object object = jComponent.getClientProperty(PANEL);
                if (object instanceof CommunicationPage) {
                    CommunicationPage communicationPage = (CommunicationPage)object;
                    communicationPage.exportHistoryTable(this.getBrowserFrame());
                    break;
                }
                if (!(object instanceof DeviceObjectPage)) break;
                DeviceObjectPage deviceObjectPage = (DeviceObjectPage)object;
                deviceObjectPage.exportHistoryTable(this.getBrowserFrame());
                break;
            }
            case 8: {
                Object object = jComponent.getClientProperty(PANEL);
                if (object instanceof DeviceObjectPage) {
                    ((DeviceObjectPage)object).saveHistoryTable();
                    return;
                }
                if (!this.createSaveDialog()) {
                    return;
                }
                String string = ICSaveDialog.getFileNameWithPath();
                ((CommunicationPage)object).saveHistoryTable(string);
                break;
            }
            case 12: {
                switch ((Integer)jComponent.getClientProperty(OBJECT)) {
                    case 5: {
                        this.deleteObject(this.combineVectors(this.fAllInterfaceObjects, this.fAllDeviceObjects));
                        break;
                    }
                    case 6: {
                        this.deleteObject(this.fAllInterfaceObjects);
                        break;
                    }
                    case 7: {
                        this.deleteObject(this.fAllDeviceObjects);
                    }
                }
                break;
            }
            case 9: {
                Vector<Object> vector = new Vector<Object>();
                vector.addElement(jComponent.getClientProperty(OBJECT));
                this.deleteObject(vector);
                break;
            }
            case 21: {
                switch ((Integer)jComponent.getClientProperty(OBJECT)) {
                    case 5: {
                        this.fObjectTablePage.removeDuplicates(0);
                        break;
                    }
                    case 6: {
                        this.fObjectTablePage.removeDuplicates(1);
                        break;
                    }
                    case 7: {
                        this.fObjectTablePage.removeDuplicates(2);
                    }
                }
                break;
            }
            case 17: {
                MIDTool.newDocument(MatlabPath.getCWD());
                break;
            }
            case 16: {
                this.fDriverTablePage.scan((Integer)jComponent.getClientProperty(OBJECT));
                break;
            }
            case 18: {
                String string = (String)jComponent.getClientProperty(OBJECT);
                MIDTool.openDocument(string);
                break;
            }
            case 20: {
                DriverPageInfo driverPageInfo;
                if (this.fCreateObjectFromDriverDialog == null) {
                    this.fCreateObjectFromDriverDialog = new CreateObjectDialog();
                }
                if (!(driverPageInfo = (DriverPageInfo)jComponent.getClientProperty(OBJECT)).showDialog()) {
                    this.fCreateObjectFromDriverDialog.createObject(driverPageInfo);
                    return;
                }
                this.fCreateObjectFromDriverDialog.update(driverPageInfo);
                this.fCreateObjectFromDriverDialog.showAsDialog(this.getBrowserFrame(), this);
                break;
            }
            case 27: {
                BrowserTreeNode browserTreeNode = this.getSelectedNode();
                String string = browserTreeNode.getName();
                IviCInstrumentObjectStore.removeObject(string);
                break;
            }
            case 28: {
                BrowserTreeNode browserTreeNode = this.getSelectedNode();
                IviCInstrumentObjectStore.setSelectedIviInstrumentObject(browserTreeNode.getName());
                browserTreeNode.setEditable(true);
                this.postNodeEditingEvent(browserTreeNode);
                break;
            }
            case 22: {
                this.fIviPage.saveAsConfigStore();
                break;
            }
            case 23: {
                this.fIviPage.saveConfigStore();
                break;
            }
            case 24: {
                this.fIviPage.loadNewConfigStore();
                break;
            }
            case 2: {
                this.setNodeVisible(this.fLevel1, ((MJCheckBoxMenuItem)actionEvent.getSource()).isSelected(), 0);
                break;
            }
            case 3: {
                this.fOkToAddInstrumentObjects = ((MJCheckBoxMenuItem)actionEvent.getSource()).isSelected();
                int n2 = this.fRootNode.getChildCount();
                int n3 = 0;
                if (n2 != 0 && this.fRootNode.getChildAt(0).equals(this.fLevel1)) {
                    n3 = 1;
                }
                this.setNodeVisible(this.fLevel2, this.fOkToAddInstrumentObjects, n3);
                if (!this.fOkToAddInstrumentObjects) break;
                this.cleanupNodeAfterInsertion();
                break;
            }
            case 4: {
                this.setNodeVisible(this.fLevel3, ((MJCheckBoxMenuItem)actionEvent.getSource()).isSelected(), 2);
            }
        }
    }

    public void helpMenuActionPerformed(String string) {
    }

    private Vector<Object> combineVectors(Vector<Object> vector, Vector<Object> vector2) {
        Vector vector3 = (Vector)vector.clone();
        Vector vector4 = (Vector)vector2.clone();
        for (int i = 0; i < vector4.size(); ++i) {
            vector3.addElement(vector4.elementAt(i));
        }
        return vector3;
    }

    private void setNodeVisible(final BrowserTreeNode browserTreeNode, final boolean bl, final int n) {
        try {
            AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (bl) {
                        if (InstrumentControlBrowser.this.fRootNode.getChildCount() == 0) {
                            InstrumentControlBrowser.this.postNodeAddedEvent(InstrumentControlBrowser.this.fRootNode, browserTreeNode, true, n);
                        } else {
                            InstrumentControlBrowser.this.postNodeAddedEvent(InstrumentControlBrowser.this.fRootNode, browserTreeNode, false, n);
                        }
                    } else {
                        InstrumentControlBrowser.this.postNodeRemovedEvent(InstrumentControlBrowser.this.fRootNode, browserTreeNode);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void cleanupNodeAfterInsertion() {
        final String[] stringArray = new String[]{"Instrument Control Toolbox", "Instrument Objects", ""};
        int n = 0;
        if (n < this.fInstrumentObjectsToAdd.size()) {
            final BrowserTreeNode browserTreeNode = this.fInstrumentObjectsToAdd.elementAt(n);
            if (browserTreeNode.getType() == 8) {
                stringArray[2] = "Interface Objects";
                CommunicationInfo communicationInfo = (CommunicationInfo)browserTreeNode.getUserData();
                this.fInstrumentObjectNodes.put(communicationInfo.getInstrumentObject(), browserTreeNode);
            } else {
                stringArray[2] = "Device Objects";
            }
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        InstrumentControlBrowser.this.postNodeAddedEvent(browserTreeNode.getName(), stringArray, browserTreeNode, 2, false);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        try {
            AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < InstrumentControlBrowser.this.fInstrumentObjectsToRemove.size(); ++i) {
                        Object object;
                        Object e = InstrumentControlBrowser.this.fInstrumentObjectsToRemove.elementAt(i);
                        if (e instanceof Instrument) {
                            stringArray[2] = "Interface Objects";
                            object = InstrumentControlBrowser.this.fCommunicationInfoStore.findInstrument((Instrument)e);
                            InstrumentControlBrowser.this.postNodeRemovedEvent(stringArray, object, 0);
                            InstrumentControlBrowser.this.fCommunicationInfoStore.removeInstrument((CommunicationInfo)object);
                            InstrumentControlBrowser.this.fInstrumentObjectNodes.remove(e);
                            continue;
                        }
                        stringArray[2] = "Device Objects";
                        object = DeviceObjectPage.getInstance();
                        DeviceObjectPageInfo deviceObjectPageInfo = ((DeviceObjectPage)object).getInfoFromStore((ICDevice)e);
                        ((DeviceObjectPage)object).removeFromStore(deviceObjectPageInfo);
                        InstrumentControlBrowser.this.postNodeRemovedEvent(stringArray, deviceObjectPageInfo, 0);
                    }
                    InstrumentControlBrowser.this.fInstrumentObjectsToAdd.removeAllElements();
                    InstrumentControlBrowser.this.fInstrumentObjectsToRemove.removeAllElements();
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public BrowserTreeNode getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(BrowserTreeNode browserTreeNode) {
        this.selectedNode = browserTreeNode;
    }

    protected void createNewObjectDialog(int n) {
        int n2 = 0;
        switch (n) {
            case 5: {
                n2 = 0;
                break;
            }
            case 6: {
                n2 = 1;
                break;
            }
            case 7: {
                n2 = 2;
            }
        }
        if (this.fNewObjectDialog == null) {
            this.fNewObjectDialog = new NewObjectDialog(n2);
        } else {
            this.fNewObjectDialog.setInstrumentObjType(n2);
        }
        this.fNewObjectDialog.showAsDialog(this.getBrowserFrame(), true);
    }

    public boolean createSaveDialog() {
        return ICSaveDialog.save(".m", "Save Session Log", "MATLAB Files (*.m)", this.getBrowserFrame());
    }

    public BrowserTreeNode getDriverNode(int n) {
        switch (n) {
            case 1: {
                return this.fMatlabDriverNode;
            }
            case 2: {
                return this.fVxipnpDriverNode;
            }
        }
        return null;
    }

    public void addNode(final String string, final String[] stringArray) {
        InstrumentControlBrowser instrumentControlBrowser = this;
        final BrowserTreeNode browserTreeNode = new BrowserTreeNode(string, (BrowserClient)instrumentControlBrowser);
        if (SwingUtilities.isEventDispatchThread()) {
            this.postNodeAddedEvent(string, stringArray, browserTreeNode, 1, false);
        } else {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        InstrumentControlBrowser.this.postNodeAddedEvent(string, stringArray, browserTreeNode, 1, false);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.storeNode(stringArray, string, browserTreeNode);
    }

    public void addNode(final String string, final String[] stringArray, final BrowserTreeNode browserTreeNode) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.postNodeAddedEvent(string, stringArray, browserTreeNode, 1, false);
        } else {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        InstrumentControlBrowser.this.postNodeAddedEvent(string, stringArray, browserTreeNode, 1, false);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.storeNode(stringArray, string, browserTreeNode);
    }

    public void addNode(final String string, final String[] stringArray, final BrowserTreeNode browserTreeNode, final int n) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.postNodeAddedEvent(string, stringArray, browserTreeNode, 1, false, n);
        } else {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        InstrumentControlBrowser.this.postNodeAddedEvent(string, stringArray, browserTreeNode, 1, false, n);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.storeNode(stringArray, string, browserTreeNode);
    }

    public void removeNode(final String string, final String[] stringArray) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        InstrumentControlBrowser.this.postNodeRemovedEvent(string, stringArray, 0);
                        InstrumentControlBrowser.this.cleanupNode(stringArray, string);
                    }
                });
            }
            catch (Throwable throwable) {}
        } else {
            this.postNodeRemovedEvent(string, stringArray, 0);
            this.cleanupNode(stringArray, string);
        }
    }

    public void removeNode(final String string, final String[] stringArray, final Object object) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        InstrumentControlBrowser.this.postNodeRemovedEvent(stringArray, object, 0);
                        InstrumentControlBrowser.this.cleanupNode(stringArray, string);
                    }
                });
            }
            catch (Throwable throwable) {}
        } else {
            this.postNodeRemovedEvent(stringArray, object, 0);
            this.cleanupNode(stringArray, string);
        }
    }

    private void storeNode(String[] stringArray, String string, BrowserTreeNode browserTreeNode) {
        this.fHardwareInstrumentNodes.put(this.createKey(stringArray, string), browserTreeNode);
    }

    private void cleanupNode(String[] stringArray, String string) {
        BrowserTreeNode browserTreeNode = this.fHardwareInstrumentNodes.get(this.createKey(stringArray, string));
        if (browserTreeNode != null) {
            this.fHardwareInstrumentNodes.remove(this.createKey(stringArray, string));
        } else {
            int n = string.indexOf("(");
            if (n != -1) {
                this.fHardwareInstrumentNodes.remove(this.createKey(stringArray, string.substring(0, n - 1)));
            }
        }
    }

    public BrowserTreeNode getNode(String[] stringArray, String string) {
        return this.fHardwareInstrumentNodes.get(this.createKey(stringArray, string));
    }

    private String createKey(String[] stringArray, String string) {
        String string2 = "";
        if (stringArray.length > 2 && stringArray[2].startsWith("VXIplug&play Drivers")) {
            stringArray[2] = new String("VXIplug&&play Drivers");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = string2 + stringArray[i] + " ";
        }
        string2 = string2 + string;
        return string2;
    }

    public MJFrame getBrowserFrame() {
        if (this.frame == null && this.browser != null) {
            this.frame = (MJFrame)SwingUtilities.windowForComponent((Component)this.browser);
        }
        if (this.frame == null) {
            this.frame = ICTBrowserDesktop.getInstance().getMainFrame();
        }
        return this.frame;
    }

    public void postStatusBarUpdateEvent(String string) {
        ICTBrowserDesktop.getInstance().setStatusText(string);
    }

    public void postBlockEventsEvent(boolean bl) {
        if (ICTBrowserDesktop.getInstance().getMainFrame() == null) {
            return;
        }
        ICTBrowserDesktop.getInstance().enableGlassPane(bl);
    }

    public MJMenu getCurrentNodeMenu(BrowserTreeNode browserTreeNode) {
        switch (browserTreeNode.getType()) {
            case 4: {
                return this.getInstrumentNodeMenu(((CommunicationInfo)browserTreeNode.getUserData()).getBrowserObject(), browserTreeNode);
            }
            case 8: {
                return this.getInstrumentObjectChildNodeMenu(((CommunicationInfo)browserTreeNode.getUserData()).getInstrumentObject(), browserTreeNode);
            }
            case 10: {
                return this.getInstrumentObjectChildNodeMenu(((DeviceObjectPageInfo)browserTreeNode.getUserData()).getObject(), browserTreeNode);
            }
            case 5: {
                return this.getInstrumentObjectNodeMenu("Instrument", INSTRUMENT_OBJECT_LEVEL_INT);
            }
            case 6: {
                return this.getInstrumentObjectNodeMenu("Interface", INTERFACE_OBJECT_LEVEL_INT);
            }
            case 7: {
                return this.getInstrumentObjectNodeMenu("Device", DEVICE_OBJECT_LEVEL_INT);
            }
            case 14: {
                return this.getIndividualMLDriverNodeMenu((DriverPageInfo)browserTreeNode.getUserData());
            }
            case 13: {
                return this.getIVINodeMenu();
            }
            case 19: {
                return this.getIVIInstrumentObjectNodeMenu(browserTreeNode);
            }
        }
        return null;
    }

    public MJMenu getIVIInstrumentObjectNodeMenu(BrowserTreeNode browserTreeNode) {
        MJMenu mJMenu = new MJMenu("File");
        MJMenuItem mJMenuItem = new MJMenuItem("Delete IVI Instrument Object");
        mJMenuItem.addActionListener((ActionListener)this);
        mJMenuItem.putClientProperty((Object)OBJECT, (Object)((String)browserTreeNode.getUserData()));
        mJMenuItem.putClientProperty((Object)ACTION, (Object)new Integer(27));
        MJMenuItem mJMenuItem2 = new MJMenuItem("Rename IVI Instrument Object");
        mJMenuItem2.addActionListener((ActionListener)this);
        mJMenuItem2.putClientProperty((Object)ACTION, (Object)new Integer(28));
        mJMenu.add((JMenuItem)mJMenuItem);
        mJMenu.add((JMenuItem)mJMenuItem2);
        mJMenu.addSeparator();
        return mJMenu;
    }

    public MJMenu getIVINodeMenu() {
        MJMenu mJMenu = new MJMenu("File");
        this.saveConfigurationStoreMenu = new MJMenuItem("Save IVI Configuration Store");
        this.saveConfigurationStoreMenu.addActionListener((ActionListener)this);
        this.saveConfigurationStoreMenu.putClientProperty((Object)ACTION, (Object)new Integer(23));
        MJMenuItem mJMenuItem = new MJMenuItem("Save IVI Configuration Store As...");
        mJMenuItem.addActionListener((ActionListener)this);
        mJMenuItem.putClientProperty((Object)ACTION, (Object)new Integer(22));
        MJMenuItem mJMenuItem2 = new MJMenuItem("Load IVI Configuration Store...");
        mJMenuItem2.addActionListener((ActionListener)this);
        mJMenuItem2.putClientProperty((Object)ACTION, (Object)new Integer(24));
        mJMenu.add((JMenuItem)this.saveConfigurationStoreMenu);
        mJMenu.add((JMenuItem)mJMenuItem);
        mJMenu.add((JMenuItem)mJMenuItem2);
        mJMenu.addSeparator();
        return mJMenu;
    }

    private MJMenu getIndividualMLDriverNodeMenu(DriverPageInfo driverPageInfo) {
        MJMenu mJMenu = new MJMenu("File");
        this.fEditMLDriverMenu = new MJMenuItem("Edit MATLAB Instrument Driver...");
        this.fEditMLDriverMenu.addActionListener((ActionListener)this);
        this.fEditMLDriverMenu.putClientProperty((Object)ACTION, (Object)new Integer(18));
        this.fEditMLDriverMenu.putClientProperty((Object)OBJECT, (Object)driverPageInfo.getDriverNameWithPath());
        this.fCreateMLDeviceObjMenu = new MJMenuItem("Create Device Object Using Driver...");
        this.fCreateMLDeviceObjMenu.addActionListener((ActionListener)this);
        this.fCreateMLDeviceObjMenu.putClientProperty((Object)ACTION, (Object)new Integer(20));
        this.fCreateMLDeviceObjMenu.putClientProperty((Object)OBJECT, (Object)driverPageInfo);
        mJMenu.add((JMenuItem)this.fEditMLDriverMenu);
        mJMenu.add((JMenuItem)this.fCreateMLDeviceObjMenu);
        mJMenu.addSeparator();
        this.fCreateMLDeviceObjMenu.putClientProperty((Object)OBJECT, (Object)driverPageInfo);
        this.fEditMLDriverMenu.putClientProperty((Object)OBJECT, (Object)driverPageInfo.getDriverNameWithPath());
        return mJMenu;
    }

    private MJMenu getInstrumentObjectNodeMenu(String string, Integer n) {
        MJMenu mJMenu = new MJMenu("File");
        MJMenuItem mJMenuItem = new MJMenuItem("Export " + string + " Object(s)...");
        mJMenuItem.addActionListener((ActionListener)this);
        mJMenuItem.putClientProperty((Object)ACTION, (Object)new Integer(11));
        mJMenuItem.putClientProperty((Object)OBJECT, (Object)n);
        MJMenuItem mJMenuItem2 = new MJMenuItem("Delete " + string + " Object(s)");
        mJMenuItem2.addActionListener((ActionListener)this);
        mJMenuItem2.putClientProperty((Object)ACTION, (Object)new Integer(12));
        mJMenuItem2.putClientProperty((Object)OBJECT, (Object)n);
        this.fRemoveDuplicatesMenu = new MJMenuItem("Remove Duplicates from History Table");
        this.fRemoveDuplicatesMenu.addActionListener((ActionListener)this);
        this.fRemoveDuplicatesMenu.putClientProperty((Object)ACTION, (Object)new Integer(21));
        this.fRemoveDuplicatesMenu.putClientProperty((Object)OBJECT, (Object)n);
        mJMenu.add((JMenuItem)mJMenuItem);
        mJMenu.add((JMenuItem)mJMenuItem2);
        mJMenu.add((JMenuItem)this.fRemoveDuplicatesMenu);
        mJMenu.addSeparator();
        this.fRemoveDuplicatesMenu.putClientProperty((Object)OBJECT, (Object)n);
        return mJMenu;
    }

    private MJMenu getInstrumentObjectChildNodeMenu(Object object, BrowserTreeNode browserTreeNode) {
        MJMenu mJMenu = new MJMenu("File");
        MJMenu mJMenu2 = new MJMenu("Export");
        this.fInstrumentChildNodeObjectMenu = new MJMenuItem("Instrument Object...");
        this.fInstrumentChildNodeExportComm = new MJMenuItem("Instrument Response(s)...");
        this.fInstrumentChildNodeSaveComm = new MJMenuItem("Save Session Log...");
        this.fInstrumentChildNodeDeleteMenu = new MJMenuItem("Delete Object");
        mJMenu.add((JMenuItem)mJMenu2);
        mJMenu2.add((JMenuItem)this.fInstrumentChildNodeObjectMenu);
        mJMenu2.add((JMenuItem)this.fInstrumentChildNodeExportComm);
        mJMenu.add((JMenuItem)this.fInstrumentChildNodeSaveComm);
        mJMenu.add((JMenuItem)this.fInstrumentChildNodeDeleteMenu);
        mJMenu.addSeparator();
        this.fInstrumentChildNodeObjectMenu.addActionListener((ActionListener)this);
        this.fInstrumentChildNodeObjectMenu.putClientProperty((Object)ACTION, (Object)new Integer(7));
        this.fInstrumentChildNodeDeleteMenu.addActionListener((ActionListener)this);
        this.fInstrumentChildNodeDeleteMenu.putClientProperty((Object)ACTION, (Object)new Integer(9));
        this.fInstrumentChildNodeSaveComm.addActionListener((ActionListener)this);
        this.fInstrumentChildNodeSaveComm.putClientProperty((Object)ACTION, (Object)new Integer(8));
        this.fInstrumentChildNodeExportComm.addActionListener((ActionListener)this);
        this.fInstrumentChildNodeExportComm.putClientProperty((Object)ACTION, (Object)new Integer(10));
        this.updateInstrumentChildNodeMenus(object, browserTreeNode);
        return mJMenu;
    }

    private MJMenu getInstrumentNodeMenu(BrowserObject browserObject, BrowserTreeNode browserTreeNode) {
        MJMenu mJMenu = new MJMenu("File");
        MJMenu mJMenu2 = new MJMenu("Export");
        this.fInstrumentNodeObjectMenu = new MJMenuItem("Instrument Object...");
        this.fInstrumentNodeExportComm = new MJMenuItem("Instrument Response(s)...");
        this.fInstrumentNodeSaveComm = new MJMenuItem("Save Session Log...");
        mJMenu.add((JMenuItem)mJMenu2);
        mJMenu2.add((JMenuItem)this.fInstrumentNodeObjectMenu);
        mJMenu2.add((JMenuItem)this.fInstrumentNodeExportComm);
        mJMenu.add((JMenuItem)this.fInstrumentNodeSaveComm);
        mJMenu.addSeparator();
        this.fInstrumentNodeObjectMenu.addActionListener((ActionListener)this);
        this.fInstrumentNodeObjectMenu.putClientProperty((Object)ACTION, (Object)new Integer(14));
        this.fInstrumentNodeSaveComm.addActionListener((ActionListener)this);
        this.fInstrumentNodeSaveComm.putClientProperty((Object)ACTION, (Object)new Integer(8));
        this.fInstrumentNodeExportComm.addActionListener((ActionListener)this);
        this.fInstrumentNodeExportComm.putClientProperty((Object)ACTION, (Object)new Integer(10));
        this.updateInstrumentNodeMenus(browserObject, browserTreeNode);
        return mJMenu;
    }

    public void updateMenu(MJMenu mJMenu, BrowserTreeNode browserTreeNode) {
        switch (browserTreeNode.getType()) {
            case 5: {
                this.configureMenusForObjectLevelNodes(mJMenu, "Instrument", INSTRUMENT_OBJECT_LEVEL_INT, this.fAllInterfaceObjects.size() + this.fAllDeviceObjects.size());
                return;
            }
            case 6: {
                this.configureMenusForObjectLevelNodes(mJMenu, "Interface", INTERFACE_OBJECT_LEVEL_INT, this.fAllInterfaceObjects.size());
                return;
            }
            case 7: {
                this.configureMenusForObjectLevelNodes(mJMenu, "Device", DEVICE_OBJECT_LEVEL_INT, this.fAllDeviceObjects.size());
                return;
            }
            case 8: {
                this.updateInstrumentChildNodeMenus(((CommunicationInfo)browserTreeNode.getUserData()).getInstrumentObject(), browserTreeNode);
                break;
            }
            case 10: {
                this.updateInstrumentChildNodeMenus(((DeviceObjectPageInfo)browserTreeNode.getUserData()).getObject(), browserTreeNode);
                break;
            }
            case 4: {
                Instrument instrument = ((CommunicationInfo)browserTreeNode.getUserData()).getInstrumentObject();
                JMenuItem jMenuItem = mJMenu.getItem(1);
                if (instrument == null || !instrument.isvalid()) {
                    this.fInstrumentNodeObjectMenu.setEnabled(false);
                    this.fInstrumentNodeExportComm.setEnabled(false);
                    jMenuItem.setEnabled(false);
                    break;
                }
                this.fInstrumentNodeObjectMenu.setEnabled(true);
                this.fInstrumentNodeExportComm.setEnabled(true);
                jMenuItem.setEnabled(true);
                break;
            }
            case 13: {
                this.saveConfigurationStoreMenu.setEnabled(this.fIviPage.isDirty());
            }
        }
    }

    public boolean hasBluetoothObject() {
        for (int i = 0; i < this.fAllInterfaceObjects.size(); ++i) {
            Instrument instrument = (Instrument)this.fAllInterfaceObjects.elementAt(i);
            if (!instrument.getDisplayName().contains("bluetooth")) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ String[] access$1002(InstrumentControlBrowser instrumentControlBrowser, String[] stringArray) {
        instrumentControlBrowser.fVisaPorts = stringArray;
        return stringArray;
    }

    public class VISAInfoRunnable
    implements Runnable,
    MatlabListener {
        private Object[] args = new Object[]{"privateBrowserHelper", "isVisaSupported"};
        private Matlab matlab = new Matlab();

        @Override
        public void run() {
            try {
                this.matlab.feval("instrgate", this.args, 1, (MatlabListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            Object object = matlabEvent.getResult();
            if (object instanceof String[]) {
                sVisaSupported = true;
                InstrumentControlBrowser.access$1002(InstrumentControlBrowser.this, (String[])object);
            } else {
                sVisaSupported = false;
            }
        }
    }
}

