/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.driver;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.toolbox.instrument.browser.driver.IVITab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IVISoftwareModuleTab
extends IVITab
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private static final int DESCRIPTION = 0;
    private static final int MODELS = 1;
    private static final int PHYSICAL_NAMES = 2;
    private JList list;
    private DefaultListModel listModel;
    private JLabel name;
    private JTextArea description;
    private MJMultilineLabel models;
    private DefaultListModel physicalNameListModel;
    private JList physicalNameList;
    private Hashtable<String, Object[]> drivers;

    public IVISoftwareModuleTab() {
        this.layoutPanel();
    }

    private void layoutPanel() {
        this.name = new JLabel();
        this.description = new JTextArea();
        this.models = new MJMultilineLabel(true);
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        this.description.setBackground(this.name.getBackground());
        this.description.setForeground(this.name.getForeground());
        this.description.setFont(this.name.getFont());
        this.description.setEditable(false);
        this.models.setWrapStyleWord(true);
        JPanel jPanel = this.add((JComponent)new MJLabel("Name:"), this.name, 2);
        JPanel jPanel2 = this.add((JComponent)new MJLabel("Description:"), this.description, 2);
        JPanel jPanel3 = this.add((JComponent)new MJLabel("Supported instrument models:"), (JComponent)this.models, 2);
        this.physicalNameListModel = new DefaultListModel();
        this.physicalNameList = new JList(this.physicalNameListModel);
        JScrollPane jScrollPane = new JScrollPane(this.physicalNameList);
        jScrollPane.setPreferredSize(new Dimension(180, 106));
        JPanel jPanel4 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel4.add(jScrollPane);
        JPanel jPanel5 = new JPanel(new BorderLayout(0, 4));
        jPanel5.add((Component)new JLabel("Physical names:"), "North");
        jPanel5.add((Component)jPanel4, "Center");
        JPanel jPanel6 = this.add(jPanel, jPanel3, 12);
        JPanel jPanel7 = this.add(jPanel6, jPanel2, 12);
        JPanel jPanel8 = this.add(jPanel7, jPanel5, 12);
        JPanel jPanel9 = new JPanel(new BorderLayout(0, 0));
        jPanel9.add((Component)jPanel8, "North");
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        JScrollPane jScrollPane2 = new JScrollPane(this.list);
        jScrollPane2.setPreferredSize(new Dimension(180, 60));
        JPanel jPanel10 = new JPanel(new BorderLayout(0, 0));
        jPanel10.add((Component)jScrollPane2, "Center");
        jPanel10.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        this.add((Component)jPanel10, "West");
        this.add((Component)jPanel9, "Center");
        this.list.addListSelectionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.list.getSelectedIndex();
        if (n == -1) {
            String[] stringArray = new String[]{""};
            this.updateComponents("", "", "", stringArray);
            return;
        }
        String string = (String)this.listModel.elementAt(n);
        Object[] objectArray = this.drivers.get(string);
        this.updateComponents(string, (String)objectArray[0], (String)objectArray[1], (String[])objectArray[2]);
    }

    private void updateComponents(String string, String string2, String string3, String[] stringArray) {
        this.name.setText(string);
        this.description.setText(string2);
        this.models.setText(string3);
        this.physicalNameListModel.removeAllElements();
        for (int i = 0; i < stringArray.length; ++i) {
            this.physicalNameListModel.addElement(stringArray[i]);
        }
    }

    protected String[] getAllItems() {
        String[] stringArray = new String[this.listModel.getSize()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)this.listModel.getElementAt(i);
        }
        return stringArray;
    }

    public void removeAllElements() {
        this.listModel.removeAllElements();
    }

    public void updateForNewDriver(Object[] objectArray) {
        this.parse(objectArray);
    }

    private void parse(Object[] objectArray) {
        this.drivers = new Hashtable();
        for (int i = 0; i < objectArray.length; ++i) {
            Object[] objectArray2 = (Object[])objectArray[i];
            String string = (String)objectArray2[0];
            Object[] objectArray3 = new Object[]{objectArray2[1], objectArray2[2], objectArray2[3]};
            this.drivers.put(string, objectArray3);
            this.listModel.addElement(string);
        }
        if (objectArray.length > 0) {
            this.list.setSelectedIndex(0);
            this.valueChanged(null);
        }
    }
}

