/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.hardware;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.DefaultSortableTable;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowser;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowserPage;
import com.mathworks.toolbox.instrument.browser.hardware.BoardPage;
import com.mathworks.toolbox.instrument.browser.interfaceobj.CommunicationInfo;
import com.mathworks.toolbox.instrument.browser.interfaceobj.CommunicationPage;
import com.mathworks.toolbox.instrument.browser.objects.BrowserObject;
import com.mathworks.toolbox.instrument.browser.objects.VisaGenericObject;
import com.mathworks.toolbox.instrument.guiutil.MatrixTableModel;
import com.mathworks.toolbox.testmeas.browser.BrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserConfigFileWriter;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import org.w3c.dom.Element;

public class VisaMorePage
extends InstrumentControlBrowserPage
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private String[] headings = new String[]{"Vendor", "Configuration", "Identification"};
    private Object[][] data;
    private MatrixTableModel tableModel;
    private DefaultSortableTable table;
    private JButton scanButton;
    private JLabel lastScanDateLabel;
    private String initialDate;
    private InstrumentControlBrowser browser;
    private String[] path = new String[]{"Instrument Control Toolbox", "Hardware", "VISA", "More"};
    private Object[] matlabArgs;
    private Vector<BrowserTreeNode> currentNodes = new Vector();
    private Vector<BrowserTreeNode> lastNodes = new Vector();
    private boolean disableOnStart = false;
    private boolean enableOnFinish = false;
    private ScanVISAMoreRunnable scanVISAMoreRunnable = null;

    public VisaMorePage(InstrumentControlBrowser instrumentControlBrowser) {
        this.browser = instrumentControlBrowser;
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.layoutPanel();
        this.matlabArgs = new Object[2];
        this.matlabArgs[0] = "privateBrowserHelper";
        this.matlabArgs[1] = "identifyVISAMore";
        this.cleanup();
    }

    private void layoutPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 10, 0, 10));
        this.add(jPanel, "Center");
        this.tableModel = new MatrixTableModel(this.headings);
        this.table = new DefaultSortableTable((TableModel)this.tableModel);
        this.table.setName("Serial Hardware Table");
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.setReorderingAllowed(true);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(400);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(400);
        JScrollPane jScrollPane = new JScrollPane((Component)this.table);
        jPanel.add((Component)jScrollPane, "Center");
        jScrollPane.setPreferredSize(new Dimension(50, 50));
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
        this.initialDate = TMStringUtil.getDate();
        this.lastScanDateLabel = new JLabel("Last scan date: " + this.initialDate);
        jPanel2.add((Component)this.lastScanDateLabel, "West");
        jPanel2.add((Component)this.createButtonPanel(), "Center");
        jPanel.add((Component)jPanel2, "South");
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1, 0, 0));
        this.scanButton = new JButton("Scan");
        this.scanButton.addActionListener(this);
        this.scanButton.setName("Serial Scan Button");
        jPanel2.add(this.scanButton);
        jPanel.add(jPanel2);
        return jPanel;
    }

    @Override
    public void setup() {
        this.scanButton.addActionListener(this);
    }

    @Override
    public void cleanup() {
        this.scanButton.removeActionListener(this);
    }

    @Override
    public void dispose() {
        this.cleanup();
        this.headings = null;
        this.data = null;
    }

    public void save(BrowserConfigFileWriter browserConfigFileWriter, Element element) {
        if (this.data == null) {
            return;
        }
        String string = this.lastScanDateLabel.getText();
        for (int i = 0; i < this.data.length; ++i) {
            String string2 = (String)this.data[i][0];
            if (string2.equals(BoardPage.NO_INSTRUMENT_STRING)) continue;
            Element element2 = browserConfigFileWriter.addNode(element, "Instrument");
            element2.setAttribute("Type", "visa-more");
            element2.setAttribute("LastScanDate", string);
            element2.setAttribute("Identification", (String)this.data[i][2]);
            element2.setAttribute("Vendor", (String)this.data[i][0]);
            element2.setAttribute("Configuration", (String)this.data[i][1]);
        }
    }

    public void load(String string, String string2, Element element) {
        this.lastScanDateLabel.setText(string2);
        int n = string2.indexOf(": ");
        string2 = string2.substring(n + 2);
        String string3 = element.getAttribute("Vendor");
        String string4 = element.getAttribute("Configuration");
        Object[] objectArray = new Object[]{string3, string4, string};
        this.tableModel.append(objectArray);
        this.data = this.tableModel.getData();
        BrowserTreeNode browserTreeNode = this.createNode(string3, string4, string, string2);
        this.lastNodes.add(browserTreeNode);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.disableOnStart = true;
        this.enableOnFinish = true;
        this.getGUIReadyForMATLABCall();
    }

    public void scanForAll() {
        this.disableOnStart = true;
        this.enableOnFinish = true;
        this.getGUIReadyForMATLABCall();
    }

    @Override
    public void scanForAll(boolean bl, boolean bl2) {
        this.disableOnStart = bl;
        this.enableOnFinish = bl2;
        this.getGUIReadyForMATLABCall();
    }

    public void getGUIReadyForMATLABCall() {
        if (this.disableOnStart) {
            this.browser.postBlockEventsEvent(true);
        }
        this.browser.postStatusBarUpdateEvent("Scanning for more instruments using VISA");
        Instrument.enableInstrumentObjectEvents(false);
        if (this.scanVISAMoreRunnable == null) {
            this.scanVISAMoreRunnable = new ScanVISAMoreRunnable();
        }
        Matlab.whenMatlabReady((Runnable)this.scanVISAMoreRunnable);
    }

    private void updateTableData(Object object) {
        String string = TMStringUtil.getDate();
        this.lastScanDateLabel.setText("Last scan date: " + string);
        String[] stringArray = (String[])object;
        this.data = new Object[stringArray.length / 3][this.headings.length];
        int n = 0;
        if (this.data.length == 0) {
            this.data = new Object[1][this.headings.length];
            this.data[0][0] = BoardPage.NO_INSTRUMENT_STRING;
            this.data[0][1] = "";
            this.data[0][2] = "";
        } else {
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i][0] = stringArray[n++];
                this.data[i][1] = stringArray[n++];
                this.data[i][2] = stringArray[n++];
                BrowserTreeNode browserTreeNode = this.createNode((String)this.data[i][0], (String)this.data[i][1], (String)this.data[i][2], string);
                this.currentNodes.add(browserTreeNode);
            }
        }
        if (this.tableModel != null) {
            this.tableModel.setData(this.data);
        }
        this.cleanupNodes();
    }

    private BrowserTreeNode createNode(String string, String string2, String string3, String string4) {
        String string5 = this.defineNodeIDString(string3);
        String string6 = string2;
        BrowserTreeNode browserTreeNode = this.browser.getNode(this.path, string6);
        if (string3.equals(BoardPage.NO_INSTRUMENT_STRING)) {
            if (browserTreeNode == null) {
                browserTreeNode = new BrowserTreeNode(string6 + string5, (BrowserClient)this.browser);
                browserTreeNode.setType(16);
                browserTreeNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\visaGeneric_instrument.html");
                browserTreeNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "visa_generic_config");
                browserTreeNode.setPanel((JPanel)((Object)new InstrumentControlBrowserPage()));
                browserTreeNode.setUserData((Object)new Integer(BoardPage.NO_INSTRUMENT_NODE_COUNT++));
                this.browser.addNode(string6, this.path, browserTreeNode);
            }
        } else if (browserTreeNode == null) {
            browserTreeNode = new BrowserTreeNode(string6 + string5, (BrowserClient)this.browser);
            browserTreeNode.setType(4);
            browserTreeNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\visaGeneric_instrument.html");
            browserTreeNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "visa_generic_config");
            VisaGenericObject visaGenericObject = new VisaGenericObject(string, string2, string4);
            CommunicationPage communicationPage = CommunicationPage.getInstance(this.browser);
            CommunicationInfo communicationInfo = new CommunicationInfo(visaGenericObject);
            this.browser.addToCommunicationInfoStore(communicationInfo);
            visaGenericObject.setPanel(communicationPage);
            browserTreeNode.setPanel((JPanel)((Object)communicationPage));
            browserTreeNode.setUserData((Object)communicationInfo);
            this.browser.addNode(string6, this.path, browserTreeNode);
        } else {
            CommunicationInfo communicationInfo = (CommunicationInfo)browserTreeNode.getUserData();
            BrowserObject browserObject = communicationInfo.getBrowserObject();
            browserObject.setIdentification(string3);
            browserObject.setScanDate(string4);
            browserTreeNode.setName(string6 + string5);
        }
        return browserTreeNode;
    }

    private String defineNodeIDString(String string) {
        String string2 = string;
        string2 = string2.equals("No instrument was identified") ? "" : " (" + string2 + ")";
        return string2;
    }

    private void cleanupNodes() {
        for (int i = 0; i < this.lastNodes.size(); ++i) {
            if (this.currentNodes.contains(this.lastNodes.elementAt(i))) continue;
            BrowserTreeNode browserTreeNode = this.lastNodes.elementAt(i);
            this.browser.removeNode(browserTreeNode.getName(), this.path, browserTreeNode.getUserData());
            this.browser.removeBrowserObjectFromCommunicationInfoStore((CommunicationInfo)browserTreeNode.getUserData());
        }
        this.lastNodes = this.currentNodes;
        this.currentNodes = null;
        this.currentNodes = new Vector();
    }

    public class ScanVISAMoreRunnable
    implements Runnable,
    MatlabListener {
        private Matlab matlab = new Matlab();

        @Override
        public void run() {
            try {
                this.matlab.feval("instrgate", VisaMorePage.this.matlabArgs, 1, (MatlabListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            Instrument.enableInstrumentObjectEvents(true);
            if (matlabEvent.getStatus() == 0) {
                Object object = matlabEvent.getResult();
                VisaMorePage.this.updateTableData(object);
            }
            VisaMorePage.this.browser.postStatusBarUpdateEvent("");
            if (VisaMorePage.this.enableOnFinish) {
                VisaMorePage.this.browser.postBlockEventsEvent(false);
            }
            VisaMorePage.this.browser.postRefreshFinishedEvent();
        }
    }
}

