/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.interfaceobj;

import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.browser.interfaceobj.CommunicationInfo;
import com.mathworks.toolbox.instrument.browser.objects.BrowserObject;
import java.util.Vector;

public class CommunicationInfoStore {
    private Vector<CommunicationInfo> allScannedHW = new Vector();
    private Vector<CommunicationInfo> allInstrumentObject = new Vector();

    public void dispose() {
        CommunicationInfo communicationInfo;
        int n;
        for (n = 0; n < this.allScannedHW.size(); ++n) {
            communicationInfo = this.allScannedHW.elementAt(n);
            communicationInfo.dispose();
            communicationInfo = null;
        }
        for (n = 0; n < this.allInstrumentObject.size(); ++n) {
            communicationInfo = this.allInstrumentObject.elementAt(n);
            communicationInfo.dispose();
            communicationInfo = null;
        }
        this.allScannedHW.removeAllElements();
        this.allInstrumentObject.removeAllElements();
        this.allScannedHW = null;
        this.allInstrumentObject = null;
    }

    public void add(CommunicationInfo communicationInfo) {
        switch (communicationInfo.getType()) {
            case 0: {
                this.allScannedHW.addElement(communicationInfo);
                break;
            }
            case 1: {
                this.allInstrumentObject.addElement(communicationInfo);
            }
        }
    }

    public void synchronize(CommunicationInfo communicationInfo) {
        int n = communicationInfo.getType();
        CommunicationInfo communicationInfo2 = null;
        communicationInfo2 = n == 0 ? this.find(communicationInfo.getBrowserObject()) : this.find(communicationInfo.getInstrumentObject());
        if (communicationInfo2 == null) {
            return;
        }
        communicationInfo2.setWritePanelCommandIndex(communicationInfo.getWritePanelCommandIndex());
        communicationInfo2.setWritePanelFormatIndex(communicationInfo.getWritePanelFormatIndex());
        communicationInfo2.setWritePanelEvaluateCommand(communicationInfo.getWritePanelEvaluateCommand());
        communicationInfo2.setWritePanelCommands(communicationInfo.getWritePanelCommands());
        communicationInfo2.setReadPanelCommandIndex(communicationInfo.getReadPanelCommandIndex());
        communicationInfo2.setReadPanelFormatIndex(communicationInfo.getReadPanelFormatIndex());
        communicationInfo2.setReadSize(communicationInfo.getReadSize());
        communicationInfo2.setResponseText(communicationInfo.getResponseText());
        communicationInfo2.setTableData(communicationInfo.getTableData());
        communicationInfo2.setCodeBank(communicationInfo.getCodeBank());
        communicationInfo2.setTableVariables(communicationInfo.getTableVariables());
        communicationInfo2.setLastCommunicatingWithName(communicationInfo.getLastCommunicatingWithName());
        communicationInfo2.setCommands(communicationInfo.getCommands());
        communicationInfo2.setActionColumnWidth(communicationInfo.getActionColumnWidth());
        communicationInfo2.setCommunicationColumnWidth(communicationInfo.getCommunicationColumnWidth());
        communicationInfo2.setSizeColumnWidth(communicationInfo.getSizeColumnWidth());
        communicationInfo2.setFormatColumnWidth(communicationInfo.getFormatColumnWidth());
    }

    private CommunicationInfo find(Instrument instrument) {
        if (instrument == null) {
            return null;
        }
        for (int i = 0; i < this.allScannedHW.size(); ++i) {
            CommunicationInfo communicationInfo = this.allScannedHW.elementAt(i);
            BrowserObject browserObject = communicationInfo.getBrowserObject();
            if (browserObject.getInstrumentObject() != instrument) continue;
            return communicationInfo;
        }
        return null;
    }

    private CommunicationInfo find(BrowserObject browserObject) {
        if (browserObject == null) {
            return null;
        }
        Instrument instrument = browserObject.getInstrumentObject();
        for (int i = 0; i < this.allInstrumentObject.size(); ++i) {
            CommunicationInfo communicationInfo = this.allInstrumentObject.elementAt(i);
            if (communicationInfo.getInstrumentObject() != instrument) continue;
            return communicationInfo;
        }
        return null;
    }

    public CommunicationInfo findInstrument(Instrument instrument) {
        for (int i = 0; i < this.allInstrumentObject.size(); ++i) {
            CommunicationInfo communicationInfo = this.allInstrumentObject.elementAt(i);
            if (communicationInfo.getInstrumentObject() != instrument) continue;
            return communicationInfo;
        }
        return null;
    }

    public void removeInstrument(CommunicationInfo communicationInfo) {
        this.allInstrumentObject.removeElement(communicationInfo);
        communicationInfo = null;
    }

    public void removeBrowserObject(CommunicationInfo communicationInfo) {
        this.allScannedHW.removeElement(communicationInfo);
        communicationInfo = null;
    }
}

