/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.objects;

import com.mathworks.toolbox.instrument.UsbVisa;
import com.mathworks.toolbox.instrument.browser.objects.BrowserObject;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;

public class VisaUSBObject
extends BrowserObject {
    private static final String[] EOSMODE = new String[]{"none", "read", "write", "read&write"};
    protected String vendor;
    protected String boardIndex;
    protected String interfaceIndex = "0";
    protected String manufacturerID = "";
    protected String modelCode = "";
    protected String serialNumber = "";
    protected String eoiMode = "on";
    protected Object eosCharCode = "LF";
    protected String eosMode = "none";

    public VisaUSBObject(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        super(string7, string8);
        this.vendor = string;
        this.boardIndex = string2;
        this.manufacturerID = string3;
        this.modelCode = string4;
        this.serialNumber = string5;
        this.interfaceIndex = string6;
    }

    @Override
    public String[] getHeadingInfoColumnOne() {
        String[] stringArray = new String[]{"VISA vendor:", this.vendor, "Manufacturer ID:", this.manufacturerID, "Model code:", this.modelCode};
        return stringArray;
    }

    @Override
    public String getDescriptiveText() {
        return "usb manufacturer id " + this.manufacturerID + " (model code " + this.modelCode + ")";
    }

    @Override
    public String getType() {
        return "VISA-USB";
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getBoardIndex() {
        return this.boardIndex;
    }

    public String getInterfaceIndex() {
        return this.interfaceIndex;
    }

    public String getManufacturerID() {
        return this.manufacturerID;
    }

    public String getModelCode() {
        return this.modelCode;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setEOSCharCode(Object object) {
        this.eosCharCode = object;
        if (this.instrumentObject == null) {
            return;
        }
        try {
            ((UsbVisa)this.instrumentObject).setEOSCharCode(this.eosCharCode);
        }
        catch (TMException tMException) {
            TMStringUtil.error((String)"Error Setting EOSCharCode", (String)tMException.getMessage());
        }
    }

    public Object getEOSCharCode() {
        return this.eosCharCode;
    }

    public void setEOSMode(String string) {
        this.eosMode = string;
        if (this.instrumentObject == null) {
            return;
        }
        try {
            ((UsbVisa)this.instrumentObject).setEOSMode(this.getIndex(EOSMODE, this.eosMode));
        }
        catch (TMException tMException) {
            TMStringUtil.error((String)"Error Setting EOSMode", (String)tMException.getMessage());
        }
    }

    public String getEOSMode() {
        return this.eosMode;
    }

    public String getEOIMode() {
        return this.eoiMode;
    }

    public void setEOIMode(String string) {
        this.eoiMode = string;
        if (this.instrumentObject == null) {
            return;
        }
        try {
            ((UsbVisa)this.instrumentObject).setEOIMode(this.str2bool(this.eoiMode));
        }
        catch (TMException tMException) {
            TMStringUtil.error((String)"Error Setting EOIMode", (String)tMException.getMessage());
        }
    }
}

