/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.drivers.ivi;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.instrument.device.Device;
import com.mathworks.toolbox.instrument.device.drivers.COMDriver;
import com.mathworks.toolbox.instrument.device.drivers.xml.Parser;
import com.mathworks.toolbox.testmeas.util.TMException;
import java.io.File;

public class IviCOMDriver
extends COMDriver {
    public IviCOMDriver(Parser parser, String string, UDDObject uDDObject) throws TMException {
        super(parser, string, uDDObject);
        if (string == null || string.length() == 0) {
            this.logicalName = this.driverName;
        }
        File file = new File(parser.getLogicalName());
        this.driverName = file.getName();
        this.itrArgs[0] = "privateIviComDriverHelper";
    }

    @Override
    protected void validateDriverType() throws TMException {
        if (this.xmlParser.getDriverTypeId() != 3) {
            throw new TMException("The driver must be a MATLAB IVI instrument driver.");
        }
    }

    @Override
    public Object[] defineConstructorArgs() {
        if (this.resourceName.length() == 0) {
            Object[] objectArray = new Object[]{this.driverName};
            return objectArray;
        }
        Object[] objectArray = new Object[]{this.driverName, this.resourceName};
        return objectArray;
    }

    @Override
    public String defineConstructor() {
        if (this.resourceName.length() == 0) {
            return "icdevice('" + this.driverName + "');";
        }
        return "icdevice('" + this.driverName + "', '" + this.resourceName + "');";
    }

    @Override
    public String defineConstructorDescription() {
        if (this.resourceName.length() == 0) {
            return "Driver - " + this.driverName;
        }
        return "Driver - " + this.driverName + ", " + "ResourceName - " + this.resourceName;
    }

    @Override
    public int defineDriverType() {
        return 3;
    }

    @Override
    public int getStatusBasedOnInterface() {
        boolean bl = false;
        this.itrArgs[1] = "status";
        try {
            Object[] objectArray = (Object[])Matlab.mtFeval((String)"instrgate", (Object[])this.itrArgs, (int)1);
            bl = ((boolean[])objectArray[0])[0];
            if (bl) {
                return 1;
            }
            return 0;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public void open() throws TMException {
        boolean bl = false;
        this.itrArgs[3] = this.logicalName;
        if (this.resourceName.length() > 0) {
            this.itrArgs[3] = this.resourceName;
        }
        this.itrArgs[1] = "open";
        this.itrArgs[4] = this.deviceMLObject;
        try {
            Object[] objectArray = (Object[])Matlab.mtFeval((String)"instrgate", (Object[])this.itrArgs, (int)1);
            bl = ((boolean[])objectArray[0])[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.itrArgs[3] = null;
        if (!bl) {
            if (this.resourceName.length() > 0) {
                throw new TMException("The IVI driver could not connect to the instrument using the specified resource name.");
            }
            throw new TMException("The IVI driver could not connect to the instrument using the configuration defined in the logical name.");
        }
    }

    @Override
    public void close() throws TMException {
        this.itrArgs[1] = "close";
        try {
            Matlab.mtFeval((String)"instrgate", (Object[])this.itrArgs, (int)1);
        }
        catch (Exception exception) {
            throw new TMException(exception.getMessage());
        }
    }

    @Override
    public void dispose() throws TMException {
        this.deviceMLObject.dispose();
        this.comMLObject.releaseReference();
        if (this.comMLArrayRef != Device.USERDATA) {
            this.comMLArrayRef.dispose();
        }
    }

    @Override
    public MLArrayRef getInterfaceObject() {
        return this.comMLArrayRef;
    }

    @Override
    public String getInterfaceConstructor() {
        return "";
    }

    @Override
    public String getError() throws TMException {
        String string = "";
        this.itrArgs[1] = "error";
        try {
            Object[] objectArray = (Object[])Matlab.mtFeval((String)"instrgate", (Object[])this.itrArgs, (int)1);
            string = (String)objectArray[0];
        }
        catch (Exception exception) {
            throw new TMException("The call to the driver error query method failed.");
        }
        return string;
    }

    @Override
    public void hwreset() throws TMException {
        this.itrArgs[1] = "reset";
        try {
            Matlab.mtFeval((String)"instrgate", (Object[])this.itrArgs, (int)1);
        }
        catch (Exception exception) {
            throw new TMException("The call to the driver reset method failed.");
        }
    }

    @Override
    public String selftest() throws TMException {
        String string = "";
        this.itrArgs[1] = "selftest";
        try {
            Object[] objectArray = (Object[])Matlab.mtFeval((String)"instrgate", (Object[])this.itrArgs, (int)1);
            string = (String)objectArray[0];
        }
        catch (Exception exception) {
            throw new TMException("The call to the driver selftest method failed.");
        }
        return string;
    }

    @Override
    public String getInstrumentModel() {
        String string = "";
        this.itrArgs[1] = "model";
        try {
            Object[] objectArray = (Object[])Matlab.mtFeval((String)"instrgate", (Object[])this.itrArgs, (int)1);
            string = (String)objectArray[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }
}

