/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtest.panel;

import com.mathworks.toolbox.instrument.device.drivers.xml.property.PropertyConstraint;
import com.mathworks.toolbox.instrument.device.drivers.xml.property.PropertyDefinition;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.CodeGenerator;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.MIDTestToolClient;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.MIDTestToolFileWriter;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.PropertyInfo;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.PropertyPanel;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.StepInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropertySetPanel
extends PropertyPanel
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private static final String SINGLE_VALUE_STEP_PASS = "If property value after set is: ";
    private static final String ALL_VALUE_STEP_PASS = "If current value matches configured value";
    private static final int TEST_ALL_VALUES = 0;
    private ButtonGroup valueToTestButtonGroup;
    private JPanel valueToTestPanel;
    private JPanel radioButtonPanel;
    private JRadioButton allRB;
    private JRadioButton otherRB;
    private JTextField otherTextField;
    private Vector<PropertyConstraint> constraints = new Vector();
    private Hashtable<PropertyConstraint, JRadioButton> buttonConstraints = new Hashtable();
    private JPanel stepPassesPanel;
    private JTextField stepPassesTextField;
    private JCheckBox noErrorStepPass;
    private JCheckBox argsStepPass;
    private JPanel argsStepPassPanel;
    private JButton helpButton;
    private Vector<Object> constraintValues;

    public PropertySetPanel(MIDTestToolClient mIDTestToolClient) {
        this.client = mIDTestToolClient;
        this.setStepType(0);
        this.layoutPanel();
        this.setName("Set Property Step Panel");
    }

    @Override
    public void update(StepInfo stepInfo) {
        boolean bl;
        super.update(stepInfo);
        PropertyInfo propertyInfo = (PropertyInfo)stepInfo;
        if (!propertyInfo.getNeedsToUpdate()) {
            this.selectIndexInButtonGroup(this.valueToTestButtonGroup, propertyInfo.getValueToTest());
            this.noErrorStepPass.setSelected(propertyInfo.getNoErrorStepPass());
            this.argsStepPass.setSelected(propertyInfo.getArgsStepPass());
            this.stepPassesTextField.setText(propertyInfo.getStepPassesValue());
            this.otherTextField.setText(propertyInfo.getOtherValueToTest());
            this.constraintValues = propertyInfo.getConstraintValues();
            this.updateConstraintValues();
        }
        if (!(bl = this.updateAfterDriverReload(propertyInfo))) {
            this.objectToTest.removeAllItems();
            this.stepPassesTextField.setText("");
            this.otherTextField.setText("");
            this.createNoConstraintPanel();
        }
        propertyInfo.setNeedsToUpdate(false);
    }

    public void updatePanelAfterDriverReload() {
        this.updatePropertiesInListBox();
    }

    private boolean updateAfterDriverReload(PropertyInfo propertyInfo) {
        this.updatePropertiesInListBox();
        if (propertyInfo.getProperty().equals("")) {
            this.propertyToTest.setSelectedIndex(0);
            return false;
        }
        String string = propertyInfo.getGroup();
        String string2 = propertyInfo.getProperty();
        int n = this.getPropertyIndex(string2, string);
        if (n == -1) {
            this.propertyToTest.setSelectedIndex(0);
            return false;
        }
        this.propertyToTest.setSelectedIndex(n);
        this.constraintValues = propertyInfo.getConstraintValues();
        this.updatePanel(string, string2);
        this.stepPassesTextField.setText(propertyInfo.getStepPassesValue());
        this.noErrorStepPass.setSelected(propertyInfo.getNoErrorStepPass());
        this.argsStepPass.setSelected(propertyInfo.getArgsStepPass());
        this.objectToTest.setSelectedItem(propertyInfo.getObject());
        this.otherTextField.setText(propertyInfo.getOtherValueToTest());
        try {
            this.selectIndexInButtonGroup(this.valueToTestButtonGroup, propertyInfo.getValueToTest());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public void cleanup(StepInfo stepInfo) {
        super.cleanup(stepInfo);
        PropertyInfo propertyInfo = (PropertyInfo)stepInfo;
        propertyInfo.setValueToTest(this.getSelectedIndexInButtonGroup(this.valueToTestButtonGroup));
        propertyInfo.setNoErrorStepPass(this.noErrorStepPass.isSelected());
        propertyInfo.setArgsStepPass(this.argsStepPass.isSelected());
        propertyInfo.setStepPassesValue(this.stepPassesTextField.getText());
        propertyInfo.setOtherValueToTest(this.otherTextField.getText());
        int n = this.propertyToTest.getSelectedIndex();
        if (n == -1) {
            n = 0;
        }
        propertyInfo.setProperty(this.getProperty(n));
        propertyInfo.setGroup(this.getSelectedPropertyGroup(n));
        propertyInfo.setObject((String)this.objectToTest.getSelectedItem());
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < this.constraints.size(); ++i) {
            vector.addElement(this.constraints.elementAt(i).getPanelValue());
        }
        propertyInfo.setConstraintValues(vector);
        this.constraintValues = null;
        propertyInfo.setValueToSet(this.getValueToSet());
    }

    private String getValueToSet() {
        JRadioButton jRadioButton = this.getSelectedRadioButtonInButtonGroup(this.valueToTestButtonGroup);
        if (jRadioButton.equals(this.allRB)) {
            return null;
        }
        if (jRadioButton.equals(this.otherRB)) {
            return this.otherTextField.getText();
        }
        PropertyConstraint propertyConstraint = this.getConstraint(jRadioButton);
        return String.valueOf(propertyConstraint.getPanelValue());
    }

    private PropertyConstraint getConstraint(JRadioButton jRadioButton) {
        for (int i = 0; i < this.constraints.size(); ++i) {
            PropertyConstraint propertyConstraint = this.constraints.elementAt(i);
            JRadioButton jRadioButton2 = this.buttonConstraints.get(propertyConstraint);
            if (!jRadioButton2.equals(jRadioButton)) continue;
            return propertyConstraint;
        }
        return null;
    }

    @Override
    public void save(MIDTestToolFileWriter mIDTestToolFileWriter, Element element, StepInfo stepInfo) {
        PropertyInfo propertyInfo = (PropertyInfo)stepInfo;
        mIDTestToolFileWriter.addNode(element, "Name", propertyInfo.getName());
        mIDTestToolFileWriter.addNode(element, "Property", propertyInfo.getProperty());
        mIDTestToolFileWriter.addNode(element, "Group", propertyInfo.getGroup());
        mIDTestToolFileWriter.addNode(element, "Object", propertyInfo.getObject());
        mIDTestToolFileWriter.addNode(element, "PropertyIndex", propertyInfo.getPropertyToTest());
        mIDTestToolFileWriter.addNode(element, "ObjectIndex", propertyInfo.getObjectToTest());
        mIDTestToolFileWriter.addNode(element, "ValueToTest", propertyInfo.getValueToTest());
        mIDTestToolFileWriter.addNode(element, "OtherValueToTest", propertyInfo.getOtherValueToTest());
        mIDTestToolFileWriter.addNode(element, "NoErrorStepPass", propertyInfo.getNoErrorStepPass());
        mIDTestToolFileWriter.addNode(element, "ArgsStepPass", propertyInfo.getArgsStepPass());
        mIDTestToolFileWriter.addNode(element, "StepPassesValue", propertyInfo.getStepPassesValue());
        if (propertyInfo.getValueToTest() != 0 && propertyInfo.getValueToSet() != null) {
            mIDTestToolFileWriter.addNode(element, "ValueToSet", propertyInfo.getValueToSet());
        }
        Vector<Object> vector = propertyInfo.getConstraintValues();
        for (int i = 0; i < vector.size(); ++i) {
            mIDTestToolFileWriter.addNode(element, "ConstraintValue", String.valueOf(vector.elementAt(i)));
        }
    }

    @Override
    public void load(Node node, StepInfo stepInfo) {
        PropertyInfo propertyInfo = (PropertyInfo)stepInfo;
        propertyInfo.setNeedsToUpdate(true);
        propertyInfo.setValueToSet(null);
        Vector<Object> vector = new Vector<Object>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = nodeList.item(i).getNodeName();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            if (nodeList2.getLength() == 0) continue;
            if (string.equals("Name")) {
                propertyInfo.setName(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string.equals("Property")) {
                propertyInfo.setProperty(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string.equals("Group")) {
                propertyInfo.setGroup(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string.equals("Object")) {
                propertyInfo.setObject(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string.equals("PropertyIndex")) {
                propertyInfo.setPropertyToTest(new Integer(nodeList2.item(0).getNodeValue()));
                continue;
            }
            if (string.equals("ObjectIndex")) {
                propertyInfo.setObjectToTest(new Integer(nodeList2.item(0).getNodeValue()));
                continue;
            }
            if (string.equals("ValueToTest")) {
                propertyInfo.setValueToTest(new Integer(nodeList2.item(0).getNodeValue()));
                continue;
            }
            if (string.equals("OtherValueToTest")) {
                propertyInfo.setOtherValueToTest(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string.equals("NoErrorStepPass")) {
                propertyInfo.setNoErrorStepPass(new Boolean(nodeList2.item(0).getNodeValue()));
                continue;
            }
            if (string.equals("ArgsStepPass")) {
                propertyInfo.setArgsStepPass(new Boolean(nodeList2.item(0).getNodeValue()));
                continue;
            }
            if (string.equals("StepPassesValue")) {
                propertyInfo.setStepPassesValue(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string.equals("ConstraintValue")) {
                vector.addElement(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (!string.equals("ValueToSet")) continue;
            propertyInfo.setValueToSet(nodeList2.item(0).getNodeValue());
        }
        propertyInfo.setConstraintValues(vector);
        propertyInfo.setIsNodeDirty(false);
    }

    @Override
    public void duplicate(StepInfo stepInfo, StepInfo stepInfo2) {
        PropertyInfo propertyInfo = (PropertyInfo)stepInfo;
        PropertyInfo propertyInfo2 = (PropertyInfo)stepInfo2;
        propertyInfo.setValueToTest(propertyInfo2.getValueToTest());
        propertyInfo.setNoErrorStepPass(propertyInfo2.getNoErrorStepPass());
        propertyInfo.setArgsStepPass(propertyInfo2.getArgsStepPass());
        propertyInfo.setStepPassesValue(propertyInfo2.getStepPassesValue());
        propertyInfo.setOtherValueToTest(propertyInfo2.getOtherValueToTest());
        propertyInfo.setProperty(propertyInfo2.getProperty());
        propertyInfo.setGroup(propertyInfo2.getGroup());
        propertyInfo.setObject(propertyInfo2.getObject());
        propertyInfo.setConstraintValues(propertyInfo2.getConstraintValues());
        propertyInfo.setValueToSet(propertyInfo2.getValueToSet());
    }

    private void layoutPanel() {
        this.setLayout(new BorderLayout(0, 0));
        JPanel jPanel = this.add(this.createPropertyToTestPanel(), this.createObjectToTestPanel(), 5);
        JPanel jPanel2 = this.add(jPanel, this.createValueToTestPanel(), 5);
        JPanel jPanel3 = this.add(jPanel2, this.createStepPassesPanel(), 5);
        this.add((Component)jPanel3, "North");
        JPanel jPanel4 = new JPanel(new FlowLayout(2, 0, 0));
        this.helpButton = new JButton("Show Help on Property...");
        this.helpButton.setName("Show Help on Property Button");
        this.helpButton.addActionListener(this);
        jPanel4.add(this.helpButton);
        this.add((Component)jPanel4, "South");
    }

    protected JPanel createValueToTestPanel() {
        this.otherTextField = new JTextField();
        this.valueToTestPanel = new JPanel(new BorderLayout(0, 0));
        this.valueToTestPanel.setBorder(BorderFactory.createTitledBorder("Define the value(s) to test"));
        this.valueToTestButtonGroup = new ButtonGroup();
        this.allRB = new JRadioButton("All supported values", false);
        this.otherRB = new JRadioButton("Other: ", false);
        this.allRB.addItemListener(this);
        this.valueToTestButtonGroup.add(this.allRB);
        this.valueToTestButtonGroup.add(this.otherRB);
        this.radioButtonPanel = this.createRadioButtonPanel();
        this.valueToTestPanel.add((Component)this.radioButtonPanel, "North");
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.add((Component)this.valueToTestPanel, "Center");
        this.otherTextField.setName("Other Text Field");
        this.allRB.setName("All supported values Radiobutton");
        this.otherRB.setName("Other Radiobutton");
        return jPanel;
    }

    protected JPanel createStepPassesPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        this.stepPassesTextField = new JTextField("");
        if (this.constraints == null || this.constraints.size() == 0) {
            this.stepPassesTextField.setText("");
        } else {
            Object object = this.constraints.elementAt(0).getPanelValue();
            this.stepPassesTextField.setText(object.toString());
        }
        this.noErrorStepPass = new JCheckBox("If no MATLAB or instrument error occurs", true);
        this.argsStepPass = new JCheckBox(SINGLE_VALUE_STEP_PASS, false);
        this.noErrorStepPass.setName("No error Checkbox");
        this.argsStepPass.setName("Matches CheckBox");
        this.stepPassesTextField.setName("Step Passes Text Field");
        this.stepPassesPanel = new JPanel(new GridLayout(2, 1, 0, 0));
        this.stepPassesPanel.setBorder(BorderFactory.createTitledBorder("Select when this step passes"));
        this.stepPassesPanel.add(this.noErrorStepPass);
        this.argsStepPassPanel = this.addTextFieldToComponent(this.argsStepPass, this.stepPassesTextField, 93);
        this.stepPassesPanel.add(this.argsStepPassPanel);
        jPanel.add((Component)this.stepPassesPanel, "North");
        return jPanel;
    }

    private JPanel createRadioButtonPanel() {
        String string = this.getProperty(this.propertyToTest.getSelectedIndex());
        String string2 = this.getSelectedPropertyGroup(this.propertyToTest.getSelectedIndex());
        PropertyDefinition propertyDefinition = (PropertyDefinition)this.getParser().getPropertyInformation(string, string2);
        PropertyConstraint[] propertyConstraintArray = propertyDefinition.getValidConstraints(this.getParser());
        JPanel jPanel = new JPanel(new GridLayout(propertyConstraintArray.length + 2, 1, 0, 0));
        this.constraints.removeAllElements();
        for (int i = 0; i < propertyConstraintArray.length; ++i) {
            jPanel.add(this.createConstraintPanel(propertyConstraintArray[i]));
            this.constraints.add(propertyConstraintArray[i]);
        }
        jPanel.add(this.allRB);
        jPanel.add(this.addTextFieldToComponent(this.otherRB, this.otherTextField, 93));
        if (this.constraints != null && this.constraints.size() > 0) {
            this.buttonConstraints.get(this.constraints.elementAt(0)).setSelected(true);
        } else {
            this.allRB.setSelected(true);
        }
        return jPanel;
    }

    private JPanel createConstraintPanel(PropertyConstraint propertyConstraint) {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        JRadioButton jRadioButton = new JRadioButton();
        jRadioButton.setName("Constraint Radiobutton");
        this.valueToTestButtonGroup.add(jRadioButton);
        this.buttonConstraints.put(propertyConstraint, jRadioButton);
        jPanel.add((Component)jRadioButton, "West");
        jPanel.add((Component)propertyConstraint.getPanel(), "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, "North");
        return jPanel2;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.showHelp();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.allRB.isSelected()) {
            this.argsStepPass.setText(ALL_VALUE_STEP_PASS);
            this.stepPassesTextField.setVisible(false);
        } else {
            this.argsStepPass.setText(SINGLE_VALUE_STEP_PASS);
            this.stepPassesTextField.setVisible(true);
        }
    }

    @Override
    public void updatePanel(String string, String string2) {
        this.cleanupPanel();
        this.radioButtonPanel = this.createRadioButtonPanel();
        this.valueToTestPanel.add((Component)this.radioButtonPanel, "Center");
        if (this.constraints == null || this.constraints.size() == 0) {
            this.stepPassesTextField.setText("");
        } else {
            Object object = this.constraints.elementAt(0).getPanelValue();
            this.stepPassesTextField.setText(object.toString());
        }
        this.updateConstraintValues();
        this.repaint();
    }

    private void updateConstraintValues() {
        if (this.constraintValues == null || this.constraintValues.size() == 0) {
            return;
        }
        for (int i = 0; i < this.constraints.size(); ++i) {
            PropertyConstraint propertyConstraint = this.constraints.elementAt(i);
            try {
                propertyConstraint.setPanelValue(this.constraintValues.elementAt(i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void createNoConstraintPanel() {
        this.cleanupPanel();
        this.radioButtonPanel = new JPanel(new GridLayout(2, 1, 0, 0));
        this.radioButtonPanel.add(this.allRB);
        this.radioButtonPanel.add(this.addTextFieldToComponent(this.otherRB, this.otherTextField, 93));
        this.allRB.setSelected(true);
        this.valueToTestPanel.add((Component)this.radioButtonPanel, "Center");
        this.repaint();
    }

    private void cleanupPanel() {
        this.valueToTestPanel.remove(this.radioButtonPanel);
        for (int i = 0; i < this.constraints.size(); ++i) {
            JRadioButton jRadioButton = this.buttonConstraints.get(this.constraints.elementAt(i));
            this.valueToTestButtonGroup.remove(jRadioButton);
            this.buttonConstraints.remove(this.constraints.elementAt(i));
        }
        this.constraints.removeAllElements();
    }

    @Override
    public void setComponentsEnabled(boolean bl) {
        if (this.isEnabled == bl) {
            return;
        }
        this.objectToTestLabel.setEnabled(bl);
        this.objectToTest.setEnabled(bl);
        this.otherTextField.setEnabled(bl);
        this.enableButtonGroup(this.valueToTestButtonGroup, bl);
        this.stepPassesTextField.setEnabled(bl);
        this.noErrorStepPass.setEnabled(bl);
        this.argsStepPass.setEnabled(bl);
        this.helpButton.setEnabled(bl);
        if (!bl) {
            this.objectToTest.removeAllItems();
            this.stepPassesTextField.setText("");
            this.otherTextField.setText("");
            this.createNoConstraintPanel();
        }
        this.isEnabled = bl;
    }

    @Override
    public String generateCode(StepInfo stepInfo, boolean bl, boolean bl2, int n) {
        String string;
        PropertyInfo propertyInfo = (PropertyInfo)stepInfo;
        if (this.isHeader(propertyInfo.getPropertyToTest())) {
            if (bl) {
                this.client.assignVariableInformation(new Integer(0));
            }
            return "";
        }
        String string2 = this.getDisplayFunction(bl);
        String string3 = this.getDisplayInsert(bl);
        String string4 = this.addLine("\n", "errorcode = false;");
        if (propertyInfo.getValueToTest() == 0) {
            string = this.generateTestAllValuesCode(bl, propertyInfo, n);
            string4 = this.addLine(string4, string);
        } else {
            string = this.generateSpecificValueCode(bl, propertyInfo);
            string4 = this.addLine(string4, string);
        }
        if (bl) {
            this.client.assignVariableInformation(new Integer(0));
        }
        if (!bl2) {
            return string4;
        }
        int n2 = propertyInfo.getPropertyToTest();
        String string5 = propertyInfo.getGroup();
        String string6 = propertyInfo.getProperty();
        boolean bl3 = true;
        if (!this.isPropertyHelpDefined(string5, n2)) {
            bl3 = false;
            string4 = this.addLine(string4, "");
            string4 = this.addLine(string4, "% Post warnings.");
            string4 = this.addLine(string4, "warningOccurred = true;");
            string4 = this.addLine(string4, "stepWarningOccurred = true;");
            string4 = this.addLine(string4, string2 + "('" + CodeGenerator.generateColorCode(bl, "\"#0000FF\"", "Warning: No help is defined for the " + string6 + " property in the " + string5 + " group.") + string3 + "');");
        }
        if (!this.isDefaultValueDefined(string5, n2)) {
            if (bl3) {
                string4 = this.addLine(string4, "");
                string4 = this.addLine(string4, "% Post warnings.");
                string4 = this.addLine(string4, "warningOccurred = true;");
                string4 = this.addLine(string4, "stepWarningOccurred = true;");
            }
            string4 = this.addLine(string4, string2 + "('" + CodeGenerator.generateColorCode(bl, "\"#0000FF\"", "Warning: No default value is defined for the " + string6 + " property in the " + string5 + " group.") + string3 + "');");
        }
        return string4;
    }

    private String generateSpecificValueCode(boolean bl, PropertyInfo propertyInfo) {
        String string;
        String string2 = this.getDisplayFunction(bl);
        String string3 = this.getDisplayInsert(bl);
        boolean bl2 = false;
        String string4 = this.addLine("\n", "try");
        string4 = this.addTabbedLine(string4, "% Configure the property.");
        String string5 = this.formatPropertyValue(propertyInfo.getValueToSet());
        if (propertyInfo.getGroup().equals("parent")) {
            string4 = this.addTabbedLine(string4, "set(deviceObj, '" + propertyInfo.getProperty() + "', " + string5 + ");");
        } else {
            String string6;
            string4 = this.addTabbedLine(string4, "groupObj = get(deviceObj, '" + propertyInfo.getGroup() + "');");
            string = propertyInfo.getObject();
            if (!string.equals(string6 = "All " + propertyInfo.getGroup() + " group objects")) {
                string4 = this.addTabbedLine(string4, "groupObj = groupObj(" + (propertyInfo.getObjectToTest() + 1) + ");");
            } else {
                bl2 = true;
            }
            string4 = this.addTabbedLine(string4, "set(groupObj, '" + propertyInfo.getProperty() + "', " + string5 + ");");
        }
        string4 = this.addLine(string4, " ");
        string4 = this.addTabbedLine(string4, "% Check if instrument error occurred.");
        string4 = this.addTabbedLine(string4, "result = geterror(deviceObj);");
        if (propertyInfo.getNoErrorStepPass()) {
            string4 = this.addTabbedLine(string4, "errorcode = ~strcmpi(result, noErrorMsg);");
            string4 = this.addTabbedLine(string4, "");
            string4 = this.addTabbedLine(string4, this.postMessage(bl, "An instrument error occurred while setting the property value.", "result", true, "    "));
        }
        if (propertyInfo.getArgsStepPass()) {
            string4 = this.addTabbedLine(string4, "% Verify that the configured value matches the expected value.");
            string4 = this.addTabbedLine(string4, "if (errorcode == false)");
            string4 = this.addTabbedLine(string4, "    % Get the current property value.");
            string4 = propertyInfo.getGroup().equals("parent") ? this.addTabbedLine(string4, "    currentValue = get(deviceObj, '" + propertyInfo.getProperty() + "');") : (!bl2 ? this.addTabbedLine(string4, "    currentValue = get(groupObj, '" + propertyInfo.getProperty() + "');") : this.addTabbedLine(string4, "    currentValue = get(groupObj, {'" + propertyInfo.getProperty() + "'});"));
            string = this.formatPropertyValue(propertyInfo.getStepPassesValue());
            string4 = this.addTabbedLine(string4, "");
            string4 = this.addTabbedLine(string4, "    % Compare to the expected value.");
            if (bl2) {
                string4 = this.addTabbedLine(string4, "    expectedValue = cell(size(groupObj))';");
                string4 = this.addTabbedLine(string4, "    [expectedValue{:}] = deal(" + string + ");");
                string4 = this.addTabbedLine(string4, "    errorcode = ~isequal(currentValue, expectedValue);");
            } else {
                string4 = this.addTabbedLine(string4, "    errorcode = ~isequal(currentValue, " + string + ");");
            }
            string4 = this.addTabbedLine(string4, "");
            string4 = this.addTabbedLine(string4, "    % Post information about test step failure.");
            string4 = this.addTabbedLine(string4, "    if (errorcode == true)");
            string4 = this.addTabbedLine(string4, "        " + string2 + "('The property is not configured to the expected value." + string3 + "');");
            if (!bl2) {
                string4 = this.addTabbedLine(string4, "");
                string4 = this.addTabbedLine(string4, "        % Post actual value.");
                string4 = this.addTabbedLine(string4, "        if isnumeric(currentValue)");
                string4 = this.addTabbedLine(string4, "            " + string2 + "(['Actual value: ' num2str(currentValue) '" + string3 + "']);");
                string4 = this.addTabbedLine(string4, "        else");
                string4 = this.addTabbedLine(string4, "            " + string2 + "(['Actual value: ' currentValue '" + string3 + "']);");
                string4 = this.addTabbedLine(string4, "        end");
                string4 = this.addTabbedLine(string4, "");
                string4 = this.addTabbedLine(string4, "        % Post expected value.");
                string4 = this.addTabbedLine(string4, "        " + string2 + "('Expected value: " + this.formatPropertyValueForStringConcat(propertyInfo.getStepPassesValue()) + string3 + "');");
                string4 = this.addTabbedLine(string4, "    end");
            } else {
                string4 = this.addTabbedLine(string4, "");
                string4 = this.addTabbedLine(string4, "        % Post actual value.");
                string4 = this.addTabbedLine(string4, "        for i=1:length(currentValue)");
                string4 = this.addTabbedLine(string4, "            c = currentValue{i};");
                string4 = this.addTabbedLine(string4, "            if isnumeric(c)");
                string4 = this.addTabbedLine(string4, "                " + string2 + "(['Actual value(' num2str(i) '): ' num2str(c) '" + string3 + "']);");
                string4 = this.addTabbedLine(string4, "            else");
                string4 = this.addTabbedLine(string4, "                " + string2 + "(['Actual value(' num2str(i) '): ' c '" + string3 + "']);");
                string4 = this.addTabbedLine(string4, "            end");
                string4 = this.addTabbedLine(string4, "        end");
                string4 = this.addTabbedLine(string4, "");
                string4 = this.addTabbedLine(string4, "        % Post expected value.");
                string4 = this.addTabbedLine(string4, "        " + string2 + "('Expected value: " + this.formatPropertyValueForStringConcat(propertyInfo.getStepPassesValue()) + string3 + "');");
                string4 = this.addTabbedLine(string4, "    end");
            }
            string4 = this.addLine(string4, " ");
            string4 = this.addTabbedLine(string4, "    % Check if instrument error occurred.");
            string4 = this.addTabbedLine(string4, "    result = geterror(deviceObj);");
            if (propertyInfo.getNoErrorStepPass()) {
                string4 = this.addTabbedLine(string4, "    errorcode1 = ~strcmpi(result, noErrorMsg);");
                string4 = this.addTabbedLine(string4, "");
                string4 = this.addTabbedLine(string4, "    % Post information about error if one occurred.");
                string4 = this.addTabbedLine(string4, "    if (errorcode1 == true)");
                string4 = this.addTabbedLine(string4, "        errorcode = errorcode1;");
                string4 = this.addTabbedLine(string4, "        " + string2 + "('An instrument error occurred while getting the property value." + string3 + "');");
                string4 = this.addTabbedLine(string4, "        " + string2 + "([result '" + string3 + "']);");
                string4 = this.addTabbedLine(string4, "    end");
            }
            string4 = this.addTabbedLine(string4, "end");
        }
        string4 = this.addLine(string4, "catch aException");
        string4 = this.addTabbedLine(string4, "% A MATLAB error occurred.");
        if (propertyInfo.getNoErrorStepPass()) {
            string4 = this.addTabbedLine(string4, "errorcode = true;");
            string4 = this.addLine(string4, "");
            string4 = this.addTabbedLine(string4, "% Post information about error.");
            string4 = this.addTabbedLine(string4, string2 + "('" + CodeGenerator.generateColorCode(bl, "\"#FF0000\"", "A MATLAB error occurred while testing the property.") + string3 + "');");
            string4 = this.addTabbedLine(string4, string2 + "(" + CodeGenerator.generateColorCodeToEval(bl, "\"#FF0000\"", "aException.message") + ");");
        }
        string4 = this.addLine(string4, "end");
        return string4;
    }

    private String generateTestAllValuesCode(boolean bl, PropertyInfo propertyInfo, int n) {
        Object object;
        String string = this.getDisplayFunction(bl);
        String string2 = this.getDisplayInsert(bl);
        String string3 = propertyInfo.getProperty();
        String string4 = propertyInfo.getGroup();
        boolean bl2 = false;
        String string5 = "";
        PropertyConstraint[] propertyConstraintArray = this.getPropertyConstraints(string4, string3);
        for (int i = 0; i < propertyConstraintArray.length; ++i) {
            object = propertyConstraintArray[i];
            string5 = this.addConstraintValues(string5, (PropertyConstraint)object, n);
        }
        string5 = "{" + string5 + "}";
        String string6 = this.addLine("\n", "% Overall error status for all settings.");
        string6 = this.addLine(string6, "finalerrorcode = false;\n");
        string6 = this.addLine(string6, "% Valid values for the " + string3 + " property.");
        string6 = this.addLine(string6, "validValues = " + string5 + ";");
        string6 = this.addLine(string6, "");
        string6 = this.addLine(string6, "% Test all supported values.");
        string6 = this.addLine(string6, "for i = 1:length(validValues)");
        string6 = this.addTabbedLine(string6, "try");
        string6 = this.addTabbedLine(string6, "    % Configure the property.");
        if (string4.equals("parent")) {
            string6 = this.addTabbedLine(string6, "    set(deviceObj, '" + string3 + "', validValues{i});");
        } else {
            String string7;
            string6 = this.addTabbedLine(string6, "    groupObj = get(deviceObj, '" + string4 + "');");
            object = propertyInfo.getObject();
            if (!((String)object).equals(string7 = "All " + string4 + " group objects")) {
                string6 = this.addTabbedLine(string6, "    groupObj = groupObj(" + (propertyInfo.getObjectToTest() + 1) + ");");
            } else {
                bl2 = true;
            }
            string6 = this.addTabbedLine(string6, "    set(groupObj, '" + string3 + "', validValues{i});");
        }
        string6 = this.addLine(string6, "");
        string6 = this.addTabbedLine(string6, "    % Check if instrument error occurred.");
        string6 = this.addTabbedLine(string6, "    result = geterror(deviceObj);");
        if (propertyInfo.getNoErrorStepPass()) {
            string6 = this.addTabbedLine(string6, "    errorcode = ~strcmp(result, noErrorMsg);");
            string6 = this.addLine(string6, "");
            string6 = this.addTabbedLine(string6, this.postMessage(bl, "An instrument error occurred while setting the property value.", "result", true, "        "));
        }
        if (propertyInfo.getArgsStepPass()) {
            string6 = this.addLine(string6, "");
            string6 = this.addTabbedLine(string6, "    % Verify that the configured value matches the expected value.");
            string6 = this.addTabbedLine(string6, "    if (errorcode == false)");
            string6 = this.addTabbedLine(string6, "        % Get the current property value.");
            string6 = string4.equals("parent") ? this.addTabbedLine(string6, "        tempOut = get(deviceObj, '" + string3 + "');") : (!bl2 ? this.addTabbedLine(string6, "        tempOut = get(groupObj, '" + string3 + "');") : this.addTabbedLine(string6, "        tempOut = get(groupObj, {'" + string3 + "'});"));
            string6 = this.addLine(string6, "");
            if (bl2) {
                string6 = this.addTabbedLine(string6, "        % Compare to the expected value.");
                string6 = this.addTabbedLine(string6, "        expectedValue = cell(size(groupObj))';");
                string6 = this.addTabbedLine(string6, "        [expectedValue{:}] = deal(validValues{i});");
                string6 = this.addTabbedLine(string6, "        errorcode = ~isequal(tempOut, expectedValue);");
            } else {
                string6 = this.addTabbedLine(string6, "        % Compare to the expected value.");
                string6 = this.addTabbedLine(string6, "        errorcode = ~isequal(tempOut, validValues{i});");
            }
            string6 = this.addTabbedLine(string6, "");
            string6 = this.addTabbedLine(string6, "        % Post information about test step failure.");
            string6 = this.addTabbedLine(string6, "        if (errorcode == true)");
            string6 = this.addTabbedLine(string6, "            " + string + "('The property is not configured to the expected value." + string2 + "');");
            if (!bl2) {
                string6 = this.addTabbedLine(string6, "");
                string6 = this.addTabbedLine(string6, "            % Post actual value.");
                string6 = this.addTabbedLine(string6, "            if isnumeric(tempOut)");
                string6 = this.addTabbedLine(string6, "                " + string + "(['Actual value: ' num2str(tempOut) '" + string2 + "']);");
                string6 = this.addTabbedLine(string6, "            else");
                string6 = this.addTabbedLine(string6, "                " + string + "(['Actual value: ' tempOut '" + string2 + "']);");
                string6 = this.addTabbedLine(string6, "            end");
                string6 = this.addTabbedLine(string6, "");
                string6 = this.addTabbedLine(string6, "            % Post expected value.");
                string6 = this.addTabbedLine(string6, "            if isnumeric(validValues{i})");
                string6 = this.addTabbedLine(string6, "                " + string + "(['Expected value: ' num2str(validValues{i}) '" + string2 + "']);");
                string6 = this.addTabbedLine(string6, "            else");
                string6 = this.addTabbedLine(string6, "                " + string + "(['Expected value: ' validValues{i} '" + string2 + "']);");
                string6 = this.addTabbedLine(string6, "            end");
                string6 = this.addTabbedLine(string6, "        end");
            } else {
                string6 = this.addTabbedLine(string6, "");
                string6 = this.addTabbedLine(string6, "            % Post actual value.");
                string6 = this.addTabbedLine(string6, "            for k=1:length(tempOut)");
                string6 = this.addTabbedLine(string6, "                c = tempOut{k};");
                string6 = this.addTabbedLine(string6, "                if isnumeric(c)");
                string6 = this.addTabbedLine(string6, "                    " + string + "(['Actual value(' num2str(k) '): ' num2str(c) '" + string2 + "']);");
                string6 = this.addTabbedLine(string6, "                else");
                string6 = this.addTabbedLine(string6, "                    " + string + "(['Actual value(' num2str(k) '): ' c '" + string2 + "']);");
                string6 = this.addTabbedLine(string6, "                end");
                string6 = this.addTabbedLine(string6, "            end");
                string6 = this.addTabbedLine(string6, "");
                string6 = this.addTabbedLine(string6, "            % Post expected value.");
                string6 = this.addTabbedLine(string6, "            if isnumeric(validValues{i})");
                string6 = this.addTabbedLine(string6, "                " + string + "(['Expected value: ' num2str(validValues{i}) '" + string2 + "']);");
                string6 = this.addTabbedLine(string6, "            else");
                string6 = this.addTabbedLine(string6, "                " + string + "(['Expected value: ' validValues{i} '" + string2 + "']);");
                string6 = this.addTabbedLine(string6, "            end");
                string6 = this.addTabbedLine(string6, "        end");
            }
            string6 = this.addLine(string6, "");
            string6 = this.addTabbedLine(string6, "        % Check if instrument error occurred.");
            string6 = this.addTabbedLine(string6, "        result = geterror(deviceObj);");
            if (propertyInfo.getNoErrorStepPass()) {
                string6 = this.addTabbedLine(string6, "        errorcode1 = ~strcmp(result, noErrorMsg);");
                string6 = this.addLine(string6, "");
                string6 = this.addTabbedLine(string6, "        % Post information about error if one occurred.");
                string6 = this.addTabbedLine(string6, "        if (errorcode1 == true)");
                string6 = this.addTabbedLine(string6, "            errorcode = errorcode1;");
                string6 = this.addTabbedLine(string6, "            " + string + "('An instrument error occurred while getting the property value." + string2 + "');");
                string6 = this.addTabbedLine(string6, "            " + string + "([result '" + string2 + "']);");
                string6 = this.addTabbedLine(string6, "        end");
            }
            string6 = this.addTabbedLine(string6, "    end");
        }
        string6 = this.addTabbedLine(string6, "catch aException");
        string6 = this.addTabbedLine(string6, "    % A MATLAB error occurred.");
        if (propertyInfo.getNoErrorStepPass()) {
            string6 = this.addTabbedLine(string6, "    errorcode = true;");
            string6 = this.addLine(string6, "");
            string6 = this.addTabbedLine(string6, "    % Post information about error.");
            string6 = this.addTabbedLine(string6, "    " + string + "('" + CodeGenerator.generateColorCode(bl, "\"#FF0000\"", "A MATLAB error occurred while testing the property.") + string2 + "');");
            string6 = this.addTabbedLine(string6, "    " + string + "(" + CodeGenerator.generateColorCodeToEval(bl, "\"#FF0000\"", "aException.message") + ");");
        }
        string6 = this.addTabbedLine(string6, "end");
        string6 = this.addTabbedLine(string6, "if (errorcode == true)");
        string6 = this.addTabbedLine(string6, "    finalerrorcode = true;");
        string6 = this.addTabbedLine(string6, "end");
        string6 = this.addLine(string6, "end");
        string6 = this.addLine(string6, "errorcode = finalerrorcode;");
        return string6;
    }

    private String addConstraintValues(String string, PropertyConstraint propertyConstraint, int n) {
        String string2 = propertyConstraint.getCellArrayOfValues();
        if (!string2.equals("{}")) {
            if (string.equals("")) {
                return string2.substring(1, string2.length() - 1);
            }
            return string + ", " + string2.substring(1, string2.length() - 1);
        }
        string2 = propertyConstraint.getCellArrayOfValues(n);
        if (!string2.equals("{}")) {
            if (string.equals("")) {
                return string2.substring(1, string2.length() - 1);
            }
            return string + ", " + string2.substring(1, string2.length() - 1);
        }
        return string;
    }
}

