/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtool;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class ImportDialog
extends MJPanel
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    public static final int ALL = 0;
    public static final int VXIPNP = 1;
    public static final int IVILOGICAL = 2;
    public static final int IVIPROGRAMID = 3;
    public static final int IVIMODULE = 4;
    public static final String[] DRIVERNAMES = new String[]{"all", "VXIplug&play Driver", "IVI Logical Name", "IVI-COM Driver", "IVI-C Driver"};
    private static final String ACTION = "ACTION";
    private static final int CANCEL = 0;
    private static final int OK = 1;
    private static final int DRIVER = 3;
    private MJComboBox driverBox = null;
    MJButton okButton = null;
    private MJTable driverTable = null;
    private DriverListTableModel driverTableModel;
    private Vector<String> driverVector = new Vector();
    private Vector<Integer> driverTypes = new Vector();
    public String[] vxipnp = null;
    public String[] iviLogical = null;
    public String[] iviProgramId = null;
    public String[] iviModule = null;
    private String vxipnppath = "";
    private String ivipath = "";
    private boolean importDriver = false;
    private MJFrame frame;
    private MJDialog dialog;
    private ImportDialogScanRunnable runnable = null;

    public ImportDialog() {
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(1, 4, 4, 4));
        this.layoutPanel();
        this.scan();
    }

    private void layoutPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        mJPanel.add((Component)this.createDriverSelectionPanel(), (Object)"Center");
        mJPanel.add((Component)this.createButtonPanel(), (Object)"South");
        this.add((Component)mJPanel, "Center");
    }

    private MJPanel createDriverSelectionPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        MJLabel mJLabel = new MJLabel("Type of driver:");
        this.driverBox = new MJComboBox();
        this.driverBox.addItem((Object)"All");
        this.driverBox.addItem((Object)"VXIplug&play");
        this.driverBox.addItem((Object)"IVI Logical Names");
        this.driverBox.addItem((Object)"IVI-COM Drivers");
        this.driverBox.addItem((Object)"IVI-C Drivers");
        this.driverBox.setSelectedItem((Object)"All");
        this.driverBox.putClientProperty((Object)ACTION, (Object)new Integer(3));
        this.driverBox.addActionListener((ActionListener)this);
        this.driverBox.setName("Import Dialog combobox");
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout(4, 0));
        mJPanel2.add((Component)mJLabel, (Object)"West");
        mJPanel2.add((Component)this.driverBox, (Object)"Center");
        mJPanel.add((Component)mJPanel2, (Object)gridBagConstraints);
        this.driverTableModel = new DriverListTableModel();
        this.driverTable = new MJTable((TableModel)this.driverTableModel);
        this.driverTable.getSelectionModel().setSelectionMode(0);
        this.driverTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    Point point = mouseEvent.getPoint();
                    int n = ImportDialog.this.driverTable.rowAtPoint(point);
                    int n2 = ImportDialog.this.driverTable.columnAtPoint(point);
                    if (n == -1 || n2 == -1) {
                        return;
                    }
                    ImportDialog.this.importSelected();
                }
            }
        });
        this.driverTable.getSelectionModel().addListSelectionListener(this);
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.driverTable);
        mJScrollPane.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        mJPanel.add((Component)mJScrollPane, (Object)gridBagConstraints);
        return mJPanel;
    }

    private MJPanel createButtonPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout(2, 0, 5));
        mJPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new GridLayout(1, 2, 5, 0));
        this.okButton = new MJButton("Import");
        this.okButton.addActionListener((ActionListener)this);
        this.okButton.putClientProperty((Object)ACTION, (Object)new Integer(1));
        this.okButton.setEnabled(false);
        MJButton mJButton = new MJButton("Cancel");
        mJButton.addActionListener((ActionListener)this);
        mJButton.putClientProperty((Object)ACTION, (Object)new Integer(0));
        mJPanel2.add((Component)this.okButton);
        mJPanel2.add((Component)mJButton);
        this.okButton.setName("Import Driver OK Button");
        mJButton.setName("Import Driver Cancel Button");
        mJPanel.add((Component)mJPanel2);
        return mJPanel;
    }

    private void importSelected() {
        this.importDriver = true;
        this.dialog.dispose();
        this.runnable = null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = (Integer)((JComponent)actionEvent.getSource()).getClientProperty(ACTION);
        switch (n) {
            case 1: {
                if (this.driverTable.getSelectionModel().isSelectionEmpty()) break;
                this.importSelected();
                break;
            }
            case 0: {
                this.importDriver = false;
                this.dialog.dispose();
                this.runnable = null;
                break;
            }
            case 3: {
                this.updateListBox();
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            if (this.driverTable.getSelectionModel().getLeadSelectionIndex() != -1) {
                this.okButton.setEnabled(true);
            } else {
                this.okButton.setEnabled(false);
            }
        }
    }

    private void scan() {
        if (this.runnable == null) {
            this.runnable = new ImportDialogScanRunnable();
        }
        Matlab.whenMatlabReady((Runnable)this.runnable);
    }

    protected void updateListBox() {
        this.driverVector.clear();
        this.driverTypes.clear();
        switch (this.driverBox.getSelectedIndex()) {
            case 0: {
                this.updateListBox(this.vxipnp, 1);
                this.updateListBox(this.iviLogical, 2);
                this.updateListBox(this.iviProgramId, 3);
                this.updateListBox(this.iviModule, 4);
                break;
            }
            case 1: {
                this.updateListBox(this.vxipnp, 1);
                break;
            }
            case 2: {
                this.updateListBox(this.iviLogical, 2);
                break;
            }
            case 3: {
                this.updateListBox(this.iviProgramId, 3);
                break;
            }
            case 4: {
                this.updateListBox(this.iviModule, 4);
            }
        }
        if (this.driverVector.size() > 0) {
            this.driverTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void updateListBox(String[] stringArray, int n) {
        if (stringArray == null) {
            this.driverTableModel.fireTableDataChanged();
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.driverVector.add(stringArray[i]);
            this.driverTypes.add(new Integer(n));
        }
        this.driverTableModel.fireTableDataChanged();
    }

    public boolean okToImportDriver() {
        return this.importDriver;
    }

    public String getSelectedDriver() {
        return this.driverVector.get(this.driverTable.getSelectedRow());
    }

    public int getSelectedType() {
        return this.driverTypes.get(this.driverTable.getSelectedRow());
    }

    public String getPathForSelectedType() {
        int n = this.driverTypes.get(this.driverTable.getSelectedRow());
        if (n == 1) {
            return this.vxipnppath;
        }
        if (n == 4) {
            return this.ivipath;
        }
        return "";
    }

    public void showAsDialog(MJFrame mJFrame) {
        this.frame = mJFrame;
        this.dialog = new MJDialog((Frame)this.frame, "Import Driver", true);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.getContentPane().add((Component)((Object)this));
        this.dialog.pack();
        this.dialog.setSize(400, 268);
        this.dialog.setResizable(false);
        Dimension dimension = this.frame.getSize();
        Point point = this.frame.getLocation();
        this.dialog.setLocation((int)point.getX() + (dimension.width - 400) / 2, (int)point.getY() + (dimension.height - 268) / 2);
        this.dialog.show();
    }

    public class ImportDialogScanRunnable
    implements Runnable,
    MatlabListener {
        private Matlab matlab = new Matlab();
        private String[] matlabArgs = new String[]{"privateImportDriverDialogHelper"};

        @Override
        public void run() {
            try {
                this.matlab.feval("instrgate", (Object[])this.matlabArgs, 1, (MatlabListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            if (matlabEvent.getStatus() == 0) {
                Object[] objectArray = (Object[])matlabEvent.getResult();
                ImportDialog.this.vxipnp = null;
                ImportDialog.this.iviLogical = null;
                ImportDialog.this.iviProgramId = null;
                ImportDialog.this.iviModule = null;
                ImportDialog.this.vxipnppath = "";
                ImportDialog.this.ivipath = "";
                if (objectArray != null) {
                    if (objectArray[0] instanceof String[]) {
                        ImportDialog.this.vxipnp = (String[])objectArray[0];
                    }
                    if (objectArray[1] instanceof String[]) {
                        ImportDialog.this.iviLogical = (String[])objectArray[1];
                    }
                    if (objectArray[2] instanceof String[]) {
                        ImportDialog.this.iviProgramId = (String[])objectArray[2];
                    }
                    if (objectArray[3] instanceof String[]) {
                        ImportDialog.this.iviModule = (String[])objectArray[3];
                    }
                    if (objectArray[4] instanceof String) {
                        ImportDialog.this.vxipnppath = (String)objectArray[4];
                    }
                    if (objectArray[5] instanceof String) {
                        ImportDialog.this.ivipath = (String)objectArray[5];
                    }
                }
                ImportDialog.this.updateListBox();
            }
        }
    }

    public class DriverListTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return "Name";
            }
            return "Type";
        }

        @Override
        public int getRowCount() {
            return ImportDialog.this.driverVector.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return ImportDialog.this.driverVector.get(n);
            }
            return DRIVERNAMES[(Integer)ImportDialog.this.driverTypes.get(n)];
        }
    }
}

